/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.Util;

public abstract class CreateElementInTUOperation
extends CModelOperation {
    protected static final int INSERT_LAST = 1;
    protected static final int INSERT_AFTER = 2;
    protected static final int INSERT_BEFORE = 3;
    protected int fInsertionPolicy = 1;
    protected String fCreatedElement = null;
    protected ICElement fAnchorElement = null;
    protected boolean fCreationOccurred = true;
    protected int fInsertionPosition = -1;
    protected int fReplacementLength = -1;

    public CreateElementInTUOperation(ICElement parentElement) {
        super(null, new ICElement[]{parentElement});
        this.initializeDefaultPosition();
    }

    protected void checkCanceled() {
        if (!this.fNested) {
            super.checkCanceled();
        }
    }

    public void createAfter(ICElement sibling) {
        this.setRelativePosition(sibling, 2);
    }

    public void createBefore(ICElement sibling) {
        this.setRelativePosition(sibling, 3);
    }

    protected abstract String generateElement(ITranslationUnit var1) throws CModelException;

    protected void executeOperation() throws CModelException {
        this.beginTask(this.getMainTaskName(), this.getMainAmountOfWork());
        CElementDelta delta = this.newCElementDelta();
        ITranslationUnit unit = this.getTranslationUnit();
        this.fCreatedElement = this.generateElement(unit);
        this.insertElement();
        if (this.fCreationOccurred) {
            IBuffer buffer = unit.getBuffer();
            if (buffer == null) {
                return;
            }
            char[] bufferContents = buffer.getCharacters();
            if (bufferContents == null) {
                return;
            }
            char[] elementContents = Util.normalizeCRs(this.getCreatedElementCharacters(), bufferContents);
            switch (this.fReplacementLength) {
                case -1: {
                    buffer.append(elementContents);
                    break;
                }
                case 0: {
                    buffer.replace(this.fInsertionPosition, 0, elementContents);
                    break;
                }
                default: {
                    buffer.replace(this.fInsertionPosition, this.fReplacementLength, elementContents);
                }
            }
            unit.save(null, false);
            boolean isWorkingCopy = unit.isWorkingCopy();
            this.worked(1);
            this.fResultElements = this.generateResultHandles();
            if (!isWorkingCopy && unit.getParent().exists()) {
                int i = 0;
                while (i < this.fResultElements.length) {
                    delta.added(this.fResultElements[i]);
                    ++i;
                }
                this.addDelta(delta);
            }
        }
        this.done();
    }

    private char[] getCreatedElementCharacters() {
        return this.fCreatedElement.toCharArray();
    }

    protected abstract ICElement generateResultHandle();

    protected ICElement[] generateResultHandles() throws CModelException {
        return new ICElement[]{this.generateResultHandle()};
    }

    protected ITranslationUnit getTranslationUnit() {
        return ((ISourceReference)((Object)this.getParentElement())).getTranslationUnit();
    }

    protected int getMainAmountOfWork() {
        return 2;
    }

    protected abstract String getMainTaskName();

    public ICElement[] getResultElements() {
        return this.fResultElements;
    }

    protected void initializeDefaultPosition() {
    }

    protected void insertElement() throws CModelException {
        if (this.fInsertionPolicy != 1) {
            ISourceRange range = ((ISourceReference)((Object)this.fAnchorElement)).getSourceRange();
            switch (this.fInsertionPolicy) {
                case 2: {
                    this.fReplacementLength = 0;
                    this.fInsertionPosition = range.getStartPos() + range.getLength();
                    break;
                }
                case 3: {
                    this.fReplacementLength = 0;
                    this.fInsertionPosition = range.getStartPos();
                    break;
                }
                default: {
                    this.fReplacementLength = range.getStartPos() + range.getLength();
                    this.fInsertionPosition = range.getStartPos();
                }
            }
            return;
        }
        this.fReplacementLength = -1;
    }

    protected void setAlteredName(String newName) {
    }

    protected void setRelativePosition(ICElement sibling, int policy) throws IllegalArgumentException {
        if (sibling == null) {
            this.fAnchorElement = null;
            this.fInsertionPolicy = 1;
        } else {
            this.fAnchorElement = sibling;
            this.fInsertionPolicy = policy;
        }
    }

    public ICModelStatus verify() {
        ICElement domPresentParent;
        if (this.getParentElement() == null) {
            return new CModelStatus(968);
        }
        if (this.fAnchorElement != null && !(domPresentParent = this.fAnchorElement.getParent()).equals(this.getParentElement())) {
            return new CModelStatus(993, this.fAnchorElement);
        }
        return CModelStatus.VERIFIED_OK;
    }
}

