/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.internal.core.model.CContainerInfo;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModel;
import org.eclipse.cdt.internal.core.model.CModelInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;

public class DeltaProcessor {
    protected CElementDelta fCurrentDelta;
    protected IndexManager indexManager = new IndexManager();
    ICElement currentElement;
    static final ICElementDelta[] NO_DELTA = new ICElementDelta[0];
    public static boolean VERBOSE = false;
    ICElement movedFromElement = null;

    protected ICElement createElement(IResource resource) {
        int i;
        IProject project;
        if (resource == null) {
            return null;
        }
        CModelManager manager = CModelManager.getDefault();
        boolean shouldProcess = true;
        if (!(resource instanceof IWorkspaceRoot || CoreModel.hasCNature(project = resource.getProject()) || CoreModel.hasCCNature(project))) {
            shouldProcess = false;
            CModel root = manager.getCModel();
            CModelInfo rootInfo = (CModelInfo)manager.peekAtInfo(root);
            if (rootInfo != null) {
                ICElement[] celements = rootInfo.getChildren();
                i = 0;
                while (i < celements.length) {
                    IResource r = celements[i].getResource();
                    if (project.equals((Object)r)) {
                        shouldProcess = true;
                    }
                    ++i;
                }
            }
        }
        if (!shouldProcess) {
            return null;
        }
        ICElement celement = manager.create(resource, null);
        try {
            ICElement parent;
            IArchiveContainer ar;
            IResource res;
            ICElement[] children;
            IBinaryContainer bin;
            ICProject cproj;
            if (celement == null && resource.getType() == 1 && (cproj = manager.create(resource.getProject())) != null && cproj.isOpen() && (bin = cproj.getBinaryContainer()).isOpen()) {
                children = ((CElement)((Object)bin)).getElementInfo().getChildren();
                i = 0;
                while (i < children.length) {
                    res = children[i].getResource();
                    if (resource.equals((Object)res)) {
                        celement = children[i];
                        break;
                    }
                    ++i;
                }
            }
            if (celement == null && resource.getType() == 1 && (cproj = manager.create(resource.getProject())) != null && cproj.isOpen() && (ar = cproj.getArchiveContainer()).isOpen()) {
                children = ((CElement)((Object)ar)).getElementInfo().getChildren();
                i = 0;
                while (i < children.length) {
                    res = children[i].getResource();
                    if (resource.equals((Object)res)) {
                        celement = children[i];
                        break;
                    }
                    ++i;
                }
            }
            if (celement != null && resource.getType() == 1 && ((parent = celement.getParent()) instanceof IArchiveContainer || parent instanceof IBinaryContainer)) {
                this.releaseCElement(celement);
                celement = null;
            }
        }
        catch (CModelException cModelException) {
            return null;
        }
        return celement;
    }

    protected void addToParentInfo(Openable child) throws CModelException {
        CElementInfo info;
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen() && !(info = parent.getElementInfo()).includesChild(child)) {
            info.addChild(child);
        }
    }

    private void removeFromParentInfo(ICElement child) throws CModelException {
        CModelManager factory = CModelManager.getDefault();
        ICElement parent = child.getParent();
        if (parent != null && parent instanceof Parent && factory.peekAtInfo(parent) != null) {
            ((Parent)parent).removeChild(child);
        }
    }

    protected void releaseCElement(ICElement celement) throws CModelException {
        CModelManager factory = CModelManager.getDefault();
        int type = celement.getElementType();
        if (type == 18) {
            ICProject cproject = celement.getCProject();
            IArchiveContainer container = cproject.getArchiveContainer();
            this.fCurrentDelta.changed(container, 4);
        } else if (type == 14) {
            ICProject cproject = celement.getCProject();
            IBinaryContainer container = cproject.getBinaryContainer();
            this.fCurrentDelta.changed(container, 4);
        } else {
            int i;
            ICProject cproject = celement.getCProject();
            CProjectInfo pinfo = (CProjectInfo)factory.peekAtInfo(cproject);
            if (pinfo != null && pinfo.vBin != null && factory.peekAtInfo(pinfo.vBin) != null) {
                ICElement[] bins = pinfo.vBin.getChildren();
                i = 0;
                while (i < bins.length) {
                    if (celement.getPath().isPrefixOf(bins[i].getPath())) {
                        this.fCurrentDelta.changed(pinfo.vBin, 4);
                    }
                    ++i;
                }
            }
            if (pinfo != null && pinfo.vLib != null && factory.peekAtInfo(pinfo.vLib) != null) {
                ICElement[] ars = pinfo.vLib.getChildren();
                i = 0;
                while (i < ars.length) {
                    if (celement.getPath().isPrefixOf(ars[i].getPath())) {
                        this.fCurrentDelta.changed(pinfo.vBin, 4);
                    }
                    ++i;
                }
            }
        }
        this.removeFromParentInfo(celement);
        factory.releaseCElement(celement);
    }

    protected ICElement createElement(IPath path) {
        return CModelManager.getDefault().create(path);
    }

    protected void elementAdded(ICElement element, IResourceDelta delta) throws CModelException {
        if (element instanceof Openable) {
            this.addToParentInfo((Openable)element);
        }
        if ((delta.getFlags() & 0x1000) != 0) {
            if (this.movedFromElement == null) {
                this.movedFromElement = this.createElement(delta.getMovedFromPath());
            }
            this.fCurrentDelta.movedTo(element, this.movedFromElement);
            this.movedFromElement = null;
        } else {
            this.fCurrentDelta.added(element);
        }
    }

    protected void elementClosed(ICElement element, IResourceDelta delta) throws CModelException {
        if (element.getElementType() == 11) {
            this.elementRemoved(element, delta);
            CModelInfo rootInfo = (CModelInfo)CModelManager.getDefault().getCModel().getElementInfo();
            rootInfo.setNonCResources(null);
        } else {
            this.fCurrentDelta.closed(element);
        }
    }

    protected void elementOpened(ICElement element, IResourceDelta delta) throws CModelException {
        if (element.getElementType() == 11) {
            if (this.hasCNature(delta.getResource())) {
                this.elementAdded(element, delta);
            }
            CModelInfo rootInfo = (CModelInfo)CModelManager.getDefault().getCModel().getElementInfo();
            rootInfo.setNonCResources(null);
        } else {
            this.fCurrentDelta.opened(element);
        }
    }

    private void close(Openable element) {
        try {
            element.close();
        }
        catch (CModelException cModelException) {}
    }

    private void closeBinary(ICElement celement) {
        CModelManager factory = CModelManager.getDefault();
        CElementInfo pinfo = (CElementInfo)factory.peekAtInfo(celement);
        if (pinfo != null) {
            ICElement[] celems = pinfo.getChildren();
            int i = 0;
            while (i < celems.length) {
                this.closeBinary(celems[i]);
                ++i;
            }
            factory.removeInfo(celement);
        }
    }

    protected void elementChanged(ICElement element, IResourceDelta delta) {
        if (element instanceof IBinary || element instanceof IArchive) {
            this.closeBinary(element);
        } else if (element instanceof Openable) {
            this.close((Openable)element);
        }
        this.fCurrentDelta.changed(element, 1);
    }

    protected void elementRemoved(ICElement element, IResourceDelta delta) throws CModelException {
        if ((delta.getFlags() & 0x2000) != 0) {
            IPath movedToPath = delta.getMovedToPath();
            ICElement movedToElement = this.createElement(movedToPath);
            if (movedToElement == null) {
                this.fCurrentDelta.removed(element);
            } else {
                this.movedFromElement = element;
                this.fCurrentDelta.movedFrom(element, movedToElement);
            }
        } else {
            this.fCurrentDelta.removed(element);
        }
        this.releaseCElement(element);
    }

    protected ICElementDelta[] filterRealDeltas(ICElementDelta[] deltas) {
        int length = deltas.length;
        ICElementDelta[] realDeltas = null;
        int index = 0;
        int i = 0;
        while (i < length) {
            CElementDelta delta = (CElementDelta)deltas[i];
            if (delta != null && (delta.getAffectedChildren().length > 0 || delta.getKind() == 1 || delta.getKind() == 2 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x40) != 0 || delta.resourceDeltasCounter > 0)) {
                if (realDeltas == null) {
                    realDeltas = new ICElementDelta[length];
                }
                realDeltas[index++] = delta;
            }
            ++i;
        }
        if (index > 0) {
            ICElementDelta[] result = new ICElementDelta[index];
            System.arraycopy(realDeltas, 0, result, 0, index);
            return result;
        }
        return NO_DELTA;
    }

    protected boolean hasCNature(IResource resource) {
        IProject project = resource.getProject();
        if (project.isOpen()) {
            return CoreModel.hasCNature(project);
        }
        return false;
    }

    public ICElementDelta[] processResourceDelta(IResourceDelta changes) {
        CModel root = CModelManager.getDefault().getCModel();
        IResourceDelta[] deltas = changes.getAffectedChildren();
        ICElementDelta[] translatedDeltas = new CElementDelta[deltas.length];
        int i = 0;
        while (i < deltas.length) {
            IResourceDelta delta = deltas[i];
            this.fCurrentDelta = new CElementDelta(root);
            this.traverseDelta(root, delta);
            translatedDeltas[i] = this.fCurrentDelta;
            ++i;
        }
        return this.filterRealDeltas(translatedDeltas);
    }

    protected void traverseDelta(ICElement parent, IResourceDelta delta) {
        boolean updateChildren = true;
        try {
            IResource resource = delta.getResource();
            ICElement current = this.createElement(resource);
            updateChildren = this.updateCurrentDeltaAndIndex(current, delta);
            if (current == null || current instanceof ISourceRoot) {
                this.nonCResourcesChanged(parent, delta);
            } else if (current instanceof ICProject) {
                ICProject cprj = (ICProject)current;
                CModel cModel = CModelManager.getDefault().getCModel();
                if (!cprj.getProject().isOpen() || cModel.findCProject(cprj.getProject()) == null) {
                    this.nonCResourcesChanged(parent, delta);
                }
            }
            if (current != null) {
                parent = current;
            }
        }
        catch (CModelException cModelException) {}
        if (updateChildren) {
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.traverseDelta(parent, children[i]);
                ++i;
            }
        }
    }

    protected void nonCResourcesChanged(ICElement parent, IResourceDelta delta) throws CModelException {
        CElementDelta elementDelta;
        if (parent instanceof Openable && ((Openable)parent).isOpen()) {
            CElementInfo info = ((Openable)parent).getElementInfo();
            switch (parent.getElementType()) {
                case 10: {
                    ((CModelInfo)info).setNonCResources(null);
                    this.fCurrentDelta.addResourceDelta(delta);
                    return;
                }
                case 11: {
                    ((CProjectInfo)info).setNonCResources(null);
                    ICProject cproject = (ICProject)parent;
                    ISourceRoot[] roots = cproject.getAllSourceRoots();
                    int i = 0;
                    while (i < roots.length) {
                        CElementInfo cinfo;
                        IResource r = roots[i].getResource();
                        if (r instanceof IProject && (cinfo = (CElementInfo)CModelManager.getDefault().peekAtInfo(roots[i])) instanceof CContainerInfo) {
                            ((CContainerInfo)cinfo).setNonCResources(null);
                        }
                        ++i;
                    }
                    break;
                }
                case 12: {
                    ((CContainerInfo)info).setNonCResources(null);
                }
            }
        }
        if ((elementDelta = this.fCurrentDelta.find(parent)) == null) {
            this.fCurrentDelta.changed(parent, 1);
            elementDelta = this.fCurrentDelta.find(parent);
            if (elementDelta != null) {
                elementDelta.addResourceDelta(delta);
            }
        } else {
            elementDelta.addResourceDelta(delta);
        }
    }

    private boolean updateCurrentDeltaAndIndex(ICElement element, IResourceDelta delta) throws CModelException {
        IResource resource = delta.getResource();
        switch (delta.getKind()) {
            case 1: {
                if (element != null) {
                    this.updateIndexAddResource(element, delta, false);
                    this.elementAdded(element, delta);
                    return element instanceof ICContainer;
                }
                return false;
            }
            case 2: {
                if (element != null) {
                    this.updateIndexRemoveResource(element, delta);
                    this.elementRemoved(element, delta);
                }
                return element instanceof ICContainer;
            }
            case 4: {
                int flags = delta.getFlags();
                if ((flags & 0x100) != 0) {
                    if (element != null) {
                        this.elementChanged(element, delta);
                        this.updateIndexAddResource(element, delta, true);
                        this.updateDependencies(element);
                    }
                } else if (resource.getType() == 4) {
                    if ((flags & 0x4000) != 0) {
                        IProject project = (IProject)resource;
                        if (element != null) {
                            if (project.isOpen()) {
                                this.elementOpened(element, delta);
                                this.updateIndexAddResource(element, delta, true);
                                return false;
                            }
                            this.elementClosed(element, delta);
                            this.updateIndexRemoveResource(element, delta);
                            return false;
                        }
                    }
                    if ((flags & 0x80000) != 0) {
                        boolean isCProject;
                        IProject res = (IProject)delta.getResource();
                        CModel cModel = CModelManager.getDefault().getCModel();
                        boolean wasCProject = cModel.findCProject(res) != null;
                        if (wasCProject != (isCProject = CProject.hasCNature(res)) && element != null) {
                            if (isCProject) {
                                this.elementOpened(element, delta);
                                this.updateIndexAddResource(element, delta, true);
                            } else {
                                this.elementRemoved(element, delta);
                                this.updateIndexRemoveResource(element, delta);
                            }
                            return true;
                        }
                    }
                }
                return true;
            }
        }
        return true;
    }

    protected void updateIndexAddResource(ICElement element, IResourceDelta delta, boolean elementHasChanged) {
        if (this.indexManager == null) {
            return;
        }
        switch (element.getElementType()) {
            case 11: {
                this.indexManager.addResourceEvent(element.getCProject().getProject(), delta, 1);
                break;
            }
            case 12: {
                this.indexManager.addResourceEvent(element.getCProject().getProject(), delta, 2);
                break;
            }
            case 60: {
                this.indexManager.addResourceEvent(element.getCProject().getProject(), delta, 4);
            }
        }
    }

    protected void updateIndexRemoveResource(ICElement element, IResourceDelta delta) {
        if (this.indexManager == null) {
            return;
        }
        switch (element.getElementType()) {
            case 11: {
                this.indexManager.removeResourceEvent(element.getCProject().getProject(), delta, 1);
                break;
            }
            case 12: {
                this.indexManager.removeResourceEvent(element.getCProject().getProject(), delta, 2);
                break;
            }
            case 60: {
                this.indexManager.removeResourceEvent(element.getCProject().getProject(), delta, 4);
            }
        }
    }

    private void updateDependencies(ICElement element) {
        String filename;
        IResource resource = element.getResource();
        if (resource == null) {
            return;
        }
        IProject project = resource.getProject();
        if (CoreModel.isValidHeaderUnitName(project, filename = resource.getName())) {
            this.indexManager.updateDependencies(project, resource);
        }
    }
}

