/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IncludeReference
extends Openable
implements IIncludeReference {
    IIncludeEntry fIncludeEntry;
    IPath fPath;

    public IncludeReference(ICProject cproject, IIncludeEntry entry) {
        this((ICElement)cproject, entry, entry.getFullIncludePath());
    }

    public IncludeReference(ICElement celement, IIncludeEntry entry, IPath path) {
        super(celement, null, path.toString(), 30);
        this.fIncludeEntry = entry;
        this.fPath = path;
    }

    public IResource getResource() {
        return null;
    }

    protected CElementInfo createElementInfo() {
        return new OpenableInfo(this);
    }

    public IIncludeEntry getIncludeEntry() {
        return this.fIncludeEntry;
    }

    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws CModelException {
        return this.computeChildren(info, underlyingResource);
    }

    public IPath getAffectedPath() {
        return this.fIncludeEntry.getPath();
    }

    protected boolean computeChildren(OpenableInfo info, IResource res) throws CModelException {
        ArrayList<IncludeReference> vChildren = new ArrayList<IncludeReference>();
        File file = null;
        if (this.fPath != null) {
            file = this.fPath.toFile();
        } else if (this.fIncludeEntry != null) {
            file = this.fIncludeEntry.getFullIncludePath().toFile();
        }
        String[] names = null;
        if (file != null && file.isDirectory()) {
            names = file.list();
        }
        if (names != null) {
            Path path = new Path(file.getAbsolutePath());
            int i = 0;
            while (i < names.length) {
                String id;
                File child = new File(file, names[i]);
                Openable celement = null;
                if (child.isDirectory()) {
                    celement = new IncludeReference((ICElement)this, this.fIncludeEntry, (IPath)new Path(child.getAbsolutePath()));
                } else if (child.isFile() && (id = CoreModel.getRegistedContentTypeId(this.getCProject().getProject(), names[i])) != null) {
                    celement = new ExternalTranslationUnit((ICElement)this, path.append(names[i]), id);
                }
                if (celement != null) {
                    vChildren.add((IncludeReference)celement);
                }
                ++i;
            }
        }
        info.setChildren(vChildren);
        return true;
    }

    public boolean isOnIncludeEntry(IPath path) {
        return this.fIncludeEntry.getIncludePath().isPrefixOf(path) && !CoreModelUtil.isExcluded(path, this.fIncludeEntry.fullExclusionPatternChars());
    }

    public IPath getPath() {
        return this.fPath;
    }
}

