/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.StructureDeclaration;

public class Structure
extends StructureDeclaration
implements IStructure {
    Map superClassesNames = new TreeMap();

    public Structure(ICElement parent, int kind, String name) {
        super(parent, name, kind);
    }

    public IField[] getFields() throws CModelException {
        ArrayList fields = new ArrayList();
        fields.addAll(this.getChildrenOfType(72));
        return fields.toArray(new IField[fields.size()]);
    }

    public IField getField(String name) {
        try {
            IField[] fields = this.getFields();
            int i = 0;
            while (i < fields.length) {
                IField field = fields[i];
                if (field.getElementName().equals(name)) {
                    return field;
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public IMethodDeclaration[] getMethods() throws CModelException {
        ArrayList methods = new ArrayList();
        methods.addAll(this.getChildrenOfType(71));
        methods.addAll(this.getChildrenOfType(70));
        return methods.toArray(new IMethodDeclaration[methods.size()]);
    }

    public IMethodDeclaration getMethod(String name) {
        try {
            IMethodDeclaration[] methods = this.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethodDeclaration method = methods[i];
                if (method.getElementName().equals(name)) {
                    return method;
                }
                ++i;
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public boolean isAbstract() throws CModelException {
        IMethodDeclaration[] methods = this.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodDeclaration method = methods[i];
            if (method.isPureVirtual()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getSuperClassesNames() {
        return this.superClassesNames.keySet().toArray(new String[this.superClassesNames.keySet().size()]);
    }

    public ASTAccessVisibility getSuperClassAccess(String name) {
        return (ASTAccessVisibility)this.superClassesNames.get(name);
    }

    public void addSuperClass(String name) {
        this.superClassesNames.put(name, ASTAccessVisibility.PUBLIC);
    }

    public void addSuperClass(String name, ASTAccessVisibility access) {
        this.superClassesNames.put(name, access);
    }
}

