/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;

public class ASTInitializerClause
implements IASTInitializerClause {
    private List references = new ArrayList();
    private IASTVariable ownerDeclaration = null;
    private final IASTInitializerClause.Kind kind;
    private final IASTExpression assignmentExpression;
    private final List initializerClauses;
    private final List designators;

    public ASTInitializerClause(IASTInitializerClause.Kind kind, IASTExpression assignmentExpression, List initializerClauses, List designators) {
        this.kind = kind;
        this.assignmentExpression = assignmentExpression;
        this.initializerClauses = initializerClauses;
        this.designators = designators;
    }

    public IASTInitializerClause.Kind getKind() {
        return this.kind;
    }

    public Iterator getInitializers() {
        if (this.initializerClauses == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.initializerClauses.iterator();
    }

    public List getInitializersList() {
        return this.initializerClauses != null ? this.initializerClauses : Collections.EMPTY_LIST;
    }

    public IASTExpression getAssigmentExpression() {
        return this.assignmentExpression;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        List initializers = this.getInitializersList();
        int size = initializers.size();
        int i = 0;
        while (i < size) {
            ((IASTInitializerClause)initializers.get(i)).acceptElement(requestor);
            ++i;
        }
        if (this.assignmentExpression != null) {
            this.assignmentExpression.acceptElement(requestor);
        }
        Parser.processReferences(this.references, requestor);
        this.references = null;
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public Iterator getDesignators() {
        return this.designators.iterator();
    }

    public List getDesignatorList() {
        return this.designators;
    }

    public void setOwnerVariableDeclaration(IASTVariable declaration) {
        this.ownerDeclaration = declaration;
        Iterator subInitializers = this.getInitializers();
        while (subInitializers.hasNext()) {
            ((IASTInitializerClause)subInitializers.next()).setOwnerVariableDeclaration(declaration);
        }
    }

    public IASTVariable getOwnerVariableDeclaration() {
        return this.ownerDeclaration;
    }

    public List getReferences() {
        return this.references;
    }

    public IASTExpression findExpressionForDuple(ITokenDuple finalDuple) throws ASTNotImplementedException {
        if (this.kind == IASTInitializerClause.Kind.EMPTY) {
            return null;
        }
        if (this.kind == IASTInitializerClause.Kind.ASSIGNMENT_EXPRESSION || this.kind == IASTInitializerClause.Kind.DESIGNATED_ASSIGNMENT_EXPRESSION) {
            return ((ASTExpression)this.assignmentExpression).findNewDescriptor(finalDuple);
        }
        Iterator i = this.getInitializers();
        while (i.hasNext()) {
            IASTInitializerClause clause = (IASTInitializerClause)i.next();
            IASTExpression e = clause.findExpressionForDuple(finalDuple);
            if (e == null) continue;
            return e;
        }
        return null;
    }
}

