/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTConstructorMemberInitializer;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNode;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTFunction;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;

public class ASTMethod
extends ASTFunction
implements IASTMethod {
    private final List constructorChain;
    private final boolean isConstructor;
    private final boolean isPureVirtual;
    private final ASTAccessVisibility visibility;
    private final boolean isDestructor;

    public ASTMethod(IParameterizedSymbol symbol, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, int startOffset, int startLine, int nameOffset, int nameEndOffset, int nameLine, IASTTemplate ownerTemplate, List references, boolean previouslyDeclared, boolean isConstructor, boolean isDestructor, boolean isPureVirtual, ASTAccessVisibility visibility, List constructorChain, boolean hasFunctionTryBlock, boolean isFriend, char[] filename) {
        super(symbol, nameEndOffset, parameters, returnType, exception, startOffset, startLine, nameOffset, nameLine, ownerTemplate, references, previouslyDeclared, hasFunctionTryBlock, isFriend, filename);
        this.visibility = visibility;
        this.isConstructor = isConstructor;
        this.isDestructor = isDestructor;
        this.isPureVirtual = isPureVirtual;
        this.constructorChain = constructorChain;
    }

    public boolean isVirtual() {
        return this.symbol.getTypeInfo().checkBit(64);
    }

    public boolean isExplicit() {
        return this.symbol.getTypeInfo().checkBit(128);
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isDestructor() {
        return this.isDestructor;
    }

    public boolean isConst() {
        return this.symbol.getTypeInfo().checkBit(1024);
    }

    public boolean isVolatile() {
        return this.symbol.getTypeInfo().checkBit(2048);
    }

    public boolean isPureVirtual() {
        return this.isPureVirtual;
    }

    public ASTAccessVisibility getVisiblity() {
        return this.visibility;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            if (this.isFriend()) {
                requestor.acceptFriendDeclaration(this);
            } else {
                requestor.acceptMethodDeclaration(this);
            }
        }
        catch (Exception exception) {}
        this.methodCallbacks(requestor);
    }

    protected void methodCallbacks(ISourceElementRequestor requestor) {
        this.functionCallbacks(requestor);
        this.processConstructorChain(requestor);
    }

    protected void processConstructorChain(ISourceElementRequestor requestor) {
        if (this.constructorChain != null) {
            List initializers = this.getConstructorChainInitializersList();
            int i = 0;
            while (i < initializers.size()) {
                IASTConstructorMemberInitializer c = (IASTConstructorMemberInitializer)initializers.get(i);
                c.acceptElement(requestor);
                ++i;
            }
        }
    }

    public void enterScope(ISourceElementRequestor requestor) {
        try {
            requestor.enterMethodBody(this);
        }
        catch (Exception exception) {}
        this.methodCallbacks(requestor);
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitMethodBody(this);
        }
        catch (Exception exception) {}
    }

    public Iterator getConstructorChainInitializers() {
        if (this.constructorChain == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.constructorChain.iterator();
    }

    public List getConstructorChainInitializersList() {
        if (this.constructorChain == null) {
            return Collections.EMPTY_LIST;
        }
        return this.constructorChain;
    }

    public IASTClassSpecifier getOwnerClassSpecifier() {
        if (this.getOwnerScope() instanceof IASTTemplateDeclaration) {
            return (IASTClassSpecifier)((IASTTemplateDeclaration)this.getOwnerScope()).getOwnerScope();
        }
        return (IASTClassSpecifier)this.getOwnerScope();
    }

    protected List performPrefixLookup(char[] prefix, IContainerSymbol thisContainer, IContainerSymbol qualification, TypeFilter filter, List paramList) throws IASTNode.LookupError {
        block5: {
            if (filter.isLookingInThis()) {
                try {
                    ISymbol thisClass;
                    ISymbol thisPointer = thisContainer.lookup(ParserSymbolTable.THIS);
                    ISymbol iSymbol = thisClass = thisPointer != null ? thisPointer.getTypeSymbol() : null;
                    if (thisClass != null && thisClass instanceof IContainerSymbol) {
                        return ((IContainerSymbol)thisClass).prefixLookup(filter, prefix, true, paramList);
                    }
                    break block5;
                }
                catch (ParserSymbolTableException parserSymbolTableException) {
                    throw new IASTNode.LookupError();
                }
                catch (ParserSymbolTableError parserSymbolTableError) {
                    throw new IASTNode.LookupError();
                }
            }
            return super.performPrefixLookup(prefix, thisContainer, qualification, filter, paramList);
        }
        return null;
    }
}

