/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.quick.ASTDeclaration;

public class ASTFunction
extends ASTDeclaration
implements IASTFunction {
    private boolean previouslyDeclared;
    private boolean hasFunctionBody = false;
    private final IASTQualifiedNameElement qualifiedName;
    private final IASTTemplate ownerTemplateDeclaration;
    private List declarations = new ArrayList();
    private final IASTExceptionSpecification exceptionSpec;
    private final char[] name;
    private final List parms;
    private final IASTAbstractDeclaration returnType;
    private final boolean isInline;
    private final boolean isFriend;
    private final boolean isStatic;
    private final char[] fn;
    private boolean hasFunctionTryBlock = false;
    private final boolean varArgs;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public ASTFunction(IASTScope scope, char[] name, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, boolean isInline, boolean isFriend, boolean isStatic, int startOffset, int startLine, int nameOffset, int nameEndOffset, IASTTemplate ownerTemplate, boolean hasFunctionTryBlock, boolean hasVarArgs, int nameLine, char[] filename) {
        super(ownerTemplate != null ? null : scope);
        this.name = name;
        this.parms = parameters;
        this.returnType = returnType;
        this.exceptionSpec = exception;
        this.isInline = isInline;
        this.isFriend = isFriend;
        this.isStatic = isStatic;
        this.ownerTemplateDeclaration = ownerTemplate;
        if (ownerTemplate != null) {
            ownerTemplate.setOwnedDeclaration(this);
        }
        this.setStartingOffsetAndLineNumber(startOffset, startLine);
        this.setNameOffset(nameOffset);
        this.qualifiedName = new ASTQualifiedNamedElement(scope, name);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.hasFunctionTryBlock = hasFunctionTryBlock;
        this.varArgs = hasVarArgs;
        this.fn = filename;
    }

    public char[] getFilename() {
        return this.fn;
    }

    public boolean isInline() {
        return this.isInline;
    }

    public boolean isFriend() {
        return this.isFriend;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getName() {
        return String.valueOf(this.name);
    }

    public IASTAbstractDeclaration getReturnType() {
        return this.returnType;
    }

    public Iterator getParameters() {
        return this.parms.iterator();
    }

    public IASTExceptionSpecification getExceptionSpec() {
        return this.exceptionSpec;
    }

    public IASTTemplate getOwnerTemplateDeclaration() {
        return this.ownerTemplateDeclaration;
    }

    public Iterator getDeclarations() {
        return this.declarations.iterator();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            if (this.isFriend()) {
                requestor.acceptFriendDeclaration(this);
            } else {
                requestor.acceptFunctionDeclaration(this);
            }
        }
        catch (Exception exception) {}
    }

    public void enterScope(ISourceElementRequestor requestor) {
        try {
            requestor.enterFunctionBody(this);
        }
        catch (Exception exception) {}
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitFunctionBody(this);
        }
        catch (Exception exception) {}
    }

    public void setHasFunctionBody(boolean b) {
        this.hasFunctionBody = true;
    }

    public boolean hasFunctionBody() {
        return this.hasFunctionBody;
    }

    public IASTCodeScope getOwnerCodeScope() {
        return null;
    }

    public boolean previouslyDeclared() {
        return this.previouslyDeclared;
    }

    public void setHasFunctionTryBlock(boolean b) {
        this.hasFunctionTryBlock = b;
    }

    public boolean hasFunctionTryBlock() {
        return this.hasFunctionTryBlock;
    }

    public boolean takesVarArgs() {
        return this.varArgs;
    }

    public IASTFunction getContainingFunction() {
        return this;
    }

    public final int getStartingLine() {
        return this.startingLineNumber;
    }

    public final int getEndingLine() {
        return this.endingLineNumber;
    }

    public final int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public final void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public final void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public final int getStartingOffset() {
        return this.startingOffset;
    }

    public final int getEndingOffset() {
        return this.endingOffset;
    }

    public final int getNameOffset() {
        return this.nameStartOffset;
    }

    public final void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public final int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public final void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public char[] getNameCharArray() {
        return this.name;
    }
}

