/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.List;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.parser.pst.ExtensibleSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public class BasicSymbol
extends ExtensibleSymbol
implements ISymbol {
    private char[] _name;
    private ITypeInfo _typeInfo;
    private int _depth;
    private boolean _isInvisible = false;
    private boolean _isTemplateMember = false;
    private boolean _isForwardDeclaration = false;
    private boolean _isTemplateInstance = false;
    private ISymbol _symbolDef = null;

    public BasicSymbol(ParserSymbolTable table, char[] name) {
        super(table);
        this._name = name;
    }

    public BasicSymbol(ParserSymbolTable table, char[] name, ITypeInfo.eType typeInfo) {
        super(table);
        this._name = name;
        this._typeInfo = TypeInfoProvider.newTypeInfo(typeInfo);
    }

    public ISymbol instantiate(ITemplateSymbol template, ObjectMap argMap) throws ParserSymbolTableException {
        if (!this.isTemplateMember() && !this.getContainingSymbol().isTemplateMember()) {
            return null;
        }
        ISymbol newSymbol = (ISymbol)this.clone();
        newSymbol.setTypeInfo(TemplateEngine.instantiateTypeInfo(newSymbol.getTypeInfo(), template, argMap));
        newSymbol.setInstantiatedSymbol(this);
        return newSymbol;
    }

    public char[] getName() {
        return this._name;
    }

    public void setName(char[] name) {
        this._name = name;
    }

    public void setContainingSymbol(IContainerSymbol scope) {
        super.setContainingSymbol(scope);
        this._depth = scope.getDepth() + 1;
    }

    public void setType(ITypeInfo.eType t) {
        this.getTypeInfo().setType(t);
    }

    public ITypeInfo.eType getType() {
        return this.getTypeInfo().getType();
    }

    public boolean isType(ITypeInfo.eType type) {
        return this.getTypeInfo().isType(type, ITypeInfo.t_undef);
    }

    public boolean isType(ITypeInfo.eType type, ITypeInfo.eType upperType) {
        return this.getTypeInfo().isType(type, upperType);
    }

    public ISymbol getTypeSymbol() {
        ISymbol symbol = this.getTypeInfo().getTypeSymbol();
        if (symbol != null && symbol.isForwardDeclaration() && symbol.getForwardSymbol() != null) {
            return symbol.getForwardSymbol();
        }
        return symbol;
    }

    public void setTypeSymbol(ISymbol type) {
        this.getTypeInfo().setTypeSymbol(type);
    }

    public ITypeInfo getTypeInfo() {
        return this._typeInfo != null ? this._typeInfo : (this._typeInfo = new TypeInfo());
    }

    public void setTypeInfo(ITypeInfo info) {
        this._typeInfo = info;
    }

    public boolean isForwardDeclaration() {
        return this._isForwardDeclaration;
    }

    public void setIsForwardDeclaration(boolean forward) {
        this._isForwardDeclaration = forward;
    }

    public void setForwardSymbol(ISymbol forward) {
        this._symbolDef = forward;
    }

    public ISymbol getForwardSymbol() {
        return this._isForwardDeclaration || this.isType(ITypeInfo.t_namespace) ? this._symbolDef : null;
    }

    public int compareCVQualifiersTo(ISymbol symbol) {
        int size2;
        int size = symbol.getTypeInfo().hasPtrOperators() ? symbol.getTypeInfo().getPtrOperators().size() : 0;
        int n = size2 = this.getTypeInfo().hasPtrOperators() ? this.getTypeInfo().getPtrOperators().size() : 0;
        if (size != size2) {
            return size2 - size;
        }
        if (size == 0) {
            return 0;
        }
        ITypeInfo.PtrOp op1 = null;
        ITypeInfo.PtrOp op2 = null;
        int i = 0;
        while (i > size) {
            op1 = (ITypeInfo.PtrOp)symbol.getTypeInfo().getPtrOperators().get(i);
            if (op1.compareCVTo(op2 = (ITypeInfo.PtrOp)this.getTypeInfo().getPtrOperators().get(i)) != 0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public List getPtrOperators() {
        return this.getTypeInfo().getPtrOperators();
    }

    public void addPtrOperator(ITypeInfo.PtrOp ptrOp) {
        this.getTypeInfo().addPtrOperator(ptrOp);
    }

    public void preparePtrOperatros(int numPtrOps) {
        this.getTypeInfo().preparePtrOperators(numPtrOps);
    }

    public int getDepth() {
        return this._depth;
    }

    public boolean isTemplateMember() {
        return this._isTemplateMember;
    }

    public void setIsTemplateMember(boolean isMember) {
        this._isTemplateMember = isMember;
    }

    public boolean isTemplateInstance() {
        return this._isTemplateInstance && this._symbolDef != null;
    }

    public ISymbol getInstantiatedSymbol() {
        return this._symbolDef;
    }

    public void setInstantiatedSymbol(ISymbol symbol) {
        this._isTemplateInstance = true;
        this._symbolDef = symbol;
    }

    public boolean getIsInvisible() {
        return this._isInvisible;
    }

    public void setIsInvisible(boolean invisible) {
        this._isInvisible = invisible;
    }

    public Object clone() {
        BasicSymbol s = (BasicSymbol)super.clone();
        s._typeInfo = TypeInfoProvider.newTypeInfo(s._typeInfo);
        return s;
    }
}

