/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;

public class BasicTypeInfo
implements ITypeInfo {
    private static final char[][] _image = new char[][]{ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, "namespace".toCharArray(), "class".toCharArray(), "struct".toCharArray(), "union".toCharArray(), "enum".toCharArray(), ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, "_Bool".toCharArray(), "bool".toCharArray(), "char".toCharArray(), "wchar_t".toCharArray(), "int".toCharArray(), "float".toCharArray(), "double".toCharArray(), "void".toCharArray(), ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, "template".toCharArray(), ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, ParserSymbolTable.EMPTY_NAME_ARRAY, "typename".toCharArray()};
    protected int _typeBits = 0;
    protected ITypeInfo.eType _type = t_undef;
    protected List _ptrOperators = Collections.EMPTY_LIST;
    protected boolean _hasDefault = false;

    public void setBit(boolean b, int mask) {
        this._typeBits = b ? (this._typeBits |= mask) : (this._typeBits &= ~mask);
    }

    public boolean checkBit(int mask) {
        return (this._typeBits & mask) != 0;
    }

    public void setType(ITypeInfo.eType t) {
        this._type = t;
    }

    public ITypeInfo.eType getType() {
        return this._type;
    }

    public boolean isType(ITypeInfo.eType type) {
        return this.isType(type, t_undef);
    }

    public int getTypeBits() {
        return this._typeBits;
    }

    public void setTypeBits(int typeInfo) {
        this._typeBits = typeInfo;
    }

    public ITypeInfo getFinalType(TypeInfoProvider infoProvider) {
        return ParserSymbolTable.getFlatTypeInfo(this, infoProvider);
    }

    public boolean isType(ITypeInfo.eType type, ITypeInfo.eType upperType) {
        if (type == t_any) {
            return true;
        }
        if (upperType == t_undef) {
            return this.getType() == type;
        }
        return this.getType().compareTo(type) >= 0 && this.getType().compareTo(upperType) <= 0;
    }

    public boolean hasPtrOperators() {
        return this._ptrOperators.size() > 0;
    }

    public List getPtrOperators() {
        return this._ptrOperators;
    }

    public boolean hasSamePtrs(ITypeInfo type) {
        int size = this.getPtrOperators().size();
        int size2 = type.getPtrOperators().size();
        ITypeInfo.PtrOp ptr1 = null;
        ITypeInfo.PtrOp ptr2 = null;
        if (size == size2) {
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    ptr1 = (ITypeInfo.PtrOp)this.getPtrOperators().get(i);
                    ptr2 = (ITypeInfo.PtrOp)type.getPtrOperators().get(i);
                    if (ptr1.getType() != ptr2.getType()) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public void applyOperatorExpression(ITypeInfo.OperatorExpression op) {
        if (op == null) {
            return;
        }
        if (op == ITypeInfo.OperatorExpression.indirection || op == ITypeInfo.OperatorExpression.subscript) {
            ListIterator iterator;
            ITypeInfo.PtrOp last;
            if (this.hasPtrOperators() && ((last = (ITypeInfo.PtrOp)(iterator = this.getPtrOperators().listIterator(this.getPtrOperators().size())).previous()).getType() == ITypeInfo.PtrOp.t_pointer || last.getType() == ITypeInfo.PtrOp.t_array)) {
                iterator.remove();
            }
        } else if (op == ITypeInfo.OperatorExpression.addressof) {
            ITypeInfo.PtrOp newOp = new ITypeInfo.PtrOp(ITypeInfo.PtrOp.t_pointer);
            this.addPtrOperator(newOp);
        }
    }

    public void addPtrOperator(ITypeInfo.PtrOp ptr) {
        if (ptr != null) {
            if (this._ptrOperators == Collections.EMPTY_LIST) {
                this._ptrOperators = new ArrayList(4);
            }
            this._ptrOperators.add(ptr);
        }
    }

    public void addPtrOperator(List ptrs) {
        if (ptrs == null || ptrs.size() == 0) {
            return;
        }
        if (this._ptrOperators == Collections.EMPTY_LIST) {
            this._ptrOperators = new ArrayList(ptrs.size());
        }
        int size = ptrs.size();
        int i = 0;
        while (i < size) {
            this._ptrOperators.add(ptrs.get(i));
            ++i;
        }
    }

    public void preparePtrOperators(int numPtrOps) {
        if (this._ptrOperators == Collections.EMPTY_LIST) {
            this._ptrOperators = new ArrayList(numPtrOps);
        } else {
            ((ArrayList)this._ptrOperators).ensureCapacity(numPtrOps);
        }
    }

    public boolean canHold(ITypeInfo type) {
        if (this.getType().compareTo(type.getType()) > 0) {
            return true;
        }
        int mask = 286720;
        return (this.getTypeBits() & mask) >= (type.getTypeBits() & mask);
    }

    public boolean equals(Object t) {
        int size2;
        if (t == null || !(t instanceof ITypeInfo)) {
            return false;
        }
        int bits1 = this._typeBits & 0xFFFFFEFF & 0xFFFF7FFF & 0xFFFFFFFB & 0xFFFFFFF7;
        ITypeInfo type = (ITypeInfo)t;
        int bits2 = type.getTypeBits() & 0xFFFFFEFF & 0xFFFF7FFF & 0xFFFFFFFB & 0xFFFFFFF7;
        boolean result = bits1 == bits2;
        if (!(result &= this._type == type.getType())) {
            return false;
        }
        int size1 = this._ptrOperators.size();
        if (size1 == (size2 = type.getPtrOperators().size())) {
            if (size1 != 0) {
                ITypeInfo.PtrOp op1 = null;
                ITypeInfo.PtrOp op2 = null;
                int i = 0;
                while (i < size1) {
                    op1 = (ITypeInfo.PtrOp)this._ptrOperators.get(i);
                    if (!op1.equals(op2 = (ITypeInfo.PtrOp)type.getPtrOperators().get(i))) {
                        return false;
                    }
                    ++i;
                }
            }
        } else {
            return false;
        }
        return result;
    }

    public char[] toCharArray() {
        if (this.isType(t_type) && this.getTypeSymbol() != null) {
            return this.getTypeSymbol().getName();
        }
        return _image[this.getType().toInt()];
    }

    public void clear() {
        this._typeBits = 0;
        this._type = t_undef;
        this._ptrOperators = Collections.EMPTY_LIST;
    }

    public void copy(ITypeInfo t) {
        if (t == null) {
            return;
        }
        this._typeBits = t.getTypeBits();
        this._type = t.getType();
        this._ptrOperators = t.getPtrOperators() != Collections.EMPTY_LIST ? (ArrayList)((ArrayList)t.getPtrOperators()).clone() : Collections.EMPTY_LIST;
    }

    public boolean getHasDefault() {
        return this._hasDefault;
    }

    public void setHasDefault(boolean def) {
        this._hasDefault = def;
    }

    public ITypeInfo.eType getTemplateParameterType() {
        return ITypeInfo.t_undef;
    }

    public void setTemplateParameterType(ITypeInfo.eType type) {
        throw new UnsupportedOperationException();
    }

    public ISymbol getTypeSymbol() {
        return null;
    }

    public void setTypeSymbol(ISymbol type) {
        if (type != null) {
            throw new UnsupportedOperationException();
        }
    }

    public void setDefault(Object t) {
        if (t != null) {
            throw new UnsupportedOperationException();
        }
    }

    public Object getDefault() {
        return null;
    }
}

