/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTMember;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.CharTable;
import org.eclipse.cdt.core.parser.util.HashTable;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNode;
import org.eclipse.cdt.internal.core.parser.pst.BasicSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.DerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.ITemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.IUsingDirectiveSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableError;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.SpecializedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;
import org.eclipse.cdt.internal.core.parser.pst.TemplateFactory;
import org.eclipse.cdt.internal.core.parser.pst.TemplateSymbol;
import org.eclipse.cdt.internal.core.parser.pst.TypeFilter;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfoProvider;
import org.eclipse.cdt.internal.core.parser.pst.UndefinedTemplateSymbol;

public class ParserSymbolTable {
    public static final int TYPE_LOOP_THRESHOLD = 50;
    public static final int TEMPLATE_LOOP_THRESHOLD = 10;
    public static final char[] EMPTY_NAME_ARRAY = new char[0];
    public static final char[] THIS = new char[]{'t', 'h', 'i', 's'};
    public static final char[] OPERATOR_ = new char[]{'o', 'p', 'e', 'r', 'a', 't', 'o', 'r', ' '};
    private IContainerSymbol _compilationUnit = this.newContainerSymbol(EMPTY_NAME_ARRAY, ITypeInfo.t_namespace);
    private ParserLanguage _language;
    private TypeInfoProvider _typeInfoProvider;
    private ParserMode _mode;

    public ParserSymbolTable(ParserLanguage language, ParserMode mode) {
        this._language = language;
        this._mode = mode;
        this._typeInfoProvider = new TypeInfoProvider();
    }

    public IContainerSymbol getCompilationUnit() {
        return this._compilationUnit;
    }

    public IContainerSymbol newContainerSymbol(char[] name) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new ContainerSymbol(this, name);
    }

    public IContainerSymbol newContainerSymbol(char[] name, ITypeInfo.eType type) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new ContainerSymbol(this, name, type);
    }

    public ISymbol newSymbol(char[] name) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new BasicSymbol(this, name);
    }

    public ISymbol newSymbol(char[] name, ITypeInfo.eType type) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new BasicSymbol(this, name, type);
    }

    public IDerivableContainerSymbol newDerivableContainerSymbol(char[] name) {
        return new DerivableContainerSymbol(this, name != null ? name : EMPTY_NAME_ARRAY);
    }

    public IDerivableContainerSymbol newDerivableContainerSymbol(char[] name, ITypeInfo.eType type) {
        return new DerivableContainerSymbol(this, name != null ? name : EMPTY_NAME_ARRAY, type);
    }

    public IParameterizedSymbol newParameterizedSymbol(char[] name) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new ParameterizedSymbol(this, name);
    }

    public IParameterizedSymbol newParameterizedSymbol(char[] name, ITypeInfo.eType type) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new ParameterizedSymbol(this, name, type);
    }

    public ITemplateSymbol newTemplateSymbol(char[] name) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new TemplateSymbol(this, name);
    }

    public ISpecializedSymbol newSpecializedSymbol(char[] name) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new SpecializedSymbol(this, name);
    }

    public ITemplateFactory newTemplateFactory() {
        return new TemplateFactory(this);
    }

    public ISymbol newUndefinedTemplateSymbol(char[] name) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new UndefinedTemplateSymbol(this, name);
    }

    public ISymbol newUndefinedTemplateSymbol(char[] name, ITypeInfo.eType type) {
        if (name == null) {
            name = EMPTY_NAME_ARRAY;
        }
        return new UndefinedTemplateSymbol(this, name, type);
    }

    protected static void lookup(LookupData data, IContainerSymbol inSymbol) throws ParserSymbolTableException {
        ISymbol symbol;
        if (inSymbol.isType(ITypeInfo.t_namespace) && (symbol = inSymbol.getForwardSymbol()) != null && symbol.isType(ITypeInfo.t_namespace)) {
            inSymbol = (IContainerSymbol)symbol;
        }
        ArrayList transitives = null;
        CharArrayObjectMap map = null;
        if (!data.usingDirectivesOnly) {
            map = ParserSymbolTable.lookupInContained(data, inSymbol);
            if (data.foundItems == null || data.foundItems.isEmpty()) {
                data.foundItems = map;
            } else {
                ParserSymbolTable.mergeScopedResults(data.foundItems, map);
            }
        }
        if (inSymbol.getSymbolTable().getLanguage() == ParserLanguage.CPP && !data.ignoreUsingDirectives) {
            data.visited.clear();
            transitives = ParserSymbolTable.lookupInNominated(data, inSymbol, transitives);
            if (!data.qualified || data.foundItems == null || data.foundItems.isEmpty()) {
                ParserSymbolTable.processDirectives(inSymbol, data, transitives);
                if (inSymbol.hasUsingDirectives()) {
                    ParserSymbolTable.processDirectives(inSymbol, data, inSymbol.getUsingDirectives());
                }
                while (data.usingDirectives != null && data.usingDirectives.get(inSymbol) != null) {
                    if (transitives != null) {
                        transitives.clear();
                    }
                    transitives = ParserSymbolTable.lookupInNominated(data, inSymbol, transitives);
                    if (data.qualified && data.foundItems != null) continue;
                    ParserSymbolTable.processDirectives(inSymbol, data, transitives);
                }
            }
        }
        if (!data.isPrefixLookup() && (data.foundItems != null && !data.foundItems.isEmpty() || data.getStopAt() == inSymbol)) {
            return;
        }
        if (!data.usingDirectivesOnly && inSymbol instanceof IDerivableContainerSymbol) {
            data.visited.clear();
            map = ParserSymbolTable.lookupInParents(data, inSymbol);
            if (data.foundItems == null || data.foundItems.isEmpty()) {
                data.foundItems = map;
            } else {
                ParserSymbolTable.mergeScopedResults(data.foundItems, map);
            }
        }
        if ((data.foundItems == null || data.foundItems.isEmpty() || data.isPrefixLookup()) && inSymbol.getContainingSymbol() != null) {
            if (data.qualified) {
                if (data.usingDirectives != null && !data.usingDirectives.isEmpty()) {
                    data.usingDirectivesOnly = true;
                    ParserSymbolTable.lookup(data, inSymbol.getContainingSymbol());
                }
            } else {
                ParserSymbolTable.lookup(data, inSymbol.getContainingSymbol());
            }
        }
    }

    private static ArrayList lookupInNominated(LookupData data, IContainerSymbol symbol, ArrayList transitiveDirectives) throws ParserSymbolTableException {
        if (data.usingDirectives == null) {
            return transitiveDirectives;
        }
        ArrayList directives = null;
        IContainerSymbol temp = null;
        boolean foundSomething = false;
        int size = 0;
        directives = (ArrayList)data.usingDirectives.remove(symbol);
        if (directives == null) {
            return transitiveDirectives;
        }
        size = directives.size();
        int i = 0;
        while (i < size) {
            temp = (IContainerSymbol)directives.get(i);
            if (!data.visited.containsKey(temp)) {
                if (data.visited == ObjectSet.EMPTY_SET) {
                    data.visited = new ObjectSet(2);
                }
                data.visited.put(temp);
                CharArrayObjectMap map = ParserSymbolTable.lookupInContained(data, temp);
                boolean bl = foundSomething = map != null && !map.isEmpty();
                if (foundSomething) {
                    if (data.foundItems == null) {
                        data.foundItems = map;
                    } else {
                        ParserSymbolTable.mergeResults(data, data.foundItems, map);
                    }
                }
                if ((!data.qualified || !foundSomething || data.isPrefixLookup()) && temp.hasUsingDirectives()) {
                    if (transitiveDirectives == null) {
                        transitiveDirectives = new ArrayList(4);
                    }
                    transitiveDirectives.addAll(temp.getUsingDirectives());
                }
            }
            ++i;
        }
        return transitiveDirectives;
    }

    private static void mergeResults(LookupData data, CharArrayObjectMap resultMap, CharArrayObjectMap map) throws ParserSymbolTableException {
        if (resultMap == null || map == null || map.isEmpty()) {
            return;
        }
        char[] key = null;
        int size = map.size();
        int i = 0;
        while (i < size) {
            key = map.keyAt(i);
            if (resultMap.containsKey(key)) {
                ArrayList<Object> list = new ArrayList<Object>();
                Object obj = resultMap.get(key);
                if (obj instanceof List) {
                    list.addAll((List)obj);
                } else {
                    list.add(obj);
                }
                obj = map.get(key);
                if (obj instanceof List) {
                    list.addAll((List)obj);
                } else {
                    list.add(obj);
                }
                resultMap.put(key, ParserSymbolTable.collectSymbol(data, list));
            } else {
                resultMap.put(key, map.get(key));
            }
            ++i;
        }
    }

    protected static CharArrayObjectMap lookupInContained(LookupData data, IContainerSymbol lookIn) throws ParserSymbolTableException {
        HashTable found = null;
        Object obj = null;
        if (data.getAssociated() != null) {
            data.getAssociated().remove(lookIn);
        }
        CharArrayObjectMap declarations = lookIn.getContainedSymbols();
        int numKeys = -1;
        int idx = 0;
        if (data.isPrefixLookup() && declarations != CharArrayObjectMap.EMPTY_MAP) {
            numKeys = declarations.size();
        }
        char[] name = numKeys > 0 ? declarations.keyAt(idx++) : data.name;
        while (name != null) {
            if (ParserSymbolTable.nameMatches(data, name)) {
                Object object = obj = declarations.size() > 0 ? declarations.get(name) : null;
                if (obj != null && (obj = ParserSymbolTable.collectSymbol(data, obj)) != null) {
                    if (found == null) {
                        found = new CharArrayObjectMap(2);
                    }
                    ((CharArrayObjectMap)found).put(name, obj);
                }
            }
            name = idx < numKeys ? declarations.keyAt(idx++) : (char[])null;
        }
        if (found != null && data.isPrefixLookup()) {
            found.sort(ContainerSymbol.comparator);
        }
        if (found != null && !data.isPrefixLookup()) {
            return found;
        }
        if (lookIn instanceof IParameterizedSymbol) {
            found = ParserSymbolTable.lookupInParameters(data, lookIn, (CharArrayObjectMap)found);
        }
        if (lookIn.isTemplateMember() && data.templateMember == null) {
            IContainerSymbol outer;
            IContainerSymbol containing = lookIn.getContainingSymbol();
            IContainerSymbol iContainerSymbol = outer = containing != null ? containing.getContainingSymbol() : null;
            if (containing instanceof IDerivableContainerSymbol && outer instanceof ITemplateSymbol || lookIn instanceof IParameterizedSymbol && containing instanceof ITemplateSymbol || lookIn instanceof IDerivableContainerSymbol && containing instanceof ITemplateSymbol) {
                data.templateMember = lookIn;
            }
        }
        return found;
    }

    private static CharArrayObjectMap lookupInParameters(LookupData data, IContainerSymbol lookIn, CharArrayObjectMap found) throws ParserSymbolTableException {
        CharArrayObjectMap parameters;
        if (lookIn instanceof ITemplateSymbol && !((ITemplateSymbol)lookIn).getDefinitionParameterMap().isEmpty()) {
            ITemplateSymbol template = (ITemplateSymbol)lookIn;
            if (data.templateMember != null && template.getDefinitionParameterMap().containsKey(data.templateMember)) {
                ObjectMap map = (ObjectMap)template.getDefinitionParameterMap().get(data.templateMember);
                int i = 0;
                while (i < map.size()) {
                    Object obj;
                    ISymbol symbol = (ISymbol)map.keyAt(i);
                    if (ParserSymbolTable.nameMatches(data, symbol.getName()) && (obj = ParserSymbolTable.collectSymbol(data, symbol)) != null) {
                        if (found == null) {
                            found = new CharArrayObjectMap(2);
                        }
                        found.put(symbol.getName(), obj);
                    }
                    ++i;
                }
                if (found != null && data.isPrefixLookup()) {
                    found.sort(ContainerSymbol.comparator);
                }
                return found;
            }
        }
        if ((parameters = ((IParameterizedSymbol)lookIn).getParameterMap()) != CharArrayObjectMap.EMPTY_MAP) {
            int numKeys = -1;
            int idx = 0;
            if (data.isPrefixLookup() && parameters != CharArrayObjectMap.EMPTY_MAP) {
                numKeys = parameters.size();
            }
            char[] name = numKeys > 0 ? parameters.keyAt(idx++) : data.name;
            while (name != null) {
                if (ParserSymbolTable.nameMatches(data, name)) {
                    Object obj = parameters.get(name);
                    if ((obj = ParserSymbolTable.collectSymbol(data, obj)) != null) {
                        if (found == null) {
                            found = new CharArrayObjectMap(2);
                        }
                        found.put(name, obj);
                    }
                }
                name = idx < numKeys ? parameters.keyAt(idx++) : (char[])null;
            }
        }
        if (found != null && data.isPrefixLookup()) {
            found.sort(ContainerSymbol.comparator);
        }
        return found;
    }

    private static boolean nameMatches(LookupData data, char[] name) {
        if (data.isPrefixLookup()) {
            return CharArrayUtils.equals(name, 0, data.name.length, data.name, true);
        }
        return CharArrayUtils.equals(name, data.name);
    }

    private static boolean checkType(LookupData data, ISymbol symbol) {
        if (data.getFilter() == null) {
            return true;
        }
        TypeInfoProvider provider = symbol.getSymbolTable().getTypeInfoProvider();
        ITypeInfo typeInfo = ParserSymbolTable.getFlatTypeInfo(symbol.getTypeInfo(), provider);
        boolean accept = data.getFilter().shouldAccept(symbol, typeInfo) || data.getFilter().shouldAccept(symbol);
        provider.returnTypeInfo(typeInfo);
        return accept;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object collectSymbol(LookupData data, Object object) throws ParserSymbolTableException {
        if (object == null) {
            return null;
        }
        ISymbol foundSymbol = null;
        List objList = object instanceof List ? (List)object : null;
        int objListSize = objList != null ? objList.size() : 0;
        ISymbol symbol = objList != null ? (ISymbol)objList.get(0) : (ISymbol)object;
        ObjectSet functionSet = ObjectSet.EMPTY_SET;
        ObjectSet templateFunctionSet = ObjectSet.EMPTY_SET;
        ISymbol obj = null;
        ISymbol cls = null;
        int idx = 1;
        while (symbol != null) {
            if (symbol instanceof ITemplateSymbol) {
                IContainerSymbol temp = ((ITemplateSymbol)symbol).getTemplatedSymbol();
                ISymbol iSymbol = symbol = temp != null ? temp : symbol;
            }
            if ((data.returnInvisibleSymbols || !symbol.getIsInvisible()) && ParserSymbolTable.checkType(data, symbol)) {
                foundSymbol = symbol;
                if (foundSymbol.isType(ITypeInfo.t_function)) {
                    if (foundSymbol.isForwardDeclaration() && foundSymbol.getForwardSymbol() != null && !foundSymbol.isTemplateInstance() && foundSymbol.getForwardSymbol().getContainingSymbol() != null) {
                        foundSymbol = foundSymbol.getForwardSymbol();
                    }
                    if (foundSymbol.getContainingSymbol().isType(ITypeInfo.t_template)) {
                        if (templateFunctionSet == ObjectSet.EMPTY_SET) {
                            templateFunctionSet = new ObjectSet(2);
                        }
                        templateFunctionSet.put(foundSymbol);
                    } else {
                        if (functionSet == ObjectSet.EMPTY_SET) {
                            functionSet = new ObjectSet(2);
                        }
                        functionSet.put(foundSymbol);
                    }
                } else if (foundSymbol.isType(ITypeInfo.t_class, ITypeInfo.t_enumeration)) {
                    if (cls == null) {
                        cls = (IContainerSymbol)foundSymbol;
                    } else if (cls.isForwardDeclaration() && cls.getForwardSymbol() == foundSymbol) {
                        cls = (IContainerSymbol)foundSymbol;
                    } else if (!foundSymbol.isForwardDeclaration() || foundSymbol.getForwardSymbol() != cls) {
                        if (!data.isPrefixLookup()) throw new ParserSymbolTableException(0);
                        data.addAmbiguity(foundSymbol.getName());
                    }
                } else if (obj == null) {
                    obj = foundSymbol;
                } else if (obj.isForwardDeclaration() && obj.getForwardSymbol() == foundSymbol) {
                    obj = foundSymbol;
                } else if (!(foundSymbol.isForwardDeclaration() && foundSymbol.getForwardSymbol() == obj || foundSymbol.getTypeInfo().checkBit(256) && obj.getTypeInfo().checkBit(256) && foundSymbol.getTypeInfo().getFinalType(null).equals(obj.getTypeInfo().getFinalType(null)))) {
                    if (!data.isPrefixLookup()) throw new ParserSymbolTableException(0);
                    data.addAmbiguity(foundSymbol.getName());
                }
            }
            symbol = objList != null && idx < objListSize ? (ISymbol)objList.get(idx++) : null;
        }
        int numFunctions = functionSet.size();
        int numTemplateFunctions = templateFunctionSet.size();
        boolean ambiguous = false;
        if (cls != null) {
            int i;
            if (obj != null && cls.getContainingSymbol() != obj.getContainingSymbol()) {
                ambiguous = true;
            }
            IParameterizedSymbol fn = null;
            if (numTemplateFunctions > 0) {
                i = 0;
                while (i < numTemplateFunctions) {
                    fn = (IParameterizedSymbol)templateFunctionSet.keyAt(i);
                    if (cls.getContainingSymbol() != fn.getContainingSymbol()) {
                        ambiguous = true;
                        break;
                    }
                    ++i;
                }
            }
            if (numFunctions > 0) {
                i = 0;
                while (i < numFunctions) {
                    fn = (IParameterizedSymbol)functionSet.keyAt(i);
                    if (cls.getContainingSymbol() != fn.getContainingSymbol()) {
                        ambiguous = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (numTemplateFunctions > 0) {
            if (!(data.getParameters() == null || data.exactFunctionsOnly && data.getTemplateParameters() == null)) {
                List fns = TemplateEngine.selectTemplateFunctions(templateFunctionSet, data.getParameters(), data.getTemplateParameters());
                if (fns != null) {
                    if (functionSet == ObjectSet.EMPTY_SET) {
                        functionSet = new ObjectSet(fns.size());
                    }
                    functionSet.addAll(fns);
                }
                numFunctions = functionSet.size();
            } else {
                if (functionSet == ObjectSet.EMPTY_SET) {
                    functionSet = new ObjectSet(templateFunctionSet.size());
                }
                functionSet.addAll(templateFunctionSet);
                numFunctions += numTemplateFunctions;
            }
        }
        if (obj != null && !ambiguous) {
            if (numFunctions <= 0) return obj;
            ambiguous = true;
        } else if (numFunctions > 0) {
            return functionSet.toList();
        }
        if (!ambiguous) return cls;
        if (!data.isPrefixLookup()) throw new ParserSymbolTableException(0);
        data.addAmbiguity(foundSymbol.getName());
        return cls;
    }

    private static CharArrayObjectMap lookupInParents(LookupData data, ISymbol lookIn) throws ParserSymbolTableException {
        IDerivableContainerSymbol container = null;
        if (!(lookIn instanceof IDerivableContainerSymbol)) {
            throw new ParserSymbolTableError(-1);
        }
        container = (IDerivableContainerSymbol)lookIn;
        List scopes = container.getParents();
        HashTable temp = null;
        HashTable symbol = null;
        CharArrayObjectMap inherited = null;
        IDerivableContainerSymbol.IParentSymbol wrapper = null;
        if (scopes == null) {
            return null;
        }
        if (data.inheritanceChain == null) {
            data.inheritanceChain = new ObjectSet(2);
        }
        data.inheritanceChain.put(container);
        int size = scopes.size();
        int i = 0;
        while (i < size) {
            wrapper = (IDerivableContainerSymbol.IParentSymbol)scopes.get(i);
            ISymbol parent = wrapper.getParent();
            if (parent != null && !parent.isType(ITypeInfo.t_templateParameter)) {
                if (!wrapper.isVirtual() || !data.visited.containsKey(parent)) {
                    if (wrapper.isVirtual()) {
                        if (data.visited == ObjectSet.EMPTY_SET) {
                            data.visited = new ObjectSet(2);
                        }
                        data.visited.put(parent);
                    }
                    if (parent instanceof IDeferredTemplateInstance) {
                        parent = ((IDeferredTemplateInstance)parent).getTemplate().getTemplatedSymbol();
                    } else if (parent instanceof ITemplateSymbol) {
                        parent = ((ITemplateSymbol)parent).getTemplatedSymbol();
                    }
                    if (!data.inheritanceChain.containsKey(parent)) {
                        if (!(parent instanceof IDerivableContainerSymbol)) {
                            throw new ParserSymbolTableException(1);
                        }
                        temp = ParserSymbolTable.lookupInContained(data, (IDerivableContainerSymbol)parent);
                        if (temp == null || temp.isEmpty() || data.isPrefixLookup()) {
                            inherited = ParserSymbolTable.lookupInParents(data, parent);
                            if (temp == null) {
                                temp = inherited;
                            } else {
                                ParserSymbolTable.mergeScopedResults((CharArrayObjectMap)temp, inherited);
                            }
                        }
                    } else {
                        throw new ParserSymbolTableException(2);
                    }
                }
                if (temp != null && !temp.isEmpty()) {
                    if (symbol == null || symbol.isEmpty()) {
                        symbol = temp;
                    } else if (temp != null && !temp.isEmpty()) {
                        char[] key = null;
                        int tempSize = temp.size();
                        int ii = 0;
                        while (ii < tempSize) {
                            key = ((CharTable)temp).keyAt(ii);
                            if (((CharTable)symbol).containsKey(key)) {
                                Object obj = ((CharArrayObjectMap)symbol).get(key);
                                List objList = obj instanceof List ? (List)obj : null;
                                int objListSize = objList != null ? objList.size() : 0;
                                int idx = 1;
                                ISymbol sym = (ISymbol)(objList != null && objListSize > 0 ? objList.get(0) : obj);
                                while (sym != null) {
                                    if (!ParserSymbolTable.checkAmbiguity(sym, ((CharArrayObjectMap)temp).get(key))) {
                                        if (data.isPrefixLookup()) {
                                            data.addAmbiguity(sym.getName());
                                        } else {
                                            throw new ParserSymbolTableException(0);
                                        }
                                    }
                                    sym = objList != null && idx < objListSize ? (ISymbol)objList.get(idx++) : null;
                                }
                            } else {
                                ((CharArrayObjectMap)symbol).put(key, ((CharArrayObjectMap)temp).get(key));
                            }
                            ++ii;
                        }
                    }
                } else {
                    temp = null;
                }
            }
            ++i;
        }
        data.inheritanceChain.remove(container);
        return symbol;
    }

    private static boolean checkAmbiguity(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            List objList = obj1 instanceof List ? (List)obj1 : null;
            int objListSize = objList != null ? objList.size() : 0;
            ISymbol symbol = objList != null ? (ISymbol)objList.get(0) : (ISymbol)obj1;
            int idx = 1;
            while (symbol != null) {
                ITypeInfo type = ((ISymbol)obj1).getTypeInfo();
                if (!type.checkBit(4) && !type.isType(ITypeInfo.t_enumerator)) {
                    return false;
                }
                symbol = objList != null && idx < objListSize ? (ISymbol)objList.get(idx++) : null;
            }
            return true;
        }
        return false;
    }

    private static void mergeScopedResults(CharArrayObjectMap resultMap, CharArrayObjectMap map) {
        if (resultMap == null || map == null || map.isEmpty()) {
            return;
        }
        char[] key = null;
        int size = map.size();
        int i = 0;
        while (i < size) {
            key = map.keyAt(i);
            if (!resultMap.containsKey(key)) {
                resultMap.put(key, map.get(key));
            }
            ++i;
        }
    }

    protected static boolean isValidOverload(ISymbol origSymbol, ISymbol newSymbol) {
        ITemplateSymbol template;
        ITypeInfo.eType origType = origSymbol.getType();
        ITypeInfo.eType newType = newSymbol.getType();
        if (origType == ITypeInfo.t_template) {
            template = (ITemplateSymbol)origSymbol;
            if ((origSymbol = template.getTemplatedSymbol()) == null) {
                return true;
            }
            origType = origSymbol.getType();
        }
        if (newType == ITypeInfo.t_template) {
            template = (ITemplateSymbol)newSymbol;
            if ((newSymbol = template.getTemplatedSymbol()) == null) {
                return true;
            }
            newType = newSymbol.getType();
        }
        if (newSymbol.isForwardDeclaration() && newSymbol.getForwardSymbol() == origSymbol) {
            return true;
        }
        if (origSymbol.isForwardDeclaration()) {
            if (origSymbol.getForwardSymbol() == newSymbol) {
                return true;
            }
            if (origSymbol.getIsInvisible() && origSymbol.isType(newSymbol.getType())) {
                origSymbol.setForwardSymbol(newSymbol);
                return true;
            }
        }
        if (origType.compareTo(ITypeInfo.t_class) >= 0 && origType.compareTo(ITypeInfo.t_enumeration) <= 0 && (newType == ITypeInfo.t_type || newType.compareTo(ITypeInfo.t_function) >= 0)) {
            return true;
        }
        if (newType.compareTo(ITypeInfo.t_class) >= 0 && newType.compareTo(ITypeInfo.t_enumeration) <= 0 && (origType == ITypeInfo.t_type || origType.compareTo(ITypeInfo.t_function) >= 0)) {
            return true;
        }
        if (origSymbol instanceof IParameterizedSymbol && newSymbol instanceof IParameterizedSymbol) {
            return ParserSymbolTable.isValidFunctionOverload((IParameterizedSymbol)origSymbol, (IParameterizedSymbol)newSymbol);
        }
        if (origSymbol.getTypeInfo().checkBit(256) && newSymbol.getTypeInfo().checkBit(256)) {
            TypeInfoProvider provider = origSymbol.getSymbolTable().getTypeInfoProvider();
            ITypeInfo origFlat = origSymbol.getTypeInfo().getFinalType(provider);
            ITypeInfo newFlat = origSymbol.getTypeInfo().getFinalType(provider);
            boolean equals = origFlat.equals(newFlat);
            provider.returnTypeInfo(origFlat);
            provider.returnTypeInfo(newFlat);
            return equals;
        }
        return false;
    }

    protected static boolean isValidOverload(List origList, ISymbol newSymbol) {
        if (origList.size() == 1) {
            return ParserSymbolTable.isValidOverload((ISymbol)origList.get(0), newSymbol);
        }
        if (origList.size() > 1) {
            if (newSymbol.isType(ITypeInfo.t_template) && newSymbol instanceof ITemplateSymbol) {
                newSymbol = ((ITemplateSymbol)newSymbol).getTemplatedSymbol();
            }
            if (newSymbol.getType() != ITypeInfo.t_function && newSymbol.getType() != ITypeInfo.t_constructor) {
                return false;
            }
            ISymbol symbol = (ISymbol)origList.get(0);
            int numSymbols = origList.size();
            if (symbol.isType(ITypeInfo.t_template) && symbol instanceof ITemplateSymbol) {
                symbol = ((ITemplateSymbol)symbol).getTemplatedSymbol();
            }
            boolean valid = ParserSymbolTable.isValidOverload(symbol, newSymbol);
            int idx = 1;
            while (valid && idx < numSymbols) {
                if ((symbol = (ISymbol)origList.get(idx++)).isType(ITypeInfo.t_template)) {
                    ITemplateSymbol template = (ITemplateSymbol)symbol;
                    symbol = template.getTemplatedSymbol();
                }
                boolean bl = valid = symbol instanceof IParameterizedSymbol && ParserSymbolTable.isValidFunctionOverload((IParameterizedSymbol)symbol, (IParameterizedSymbol)newSymbol);
            }
            return valid;
        }
        return true;
    }

    private static boolean isValidFunctionOverload(IParameterizedSymbol origSymbol, IParameterizedSymbol newSymbol) {
        if (!origSymbol.isType(ITypeInfo.t_function) && !origSymbol.isType(ITypeInfo.t_constructor) || !newSymbol.isType(ITypeInfo.t_function) && !newSymbol.isType(ITypeInfo.t_constructor)) {
            return false;
        }
        if (origSymbol.isForwardDeclaration() && origSymbol.getForwardSymbol() == newSymbol) {
            return true;
        }
        if (origSymbol.hasSameParameters(newSymbol)) {
            if (origSymbol.getTypeInfo().checkBit(4) || newSymbol.getTypeInfo().checkBit(4)) {
                return false;
            }
            if ((origSymbol.getTypeInfo().getTypeBits() & 0xC00) != (newSymbol.getTypeInfo().getTypeBits() & 0xC00)) {
                return true;
            }
            return newSymbol.isForwardDeclaration() && newSymbol.getForwardSymbol() != null && newSymbol.getContainingSymbol() == origSymbol.getContainingSymbol() && newSymbol.getForwardSymbol().getContainingSymbol() != newSymbol.getContainingSymbol() && origSymbol.isForwardDeclaration() && origSymbol.getForwardSymbol() != null && origSymbol.getForwardSymbol().getContainingSymbol() != origSymbol.getContainingSymbol();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ISymbol resolveAmbiguities(LookupData data) throws ParserSymbolTableException {
        ISymbol resolvedSymbol = null;
        if (data.foundItems == null) return null;
        if (data.foundItems.isEmpty()) return null;
        if (data.isPrefixLookup()) {
            return null;
        }
        Object object = data.foundItems.get(data.name);
        ArrayList<ISymbol> functionList = null;
        if (object instanceof List) {
            functionList = new ArrayList<ISymbol>(((List)object).size());
            functionList.addAll((List)object);
        } else {
            ISymbol symbol = (ISymbol)object;
            if (symbol.isType(ITypeInfo.t_function)) {
                functionList = new ArrayList(1);
                functionList.add(symbol);
            } else if (symbol.isTemplateMember() && !symbol.isTemplateInstance() && !symbol.isType(ITypeInfo.t_templateParameter) && symbol.getContainingSymbol().isType(ITypeInfo.t_template)) {
                resolvedSymbol = symbol.getContainingSymbol();
                if (resolvedSymbol instanceof ISpecializedSymbol) {
                    resolvedSymbol = ((ISpecializedSymbol)resolvedSymbol).getPrimaryTemplate();
                }
            } else {
                resolvedSymbol = symbol;
            }
        }
        if (resolvedSymbol != null) return resolvedSymbol;
        if (data.getParameters() != null) return this.resolveFunction(data, functionList);
        if (functionList.size() != 1) throw new ParserSymbolTableException(7);
        return (ISymbol)functionList.get(0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IParameterizedSymbol resolveFunction(LookupData data, List functions) throws ParserSymbolTableException {
        block76: {
            if (functions == null) {
                return null;
            }
            ParserSymbolTable.reduceToViable(data, functions);
            if (data.exactFunctionsOnly && data.getTemplateParameters() == null) {
                if (functions.size() == 1) {
                    return (IParameterizedSymbol)functions.get(0);
                }
                if (functions.size() == 0) {
                    return null;
                }
                throw new ParserSymbolTableException(0);
            }
            numSourceParams = data.getParameters() == null ? 0 : data.getParameters().size();
            numFns = functions.size();
            if (numSourceParams == 0) {
                if (numFns == 0) {
                    return null;
                }
                if (numFns == 1) {
                    return (IParameterizedSymbol)functions.get(0);
                }
                if (numFns == 2) {
                    i = 0;
                    while (i < numFns) {
                        fn = (IParameterizedSymbol)functions.get(i);
                        if (fn.isForwardDeclaration() && fn.getForwardSymbol() != null && functions.contains(fn.getForwardSymbol())) {
                            return (IParameterizedSymbol)fn.getForwardSymbol();
                        }
                        ++i;
                    }
                }
                if (data.getParameters() == null) {
                    throw new ParserSymbolTableException(0);
                }
            }
            bestFn = null;
            currFn = null;
            bestFnCost = null;
            currFnCost = null;
            source = null;
            target = null;
            voidInfo = null;
            cost = null;
            temp = null;
            hasWorse = false;
            hasBetter = false;
            ambiguous = false;
            currHasAmbiguousParam = false;
            bestHasAmbiguousParam = false;
            sourceParameters = null;
            targetParameters = null;
            infoProvider = this.getTypeInfoProvider();
            if (numSourceParams == 0) {
                sourceParameters = new ArrayList<ITypeInfo>(1);
                voidInfo = infoProvider.getTypeInfo(ITypeInfo.t_void);
                voidInfo.setType(ITypeInfo.t_void);
                sourceParameters.add(voidInfo);
                numSourceParams = 1;
            } else {
                sourceParameters = data.getParameters();
            }
            try {
                fnIdx = 0;
                while (fnIdx < numFns) {
                    block75: {
                        block77: {
                            block78: {
                                currFn = (IParameterizedSymbol)functions.get(fnIdx);
                                if (bestFn == null) break block77;
                                if (!bestFn.isForwardDeclaration() || bestFn.getForwardSymbol() != currFn) break block78;
                                bestFn = currFn;
                                break block75;
                            }
                            if (currFn.isForwardDeclaration() && currFn.getForwardSymbol() == bestFn) break block75;
                        }
                        if (currFn.getParameterList().isEmpty() && !currFn.hasVariableArgs()) {
                            targetParameters = new ArrayList<ISymbol>(1);
                            targetParameters.add(currFn.getSymbolTable().newSymbol(ParserSymbolTable.EMPTY_NAME_ARRAY, ITypeInfo.t_void));
                        } else {
                            targetParameters = currFn.getParameterList();
                        }
                        numTargetParams = targetParameters.size();
                        if (currFnCost == null) {
                            currFnCost = new Cost[numSourceParams];
                        }
                        comparison = 0;
                        varArgs = false;
                        j = 0;
                        while (true) {
                            if (j >= numSourceParams) {
                                hasWorse = false;
                                hasBetter = false;
                                j = 0;
                                break;
                            }
                            source = (ITypeInfo)sourceParameters.get(j);
                            if (j < numTargetParams) {
                                target = ((ISymbol)targetParameters.get(j)).getTypeInfo();
                            } else {
                                varArgs = true;
                            }
                            if (varArgs) {
                                cost = new Cost(infoProvider, source, null);
                                cost.rank = 5;
                            } else if (target.getHasDefault() && source.isType(ITypeInfo.t_void) && !source.hasPtrOperators()) {
                                cost = new Cost(infoProvider, source, target);
                                cost.rank = 0;
                            } else if (source.equals(target)) {
                                cost = new Cost(infoProvider, source, target);
                                cost.rank = 0;
                            } else {
                                try {
                                    cost = this.checkStandardConversionSequence(source, target);
                                    if (cost.rank == -1 && !data.forUserDefinedConversion && (temp = this.checkUserDefinedConversionSequence(source, target)) != null) {
                                        cost.release(infoProvider);
                                        cost = temp;
                                    }
                                }
                                catch (ParserSymbolTableException e) {
                                    if (cost != null) {
                                        cost.release(infoProvider);
                                        cost = null;
                                    }
                                    if (temp != null) {
                                        temp.release(infoProvider);
                                        temp = null;
                                    }
                                    throw e;
                                }
                                catch (ParserSymbolTableError e) {
                                    if (cost != null) {
                                        cost.release(infoProvider);
                                        cost = null;
                                    }
                                    if (temp != null) {
                                        temp.release(infoProvider);
                                        temp = null;
                                    }
                                    throw e;
                                }
                            }
                            currFnCost[j] = cost;
                            ++j;
                        }
                        while (j < numSourceParams) {
                            if (currFnCost[j].rank < 0) {
                                hasWorse = true;
                                hasBetter = false;
                                if (!data.isPrefixLookup()) break;
                                functions.remove(fnIdx--);
                                --numFns;
                                break;
                            }
                            v0 = currHasAmbiguousParam = currFnCost[j].userDefined == 1;
                            if (bestFnCost != null) {
                                comparison = currFnCost[j].compare(bestFnCost[j]);
                                hasWorse |= comparison < 0;
                                hasBetter |= comparison > 0;
                            } else {
                                hasBetter = true;
                            }
                            ++j;
                        }
                        if (data.isPrefixLookup()) {
                            ParserSymbolTable.releaseCosts(currFnCost, infoProvider);
                        } else {
                            ambiguous |= hasWorse != false && hasBetter != false || hasWorse == false && hasBetter == false;
                            if (!hasWorse) {
                                if (!hasBetter) {
                                    bestIsTemplate = bestFn.getContainingSymbol() instanceof ITemplateSymbol;
                                    currIsTemplate = currFn.getContainingSymbol() instanceof ITemplateSymbol;
                                    if (bestIsTemplate && currIsTemplate) {
                                        try {
                                            t1 = (ITemplateSymbol)bestFn.getInstantiatedSymbol().getContainingSymbol();
                                            t2 = (ITemplateSymbol)currFn.getInstantiatedSymbol().getContainingSymbol();
                                            order = TemplateEngine.orderTemplateFunctions(t1, t2);
                                            if (order < 0) {
                                                hasBetter = true;
                                            }
                                            if (order <= 0) ** GOTO lbl184
                                            ambiguous = false;
                                        }
                                        catch (ParserSymbolTableException e) {
                                            if (currFnCost != null) {
                                                ParserSymbolTable.releaseCosts(currFnCost, infoProvider);
                                            }
                                            if (bestFnCost != null) {
                                                ParserSymbolTable.releaseCosts(bestFnCost, infoProvider);
                                            }
                                            throw e;
                                        }
                                        catch (ParserSymbolTableError e) {
                                            if (currFnCost != null) {
                                                ParserSymbolTable.releaseCosts(currFnCost, infoProvider);
                                            }
                                            if (bestFnCost != null) {
                                                ParserSymbolTable.releaseCosts(bestFnCost, infoProvider);
                                            }
                                            throw e;
                                        }
                                    } else if (bestIsTemplate && !currIsTemplate) {
                                        if (data.getTemplateParameters() == null) {
                                            hasBetter = true;
                                        } else {
                                            ambiguous = false;
                                        }
                                    } else if (!bestIsTemplate && currIsTemplate) {
                                        if (data.getTemplateParameters() == null) {
                                            ambiguous = false;
                                        } else {
                                            hasBetter = true;
                                        }
                                    }
                                }
                                if (hasBetter) {
                                    ambiguous = false;
                                    ParserSymbolTable.releaseCosts(bestFnCost, infoProvider);
                                    bestFnCost = currFnCost;
                                    bestHasAmbiguousParam = currHasAmbiguousParam;
                                    currFnCost = null;
                                    bestFn = currFn;
                                } else {
                                    ParserSymbolTable.releaseCosts(currFnCost, infoProvider);
                                }
                            } else {
                                ParserSymbolTable.releaseCosts(currFnCost, infoProvider);
                            }
                        }
                    }
                    ++fnIdx;
                }
            }
            catch (Throwable var32_36) {
                var31_37 = null;
                if (currFnCost != null) {
                    ParserSymbolTable.releaseCosts(currFnCost, infoProvider);
                    currFnCost = null;
                }
                if (bestFnCost != null) {
                    ParserSymbolTable.releaseCosts(bestFnCost, infoProvider);
                    bestFnCost = null;
                }
                if (voidInfo != null) {
                    infoProvider.returnTypeInfo(voidInfo);
                }
                throw var32_36;
            }
            {
                var31_38 = null;
                if (currFnCost == null) break block76;
            }
            ParserSymbolTable.releaseCosts(currFnCost, infoProvider);
            currFnCost = null;
        }
        if (bestFnCost != null) {
            ParserSymbolTable.releaseCosts(bestFnCost, infoProvider);
            bestFnCost = null;
        }
        if (voidInfo != null) {
            infoProvider.returnTypeInfo(voidInfo);
        }
        if (!ambiguous && !bestHasAmbiguousParam) {
            return bestFn;
        }
        throw new ParserSymbolTableException(0);
    }

    private static void releaseCosts(Cost[] costs, TypeInfoProvider provider) {
        if (costs != null && provider != null) {
            int i = 0;
            while (i < costs.length) {
                if (costs[i] != null) {
                    costs[i].release(provider);
                }
                ++i;
            }
        }
    }

    private static boolean functionHasParameters(IParameterizedSymbol function, List params) {
        if (params == null) {
            return function.getParameterList().isEmpty();
        }
        IParameterizedSymbol tempFn = function.getSymbolTable().newParameterizedSymbol(EMPTY_NAME_ARRAY, ITypeInfo.t_function);
        int size = params.size();
        int i = 0;
        while (i < size) {
            ISymbol param = function.getSymbolTable().newSymbol(EMPTY_NAME_ARRAY);
            param.setTypeInfo((ITypeInfo)params.get(i));
            tempFn.addParameter(param);
            ++i;
        }
        return function.hasSameParameters(tempFn);
    }

    private static void reduceToViable(LookupData data, List functions) {
        int numParameters;
        int n = numParameters = data.getParameters() == null ? 0 : data.getParameters().size();
        if (data.isPrefixLookup() && numParameters >= 1) {
            ++numParameters;
        }
        Object obj = null;
        int size = functions.size();
        int i = 0;
        while (i < size) {
            block14: {
                ISymbol param;
                ITypeInfo paramType;
                int num;
                IParameterizedSymbol function;
                block13: {
                    block12: {
                        obj = functions.get(i);
                        if (!(obj instanceof IParameterizedSymbol)) break block12;
                        function = obj;
                        if (function.isType(ITypeInfo.t_function) || function.isType(ITypeInfo.t_constructor)) break block13;
                        functions.remove(i--);
                        --size;
                        break block14;
                    }
                    functions.remove(i--);
                    --size;
                    break block14;
                }
                int n2 = num = function.getParameterList() == null ? 0 : function.getParameterList().size();
                if (num == numParameters) {
                    if (data.exactFunctionsOnly && !ParserSymbolTable.functionHasParameters(function, data.getParameters())) {
                        functions.remove(i--);
                        --size;
                    }
                } else if (!(numParameters != 0 || num != 1 ? numParameters == 1 && num == 0 && (paramType = (ITypeInfo)data.getParameters().get(0)).isType(ITypeInfo.t_void) : (param = (ISymbol)function.getParameterList().get(0)).isType(ITypeInfo.t_void))) {
                    if (num < numParameters) {
                        if (!function.hasVariableArgs()) {
                            functions.remove(i--);
                            --size;
                        }
                    } else if (!data.isPrefixLookup()) {
                        List params = function.getParameterList();
                        int j = num - 1;
                        while (j > numParameters - num) {
                            ITypeInfo param2 = ((ISymbol)params.get(j)).getTypeInfo();
                            if (!param2.getHasDefault()) {
                                functions.remove(i--);
                                --size;
                                break;
                            }
                            --j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static void processDirectives(IContainerSymbol symbol, LookupData data, List directives) {
        IContainerSymbol enclosing = null;
        IContainerSymbol temp = null;
        if (directives == null) {
            return;
        }
        int size = directives.size();
        int i = 0;
        while (i < size) {
            temp = ((IUsingDirectiveSymbol)directives.get(i)).getNamespace();
            if (!data.visited.containsKey(temp)) {
                ArrayList<IContainerSymbol> list;
                enclosing = ParserSymbolTable.getClosestEnclosingDeclaration(symbol, temp);
                ArrayList<IContainerSymbol> arrayList = list = data.usingDirectives == null ? null : (ArrayList<IContainerSymbol>)data.usingDirectives.get(enclosing);
                if (list == null) {
                    list = new ArrayList<IContainerSymbol>(4);
                    list.add(temp);
                    if (data.usingDirectives == null) {
                        data.usingDirectives = new ObjectMap(2);
                    }
                    data.usingDirectives.put(enclosing, list);
                } else {
                    list.add(temp);
                }
            }
            ++i;
        }
    }

    private static IContainerSymbol getClosestEnclosingDeclaration(ISymbol symbol1, ISymbol symbol2) {
        if (symbol1 == symbol2) {
            return symbol1 instanceof IContainerSymbol ? (IContainerSymbol)symbol1 : symbol1.getContainingSymbol();
        }
        if (symbol1.getDepth() == symbol2.getDepth()) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(symbol1.getContainingSymbol(), symbol2.getContainingSymbol());
        }
        if (symbol1.getDepth() > symbol2.getDepth()) {
            return ParserSymbolTable.getClosestEnclosingDeclaration(symbol1.getContainingSymbol(), symbol2);
        }
        return ParserSymbolTable.getClosestEnclosingDeclaration(symbol1, symbol2.getContainingSymbol());
    }

    protected static int hasBaseClass(ISymbol obj, ISymbol base) throws ParserSymbolTableException {
        return ParserSymbolTable.hasBaseClass(obj, base, false);
    }

    private static int hasBaseClass(ISymbol obj, ISymbol base, boolean throwIfNotVisible) throws ParserSymbolTableException {
        if (obj == base) {
            return 0;
        }
        IDerivableContainerSymbol symbol = null;
        if (!(obj instanceof IDerivableContainerSymbol)) {
            return -1;
        }
        symbol = (IDerivableContainerSymbol)obj;
        if (symbol.hasParents()) {
            ISymbol temp = null;
            IDerivableContainerSymbol parent = null;
            List parents = symbol.getParents();
            int size = parents.size();
            int i = 0;
            while (i < size) {
                boolean isVisible;
                IDerivableContainerSymbol.IParentSymbol wrapper = (IDerivableContainerSymbol.IParentSymbol)parents.get(i);
                temp = wrapper.getParent();
                boolean bl = isVisible = wrapper.getAccess() == ASTAccessVisibility.PUBLIC;
                if (temp instanceof IDerivableContainerSymbol) {
                    parent = (IDerivableContainerSymbol)temp;
                    if (parent == base) {
                        if (throwIfNotVisible && !isVisible) {
                            throw new ParserSymbolTableException(6);
                        }
                        return 1;
                    }
                    int n = ParserSymbolTable.hasBaseClass(parent, base, throwIfNotVisible);
                    if (n > 0) {
                        return n + 1;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    protected static void getAssociatedScopes(ISymbol symbol, ObjectSet associated) {
        if (symbol == null) {
            return;
        }
        if (symbol instanceof IDerivableContainerSymbol) {
            associated.put(symbol);
            associated.put(symbol.getContainingSymbol());
            ParserSymbolTable.getBaseClassesAndContainingNamespaces((IDerivableContainerSymbol)symbol, associated);
        } else if (symbol.getType() == ITypeInfo.t_union || symbol.getType() == ITypeInfo.t_enumeration) {
            associated.put(symbol.getContainingSymbol());
        }
    }

    private static void getBaseClassesAndContainingNamespaces(IDerivableContainerSymbol obj, ObjectSet classes) {
        if (obj.getParents() != null) {
            if (classes == null) {
                return;
            }
            List parents = obj.getParents();
            int size = parents.size();
            int i = 0;
            while (i < size) {
                IDerivableContainerSymbol.IParentSymbol wrapper = (IDerivableContainerSymbol.IParentSymbol)parents.get(i);
                ISymbol base = wrapper.getParent();
                if (base instanceof IDerivableContainerSymbol) {
                    classes.put(base);
                    if (base.getContainingSymbol().getType() == ITypeInfo.t_namespace) {
                        classes.put(base.getContainingSymbol());
                    }
                    ParserSymbolTable.getBaseClassesAndContainingNamespaces((IDerivableContainerSymbol)base, classes);
                }
                ++i;
            }
        }
    }

    protected static boolean okToAddUsingDeclaration(ISymbol obj, IContainerSymbol context) {
        boolean okToAdd = false;
        if (obj.isTemplateInstance() && obj.getInstantiatedSymbol().getContainingSymbol().isType(ITypeInfo.t_template)) {
            okToAdd = false;
        } else if (context.isType(ITypeInfo.t_class, ITypeInfo.t_struct)) {
            IContainerSymbol container = obj.getContainingSymbol();
            try {
                if (obj.getContainingSymbol().getType() == context.getType()) {
                    okToAdd = ParserSymbolTable.hasBaseClass(context, container) > 0;
                } else if (obj.getContainingSymbol().getType() == ITypeInfo.t_union) {
                    okToAdd = (container = container.getContainingSymbol()) instanceof IDerivableContainerSymbol ? ParserSymbolTable.hasBaseClass(context, container) > 0 : false;
                } else if (obj.getType() == ITypeInfo.t_enumerator) {
                    okToAdd = (container = container.getContainingSymbol()) instanceof IDerivableContainerSymbol ? ParserSymbolTable.hasBaseClass(context, container) > 0 : false;
                }
            }
            catch (ParserSymbolTableException parserSymbolTableException) {}
        } else {
            okToAdd = true;
        }
        return okToAdd;
    }

    private static Cost lvalue_to_rvalue(TypeInfoProvider provider, ITypeInfo source, ITypeInfo target) {
        int i;
        int size;
        ITypeInfo.PtrOp ptr;
        Cost cost;
        if (source.isType(ITypeInfo.t_type)) {
            source = ParserSymbolTable.getFlatTypeInfo(source, null);
        }
        if (target.isType(ITypeInfo.t_type)) {
            target = ParserSymbolTable.getFlatTypeInfo(target, null);
        }
        if ((cost = new Cost(provider, source, target)).getSource() == null || cost.getTarget() == null) {
            return cost;
        }
        ITypeInfo.PtrOp op = null;
        if (cost.getSource().hasPtrOperators()) {
            List sourcePtrs = cost.getSource().getPtrOperators();
            ptr = (ITypeInfo.PtrOp)sourcePtrs.get(0);
            if (ptr.getType() == ITypeInfo.PtrOp.t_reference) {
                sourcePtrs.remove(0);
            }
            size = sourcePtrs.size();
            i = 0;
            while (i < size) {
                op = (ITypeInfo.PtrOp)sourcePtrs.get(0);
                if (op.getType() == ITypeInfo.PtrOp.t_array) {
                    op.setType(ITypeInfo.PtrOp.t_pointer);
                }
                ++i;
            }
        }
        if (cost.getTarget().hasPtrOperators()) {
            List targetPtrs = cost.getTarget().getPtrOperators();
            ptr = (ITypeInfo.PtrOp)targetPtrs.get(0);
            if (ptr.getType() == ITypeInfo.PtrOp.t_reference) {
                targetPtrs.remove(0);
                cost.targetHadReference = true;
            }
            size = targetPtrs.size();
            i = 0;
            while (i < size) {
                op = (ITypeInfo.PtrOp)targetPtrs.get(0);
                if (op.getType() == ITypeInfo.PtrOp.t_array) {
                    op.setType(ITypeInfo.PtrOp.t_pointer);
                }
                ++i;
            }
        }
        return cost;
    }

    private static void qualificationConversion(Cost cost) {
        List sourcePtrs = cost.getSource().getPtrOperators();
        List targetPtrs = cost.getTarget().getPtrOperators();
        int size = sourcePtrs.size();
        int size2 = targetPtrs.size();
        ITypeInfo.PtrOp op1 = null;
        ITypeInfo.PtrOp op2 = null;
        boolean canConvert = true;
        if (size != size2) {
            canConvert = false;
        } else if (size > 0) {
            op1 = (ITypeInfo.PtrOp)sourcePtrs.get(0);
            op2 = (ITypeInfo.PtrOp)targetPtrs.get(0);
            boolean constInEveryCV2k = true;
            int j = 1;
            while (j < size) {
                op1 = (ITypeInfo.PtrOp)sourcePtrs.get(j);
                op2 = (ITypeInfo.PtrOp)targetPtrs.get(j);
                if (op1.getType() != op2.getType()) {
                    canConvert = false;
                    break;
                }
                if (op1.isConst() && !op2.isConst() || op1.isVolatile() && !op2.isVolatile()) {
                    canConvert = false;
                    break;
                }
                if (op1.compareCVTo(op2) != 0 && !constInEveryCV2k) {
                    canConvert = false;
                    break;
                }
                constInEveryCV2k &= op2.isConst();
                ++j;
            }
        }
        if (cost.getSource().checkBit(1024) && !cost.getTarget().checkBit(1024) || cost.getSource().checkBit(2048) && !cost.getTarget().checkBit(2048)) {
            canConvert = false;
        }
        if (canConvert) {
            cost.qualification = 1;
            cost.rank = 0;
        } else {
            cost.qualification = 0;
        }
    }

    private static void promotion(Cost cost) {
        ITypeInfo src = cost.getSource();
        ITypeInfo trg = cost.getTarget();
        int mask = 815104;
        if (src.isType(ITypeInfo.t__Bool, ITypeInfo.t_float) && (trg.isType(ITypeInfo.t_int) || trg.isType(ITypeInfo.t_double))) {
            if (src.getType() == trg.getType() && (src.getTypeBits() & mask) == (trg.getTypeBits() & mask)) {
                return;
            }
            cost.promotion = src.isType(ITypeInfo.t_float) ? (trg.isType(ITypeInfo.t_double) ? 1 : 0) : (trg.isType(ITypeInfo.t_int) && trg.canHold(src) ? 1 : 0);
        } else {
            cost.promotion = 0;
        }
        cost.rank = cost.promotion > 0 ? 1 : -1;
    }

    private static void conversion(Cost cost) {
        ITypeInfo src = cost.getSource();
        ITypeInfo trg = cost.getTarget();
        int temp = -1;
        cost.conversion = 0;
        cost.detail = 0;
        if (!src.hasSamePtrs(trg)) {
            return;
        }
        if (src.hasPtrOperators() && src.getPtrOperators().size() == 1) {
            ISymbol trgDecl;
            ITypeInfo.PtrOp ptr = (ITypeInfo.PtrOp)src.getPtrOperators().get(0);
            ISymbol srcDecl = src.isType(ITypeInfo.t_type) ? src.getTypeSymbol() : null;
            ISymbol iSymbol = trgDecl = trg.isType(ITypeInfo.t_type) ? trg.getTypeSymbol() : null;
            if (ptr.getType() == ITypeInfo.PtrOp.t_pointer) {
                if (srcDecl == null || trgDecl == null && !trg.isType(ITypeInfo.t_void)) {
                    return;
                }
                if (trg.isType(ITypeInfo.t_void)) {
                    cost.rank = 2;
                    cost.conversion = 1;
                    cost.detail = 2;
                    return;
                }
                cost.detail = 1;
                if (srcDecl instanceof IDerivableContainerSymbol && trgDecl.isType(srcDecl.getType())) {
                    try {
                        temp = ParserSymbolTable.hasBaseClass(srcDecl, trgDecl);
                    }
                    catch (ParserSymbolTableException parserSymbolTableException) {}
                    cost.rank = temp > -1 ? 2 : -1;
                    cost.conversion = temp > -1 ? temp : 0;
                    cost.detail = 1;
                    return;
                }
            } else if (ptr.getType() == ITypeInfo.PtrOp.t_memberPointer) {
                ITypeInfo.PtrOp srcPtr;
                if (srcDecl == null || trgDecl == null) {
                    return;
                }
                ITypeInfo.PtrOp ptrOp = srcPtr = trg.hasPtrOperators() ? (ITypeInfo.PtrOp)trg.getPtrOperators().get(0) : null;
                if (trgDecl.isType(srcDecl.getType()) && srcPtr != null && srcPtr.getType() == ITypeInfo.PtrOp.t_memberPointer) {
                    try {
                        temp = ParserSymbolTable.hasBaseClass(ptr.getMemberOf(), srcPtr.getMemberOf());
                    }
                    catch (ParserSymbolTableException parserSymbolTableException) {}
                    cost.rank = temp > -1 ? 2 : -1;
                    cost.detail = 1;
                    cost.conversion = temp > -1 ? temp : 0;
                    return;
                }
            }
        } else if (!src.hasPtrOperators() && (src.isType(ITypeInfo.t__Bool, ITypeInfo.t_int) || src.isType(ITypeInfo.t_float, ITypeInfo.t_double) || src.isType(ITypeInfo.t_enumeration) || src.isType(ITypeInfo.t_type) && src.getTypeSymbol() != null && src.getTypeSymbol().isType(ITypeInfo.t_enumeration)) && (trg.isType(ITypeInfo.t__Bool, ITypeInfo.t_int) || trg.isType(ITypeInfo.t_float, ITypeInfo.t_double))) {
            cost.rank = 2;
            cost.conversion = 1;
        }
    }

    private static void derivedToBaseConversion(Cost cost) throws ParserSymbolTableException {
        ISymbol trgDecl;
        ITypeInfo src = cost.getSource();
        ITypeInfo trg = cost.getTarget();
        ISymbol srcDecl = src.isType(ITypeInfo.t_type) ? src.getTypeSymbol() : null;
        ISymbol iSymbol = trgDecl = trg.isType(ITypeInfo.t_type) ? trg.getTypeSymbol() : null;
        if (!src.hasSamePtrs(trg) || srcDecl == null || trgDecl == null || !cost.targetHadReference) {
            return;
        }
        int temp = ParserSymbolTable.hasBaseClass(srcDecl, trgDecl, true);
        if (temp > -1) {
            cost.rank = 3;
            cost.conversion = temp;
        }
    }

    protected Cost checkStandardConversionSequence(ITypeInfo source, ITypeInfo target) throws ParserSymbolTableException {
        Cost cost = ParserSymbolTable.lvalue_to_rvalue(this.getTypeInfoProvider(), source, target);
        if (cost.getSource() == null || cost.getTarget() == null) {
            return cost;
        }
        if (cost.getSource().equals(cost.getTarget())) {
            cost.rank = 0;
            return cost;
        }
        ParserSymbolTable.qualificationConversion(cost);
        if (cost.qualification == 0) {
            return cost;
        }
        if (cost.getSource().isType(ITypeInfo.t_type) && cost.getTarget().isType(ITypeInfo.t_type)) {
            if (cost.getTarget().hasSamePtrs(cost.getSource())) {
                ISymbol srcSymbol = cost.getSource().getTypeSymbol();
                ISymbol trgSymbol = cost.getTarget().getTypeSymbol();
                if (srcSymbol != null && trgSymbol != null && srcSymbol.equals(trgSymbol)) {
                    return cost;
                }
            }
        } else if (cost.getSource().getType() == cost.getTarget().getType() && (cost.getSource().getTypeBits() & 0xFFFFFBFF & 0xFFFFF7FF) == (cost.getTarget().getTypeBits() & 0xFFFFFBFF & 0xFFFFF7FF)) {
            return cost;
        }
        ParserSymbolTable.promotion(cost);
        if (cost.promotion > 0 || cost.rank > -1) {
            return cost;
        }
        ParserSymbolTable.conversion(cost);
        if (cost.rank > -1) {
            return cost;
        }
        try {
            ParserSymbolTable.derivedToBaseConversion(cost);
        }
        catch (ParserSymbolTableException e) {
            cost.release(this.getTypeInfoProvider());
            throw e;
        }
        return cost;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Cost checkUserDefinedConversionSequence(ITypeInfo source, ITypeInfo target) throws ParserSymbolTableException {
        Object var12_12;
        Cost cost = null;
        Cost constructorCost = null;
        Cost conversionCost = null;
        ISymbol targetDecl = null;
        ISymbol sourceDecl = null;
        ISymbol constructor = null;
        Object conversion = null;
        if (target.getType() == ITypeInfo.t_type) {
            targetDecl = target.getTypeSymbol();
            if (targetDecl == null) {
                throw new ParserSymbolTableException(1);
            }
            if (targetDecl.isType(ITypeInfo.t_class, ITypeInfo.t_union)) {
                IDerivableContainerSymbol container;
                LookupData data = new LookupData(EMPTY_NAME_ARRAY){
                    private List parameters = new ArrayList(1);

                    public List getParameters() {
                        return this.parameters;
                    }

                    public TypeFilter getFilter() {
                        return CONSTRUCTOR_FILTER;
                    }
                };
                data.forUserDefinedConversion = true;
                data.getParameters().add(source);
                if (targetDecl instanceof IDeferredTemplateInstance) {
                    targetDecl = ((IDeferredTemplateInstance)targetDecl).getTemplate().getTemplatedSymbol();
                }
                if (!(container = (IDerivableContainerSymbol)targetDecl).getConstructors().isEmpty()) {
                    ArrayList constructors = new ArrayList(container.getConstructors());
                    constructor = this.resolveFunction(data, constructors);
                }
                if (constructor != null && constructor.getTypeInfo().checkBit(128)) {
                    constructor = null;
                }
            }
        }
        TypeInfoProvider provider = this.getTypeInfoProvider();
        if (source.getType() == ITypeInfo.t_type) {
            char[] name;
            sourceDecl = (source = ParserSymbolTable.getFlatTypeInfo(source, provider)) != null ? source.getTypeSymbol() : null;
            provider.returnTypeInfo(source);
            if (sourceDecl != null && sourceDecl instanceof IContainerSymbol && !CharArrayUtils.equals(name = target.toCharArray(), EMPTY_NAME_ARRAY)) {
                LookupData data = new LookupData(CharArrayUtils.concat(OPERATOR_, name)){

                    public List getParameters() {
                        return Collections.EMPTY_LIST;
                    }

                    public TypeFilter getFilter() {
                        return FUNCTION_FILTER;
                    }
                };
                data.forUserDefinedConversion = true;
                data.foundItems = ParserSymbolTable.lookupInContained(data, (IContainerSymbol)sourceDecl);
                conversion = data.foundItems != null ? (IParameterizedSymbol)this.resolveAmbiguities(data) : null;
            }
        }
        try {
            ITypeInfo info;
            if (constructor != null) {
                info = provider.getTypeInfo(ITypeInfo.t_type);
                info.setTypeSymbol(constructor.getContainingSymbol());
                constructorCost = this.checkStandardConversionSequence(info, target);
                provider.returnTypeInfo(info);
            }
            if (conversion != null) {
                info = provider.getTypeInfo(target.getType());
                info.setTypeSymbol(target.getTypeSymbol());
                conversionCost = this.checkStandardConversionSequence(info, target);
                provider.returnTypeInfo(info);
            }
            if (constructorCost != null && constructorCost.rank != -1 && conversionCost != null && conversionCost.rank != -1) {
                cost = constructorCost;
                cost.userDefined = 1;
                cost.rank = 4;
            } else if (constructorCost != null && constructorCost.rank != -1) {
                cost = constructorCost;
                cost.userDefined = constructor.hashCode();
                cost.rank = 4;
            } else if (conversionCost != null && conversionCost.rank != -1) {
                cost = conversionCost;
                cost.userDefined = conversion.hashCode();
                cost.rank = 4;
            }
            var12_12 = null;
            if (constructorCost != null && constructorCost != cost) {
                constructorCost.release(provider);
            }
            if (conversionCost == null) return cost;
            if (conversionCost == cost) return cost;
            conversionCost.release(provider);
            return cost;
        }
        catch (Throwable throwable) {
            var12_12 = null;
            if (constructorCost != null && constructorCost != cost) {
                constructorCost.release(provider);
            }
            if (conversionCost == null) throw throwable;
            if (conversionCost == cost) throw throwable;
            conversionCost.release(provider);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ITypeInfo getConditionalOperand(ITypeInfo secondOp, ITypeInfo thirdOp) throws ParserSymbolTableException {
        boolean canConvertThird;
        boolean canConvertSecond;
        Cost thirdCost = null;
        Cost secondCost = null;
        ITypeInfo temp = null;
        TypeInfoProvider provider = this.getTypeInfoProvider();
        try {
            temp = ParserSymbolTable.getFlatTypeInfo(thirdOp, provider);
            secondCost = this.checkStandardConversionSequence(secondOp, temp);
            if (secondCost.rank == -1) {
                secondCost.release(provider);
                secondCost = this.checkUserDefinedConversionSequence(secondOp, temp);
            }
            this.getTypeInfoProvider().returnTypeInfo(temp);
            temp = ParserSymbolTable.getFlatTypeInfo(secondOp, provider);
            thirdCost = this.checkStandardConversionSequence(thirdOp, temp);
            if (thirdCost.rank == -1) {
                thirdCost.release(provider);
                thirdCost = this.checkUserDefinedConversionSequence(thirdOp, temp);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (thirdCost != null) {
                thirdCost.release(provider);
            }
            if (secondCost != null) {
                secondCost.release(provider);
            }
            if (temp != null) {
                provider.returnTypeInfo(temp);
            }
            throw throwable;
        }
        {
            Object var7_10 = null;
            if (thirdCost != null) {
                thirdCost.release(provider);
            }
            if (secondCost != null) {
                secondCost.release(provider);
            }
            if (temp != null) {
                provider.returnTypeInfo(temp);
            }
            canConvertSecond = secondCost != null && secondCost.rank != -1;
        }
        boolean bl = canConvertThird = thirdCost != null && thirdCost.rank != -1;
        if (!canConvertSecond && !canConvertThird) {
            return null;
        }
        if (canConvertSecond && canConvertThird) {
            throw new ParserSymbolTableException(0);
        }
        if (canConvertSecond) {
            if (secondCost.userDefined == 1) {
                throw new ParserSymbolTableException(0);
            }
            return thirdOp;
        }
        if (thirdCost.userDefined == 1) {
            throw new ParserSymbolTableException(0);
        }
        return secondOp;
    }

    protected static ITypeInfo getFlatTypeInfo(ITypeInfo topInfo, TypeInfoProvider infoProvider) {
        ITypeInfo returnInfo = null;
        ITypeInfo info = null;
        if (topInfo.getType() == ITypeInfo.t_type && topInfo.getTypeSymbol() != null) {
            returnInfo = infoProvider != null ? infoProvider.getTypeInfo(ITypeInfo.t_type) : TypeInfoProvider.newTypeInfo(ITypeInfo.t_type);
            returnInfo.setTypeBits(topInfo.getTypeBits());
            ISymbol typeSymbol = topInfo.getTypeSymbol();
            info = typeSymbol.getTypeInfo();
            int j = 0;
            while (info.getTypeSymbol() != null && (info.isType(ITypeInfo.t_type) || info.isType(ITypeInfo.t_enumerator)) || typeSymbol != null && typeSymbol.isForwardDeclaration() && typeSymbol.getForwardSymbol() != null) {
                typeSymbol = info.isType(ITypeInfo.t_type) || info.isType(ITypeInfo.t_enumerator) ? info.getTypeSymbol() : typeSymbol.getForwardSymbol();
                returnInfo.addPtrOperator(info.getPtrOperators());
                returnInfo.setTypeBits((returnInfo.getTypeBits() | info.getTypeBits()) & 0xFFFFFEFF & 0xFFFF7FFF);
                info = typeSymbol.getTypeInfo();
                if (++j <= 50) continue;
                if (infoProvider != null) {
                    infoProvider.returnTypeInfo(returnInfo);
                }
                throw new ParserSymbolTableError();
            }
            if (info.isType(ITypeInfo.t_class, ITypeInfo.t_enumeration) || info.isType(ITypeInfo.t_function) || info.isType(ITypeInfo.t_undef) && typeSymbol instanceof UndefinedTemplateSymbol) {
                returnInfo.setType(ITypeInfo.t_type);
                returnInfo.setTypeSymbol(typeSymbol);
            } else {
                returnInfo.setTypeBits((returnInfo.getTypeBits() | info.getTypeBits()) & 0xFFFFFEFF & 0xFFFF7FFF);
                returnInfo.setType(info.getType());
                returnInfo.setTypeSymbol(null);
                returnInfo.addPtrOperator(info.getPtrOperators());
            }
            if (returnInfo.isType(ITypeInfo.t_templateParameter)) {
                returnInfo.setTypeSymbol(typeSymbol);
            }
            if (topInfo.hasPtrOperators()) {
                returnInfo.addPtrOperator(topInfo.getPtrOperators());
            }
        } else if (infoProvider != null) {
            returnInfo = infoProvider.getTypeInfo(topInfo.getType());
            returnInfo.copy(topInfo);
        } else {
            returnInfo = TypeInfoProvider.newTypeInfo(topInfo);
        }
        return returnInfo;
    }

    public void setLanguage(ParserLanguage language) {
        this._language = language;
    }

    public ParserLanguage getLanguage() {
        return this._language;
    }

    public ParserMode getParserMode() {
        return this._mode;
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return this._typeInfoProvider;
    }

    public static ASTAccessVisibility getVisibility(ISymbol symbol, IContainerSymbol qualifyingSymbol) {
        IContainerSymbol container = symbol.getContainingSymbol();
        if (qualifyingSymbol == null || container.equals(qualifyingSymbol)) {
            ASTNode node;
            ISymbolASTExtension extension = symbol.getASTExtension();
            ASTNode aSTNode = node = extension != null ? extension.getPrimaryDeclaration() : null;
            if (node != null && node instanceof IASTMember) {
                return ((IASTMember)((Object)node)).getVisiblity();
            }
            throw new ParserSymbolTableError(-1);
        }
        if (!(qualifyingSymbol instanceof IDerivableContainerSymbol)) {
            return ASTAccessVisibility.PUBLIC;
        }
        List parents = ((IDerivableContainerSymbol)qualifyingSymbol).getParents();
        int numParents = parents.size();
        IDerivableContainerSymbol.IParentSymbol parent = null;
        ASTAccessVisibility symbolAccess = null;
        ASTAccessVisibility parentAccess = null;
        int i = 0;
        while (i < numParents) {
            parent = (IDerivableContainerSymbol.IParentSymbol)parents.get(i);
            if (container == parent.getParent()) {
                parentAccess = parent.getAccess();
                return parentAccess.isGreaterThan(symbolAccess = ((IASTMember)((Object)symbol.getASTExtension().getPrimaryDeclaration())).getVisiblity()) ? parentAccess : symbolAccess;
            }
            ++i;
        }
        boolean checkAllPaths = symbol.isType(ITypeInfo.t_enumerator) || symbol.getTypeInfo().checkBit(4);
        ASTAccessVisibility resultingAccess = null;
        int i2 = 0;
        while (i2 < numParents) {
            parent = (IDerivableContainerSymbol.IParentSymbol)parents.get(i2);
            parentAccess = parent.getAccess();
            ISymbol tmp = parent.getParent();
            if (tmp instanceof IDeferredTemplateInstance) {
                tmp = ((IDeferredTemplateInstance)tmp).getTemplate().getTemplatedSymbol();
            } else if (tmp instanceof ITemplateSymbol) {
                tmp = ((ITemplateSymbol)tmp).getTemplatedSymbol();
            }
            if (!(tmp instanceof IContainerSymbol)) {
                return null;
            }
            symbolAccess = ParserSymbolTable.getVisibility(symbol, (IContainerSymbol)tmp);
            if (symbolAccess != null) {
                ASTAccessVisibility aSTAccessVisibility = symbolAccess = parentAccess.isGreaterThan(symbolAccess) ? parentAccess : symbolAccess;
                if (checkAllPaths) {
                    resultingAccess = resultingAccess != null ? (resultingAccess.isGreaterThan(symbolAccess) ? symbolAccess : resultingAccess) : symbolAccess;
                } else {
                    return symbolAccess;
                }
            }
            ++i2;
        }
        return resultingAccess;
    }

    protected static class LookupData {
        protected static final TypeFilter ANY_FILTER = new TypeFilter(ITypeInfo.t_any);
        protected static final TypeFilter CONSTRUCTOR_FILTER = new TypeFilter(ITypeInfo.t_constructor);
        protected static final TypeFilter FUNCTION_FILTER = new TypeFilter(ITypeInfo.t_function);
        public char[] name;
        public ObjectMap usingDirectives;
        public ObjectSet visited = ObjectSet.EMPTY_SET;
        public ObjectSet inheritanceChain;
        public ISymbol templateMember;
        public boolean qualified = false;
        public boolean ignoreUsingDirectives = false;
        public boolean usingDirectivesOnly = false;
        public boolean forUserDefinedConversion = false;
        public boolean exactFunctionsOnly = false;
        public boolean returnInvisibleSymbols = false;
        public CharArrayObjectMap foundItems = null;

        public LookupData(char[] n) {
            this.name = n;
        }

        public boolean isPrefixLookup() {
            return false;
        }

        public CharArraySet getAmbiguities() {
            return null;
        }

        public void addAmbiguity(char[] n) {
        }

        public List getParameters() {
            return null;
        }

        public ObjectSet getAssociated() {
            return null;
        }

        public ISymbol getStopAt() {
            return null;
        }

        public List getTemplateParameters() {
            return null;
        }

        public TypeFilter getFilter() {
            return ANY_FILTER;
        }
    }

    protected static class Cost {
        private ITypeInfo source;
        private ITypeInfo target;
        public boolean targetHadReference = false;
        public int lvalue;
        public int promotion;
        public int conversion;
        public int qualification;
        public int userDefined;
        public int rank = -1;
        public int detail;
        public static final int AMBIGUOUS_USERDEFINED_CONVERSION = 1;
        public static final int NO_MATCH_RANK = -1;
        public static final int IDENTITY_RANK = 0;
        public static final int LVALUE_OR_QUALIFICATION_RANK = 0;
        public static final int PROMOTION_RANK = 1;
        public static final int CONVERSION_RANK = 2;
        public static final int DERIVED_TO_BASE_CONVERSION = 3;
        public static final int USERDEFINED_CONVERSION_RANK = 4;
        public static final int ELLIPSIS_CONVERSION = 5;

        public Cost(TypeInfoProvider provider, ITypeInfo s, ITypeInfo t) {
            if (s != null) {
                this.source = provider.getTypeInfo(s.getType());
                this.source.copy(s);
            }
            if (t != null) {
                this.target = provider.getTypeInfo(t.getType());
                this.target.copy(t);
            }
        }

        public void release(TypeInfoProvider provider) {
            provider.returnTypeInfo(this.getSource());
            provider.returnTypeInfo(this.getTarget());
        }

        public int compare(Cost cost) {
            int result = 0;
            if (this.rank != cost.rank) {
                return cost.rank - this.rank;
            }
            if (this.userDefined != 0 || cost.userDefined != 0) {
                if (this.userDefined == 0 || cost.userDefined == 0) {
                    return cost.userDefined - this.userDefined;
                }
                if (this.userDefined == 1 || cost.userDefined == 1 || this.userDefined != cost.userDefined) {
                    return 0;
                }
            }
            if (this.promotion > 0 || cost.promotion > 0) {
                result = cost.promotion - this.promotion;
            }
            if (this.conversion > 0 || cost.conversion > 0) {
                result = this.detail == cost.detail ? cost.conversion - this.conversion : cost.detail - this.detail;
            }
            if (result == 0) {
                if (cost.qualification != this.qualification) {
                    return cost.qualification - this.qualification;
                }
                if (cost.qualification == this.qualification && this.qualification == 0) {
                    return 0;
                }
                int size = cost.getTarget().hasPtrOperators() ? cost.getTarget().getPtrOperators().size() : 0;
                int size2 = this.getTarget().hasPtrOperators() ? this.getTarget().getPtrOperators().size() : 0;
                ListIterator iter1 = cost.getTarget().getPtrOperators().listIterator(size);
                ListIterator iter2 = this.getTarget().getPtrOperators().listIterator(size2);
                ITypeInfo.PtrOp op1 = null;
                ITypeInfo.PtrOp op2 = null;
                int subOrSuper = 0;
                int i = size < size2 ? size : size2;
                while (i > 0) {
                    op1 = (ITypeInfo.PtrOp)iter1.previous();
                    op2 = (ITypeInfo.PtrOp)iter2.previous();
                    if (subOrSuper == 0) {
                        subOrSuper = op1.compareCVTo(op2);
                    } else if (subOrSuper > 0 && op1.compareCVTo(op2) < 0 || subOrSuper < 0 && op1.compareCVTo(op2) > 0) {
                        result = -1;
                        break;
                    }
                    --i;
                }
                result = result == -1 ? 0 : (size == size2 ? subOrSuper : size - size2);
            }
            return result;
        }

        public ITypeInfo getSource() {
            return this.source;
        }

        public ITypeInfo getTarget() {
            return this.target;
        }
    }
}

