/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner2.BaseScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.DynamicFunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.DynamicStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerPreprocessorLog;
import org.eclipse.cdt.internal.core.parser.scanner2.LocationMap;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerASTProblem;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerUtility;

public class DOMScanner
extends BaseScanner {
    protected final ICodeReaderFactory codeReaderFactory;
    protected int[] bufferDelta = new int[8];
    final IScannerPreprocessorLog locationMap = new LocationMap();
    protected int fsmCount = 0;

    public DOMScanner(CodeReader reader, IScannerInfo info, ParserMode parserMode, ParserLanguage language, IParserLogService log, IScannerExtensionConfiguration configuration, ICodeReaderFactory readerFactory) {
        super(reader, info, parserMode, language, log, configuration);
        this.expressionEvaluator = new BaseScanner.ExpressionEvaluator(null, null);
        this.codeReaderFactory = readerFactory;
        this.postConstructorSetup(reader, info);
    }

    private void registerMacros() {
        int i = 0;
        while (i < this.definitions.size()) {
            IMacro m = (IMacro)this.definitions.get(this.definitions.keyAt(i));
            if (!(m instanceof ObjectStyleMacro) || ((ObjectStyleMacro)m).attachment == null) {
                IMacro macro;
                if (m instanceof DynamicStyleMacro) {
                    macro = (DynamicStyleMacro)m;
                    macro.attachment = this.locationMap.registerBuiltinDynamicStyleMacro((DynamicStyleMacro)macro);
                } else if (m instanceof DynamicFunctionStyleMacro) {
                    macro = (DynamicFunctionStyleMacro)m;
                    ((DynamicFunctionStyleMacro)macro).attachment = this.locationMap.registerBuiltinDynamicFunctionStyleMacro((DynamicFunctionStyleMacro)macro);
                } else if (m instanceof FunctionStyleMacro) {
                    macro = (FunctionStyleMacro)m;
                    ((FunctionStyleMacro)macro).attachment = this.locationMap.registerBuiltinFunctionStyleMacro((FunctionStyleMacro)macro);
                } else if (m instanceof ObjectStyleMacro) {
                    macro = (ObjectStyleMacro)m;
                    ((ObjectStyleMacro)macro).attachment = this.locationMap.registerBuiltinObjectStyleMacro((ObjectStyleMacro)macro);
                }
            }
            ++i;
        }
    }

    public ILocationResolver getLocationResolver() {
        if (this.locationMap instanceof ILocationResolver) {
            return (ILocationResolver)((Object)this.locationMap);
        }
        return null;
    }

    public void setASTFactory(IASTFactory f) {
    }

    protected Object createInclusionConstruct(char[] fileName, char[] filenamePath, boolean local, int startOffset, int startingLineNumber, int nameOffset, int nameEndOffset, int nameLine, int endOffset, int endLine, boolean isForced) {
        return new DOMInclusion(filenamePath, this.resolveOffset(startOffset));
    }

    protected void processMacro(char[] name, int startingOffset, int startingLineNumber, int idstart, int idend, int nameLine, int textEnd, int endingLine, IMacro macro) {
        IScannerPreprocessorLog.IMacroDefinition m = null;
        if (macro instanceof FunctionStyleMacro) {
            m = this.locationMap.defineFunctionStyleMacro((FunctionStyleMacro)macro, this.resolveOffset(startingOffset), this.resolveOffset(idstart), this.resolveOffset(idend), this.resolveOffset(textEnd));
        } else if (macro instanceof ObjectStyleMacro) {
            m = this.locationMap.defineObjectStyleMacro((ObjectStyleMacro)macro, this.resolveOffset(startingOffset), this.resolveOffset(idstart), this.resolveOffset(idend), this.resolveOffset(textEnd));
        }
        if (m != null && macro instanceof ObjectStyleMacro) {
            ((ObjectStyleMacro)macro).attachment = m;
        }
    }

    protected CodeReader createReaderDuple(String finalPath) {
        return this.codeReaderFactory.createCodeReaderForInclusion(finalPath);
    }

    protected void pushContext(char[] buffer, Object data) {
        if (this.bufferStackPos + 1 == this.bufferDelta.length) {
            int size = this.bufferDelta.length * 2;
            int[] oldBufferDelta = this.bufferDelta;
            this.bufferDelta = new int[size];
            System.arraycopy(oldBufferDelta, 0, this.bufferDelta, 0, oldBufferDelta.length);
        }
        if (data instanceof BaseScanner.InclusionData) {
            if (this.log.isTracing()) {
                StringBuffer b = new StringBuffer("Entering inclusion ");
                b.append(((BaseScanner.InclusionData)data).reader.filename);
                this.log.traceLog(b.toString());
            }
            if (!this.isCircularInclusion((BaseScanner.InclusionData)data)) {
                DOMInclusion inc = (DOMInclusion)((BaseScanner.InclusionData)data).inclusion;
                this.locationMap.startInclusion(((BaseScanner.InclusionData)data).reader, inc.o, this.resolveOffset(this.getCurrentOffset()));
                this.bufferDelta[this.bufferStackPos + 1] = 0;
            }
        } else if (data instanceof BaseScanner.MacroData) {
            BaseScanner.MacroData d = (BaseScanner.MacroData)data;
            if (d.macro instanceof FunctionStyleMacro && this.fsmCount == 0) {
                FunctionStyleMacro fsm = (FunctionStyleMacro)d.macro;
                this.locationMap.startFunctionStyleExpansion(fsm.attachment, fsm.arglist, this.resolveOffset(d.startOffset), this.resolveOffset(d.endOffset));
                this.bufferDelta[this.bufferStackPos + 1] = 0;
            } else if (d.macro instanceof ObjectStyleMacro && this.fsmCount == 0) {
                ObjectStyleMacro osm = (ObjectStyleMacro)d.macro;
                this.locationMap.startObjectStyleMacroExpansion(osm.attachment, this.resolveOffset(d.startOffset), this.resolveOffset(d.endOffset));
                this.bufferDelta[this.bufferStackPos + 1] = 0;
            }
        } else if (data instanceof CodeReader && !this.macroFilesInitialized) {
            int resolved = this.getGlobalCounter(0);
            this.locationMap.startInclusion((CodeReader)data, resolved, resolved);
        }
        super.pushContext(buffer, data);
    }

    protected Object popContext() {
        Object result = super.popContext();
        int delta_pos = 0;
        delta_pos = this.bufferPos[this.bufferStackPos + 1] > this.bufferLimit[this.bufferStackPos + 1] ? (delta_pos += this.bufferLimit[this.bufferStackPos + 1]) : (delta_pos += this.bufferPos[this.bufferStackPos + 1]);
        if (result instanceof CodeReader) {
            if (this.isInitialized) {
                this.locationMap.endTranslationUnit(this.bufferDelta[0] + ((CodeReader)result).buffer.length);
            } else {
                this.bufferDelta[0] = this.bufferDelta[0] + (this.bufferDelta[this.bufferStackPos + 1] + ((CodeReader)result).buffer.length);
                this.locationMap.endInclusion((CodeReader)result, this.getGlobalCounter(0));
            }
        } else if (result instanceof BaseScanner.InclusionData) {
            CodeReader codeReader = ((BaseScanner.InclusionData)result).reader;
            if (this.log.isTracing()) {
                StringBuffer buffer = new StringBuffer("Exiting inclusion ");
                buffer.append(codeReader.filename);
                this.log.traceLog(buffer.toString());
            }
            int value = this.getGlobalCounter(this.bufferStackPos + 1) + delta_pos;
            this.locationMap.endInclusion(codeReader, value);
            int n = this.bufferStackPos;
            this.bufferDelta[n] = this.bufferDelta[n] + (this.bufferDelta[this.bufferStackPos + 1] + codeReader.buffer.length);
        } else if (result instanceof BaseScanner.MacroData) {
            BaseScanner.MacroData data = (BaseScanner.MacroData)result;
            if (data.macro instanceof FunctionStyleMacro && this.fsmCount == 0) {
                this.locationMap.endFunctionStyleExpansion(((FunctionStyleMacro)data.macro).attachment, this.getGlobalCounter(this.bufferStackPos + 1) + delta_pos + 1);
                int n = this.bufferStackPos;
                this.bufferDelta[n] = this.bufferDelta[n] + (this.bufferDelta[this.bufferStackPos + 1] + delta_pos + 1);
            } else if (data.macro instanceof ObjectStyleMacro && this.fsmCount == 0) {
                this.locationMap.endObjectStyleMacroExpansion(((ObjectStyleMacro)data.macro).attachment, this.getGlobalCounter(this.bufferStackPos + 1) + delta_pos);
                int n = this.bufferStackPos;
                this.bufferDelta[n] = this.bufferDelta[n] + (this.bufferDelta[this.bufferStackPos + 1] + delta_pos);
            }
        }
        return result;
    }

    protected int getGlobalCounter(int value) {
        if (value < 0) {
            return 0;
        }
        int result = this.bufferDelta[value];
        int i = value - 1;
        while (i >= 0) {
            result = this.bufferPos[i] > this.bufferLimit[i] ? (result += this.bufferLimit[i] + this.bufferDelta[i]) : (result += this.bufferPos[i] + this.bufferDelta[i]);
            --i;
        }
        return result;
    }

    protected int getGlobalCounter() {
        return this.getGlobalCounter(this.bufferStackPos);
    }

    protected IToken newToken(int signal) {
        return new _BasicToken(signal, this.resolveOffset(this.bufferPos[this.bufferStackPos] + 1));
    }

    protected IToken newToken(int signal, char[] buffer) {
        _ImagedToken i = new _ImagedToken(signal, buffer, this.resolveOffset(this.bufferPos[this.bufferStackPos] + 1));
        if (buffer != null && buffer.length == 0 && signal != 130 && signal != 131) {
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
        }
        return i;
    }

    protected void quickParsePushPopInclusion(Object inclusion) {
    }

    protected void handleProblem(int id, int offset, char[] arg) {
        ScannerASTProblem problem = new ScannerASTProblem(id, arg, true, false);
        int o = this.resolveOffset(offset);
        problem.setOffsetAndLength(o, this.resolveOffset(this.getCurrentOffset() + 1) - o);
        this.locationMap.encounterProblem(problem);
    }

    private int resolveOffset(int offset) {
        return this.getGlobalCounter() + offset;
    }

    protected void postConstructorSetup(CodeReader reader, IScannerInfo info) {
        super.postConstructorSetup(reader, info);
        this.locationMap.startTranslationUnit(this.getMainReader());
        this.registerMacros();
    }

    protected void processIfdef(int startPos, int endPos, boolean positive, boolean taken) {
        if (positive) {
            this.locationMap.encounterPoundIfdef(this.resolveOffset(startPos), this.resolveOffset(endPos), taken);
        } else {
            this.locationMap.encounterPoundIfndef(this.resolveOffset(startPos), this.resolveOffset(endPos), taken);
        }
    }

    protected void processIf(int startPos, int endPos, boolean taken) {
        this.locationMap.encounterPoundIf(this.resolveOffset(startPos), this.resolveOffset(endPos), taken);
    }

    protected void processElsif(int startPos, int endPos, boolean taken) {
        this.locationMap.encounterPoundElif(this.resolveOffset(startPos), this.resolveOffset(endPos), taken);
    }

    protected void processElse(int startPos, int endPos, boolean taken) {
        this.locationMap.encounterPoundElse(this.resolveOffset(startPos), this.resolveOffset(endPos), taken);
    }

    protected void processUndef(int pos, int endPos, char[] symbol, int namePos, Object definition) {
        IScannerPreprocessorLog.IMacroDefinition macroDefinition = definition instanceof ObjectStyleMacro ? ((ObjectStyleMacro)definition).attachment : null;
        this.locationMap.encounterPoundUndef(this.resolveOffset(pos), this.resolveOffset(endPos), symbol, namePos, macroDefinition);
    }

    protected void processError(int startPos, int endPos) {
        this.locationMap.encounterPoundError(this.resolveOffset(startPos), this.resolveOffset(endPos));
    }

    protected void processEndif(int startPos, int endPos) {
        this.locationMap.encounterPoundEndIf(this.resolveOffset(startPos), this.resolveOffset(endPos));
    }

    protected void processPragma(int startPos, int endPos) {
        this.locationMap.encounterPoundPragma(this.resolveOffset(startPos), this.resolveOffset(endPos));
    }

    protected void beforeReplaceAllMacros() {
        ++this.fsmCount;
    }

    protected void afterReplaceAllMacros() {
        --this.fsmCount;
    }

    protected CodeReader createReader(String path, String fileName) {
        String finalPath = ScannerUtility.createReconciledPath(path, fileName);
        CodeReader reader = this.createReaderDuple(finalPath);
        return reader;
    }

    static char[] getCharImage(int type) {
        switch (type) {
            case 3: {
                return Keywords.cpCOLONCOLON;
            }
            case 4: {
                return Keywords.cpCOLON;
            }
            case 5: {
                return Keywords.cpSEMI;
            }
            case 6: {
                return Keywords.cpCOMMA;
            }
            case 7: {
                return Keywords.cpQUESTION;
            }
            case 8: {
                return Keywords.cpLPAREN;
            }
            case 9: {
                return Keywords.cpRPAREN;
            }
            case 10: {
                return Keywords.cpLBRACKET;
            }
            case 11: {
                return Keywords.cpRBRACKET;
            }
            case 12: {
                return Keywords.cpLBRACE;
            }
            case 13: {
                return Keywords.cpRBRACE;
            }
            case 14: {
                return Keywords.cpPLUSASSIGN;
            }
            case 15: {
                return Keywords.cpINCR;
            }
            case 16: {
                return Keywords.cpPLUS;
            }
            case 17: {
                return Keywords.cpMINUSASSIGN;
            }
            case 18: {
                return Keywords.cpDECR;
            }
            case 19: {
                return Keywords.cpARROWSTAR;
            }
            case 20: {
                return Keywords.cpARROW;
            }
            case 21: {
                return Keywords.cpMINUS;
            }
            case 22: {
                return Keywords.cpSTARASSIGN;
            }
            case 23: {
                return Keywords.cpSTAR;
            }
            case 24: {
                return Keywords.cpMODASSIGN;
            }
            case 25: {
                return Keywords.cpMOD;
            }
            case 26: {
                return Keywords.cpXORASSIGN;
            }
            case 27: {
                return Keywords.cpXOR;
            }
            case 28: {
                return Keywords.cpAMPERASSIGN;
            }
            case 29: {
                return Keywords.cpAND;
            }
            case 30: {
                return Keywords.cpAMPER;
            }
            case 31: {
                return Keywords.cpBITORASSIGN;
            }
            case 32: {
                return Keywords.cpOR;
            }
            case 33: {
                return Keywords.cpBITOR;
            }
            case 34: {
                return Keywords.cpCOMPL;
            }
            case 35: {
                return Keywords.cpNOTEQUAL;
            }
            case 36: {
                return Keywords.cpNOT;
            }
            case 37: {
                return Keywords.cpEQUAL;
            }
            case 38: {
                return Keywords.cpASSIGN;
            }
            case 40: {
                return Keywords.cpSHIFTL;
            }
            case 41: {
                return Keywords.cpLTEQUAL;
            }
            case 42: {
                return Keywords.cpLT;
            }
            case 43: {
                return Keywords.cpSHIFTRASSIGN;
            }
            case 44: {
                return Keywords.cpSHIFTR;
            }
            case 45: {
                return Keywords.cpGTEQUAL;
            }
            case 46: {
                return Keywords.cpGT;
            }
            case 47: {
                return Keywords.cpSHIFTLASSIGN;
            }
            case 48: {
                return Keywords.cpELLIPSIS;
            }
            case 49: {
                return Keywords.cpDOTSTAR;
            }
            case 50: {
                return Keywords.cpDOT;
            }
            case 51: {
                return Keywords.cpDIVASSIGN;
            }
            case 52: {
                return Keywords.cpDIV;
            }
            case 54: {
                return Keywords.cAND;
            }
            case 55: {
                return Keywords.cAND_EQ;
            }
            case 56: {
                return Keywords.cASM;
            }
            case 57: {
                return Keywords.cAUTO;
            }
            case 58: {
                return Keywords.cBITAND;
            }
            case 59: {
                return Keywords.cBITOR;
            }
            case 60: {
                return Keywords.cBOOL;
            }
            case 61: {
                return Keywords.cBREAK;
            }
            case 62: {
                return Keywords.cCASE;
            }
            case 63: {
                return Keywords.cCATCH;
            }
            case 64: {
                return Keywords.cCHAR;
            }
            case 65: {
                return Keywords.cCLASS;
            }
            case 66: {
                return Keywords.cCOMPL;
            }
            case 67: {
                return Keywords.cCONST;
            }
            case 69: {
                return Keywords.cCONST_CAST;
            }
            case 70: {
                return Keywords.cCONTINUE;
            }
            case 71: {
                return Keywords.cDEFAULT;
            }
            case 72: {
                return Keywords.cDELETE;
            }
            case 73: {
                return Keywords.cDO;
            }
            case 74: {
                return Keywords.cDOUBLE;
            }
            case 75: {
                return Keywords.cDYNAMIC_CAST;
            }
            case 76: {
                return Keywords.cELSE;
            }
            case 77: {
                return Keywords.cENUM;
            }
            case 78: {
                return Keywords.cEXPLICIT;
            }
            case 79: {
                return Keywords.cEXPORT;
            }
            case 80: {
                return Keywords.cEXTERN;
            }
            case 81: {
                return Keywords.cFALSE;
            }
            case 82: {
                return Keywords.cFLOAT;
            }
            case 83: {
                return Keywords.cFOR;
            }
            case 84: {
                return Keywords.cFRIEND;
            }
            case 85: {
                return Keywords.cGOTO;
            }
            case 86: {
                return Keywords.cIF;
            }
            case 87: {
                return Keywords.cINLINE;
            }
            case 88: {
                return Keywords.cINT;
            }
            case 89: {
                return Keywords.cLONG;
            }
            case 90: {
                return Keywords.cMUTABLE;
            }
            case 91: {
                return Keywords.cNAMESPACE;
            }
            case 92: {
                return Keywords.cNEW;
            }
            case 93: {
                return Keywords.cNOT;
            }
            case 94: {
                return Keywords.cNOT_EQ;
            }
            case 95: {
                return Keywords.cOPERATOR;
            }
            case 96: {
                return Keywords.cOR;
            }
            case 97: {
                return Keywords.cOR_EQ;
            }
            case 98: {
                return Keywords.cPRIVATE;
            }
            case 99: {
                return Keywords.cPROTECTED;
            }
            case 100: {
                return Keywords.cPUBLIC;
            }
            case 101: {
                return Keywords.cREGISTER;
            }
            case 102: {
                return Keywords.cREINTERPRET_CAST;
            }
            case 103: {
                return Keywords.cRETURN;
            }
            case 104: {
                return Keywords.cSHORT;
            }
            case 105: {
                return Keywords.cSIZEOF;
            }
            case 106: {
                return Keywords.cSTATIC;
            }
            case 107: {
                return Keywords.cSTATIC_CAST;
            }
            case 108: {
                return Keywords.cSIGNED;
            }
            case 109: {
                return Keywords.cSTRUCT;
            }
            case 110: {
                return Keywords.cSWITCH;
            }
            case 111: {
                return Keywords.cTEMPLATE;
            }
            case 112: {
                return Keywords.cTHIS;
            }
            case 113: {
                return Keywords.cTHROW;
            }
            case 114: {
                return Keywords.cTRUE;
            }
            case 115: {
                return Keywords.cTRY;
            }
            case 116: {
                return Keywords.cTYPEDEF;
            }
            case 117: {
                return Keywords.cTYPEID;
            }
            case 118: {
                return Keywords.cTYPENAME;
            }
            case 119: {
                return Keywords.cUNION;
            }
            case 120: {
                return Keywords.cUNSIGNED;
            }
            case 121: {
                return Keywords.cUSING;
            }
            case 122: {
                return Keywords.cVIRTUAL;
            }
            case 123: {
                return Keywords.cVOID;
            }
            case 124: {
                return Keywords.cVOLATILE;
            }
            case 125: {
                return Keywords.cWCHAR_T;
            }
            case 126: {
                return Keywords.cWHILE;
            }
            case 127: {
                return Keywords.cXOR;
            }
            case 128: {
                return Keywords.cXOR_EQ;
            }
            case 134: {
                return Keywords.c_BOOL;
            }
            case 135: {
                return Keywords.c_COMPLEX;
            }
            case 136: {
                return Keywords.c_IMAGINARY;
            }
            case 137: {
                return Keywords.cRESTRICT;
            }
            case -7: {
                return Keywords.cpPOUND;
            }
            case -6: {
                return Keywords.cpPOUNDPOUND;
            }
        }
        return "".toCharArray();
    }

    private static class DOMInclusion {
        public final char[] pt;
        public final int o;

        public DOMInclusion(char[] path, int offset) {
            this.pt = path;
            this.o = offset;
        }
    }

    private static class _BasicToken
    implements IToken,
    ITokenDuple {
        private int type;
        private IToken next = null;
        private int offset;

        public _BasicToken(int type, int endOffset) {
            this.setType(type);
            this.setOffsetByLength(endOffset);
        }

        public String toString() {
            return this.getImage();
        }

        public int getType() {
            return this.type;
        }

        public void setType(int i) {
            this.type = i;
        }

        public int getLineNumber() {
            return 0;
        }

        public char[] getFilename() {
            return EMPTY_CHAR_ARRAY;
        }

        public int getEndOffset() {
            return this.getOffset() + this.getLength();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof IToken)) {
                return false;
            }
            if (((IToken)other).getType() != this.getType()) {
                return false;
            }
            if (!CharArrayUtils.equals(((IToken)other).getCharImage(), this.getCharImage())) {
                return false;
            }
            if (this.getOffset() != ((IToken)other).getOffset()) {
                return false;
            }
            return this.getEndOffset() == ((IToken)other).getEndOffset();
        }

        public boolean canBeAPrefix() {
            switch (this.getType()) {
                case 1: 
                case 34: {
                    return true;
                }
            }
            if (this.getType() >= 54 && this.getType() <= 128) {
                return true;
            }
            return this.getType() >= 134 && this.getType() <= 137;
        }

        public boolean looksLikeExpression() {
            switch (this.getType()) {
                case 2: 
                case 8: 
                case 16: 
                case 21: 
                case 23: 
                case 30: 
                case 34: 
                case 36: 
                case 50: 
                case 81: 
                case 114: 
                case 129: 
                case 130: 
                case 131: 
                case 132: {
                    return true;
                }
            }
            return false;
        }

        public boolean isOperator() {
            switch (this.getType()) {
                case 6: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 51: 
                case 52: 
                case 72: 
                case 92: {
                    return true;
                }
            }
            return false;
        }

        public boolean isPointer() {
            return this.getType() == 30 || this.getType() == 23;
        }

        public final IToken getNext() {
            return this.next;
        }

        public void setNext(IToken t) {
            this.next = t;
        }

        public boolean contains(ITokenDuple duple) {
            return duple.getFirstToken() == duple.getLastToken() && duple.getFirstToken() == this;
        }

        public char[] extractNameFromTemplateId() {
            return this.getCharImage();
        }

        public int findLastTokenType(int t) {
            if (this.getType() == t) {
                return 0;
            }
            return -1;
        }

        public IToken getFirstToken() {
            return this;
        }

        public ITokenDuple getLastSegment() {
            return this;
        }

        public IToken getLastToken() {
            return this;
        }

        public ITokenDuple getLeadingSegments() {
            return null;
        }

        public int getSegmentCount() {
            return 1;
        }

        public int getStartOffset() {
            return this.getOffset();
        }

        public ITokenDuple getSubrange(int startIndex, int endIndex) {
            if (startIndex == 0 && endIndex == 0) {
                return this;
            }
            return null;
        }

        public List[] getTemplateIdArgLists() {
            return null;
        }

        public IToken getToken(int index) {
            if (index == 0) {
                return this;
            }
            return null;
        }

        public boolean isIdentifier() {
            return this.getType() == 1;
        }

        public Iterator iterator() {
            return new SingleIterator();
        }

        public int length() {
            return 1;
        }

        public boolean syntaxOfName() {
            return this.getType() == 1;
        }

        public String[] toQualifiedName() {
            String[] qualifiedName = new String[]{this.getImage()};
            return qualifiedName;
        }

        public void freeReferences() {
        }

        public void acceptElement(ISourceElementRequestor requestor) {
        }

        public ITokenDuple[] getSegments() {
            ITokenDuple[] r = new ITokenDuple[]{};
            r[0] = this;
            return r;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.getCharImage().length;
        }

        protected void setOffsetByLength(int endOffset) {
            this.offset = endOffset - this.getLength();
        }

        public String getImage() {
            switch (this.getType()) {
                case 3: {
                    return "::";
                }
                case 4: {
                    return ":";
                }
                case 5: {
                    return ";";
                }
                case 6: {
                    return ",";
                }
                case 7: {
                    return "?";
                }
                case 8: {
                    return "(";
                }
                case 9: {
                    return ")";
                }
                case 10: {
                    return "[";
                }
                case 11: {
                    return "]";
                }
                case 12: {
                    return "{";
                }
                case 13: {
                    return "}";
                }
                case 14: {
                    return "+=";
                }
                case 15: {
                    return "++";
                }
                case 16: {
                    return "+";
                }
                case 17: {
                    return "-=";
                }
                case 18: {
                    return "--";
                }
                case 19: {
                    return "->*";
                }
                case 20: {
                    return "->";
                }
                case 21: {
                    return "-";
                }
                case 22: {
                    return "*=";
                }
                case 23: {
                    return "*";
                }
                case 24: {
                    return "%=";
                }
                case 25: {
                    return "%";
                }
                case 26: {
                    return "^=";
                }
                case 27: {
                    return "^";
                }
                case 28: {
                    return "&=";
                }
                case 29: {
                    return "&&";
                }
                case 30: {
                    return "&";
                }
                case 31: {
                    return "|=";
                }
                case 32: {
                    return "||";
                }
                case 33: {
                    return "|";
                }
                case 34: {
                    return "~";
                }
                case 35: {
                    return "!=";
                }
                case 36: {
                    return "!";
                }
                case 37: {
                    return "==";
                }
                case 38: {
                    return "=";
                }
                case 40: {
                    return "<<";
                }
                case 41: {
                    return "<=";
                }
                case 42: {
                    return "<";
                }
                case 43: {
                    return ">>=";
                }
                case 44: {
                    return ">>";
                }
                case 45: {
                    return ">=";
                }
                case 46: {
                    return ">";
                }
                case 47: {
                    return "<<=";
                }
                case 48: {
                    return "...";
                }
                case 49: {
                    return ".*";
                }
                case 50: {
                    return ".";
                }
                case 51: {
                    return "/=";
                }
                case 52: {
                    return "/";
                }
                case 54: {
                    return "and";
                }
                case 55: {
                    return "and_eq";
                }
                case 56: {
                    return "asm";
                }
                case 57: {
                    return "auto";
                }
                case 58: {
                    return "bitand";
                }
                case 59: {
                    return "bitor";
                }
                case 60: {
                    return "bool";
                }
                case 61: {
                    return "break";
                }
                case 62: {
                    return "case";
                }
                case 63: {
                    return "catch";
                }
                case 64: {
                    return "char";
                }
                case 65: {
                    return "class";
                }
                case 66: {
                    return "compl";
                }
                case 67: {
                    return "const";
                }
                case 69: {
                    return "const_cast";
                }
                case 70: {
                    return "continue";
                }
                case 71: {
                    return "default";
                }
                case 72: {
                    return "delete";
                }
                case 73: {
                    return "do";
                }
                case 74: {
                    return "double";
                }
                case 75: {
                    return "dynamic_cast";
                }
                case 76: {
                    return "else";
                }
                case 77: {
                    return "enum";
                }
                case 78: {
                    return "explicit";
                }
                case 79: {
                    return "export";
                }
                case 80: {
                    return "extern";
                }
                case 81: {
                    return "false";
                }
                case 82: {
                    return "float";
                }
                case 83: {
                    return "for";
                }
                case 84: {
                    return "friend";
                }
                case 85: {
                    return "goto";
                }
                case 86: {
                    return "if";
                }
                case 87: {
                    return "inline";
                }
                case 88: {
                    return "int";
                }
                case 89: {
                    return "long";
                }
                case 90: {
                    return "mutable";
                }
                case 91: {
                    return "namespace";
                }
                case 92: {
                    return "new";
                }
                case 93: {
                    return "not";
                }
                case 94: {
                    return "not_eq";
                }
                case 95: {
                    return "operator";
                }
                case 96: {
                    return "or";
                }
                case 97: {
                    return "or_eq";
                }
                case 98: {
                    return "private";
                }
                case 99: {
                    return "protected";
                }
                case 100: {
                    return "public";
                }
                case 101: {
                    return "register";
                }
                case 102: {
                    return "reinterpret_cast";
                }
                case 103: {
                    return "return";
                }
                case 104: {
                    return "short";
                }
                case 105: {
                    return "sizeof";
                }
                case 106: {
                    return "static";
                }
                case 107: {
                    return "static_cast";
                }
                case 108: {
                    return "signed";
                }
                case 109: {
                    return "struct";
                }
                case 110: {
                    return "switch";
                }
                case 111: {
                    return "template";
                }
                case 112: {
                    return "this";
                }
                case 113: {
                    return "throw";
                }
                case 114: {
                    return "true";
                }
                case 115: {
                    return "try";
                }
                case 116: {
                    return "typedef";
                }
                case 117: {
                    return "typeid";
                }
                case 118: {
                    return "typename";
                }
                case 119: {
                    return "union";
                }
                case 120: {
                    return "unsigned";
                }
                case 121: {
                    return "using";
                }
                case 122: {
                    return "virtual";
                }
                case 123: {
                    return "void";
                }
                case 124: {
                    return "volatile";
                }
                case 125: {
                    return "wchar_t";
                }
                case 126: {
                    return "while";
                }
                case 127: {
                    return "xor";
                }
                case 128: {
                    return "xor_eq";
                }
                case 134: {
                    return "_Bool";
                }
                case 135: {
                    return "_Complex";
                }
                case 136: {
                    return "_Imaginary";
                }
                case 137: {
                    return "restrict";
                }
                case -7: {
                    return "#";
                }
                case -6: {
                    return "##";
                }
                case 141: {
                    return "EOC";
                }
            }
            return "";
        }

        public void setImage(String i) {
        }

        public char[] getCharImage() {
            return DOMScanner.getCharImage(this.getType());
        }

        public void setImage(char[] i) {
        }

        public char[] toCharArray() {
            return this.getCharImage();
        }

        public boolean isConversion() {
            return false;
        }

        private class SingleIterator
        implements Iterator {
            boolean hasNext = true;

            SingleIterator() {
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public Object next() {
                this.hasNext = false;
                return _BasicToken.this;
            }
        }
    }

    private static class _ImagedToken
    extends _BasicToken {
        private char[] image = null;

        public _ImagedToken(int t, char[] i, int endOffset) {
            super(t, 0);
            this.setImage(i);
            this.setOffsetByLength(endOffset);
        }

        public final String getImage() {
            if (this.image == null) {
                return null;
            }
            return new String(this.image);
        }

        public final char[] getCharImage() {
            return this.image;
        }

        public void setImage(String i) {
            this.image = i.toCharArray();
        }

        public void setImage(char[] image) {
            this.image = image;
        }

        public int getLength() {
            if (this.getCharImage() == null) {
                return 0;
            }
            int s_length = this.getCharImage().length;
            switch (this.getType()) {
                case 130: {
                    return s_length + 2;
                }
                case 131: {
                    return s_length + 3;
                }
            }
            return s_length;
        }
    }
}

