/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PDOMCodeReaderFactory
implements ICodeReaderFactory {
    private final PDOMDatabase pdom;
    private List workingCopies;

    public PDOMCodeReaderFactory(PDOMDatabase pdom) {
        this.pdom = pdom;
    }

    public PDOMCodeReaderFactory(PDOMDatabase pdom, IWorkingCopy workingCopy) {
        this(pdom);
        this.workingCopies = new ArrayList(1);
        this.workingCopies.add(workingCopy);
    }

    public int getUniqueIdentifier() {
        return 0;
    }

    public CodeReader createCodeReaderForTranslationUnit(String path) {
        return ParserUtil.createReader(path, this.workingCopies != null ? this.workingCopies.iterator() : null);
    }

    public CodeReader createCodeReaderForTranslationUnit(ITranslationUnit tu) {
        return new CodeReader(tu.getResource().getLocation().toOSString(), tu.getContents());
    }

    public CodeReader createCodeReaderForInclusion(String path) {
        try {
            try {
                path = new File(path).getCanonicalPath();
            }
            catch (IOException iOException) {}
            PDOMFile file = PDOMFile.find(this.pdom, path);
            if (file != null && file.getFirstName() != null) {
                return null;
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, "PDOM Exception", (Throwable)e)));
        }
        return ParserUtil.createReader(path, null);
    }

    public ICodeReaderCache getCodeReaderCache() {
        return null;
    }
}

