/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.pdom.PDOMCodeReaderFactory;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;

public class PDOMDatabase
implements IPDOM {
    private final IPath dbPath;
    private Database db;
    private static final int VERSION = 0;
    public static final int LINKAGES = 1028;
    public static final int FILE_INDEX = 1032;
    private BTree fileIndex;
    private static final QualifiedName dbNameProperty = new QualifiedName("org.eclipse.cdt.core", "dbName");
    private List listeners;
    static /* synthetic */ Class class$0;

    public PDOMDatabase(IProject project, PDOMManager manager) throws CoreException {
        String dbName = project.getPersistentProperty(dbNameProperty);
        if (dbName == null) {
            dbName = String.valueOf(project.getName()) + "_" + System.currentTimeMillis() + ".pdom";
            project.setPersistentProperty(dbNameProperty, dbName);
        }
        this.dbPath = CCorePlugin.getDefault().getStateLocation().append(dbName);
        this.db = new Database(this.dbPath.toOSString(), 0);
    }

    public void addListener(IListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void fireChange() {
        if (this.listeners == null) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((IListener)i.next()).handleChange(this);
        }
    }

    public Database getDB() throws CoreException {
        if (this.db == null) {
            this.db = new Database(this.dbPath.toOSString(), 0);
        }
        return this.db;
    }

    public BTree getFileIndex() throws CoreException {
        if (this.fileIndex == null) {
            this.fileIndex = new BTree(this.getDB(), 1032);
        }
        return this.fileIndex;
    }

    public void addSymbols(ITranslationUnit tu) throws CoreException {
        ILanguage language = tu.getLanguage();
        if (language == null) {
            return;
        }
        final PDOMLinkage linkage = this.getLinkage(language);
        if (linkage == null) {
            return;
        }
        IASTTranslationUnit ast = language.getTranslationUnit((IFile)tu.getResource(), 13);
        if (ast == null) {
            return;
        }
        ast.accept(new ASTVisitor(){
            {
                this.shouldVisitNames = true;
                this.shouldVisitDeclarations = true;
            }

            public int visit(IASTName name) {
                try {
                    linkage.addName(name);
                    return 3;
                }
                catch (CoreException e) {
                    CCorePlugin.log(e);
                    return 2;
                }
            }
        });
        this.fireChange();
    }

    public void removeSymbols(ITranslationUnit tu) throws CoreException {
        String filename = ((IFile)tu.getResource()).getLocation().toOSString();
        PDOMFile file = PDOMFile.find(this, filename);
        if (file == null) {
            return;
        }
        file.clear();
    }

    public void delete() throws CoreException {
        this.getDB().clear();
        this.fileIndex = null;
    }

    public ICodeReaderFactory getCodeReaderFactory() {
        return new PDOMCodeReaderFactory(this);
    }

    public ICodeReaderFactory getCodeReaderFactory(IWorkingCopy root) {
        return new PDOMCodeReaderFactory(this, root);
    }

    public IASTName[] getDeclarations(IBinding binding) {
        try {
            if (binding instanceof PDOMBinding) {
                PDOMName name = ((PDOMBinding)binding).getFirstDeclaration();
                if (name == null) {
                    return new IASTName[0];
                }
                return new IASTName[]{name};
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return new IASTName[0];
    }

    public IBinding resolveBinding(IASTName name) {
        try {
            ILanguage language = name.getTranslationUnit().getLanguage();
            return this.getLinkage(language).resolveBinding(name);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IBinding[] resolvePrefix(IASTName name) {
        return new IBinding[0];
    }

    public PDOMLinkage getLinkage(ILanguage language) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IPDOMLinkageFactory factory = (IPDOMLinkageFactory)language.getAdapter(clazz);
        String id = language.getId();
        int linkrec = this.db.getInt(1028);
        while (linkrec != 0) {
            if (id.equals(PDOMLinkage.getId(this, linkrec))) {
                return factory.getLinkage(this, linkrec);
            }
            linkrec = PDOMLinkage.getNextLinkageRecord(this, linkrec);
        }
        return factory.createLinkage(this);
    }

    public PDOMLinkage getLinkage(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        String id = PDOMLinkage.getId(this, record);
        ILanguage language = LanguageManager.getInstance().getLanguage(id);
        return this.getLinkage(language);
    }

    public PDOMLinkage getFirstLinkage() throws CoreException {
        return this.getLinkage(this.db.getInt(1028));
    }

    public void insertLinkage(PDOMLinkage linkage) throws CoreException {
        linkage.setNext(this.db.getInt(1028));
        this.db.putInt(1028, linkage.getRecord());
    }

    public PDOMBinding getBinding(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        return PDOMLinkage.getLinkage(this, record).getBinding(record);
    }

    public static interface IListener {
        public void handleChange(PDOMDatabase var1);
    }
}

