/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.core.runtime.CoreException;

public class PDOMLanguage {
    private PDOMDatabase pdom;
    private int record;
    private static final int NEXT = 0;
    private static final int ID = 4;
    private static final int NAME = 6;

    public PDOMLanguage(PDOMDatabase pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public PDOMLanguage(PDOMDatabase pdom, String name, int id, int next) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(6 + (name.length() + 1) * 2);
        db.putInt(this.record + 0, next);
        db.putChar(this.record + 4, (char)id);
        db.putString(this.record + 6, name);
    }

    public int getRecord() {
        return this.record;
    }

    public int getId() throws CoreException {
        return this.pdom.getDB().getChar(this.record + 4);
    }

    public String getName() throws CoreException {
        return this.pdom.getDB().getString(this.record + 6);
    }

    public PDOMLanguage getNext() throws CoreException {
        int nextrec = this.pdom.getDB().getInt(this.record + 0);
        return nextrec != 0 ? new PDOMLanguage(this.pdom, nextrec) : null;
    }

    public boolean equals(String id) throws CoreException {
        return this.pdom.getDB().stringCompare(this.record + 6, id) == 0;
    }
}

