/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.PDOMUpdator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;

public class PDOMManager
implements IElementChangedListener,
IJobChangeListener {
    private static PDOMManager instance;
    private PDOMUpdator currJob;
    private static final QualifiedName pdomProperty;

    static {
        pdomProperty = new QualifiedName("org.eclipse.cdt.core", "pdom");
    }

    public static PDOMManager getInstance() {
        if (instance == null) {
            instance = new PDOMManager();
        }
        return instance;
    }

    public IPDOM getPDOM(IProject project) {
        try {
            IPDOM pdom = (IPDOM)project.getSessionProperty(pdomProperty);
            if (pdom == null) {
                pdom = new PDOMDatabase(project, this);
                project.setSessionProperty(pdomProperty, (Object)pdom);
            }
            return pdom;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public synchronized void elementChanged(ElementChangedEvent event) {
        if (event.getType() != 1) {
            return;
        }
        this.currJob = new PDOMUpdator(event.getDelta(), this.currJob);
        this.currJob.addJobChangeListener(this);
        this.currJob.schedule();
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public synchronized void done(IJobChangeEvent event) {
        if (this.currJob == event.getJob()) {
            this.currJob = null;
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public void deletePDOM(IProject project) throws CoreException {
        IPDOM pdom = (IPDOM)project.getSessionProperty(pdomProperty);
        project.setSessionProperty(pdomProperty, null);
        pdom.delete();
    }

    public IElementChangedListener getElementChangedListener() {
        return this;
    }
}

