/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOM;
import org.eclipse.cdt.core.dom.PDOM;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;

public class PDOMUpdator
extends Job {
    private PDOMUpdator prevJob;
    private ICElementDelta delta;
    private ICProject project;
    private List addedTUs;
    private List changedTUs;
    private List removedTUs;

    public PDOMUpdator(ICElementDelta delta, PDOMUpdator prevJob) {
        super("PDOM Updator");
        this.prevJob = prevJob;
        this.delta = delta;
    }

    public PDOMUpdator(ICProject project, PDOMUpdator prevJob) {
        super("PDOM Project Updator");
        this.prevJob = prevJob;
        this.project = project;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.prevJob != null) {
            try {
                this.prevJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            String showTimings;
            ITranslationUnit tu;
            Iterator i;
            long start = System.currentTimeMillis();
            String taskName = null;
            if (this.delta != null) {
                this.processDelta(this.delta);
                taskName = "Update PDOM";
            }
            if (this.project != null) {
                this.processNewProject(this.project);
                taskName = "Rebuild PDOM";
            }
            int count = (this.addedTUs != null ? this.addedTUs.size() : 0) + (this.changedTUs != null ? this.changedTUs.size() : 0) + (this.removedTUs != null ? this.removedTUs.size() : 0);
            if (taskName == null || count == 0) {
                return Status.OK_STATUS;
            }
            monitor.beginTask(taskName, count);
            if (this.addedTUs != null) {
                i = this.addedTUs.iterator();
                while (i.hasNext()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    tu = (ITranslationUnit)i.next();
                    monitor.subTask(String.valueOf(String.valueOf(count--)) + " files remaining - " + tu.getPath().toString());
                    this.processAddedTU(tu);
                    monitor.worked(1);
                }
            }
            if (this.changedTUs != null) {
                i = this.changedTUs.iterator();
                while (i.hasNext()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    tu = (ITranslationUnit)i.next();
                    monitor.subTask(String.valueOf(String.valueOf(count--)) + " files remaining - " + tu.getPath().toString());
                    this.processChangedTU(tu);
                    monitor.worked(1);
                }
            }
            if (this.removedTUs != null) {
                i = this.removedTUs.iterator();
                while (i.hasNext()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    tu = (ITranslationUnit)i.next();
                    monitor.subTask(String.valueOf(String.valueOf(count--)) + " files remaining - " + tu.getPath().toString());
                    this.processRemovedTU(tu);
                    monitor.worked(1);
                }
            }
            if ((showTimings = Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/pdomtimings")) != null && showTimings.equalsIgnoreCase("true")) {
                System.out.println("Updator Time: " + (System.currentTimeMillis() - start));
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return e.getStatus();
        }
    }

    private void processDelta(ICElementDelta delta) {
        ICElement element = delta.getElement();
        if (element instanceof ICProject && PDOM.getPDOM(((ICProject)element).getProject()) == null) {
            return;
        }
        ICElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i]);
            ++i;
        }
        if (element.getElementType() == 11) {
            switch (delta.getKind()) {
                case 1: {
                    this.processNewProject((ICProject)element);
                }
            }
        } else if (element.getElementType() == 60) {
            ITranslationUnit tu = (ITranslationUnit)element;
            if (tu.isWorkingCopy()) {
                return;
            }
            switch (delta.getKind()) {
                case 1: {
                    if (this.addedTUs == null) {
                        this.addedTUs = new LinkedList();
                    }
                    this.addedTUs.add(element);
                    break;
                }
                case 4: {
                    if (this.changedTUs == null) {
                        this.changedTUs = new LinkedList();
                    }
                    this.changedTUs.add(element);
                    break;
                }
                case 2: {
                    if (this.removedTUs == null) {
                        this.removedTUs = new LinkedList();
                    }
                    this.removedTUs.add(element);
                }
            }
        }
    }

    private void processNewProject(ICProject project) {
        try {
            if (!PDOM.isEnabled(project.getProject())) {
                return;
            }
            project.getProject().accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (proxy.getType() == 1) {
                        String fileName = proxy.getName();
                        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(fileName);
                        if (contentType == null) {
                            return true;
                        }
                        String contentTypeId = contentType.getId();
                        if ("org.eclipse.cdt.core.cxxSource".equals(contentTypeId) || "org.eclipse.cdt.core.cSource".equals(contentTypeId)) {
                            if (PDOMUpdator.this.addedTUs == null) {
                                PDOMUpdator.this.addedTUs = new LinkedList();
                            }
                            PDOMUpdator.this.addedTUs.add(CoreModel.getDefault().create((IFile)proxy.requestResource()));
                        }
                        return false;
                    }
                    return true;
                }
            }, 0);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    private void processAddedTU(ITranslationUnit tu) throws CoreException {
        IPDOM pdom = tu.getCProject().getIndex();
        if (pdom == null || !(pdom instanceof PDOMDatabase)) {
            return;
        }
        PDOMDatabase mypdom = (PDOMDatabase)pdom;
        mypdom.addSymbols(tu);
    }

    private void processRemovedTU(ITranslationUnit tu) throws CoreException {
        IProject project = tu.getCProject().getProject();
        IPDOM pdom = PDOM.getPDOM(project);
        if (pdom == null || !(pdom instanceof PDOMDatabase)) {
            return;
        }
        PDOMDatabase mypdom = (PDOMDatabase)pdom;
        mypdom.removeSymbols(tu);
    }

    private void processChangedTU(ITranslationUnit tu) throws CoreException {
        IPDOM pdom = PDOM.getPDOM(tu.getCProject().getProject());
        if (pdom == null || !(pdom instanceof PDOMDatabase)) {
            return;
        }
        PDOMDatabase mypdom = (PDOMDatabase)pdom;
        mypdom.removeSymbols(tu);
        mypdom.addSymbols(tu);
    }
}

