/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class Chunk {
    private MappedByteBuffer buffer;
    private Database db;
    int index;
    private Chunk prevChunk;
    private Chunk nextChunk;

    Chunk(RandomAccessFile file, int offset) throws CoreException {
        try {
            this.index = offset / 4096;
            this.buffer = file.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, 4096L);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public void putByte(int offset, byte value) {
        this.buffer.put(offset % 4096, value);
    }

    public byte getByte(int offset) {
        return this.buffer.get(offset % 4096);
    }

    public void putInt(int offset, int value) {
        this.buffer.putInt(offset % 4096, value);
    }

    public int getInt(int offset) {
        return this.buffer.getInt(offset % 4096);
    }

    public void putChar(int offset, char value) {
        this.buffer.putChar(offset % 4096, value);
    }

    public char getChar(int offset) {
        return this.buffer.getChar(offset % 4096);
    }

    public void putChars(int offset, char[] value) {
        this.buffer.position(offset % 4096);
        this.buffer.putChar((char)value.length);
        int i = 0;
        while (i < value.length) {
            this.buffer.putChar(value[i]);
            ++i;
        }
    }

    public char[] getChars(int offset) {
        this.buffer.position(offset % 4096);
        int n = this.buffer.getChar();
        char[] chars = new char[n];
        int i = 0;
        while (i < n) {
            chars[i] = this.buffer.getChar();
            ++i;
        }
        return chars;
    }

    public void putString(int offset, String value) {
        this.buffer.position(offset % 4096);
        int n = value.length();
        this.buffer.putChar((char)n);
        int i = 0;
        while (i < n) {
            this.buffer.putChar(value.charAt(i));
            ++i;
        }
    }

    public String getString(int offset) {
        return new String(this.getChars(offset));
    }

    Chunk getNextChunk() {
        return this.nextChunk;
    }

    void setNextChunk(Chunk nextChunk) {
        this.nextChunk = nextChunk;
    }

    Chunk getPrevChunk() {
        return this.prevChunk;
    }

    void setPrevChunk(Chunk prevChunk) {
        this.prevChunk = prevChunk;
    }

    void clear(int offset, int length) {
        this.buffer.position(offset % 4096);
        this.buffer.put(new byte[length]);
    }

    void free() {
        this.db.toc[this.index] = null;
        this.db.lruChunk = this.prevChunk;
        this.prevChunk.nextChunk = null;
    }
}

