/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Database {
    private final RandomAccessFile file;
    Chunk[] toc;
    Chunk mruChunk;
    Chunk lruChunk;
    private int loadedChunks;
    public static final int VERSION_OFFSET = 0;
    public static final int CHUNK_SIZE = 4096;
    public static final int CACHE_SIZE = 10000;
    public static final int MIN_SIZE = 16;
    public static final int INT_SIZE = 4;
    public static final int CHAR_SIZE = 2;
    public static final int PREV_OFFSET = 4;
    public static final int NEXT_OFFSET = 8;
    public static final int DATA_AREA = 1028;

    public Database(String filename, int version) throws CoreException {
        try {
            this.file = new RandomAccessFile(filename, "rw");
            long nChunks = this.file.length() / 4096L;
            if (nChunks == 0L) {
                this.create();
                ++nChunks;
            }
            this.toc = new Chunk[(int)nChunks];
            this.init(version);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    private void create() throws CoreException {
        try {
            this.file.seek(0L);
            this.file.write(new byte[4096]);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    private void init(int version) throws CoreException {
        this.toc[0] = new Chunk(this.file, 0);
        int oldversion = this.toc[0].getInt(0);
        if (oldversion != version) {
            this.toc[0].putInt(0, version);
        }
    }

    public void clear() throws CoreException {
        int version = this.toc[0].getInt(0);
        this.create();
        this.toc = new Chunk[1];
        this.init(version);
    }

    public Chunk getChunk(int offset) throws CoreException {
        int index = offset / 4096;
        Chunk chunk = this.toc[index];
        if (chunk == null) {
            if (this.loadedChunks == 10000) {
                this.lruChunk.free();
            }
            chunk = this.toc[index] = new Chunk(this.file, index * 4096);
        }
        Chunk prevChunk = chunk.getPrevChunk();
        Chunk nextChunk = chunk.getNextChunk();
        if (prevChunk != null) {
            prevChunk.setNextChunk(nextChunk);
        }
        if (nextChunk != null) {
            nextChunk.setPrevChunk(prevChunk);
        }
        if (this.mruChunk != null) {
            chunk.setNextChunk(this.mruChunk);
            this.mruChunk.setPrevChunk(chunk);
        }
        this.mruChunk = chunk;
        chunk.setPrevChunk(null);
        return chunk;
    }

    public int malloc(int size) throws CoreException {
        Chunk chunk;
        int freeblock = 0;
        int matchsize = 0;
        int blocksize = 16;
        while (blocksize <= 4096) {
            if (blocksize - 4 >= size) {
                if (matchsize == 0) {
                    matchsize = blocksize;
                }
                if ((freeblock = this.getFirstBlock(blocksize)) != 0) break;
            }
            blocksize += 16;
        }
        if (freeblock == 0) {
            int i = this.createChunk();
            chunk = this.toc[i];
            freeblock = i * 4096;
            blocksize = 4096;
        } else {
            chunk = this.getChunk(freeblock);
            this.removeBlock(chunk, blocksize, freeblock);
        }
        if (blocksize != matchsize) {
            this.addBlock(chunk, blocksize - matchsize, freeblock + matchsize);
        }
        chunk.putInt(freeblock, -matchsize);
        return freeblock + 4;
    }

    private int createChunk() throws CoreException {
        try {
            Chunk[] oldtoc = this.toc;
            int n = oldtoc.length;
            int offset = n * 4096;
            this.file.seek(offset);
            this.file.write(new byte[4096]);
            this.toc = new Chunk[n + 1];
            System.arraycopy(oldtoc, 0, this.toc, 0, n);
            this.toc[n] = new Chunk(this.file, offset);
            return n;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    private int getFirstBlock(int blocksize) {
        return this.toc[0].getInt(blocksize / 16 * 4);
    }

    private void setFirstBlock(int blocksize, int block) {
        this.toc[0].putInt(blocksize / 16 * 4, block);
    }

    private void removeBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        int prevblock = chunk.getInt(block + 4);
        int nextblock = chunk.getInt(block + 8);
        if (prevblock != 0) {
            this.putInt(prevblock + 8, nextblock);
        } else {
            this.setFirstBlock(blocksize, nextblock);
        }
        if (nextblock != 0) {
            this.putInt(nextblock + 4, prevblock);
        }
    }

    private void addBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        chunk.putInt(block, blocksize);
        int prevfirst = this.getFirstBlock(blocksize);
        chunk.putInt(block + 4, 0);
        chunk.putInt(block + 8, prevfirst);
        if (prevfirst != 0) {
            this.putInt(prevfirst + 4, block);
        }
        this.setFirstBlock(blocksize, block);
    }

    public void free(int offset) throws CoreException {
        int block = offset - 4;
        Chunk chunk = this.getChunk(block);
        int blocksize = -chunk.getInt(block);
        if (blocksize < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, "Already Freed", (Throwable)new Exception()));
        }
        chunk.clear(offset, blocksize - 4);
        this.addBlock(chunk, blocksize, block);
    }

    public void putByte(int offset, byte value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putByte(offset, value);
    }

    public byte getByte(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getByte(offset);
    }

    public void putInt(int offset, int value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putInt(offset, value);
    }

    public int getInt(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getInt(offset);
    }

    public void putChar(int offset, char value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putChar(offset, value);
    }

    public char getChar(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getChar(offset);
    }

    public void putChars(int offset, char[] value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putChars(offset, value);
    }

    public int putChars(char[] value) throws CoreException {
        int record = this.malloc((value.length + 1) * 2);
        this.putChars(record, value);
        return record;
    }

    public char[] getChars(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getChars(offset);
    }

    public void putString(int offset, String value) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        chunk.putString(offset, value);
    }

    public int putString(String value) throws CoreException {
        int record = this.malloc((value.length() + 1) * 2);
        this.putString(record, value);
        return record;
    }

    public String getString(int offset) throws CoreException {
        Chunk chunk = this.getChunk(offset);
        return chunk.getString(offset);
    }

    public int getNumChunks() {
        return this.toc.length;
    }

    public int stringCompare(int record1, int record2) throws CoreException {
        Chunk chunk1 = this.getChunk(record1);
        Chunk chunk2 = this.getChunk(record2);
        int i1 = record1 + 2;
        int i2 = record2 + 2;
        int n1 = i1 + chunk1.getChar(record1) * 2;
        int n2 = i2 + chunk2.getChar(record2) * 2;
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = chunk1.getChar(i1);
            if (c1 < (c2 = chunk2.getChar(i2))) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            i1 += 2;
            i2 += 2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return 0;
    }

    public int stringCompare(int record1, char[] record2) throws CoreException {
        Chunk chunk1 = this.getChunk(record1);
        int i1 = record1 + 2;
        int i2 = 0;
        int n1 = i1 + chunk1.getChar(record1) * 2;
        int n2 = record2.length;
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = chunk1.getChar(i1);
            if (c1 < (c2 = record2[i2])) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            i1 += 2;
            ++i2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return 0;
    }

    public int stringCompare(int record1, String record2) throws CoreException {
        Chunk chunk1 = this.getChunk(record1);
        int i1 = record1 + 2;
        int i2 = 0;
        int n1 = i1 + chunk1.getChar(record1) * 2;
        int n2 = record2.length();
        while (i1 < n1 && i2 < n2) {
            char c2;
            char c1 = chunk1.getChar(i1);
            if (c1 < (c2 = record2.charAt(i2))) {
                return -1;
            }
            if (c1 > c2) {
                return 1;
            }
            i1 += 2;
            ++i2;
        }
        if (i1 == n1 && i2 != n2) {
            return -1;
        }
        if (i2 == n2 && i1 != n1) {
            return 1;
        }
        return 0;
    }
}

