/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMBinding
extends PDOMNode
implements IBinding {
    private static final int BINDING_TYPE_OFFSET = 12;
    private static final int FIRST_DECL_OFFSET = 16;
    private static final int FIRST_DEF_OFFSET = 20;
    private static final int FIRST_REF_OFFSET = 24;
    protected static final int RECORD_SIZE = 28;
    static /* synthetic */ Class class$0;

    protected PDOMBinding(PDOMDatabase pdom, PDOMNode parent, IASTName name, int type) throws CoreException {
        super(pdom, parent, name.toCharArray());
        Database db = pdom.getDB();
        db.putInt(this.record + 12, type);
    }

    public PDOMBinding(PDOMDatabase pdom, int record) {
        super(pdom, record);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public static int getBindingType(PDOMDatabase pdom, int record) throws CoreException {
        return pdom.getDB().getInt(record + 12);
    }

    public static boolean isOrphaned(PDOMDatabase pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        return db.getInt(record + 16) == 0 && db.getInt(record + 20) == 0 && db.getInt(record + 24) == 0;
    }

    public int getRecord() {
        return this.record;
    }

    public int getBindingType() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 12);
    }

    public boolean hasDeclarations() throws CoreException {
        Database db = this.pdom.getDB();
        return db.getInt(this.record + 16) != 0 || db.getInt(this.record + 20) != 0;
    }

    public void addDeclaration(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstDeclaration();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstDeclaration(name);
    }

    public void addDefinition(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstDefinition();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstDefinition(name);
    }

    public void addReference(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstReference();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstReference(name);
    }

    public PDOMName getFirstDeclaration() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 16);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstDeclaration(PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 16, namerec);
    }

    public PDOMName getFirstDefinition() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 20);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstDefinition(PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 20, namerec);
    }

    public PDOMName getFirstReference() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 24);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstReference(PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 24, namerec);
    }

    public String getName() {
        try {
            return super.getName();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return "";
        }
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[0];
        }
    }

    public boolean hasName(char[] name) throws CoreException {
        return this.pdom.getDB().stringCompare(this.getNameRecord(), name) == 0;
    }

    public IScope getScope() throws DOMException {
        return null;
    }
}

