/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.core.runtime.CoreException;

public class PDOMFile {
    private PDOMDatabase pdom;
    private int record;
    private static final int FIRST_NAME_OFFSET = 0;
    private static final int FILE_NAME_OFFSET = 4;

    public static PDOMFile insert(PDOMDatabase pdom, String filename) throws CoreException {
        BTree index = pdom.getFileIndex();
        PDOMFile pdomFile = PDOMFile.find(pdom, filename);
        if (pdomFile == null) {
            Database db = pdom.getDB();
            int record = db.malloc(4 + (filename.length() + 1) * 2);
            db.putInt(record + 0, 0);
            db.putString(record + 4, filename);
            index.insert(record, new Comparator(db));
            pdomFile = new PDOMFile(pdom, record);
        }
        return pdomFile;
    }

    public static PDOMFile find(PDOMDatabase pdom, String filename) throws CoreException {
        BTree index = pdom.getFileIndex();
        int record = new FindVisitor(pdom.getDB(), filename).findIn(index);
        return record != 0 ? new PDOMFile(pdom, record) : null;
    }

    public PDOMFile(PDOMDatabase pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    public int getRecord() {
        return this.record;
    }

    public String getFileName() throws CoreException {
        return this.pdom.getDB().getString(this.record + 4);
    }

    public PDOMName getFirstName() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 0);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstName(PDOMName firstName) throws CoreException {
        int namerec = firstName != null ? firstName.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 0, namerec);
    }

    public void clear() throws CoreException {
        PDOMName name = this.getFirstName();
        while (name != null) {
            PDOMName nextName = name.getNextInFile();
            name.delete();
            name = nextName;
        }
        this.setFirstName(null);
    }

    public static class Comparator
    implements IBTreeComparator {
        private Database db;

        public Comparator(Database db) {
            this.db = db;
        }

        public int compare(int record1, int record2) throws CoreException {
            return this.db.stringCompare(record1 + 4, record2 + 4);
        }
    }

    public static abstract class Visitor
    implements IBTreeVisitor {
        private Database db;
        private String key;

        public Visitor(Database db, String key) {
            this.db = db;
            this.key = key;
        }

        public int compare(int record) throws CoreException {
            return this.db.stringCompare(record + 4, this.key);
        }
    }

    public static class FindVisitor
    extends Visitor {
        private int record;

        public FindVisitor(Database db, String key) {
            super(db, key);
        }

        public boolean visit(int record) throws CoreException {
            this.record = record;
            return false;
        }

        public int findIn(BTree btree) throws CoreException {
            btree.visit(this);
            return this.record;
        }
    }
}

