/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMLinkage
extends PDOMNode {
    private static final int ID_OFFSET = 8;
    private static final int NEXT_OFFSET = 12;
    private static final int INDEX_OFFSET = 16;
    protected static final int RECORD_SIZE = 20;

    public PDOMLinkage(PDOMDatabase pdom, int record) {
        super(pdom, record);
    }

    protected PDOMLinkage(PDOMDatabase pdom, String languageId, char[] name) throws CoreException {
        super(pdom, null, name);
        Database db = pdom.getDB();
        int idrec = db.putString(languageId);
        db.putInt(this.record + 8, idrec);
        pdom.insertLinkage(this);
    }

    protected int getRecordSize() {
        return 20;
    }

    public static String getId(PDOMDatabase pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        int namerec = db.getInt(record + 8);
        return db.getString(namerec);
    }

    public static int getNextLinkageRecord(PDOMDatabase pdom, int record) throws CoreException {
        return pdom.getDB().getInt(record + 12);
    }

    public PDOMLinkage getNextLinkage() throws CoreException {
        return this.pdom.getLinkage(this.pdom.getDB().getInt(this.record + 12));
    }

    public void setNext(int nextrec) throws CoreException {
        this.pdom.getDB().putInt(this.record + 12, nextrec);
    }

    public BTree getIndex() throws CoreException {
        return new BTree(this.pdom.getDB(), this.record + 16);
    }

    public PDOMLinkage getLinkage() throws CoreException {
        return this;
    }

    protected void addChild(PDOMNode child) throws CoreException {
        this.getIndex().insert(child.getRecord(), child.getIndexComparator());
    }

    public abstract PDOMBinding addName(IASTName var1) throws CoreException;

    public abstract PDOMBinding adaptBinding(IBinding var1) throws CoreException;

    public abstract PDOMBinding getBinding(int var1) throws CoreException;

    public abstract PDOMBinding resolveBinding(IASTName var1) throws CoreException;
}

