/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMember;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public class PDOMMemberOwner
extends PDOMBinding {
    private static final int FIRST_MEMBER = 28;
    private static final int LAST_MEMBER = 32;
    protected static final int RECORD_SIZE = 36;

    public PDOMMemberOwner(PDOMDatabase pdom, PDOMNode parent, IASTName name, int type) throws CoreException {
        super(pdom, parent, name, type);
    }

    public PDOMMemberOwner(PDOMDatabase pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 36;
    }

    public void addMember(PDOMMember member) throws CoreException {
        PDOMMember last = this.getLastMember();
        if (last != null) {
            last.setNextMember(member);
            member.setPrevMember(last);
        } else {
            this.setFirstMember(member);
        }
        this.setLastMember(member);
        member.setMemberOwner(this);
    }

    public PDOMMember getFirstMember() throws CoreException {
        return (PDOMMember)this.getLinkage().getBinding(this.pdom.getDB().getInt(this.record + 28));
    }

    public PDOMMember getLastMember() throws CoreException {
        return (PDOMMember)this.getLinkage().getBinding(this.pdom.getDB().getInt(this.record + 32));
    }

    public void setFirstMember(PDOMMember member) throws CoreException {
        int memberrec = member != null ? member.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, memberrec);
    }

    public void setLastMember(PDOMMember member) throws CoreException {
        int memberrec = member != null ? member.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 32, memberrec);
    }

    public int getNumMembers() throws CoreException {
        int n = 0;
        PDOMMember member = this.getFirstMember();
        while (member != null) {
            ++n;
            member = member.getNextMember();
        }
        return n;
    }

    public PDOMMember getMember(int index) throws CoreException {
        int n = 0;
        PDOMMember member = this.getFirstMember();
        while (member != null) {
            if (n++ == index) {
                return member;
            }
            member = member.getNextMember();
        }
        return null;
    }

    public PDOMMember[] findMembers(char[] name) throws CoreException {
        ArrayList<PDOMMember> members = new ArrayList<PDOMMember>();
        PDOMMember member = this.getFirstMember();
        while (member != null) {
            if (member.hasName(name)) {
                members.add(member);
            }
            member = member.getNextMember();
        }
        return members.toArray(new PDOMMember[members.size()]);
    }
}

