/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMNode {
    private static final int PARENT_OFFSET = 0;
    private static final int NAME_OFFSET = 4;
    protected static final int RECORD_SIZE = 8;
    protected final PDOMDatabase pdom;
    protected final int record;

    protected PDOMNode(PDOMDatabase pdom, int record) {
        this.pdom = pdom;
        this.record = record;
    }

    protected PDOMNode(PDOMDatabase pdom, PDOMNode parent, char[] name) throws CoreException {
        this.pdom = pdom;
        Database db = pdom.getDB();
        this.record = db.malloc(this.getRecordSize());
        int namerec = db.putChars(name);
        db.putInt(this.record + 4, namerec);
        if (parent != null) {
            pdom.getDB().putInt(this.record + 0, parent.getRecord());
            parent.addChild(this);
        }
    }

    protected abstract int getRecordSize();

    public PDOMDatabase getPDOM() {
        return this.pdom;
    }

    public int getRecord() {
        return this.record;
    }

    public PDOMLinkage getLinkage() throws CoreException {
        return PDOMNode.getLinkage(this.pdom, this.record);
    }

    public static PDOMLinkage getLinkage(PDOMDatabase pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        int linkagerec = record;
        int parentrec = db.getInt(linkagerec + 0);
        while (parentrec != 0) {
            linkagerec = parentrec;
            parentrec = db.getInt(linkagerec + 0);
        }
        return pdom.getLinkage(linkagerec);
    }

    public String getName() throws CoreException {
        Database db = this.pdom.getDB();
        int namerec = db.getInt(this.record + 4);
        return db.getString(namerec);
    }

    public char[] getNameCharArray() throws CoreException {
        Database db = this.pdom.getDB();
        int namerec = db.getInt(this.record + 4);
        return db.getChars(namerec);
    }

    protected int getNameRecord() throws CoreException {
        return this.pdom.getDB().getInt(this.record + 4);
    }

    protected void addChild(PDOMNode child) throws CoreException {
    }

    public boolean hasName(char[] name) throws CoreException {
        Database db = this.pdom.getDB();
        int namerec = db.getInt(this.record + 4);
        return this.pdom.getDB().stringCompare(namerec, name) == 0;
    }

    public IBTreeComparator getIndexComparator() {
        return new IBTreeComparator(){

            public int compare(int record1, int record2) throws CoreException {
                Database db = PDOMNode.this.pdom.getDB();
                int string1 = db.getInt(record1 + 4);
                int string2 = db.getInt(record2 + 4);
                return db.stringCompare(string1, string2);
            }
        };
    }

    public static abstract class NodeVisitor
    implements IBTreeVisitor {
        protected final PDOMDatabase pdom;
        protected final char[] name;

        protected NodeVisitor(PDOMDatabase pdom, char[] name) {
            this.pdom = pdom;
            this.name = name;
        }

        public int compare(int record) throws CoreException {
            Database db = this.pdom.getDB();
            int namerec = db.getInt(record + 4);
            return db.stringCompare(namerec, this.name);
        }
    }
}

