/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMember;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCField;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunction;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCStructure;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCVariable;
import org.eclipse.core.runtime.CoreException;

public class PDOMCLinkage
extends PDOMLinkage {
    public static final int CVARIABLE = 1;
    public static final int CFUNCTION = 2;
    public static final int CSTRUCTURE = 3;
    public static final int CFIELD = 4;

    public PDOMCLinkage(PDOMDatabase pdom, int record) {
        super(pdom, record);
    }

    public PDOMCLinkage(PDOMDatabase pdom) throws CoreException {
        super(pdom, "org.eclipse.cdt.core.gcc", "C".toCharArray());
    }

    public PDOMNode getParent(IBinding binding) throws CoreException {
        IBinding scopeBinding;
        PDOMBinding scopePDOMBinding;
        IScope scope = binding.getScope();
        if (scope == null) {
            return null;
        }
        IASTNode scopeNode = scope.getPhysicalNode();
        if (scopeNode instanceof IASTCompoundStatement) {
            return null;
        }
        if (scopeNode instanceof IASTTranslationUnit) {
            return this;
        }
        IASTName scopeName = scope.getScopeName();
        if (scopeName != null && (scopePDOMBinding = this.adaptBinding(scopeBinding = scopeName.resolveBinding())) != null) {
            return scopePDOMBinding;
        }
        return null;
    }

    public PDOMBinding addName(IASTName name) throws CoreException {
        if (name == null || name.toCharArray().length == 0) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (binding == null || binding instanceof IProblemBinding) {
            return null;
        }
        PDOMBinding pdomBinding = this.adaptBinding(binding);
        if (pdomBinding == null) {
            PDOMNode parent = this.getParent(binding);
            if (parent == null) {
                return null;
            }
            if (binding instanceof IParameter) {
                return null;
            }
            if (binding instanceof IField) {
                if (parent instanceof PDOMMemberOwner) {
                    pdomBinding = new PDOMCField(this.pdom, (PDOMMemberOwner)parent, name);
                }
            } else if (binding instanceof IVariable) {
                pdomBinding = new PDOMCVariable(this.pdom, parent, name);
            } else if (binding instanceof IFunction) {
                pdomBinding = new PDOMCFunction(this.pdom, parent, name);
            } else if (binding instanceof ICompositeType) {
                pdomBinding = new PDOMCStructure(this.pdom, parent, name);
            }
        }
        if (pdomBinding != null) {
            new PDOMName(this.pdom, name, pdomBinding);
        }
        return pdomBinding;
    }

    protected int getBindingType(IBinding binding) {
        if (binding instanceof IVariable) {
            return 1;
        }
        if (binding instanceof IFunction) {
            return 2;
        }
        if (binding instanceof ICompositeType) {
            return 3;
        }
        if (binding instanceof IField) {
            return 4;
        }
        return 0;
    }

    public PDOMBinding adaptBinding(IBinding binding) throws CoreException {
        PDOMMemberOwner owner;
        PDOMMember[] members;
        if (binding instanceof PDOMBinding) {
            return (PDOMBinding)binding;
        }
        PDOMNode parent = this.getParent(binding);
        if (parent == this) {
            FindBinding visitor = new FindBinding(this.pdom, binding.getNameCharArray(), this.getBindingType(binding));
            this.getIndex().visit(visitor);
            return visitor.pdomBinding;
        }
        if (parent instanceof PDOMMemberOwner && (members = (owner = (PDOMMemberOwner)parent).findMembers(binding.getNameCharArray())).length > 0) {
            return members[0];
        }
        return null;
    }

    public PDOMBinding getBinding(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        switch (PDOMBinding.getBindingType(this.pdom, record)) {
            case 1: {
                return new PDOMCVariable(this.pdom, record);
            }
            case 2: {
                return new PDOMCFunction(this.pdom, record);
            }
            case 3: {
                return new PDOMCStructure(this.pdom, record);
            }
            case 4: {
                return new PDOMCField(this.pdom, record);
            }
        }
        return null;
    }

    public PDOMBinding resolveBinding(IASTName name) throws CoreException {
        IASTNode parent = name.getParent();
        if (parent instanceof IASTIdExpression) {
            IASTNode eParent = parent.getParent();
            if (eParent instanceof IASTFunctionCallExpression) {
                FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 2);
                this.getIndex().visit(visitor);
                return visitor.pdomBinding;
            }
            FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 1);
            this.getIndex().visit(visitor);
            return visitor.pdomBinding;
        }
        if (parent instanceof ICASTElaboratedTypeSpecifier) {
            FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 3);
            this.getIndex().visit(visitor);
            return visitor.pdomBinding;
        }
        return null;
    }

    private static final class FindBinding
    extends PDOMNode.NodeVisitor {
        PDOMBinding pdomBinding;
        final int desiredType;

        public FindBinding(PDOMDatabase pdom, char[] name, int desiredType) {
            super(pdom, name);
            this.desiredType = desiredType;
        }

        public boolean visit(int record) throws CoreException {
            if (record == 0) {
                return true;
            }
            PDOMBinding tBinding = this.pdom.getBinding(record);
            if (!tBinding.hasName(this.name)) {
                return false;
            }
            if (tBinding.getBindingType() != this.desiredType) {
                return true;
            }
            this.pdomBinding = tBinding;
            return false;
        }
    }
}

