/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBlockScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespace;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespaceAlias;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVariable;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMember;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPClassType;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPField;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPMethod;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPNamespace;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPNamespaceAlias;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPVariable;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPLinkage
extends PDOMLinkage {
    public static final int CPPVARIABLE = 1;
    public static final int CPPFUNCTION = 2;
    public static final int CPPCLASSTYPE = 3;
    public static final int CPPFIELD = 4;
    public static final int CPPMETHOD = 5;
    public static final int CPPNAMESPACE = 6;
    public static final int CPPNAMESPACEALIAS = 7;

    public PDOMCPPLinkage(PDOMDatabase pdom, int record) {
        super(pdom, record);
    }

    public PDOMCPPLinkage(PDOMDatabase pdom) throws CoreException {
        super(pdom, "org.eclipse.cdt.core.g++", "C++".toCharArray());
    }

    protected int getRecordSize() {
        return 20;
    }

    public PDOMNode getParent(IBinding binding) throws CoreException {
        IBinding scopeBinding;
        PDOMBinding scopePDOMBinding;
        IASTName scopeName;
        PDOMNode parent = this;
        IScope scope = binding.getScope();
        if (scope != null && (scopeName = scope.getScopeName()) != null && (scopePDOMBinding = this.adaptBinding(scopeBinding = scopeName.resolveBinding())) != null) {
            parent = scopePDOMBinding;
        }
        return parent;
    }

    public PDOMBinding addName(IASTName name) throws CoreException {
        if (name == null || name.toCharArray().length == 0 || name instanceof ICPPASTQualifiedName) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (binding == null || binding instanceof IProblemBinding) {
            return null;
        }
        PDOMBinding pdomBinding = this.adaptBinding(binding);
        if (pdomBinding == null) {
            PDOMNode parent = this.getParent(binding);
            if (binding instanceof CPPField && parent instanceof PDOMCPPClassType) {
                pdomBinding = new PDOMCPPField(this.pdom, (PDOMCPPClassType)parent, name);
            } else if (binding instanceof CPPVariable) {
                if (!(binding.getScope() instanceof CPPBlockScope)) {
                    pdomBinding = new PDOMCPPVariable(this.pdom, parent, name);
                }
            } else if (binding instanceof CPPMethod && parent instanceof PDOMCPPClassType) {
                pdomBinding = new PDOMCPPMethod(this.pdom, (PDOMCPPClassType)parent, name);
            } else if (binding instanceof CPPFunction) {
                pdomBinding = new PDOMCPPFunction(this.pdom, parent, name);
            } else if (binding instanceof CPPClassType) {
                pdomBinding = new PDOMCPPClassType(this.pdom, parent, name);
            } else if (binding instanceof CPPNamespaceAlias) {
                pdomBinding = new PDOMCPPNamespaceAlias(this.pdom, parent, name);
            } else if (binding instanceof CPPNamespace) {
                pdomBinding = new PDOMCPPNamespace(this.pdom, parent, name);
            }
        }
        if (pdomBinding != null) {
            new PDOMName(this.pdom, name, pdomBinding);
        }
        return pdomBinding;
    }

    protected int getBindingType(IBinding binding) {
        if (binding instanceof ICPPVariable) {
            return 1;
        }
        if (binding instanceof ICPPFunction) {
            return 2;
        }
        if (binding instanceof ICPPClassType) {
            return 3;
        }
        if (binding instanceof ICPPField) {
            return 4;
        }
        if (binding instanceof ICPPMethod) {
            return 5;
        }
        if (binding instanceof ICPPNamespaceAlias) {
            return 7;
        }
        if (binding instanceof ICPPNamespace) {
            return 6;
        }
        return 0;
    }

    public PDOMBinding adaptBinding(IBinding binding) throws CoreException {
        PDOMMemberOwner owner;
        PDOMMember[] members;
        if (binding == null || binding instanceof IProblemBinding) {
            return null;
        }
        if (binding instanceof PDOMBinding) {
            return (PDOMBinding)binding;
        }
        PDOMNode parent = this.getParent(binding);
        if (parent == this) {
            FindBinding visitor = new FindBinding(this.pdom, binding.getNameCharArray(), this.getBindingType(binding));
            this.getIndex().visit(visitor);
            return visitor.pdomBinding;
        }
        if (parent instanceof PDOMMemberOwner && (members = (owner = (PDOMMemberOwner)parent).findMembers(binding.getNameCharArray())).length > 0) {
            return members[0];
        }
        return null;
    }

    public PDOMBinding getBinding(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        switch (PDOMBinding.getBindingType(this.pdom, record)) {
            case 1: {
                return new PDOMCPPVariable(this.pdom, record);
            }
            case 2: {
                return new PDOMCPPFunction(this.pdom, record);
            }
            case 3: {
                return new PDOMCPPClassType(this.pdom, record);
            }
            case 4: {
                return new PDOMCPPField(this.pdom, record);
            }
            case 5: {
                return new PDOMCPPMethod(this.pdom, record);
            }
            case 6: {
                return new PDOMCPPNamespace(this.pdom, record);
            }
            case 7: {
                return new PDOMCPPNamespaceAlias(this.pdom, record);
            }
        }
        return null;
    }

    public PDOMBinding resolveBinding(IASTName name) throws CoreException {
        if (name instanceof ICPPASTQualifiedName) {
            IASTName lastName = ((ICPPASTQualifiedName)name).getLastName();
            return lastName != null ? this.resolveBinding(lastName) : null;
        }
        IASTNode parent = name.getParent();
        if (parent instanceof ICPPASTQualifiedName) {
            parent = parent.getParent();
        }
        if (parent instanceof IASTIdExpression) {
            IASTNode eParent = parent.getParent();
            if (eParent instanceof IASTFunctionCallExpression) {
                FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 2);
                this.getIndex().visit(visitor);
                return visitor.pdomBinding;
            }
            FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), name.getParent() instanceof ICPPASTQualifiedName && ((ICPPASTQualifiedName)name.getParent()).getLastName() != name ? 6 : 1);
            this.getIndex().visit(visitor);
            return visitor.pdomBinding;
        }
        if (parent instanceof IASTNamedTypeSpecifier) {
            FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 3);
            this.getIndex().visit(visitor);
            return visitor.pdomBinding;
        }
        if (parent instanceof ICPPASTNamespaceAlias) {
            FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 6);
            this.getIndex().visit(visitor);
            return visitor.pdomBinding;
        }
        return null;
    }

    private static final class FindBinding
    extends PDOMNode.NodeVisitor {
        PDOMBinding pdomBinding;
        final int desiredType;

        public FindBinding(PDOMDatabase pdom, char[] name, int desiredType) {
            super(pdom, name);
            this.desiredType = desiredType;
        }

        public boolean visit(int record) throws CoreException {
            if (record == 0) {
                return true;
            }
            PDOMBinding tBinding = this.pdom.getBinding(record);
            if (!tBinding.hasName(this.name)) {
                return false;
            }
            if (tBinding.getBindingType() != this.desiredType) {
                return true;
            }
            this.pdomBinding = tBinding;
            return false;
        }
    }
}

