/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.internal.core.pdom.PDOMDatabase;
import org.eclipse.cdt.internal.core.pdom.db.BTree;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPNamespace
extends PDOMBinding
implements ICPPNamespace,
ICPPNamespaceScope {
    private static final int INDEX_OFFSET = 28;
    protected static final int RECORD_SIZE = 32;

    public PDOMCPPNamespace(PDOMDatabase pdom, PDOMNode parent, IASTName name) throws CoreException {
        super(pdom, parent, name, 6);
    }

    public PDOMCPPNamespace(PDOMDatabase pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 32;
    }

    public BTree getIndex() throws CoreException {
        return new BTree(this.pdom.getDB(), this.record + 28);
    }

    public void addChild(PDOMNode child) throws CoreException {
        this.getIndex().insert(child.getRecord(), child.getIndexComparator());
    }

    public String[] getQualifiedName() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public char[][] getQualifiedNameCharArray() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isGloballyQualified() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IBinding[] getMemberBindings() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public ICPPNamespaceScope getNamespaceScope() throws DOMException {
        return this;
    }

    public void addUsingDirective(IASTNode directive) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IASTNode[] getUsingDirectives() throws DOMException {
        return new IASTNode[0];
    }

    public void addBinding(IBinding binding) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public void addName(IASTName name) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IBinding[] find(String name) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public void flushCache() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IBinding getBinding(IASTName name, boolean resolve) throws DOMException {
        try {
            if (name instanceof ICPPASTQualifiedName) {
                IASTName lastName = ((ICPPASTQualifiedName)name).getLastName();
                return lastName != null ? lastName.resolveBinding() : null;
            }
            IASTNode parent = name.getParent();
            if (parent instanceof ICPPASTQualifiedName) {
                parent = parent.getParent();
            }
            if (parent instanceof IASTIdExpression) {
                IASTNode eParent = parent.getParent();
                if (eParent instanceof IASTFunctionCallExpression) {
                    FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 2);
                    this.getIndex().visit(visitor);
                    return visitor.pdomBinding;
                }
                FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), name.getParent() instanceof ICPPASTQualifiedName && ((ICPPASTQualifiedName)name.getParent()).getLastName() != name ? 6 : 1);
                this.getIndex().visit(visitor);
                return visitor.pdomBinding;
            }
            if (parent instanceof IASTNamedTypeSpecifier) {
                FindBinding visitor = new FindBinding(this.pdom, name.toCharArray(), 3);
                this.getIndex().visit(visitor);
                return visitor.pdomBinding;
            }
            return null;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IScope getParent() throws DOMException {
        return null;
    }

    public IASTNode getPhysicalNode() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public IASTName getScopeName() throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public boolean isFullyCached() throws DOMException {
        return true;
    }

    public void removeBinding(IBinding binding) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    public void setFullyCached(boolean b) throws DOMException {
        throw new PDOMNotImplementedError();
    }

    private static final class FindBinding
    extends PDOMNode.NodeVisitor {
        PDOMBinding pdomBinding;
        final int desiredType;

        public FindBinding(PDOMDatabase pdom, char[] name, int desiredType) {
            super(pdom, name);
            this.desiredType = desiredType;
        }

        public boolean visit(int record) throws CoreException {
            if (record == 0) {
                return true;
            }
            PDOMBinding tBinding = this.pdom.getBinding(record);
            if (!tBinding.hasName(this.name)) {
                return false;
            }
            if (tBinding.getBindingType() != this.desiredType) {
                return true;
            }
            this.pdomBinding = tBinding;
            return false;
        }
    }
}

