/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class IndexSelector {
    ICSearchScope searchScope;
    ICElement focus;
    IndexManager indexManager;
    IPath[] indexKeys;
    boolean isPolymorphicSearch;

    public IndexSelector(ICSearchScope searchScope, ICElement focus, boolean isPolymorphicSearch, IndexManager indexManager) {
        this.searchScope = searchScope;
        this.focus = focus;
        this.indexManager = indexManager;
        this.isPolymorphicSearch = isPolymorphicSearch;
    }

    public static boolean canSeeFocus(ICElement focus, boolean isPolymorphicSearch, IPath projectPath) {
        ICModel model = focus.getCModel();
        IndexSelector.getCProject(projectPath, model);
        return true;
    }

    private void initializeIndexKeys() {
        ArrayList<IPath> requiredIndexKeys = new ArrayList<IPath>();
        IPath[] projects = this.searchScope.enclosingProjects();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ICElement projectFocus = this.focus == null ? null : IndexSelector.getProject(this.focus);
        int i = 0;
        while (i < projects.length) {
            IPath location;
            IPath path = projects[i];
            if ((root.getProject(path.lastSegment()).exists() || path.segmentCount() <= 1 || (location = root.getFile(path).getLocation()) != null && new File(location.toOSString()).exists() || new File(path.toOSString()).exists()) && (projectFocus == null || IndexSelector.canSeeFocus(projectFocus, this.isPolymorphicSearch, path)) && requiredIndexKeys.indexOf(path) == -1) {
                requiredIndexKeys.add(path);
            }
            ++i;
        }
        this.indexKeys = new IPath[requiredIndexKeys.size()];
        requiredIndexKeys.toArray(this.indexKeys);
    }

    public IIndex[] getIndexes() {
        if (this.indexKeys == null) {
            this.initializeIndexKeys();
        }
        int length = this.indexKeys.length;
        IIndex[] indexes = new IIndex[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ICDTIndexer indexer = this.indexManager.getIndexerForProject(root.getProject(this.indexKeys[i].toOSString()));
            IIndex index = null;
            if (indexer != null) {
                index = indexer.getIndex(this.indexKeys[i], true, false);
            }
            if (index != null) {
                indexes[count++] = index;
            }
            ++i;
        }
        if (count != length) {
            IIndex[] iIndexArray = indexes;
            indexes = new IIndex[count];
            System.arraycopy(iIndexArray, 0, indexes, 0, count);
        }
        return indexes;
    }

    private static ICProject getCProject(IPath path, ICModel model) {
        ICProject project = model.getCProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }

    public static ICElement getProject(ICElement element) {
        while (!(element instanceof ICProject)) {
            element = element.getParent();
        }
        return element;
    }
}

