/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.core.index.IIndexStorage;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IndexRequest;
import org.eclipse.cdt.internal.core.index.cindexstorage.CIndexStorage;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IIndexJob;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class IndexManager
extends JobManager {
    private IIndexerSelectionListener[] listeners = new IIndexerSelectionListener[1];
    public static final String INDEX_MODEL_ID = "org.eclipse.cdt.core.cdtindexers";
    public static final String INDEXERID = "indexerID";
    public static final QualifiedName indexerIDKey = new QualifiedName("org.eclipse.cdt.core.cdtindexers", "indexerID");
    public static final String nullIndexerID = "org.eclipse.cdt.core.nullindexer";
    public static final String CDT_INDEXER = "cdt_indexer";
    public static final String INDEXER_ID = "indexerID";
    public static final String INDEXER_ID_VALUE = "indexerIDValue";
    public static boolean VERBOSE = false;
    private HashMap indexerMap = null;
    private ReadWriteMonitor monitor = new ReadWriteMonitor();
    private static ElementChangeListener elementChangeListener = null;
    static /* synthetic */ Class class$0;

    public synchronized void subscribeForIndexerChangeNotifications(IIndexerSelectionListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.search.indexing.IndexManager$IIndexerSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listeners = (IIndexerSelectionListener[])ArrayUtil.append(clazz, this.listeners, listener);
    }

    public synchronized void unSubscribeForIndexerChangeNotifications(IIndexerSelectionListener listener) {
        if (this.listeners == null) {
            return;
        }
        if (listener == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.length) {
            if (this.listeners[i] == listener) {
                this.listeners[i] = null;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        try {
            this.monitor.enterWrite();
            super.reset();
            CCorePlugin.getDefault().getPluginPreferences().setValue("indexer", "org.eclipse.cdt.core.domsourceindexer");
            this.indexerMap = new HashMap(5);
            if (elementChangeListener != null) {
                CoreModel.getDefault().removeElementChangedListener(elementChangeListener);
            }
            elementChangeListener = new ElementChangeListener();
            CoreModel.getDefault().addElementChangedListener(elementChangeListener);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.monitor.exitWrite();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.monitor.exitWrite();
            return;
        }
    }

    protected void jobFinishedNotification(IIndexJob job) {
        if (job instanceof IndexRequest) {
            IndexRequest indexRequest = (IndexRequest)job;
            IPath path = indexRequest.getIndexPath();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.toOSString());
            ICDTIndexer indexer = this.getIndexerForProject(project);
            if (indexer != null) {
                indexer.indexJobFinishedNotification(job);
            }
        }
    }

    public void addResourceEvent(IProject project, IResourceDelta delta, int kind) {
        ICDTIndexer indexer = this.getIndexerForProject(project);
        if (indexer != null) {
            indexer.addRequest(project, delta, kind);
        }
    }

    public void removeResourceEvent(IProject project, IResourceDelta delta, int kind) {
        ICDTIndexer indexer = null;
        indexer = (ICDTIndexer)this.indexerMap.get(project);
        if (indexer != null) {
            indexer.removeRequest(project, delta, kind);
        }
    }

    public void addResource(IProject project, IResource resource) {
        ICDTIndexer indexer = this.getIndexerForProject(project);
        if (indexer != null) {
            indexer.addResource(project, resource);
        }
    }

    public void addResourceByPath(IProject project, IPath path, int resourceType) {
        ICDTIndexer indexer = this.getIndexerForProject(project);
        if (indexer != null) {
            indexer.addResourceByPath(project, path, resourceType);
        }
    }

    public void removeResource(IProject project, IResource resource) {
        ICDTIndexer indexer = null;
        indexer = (ICDTIndexer)this.indexerMap.get(project);
        if (indexer != null) {
            indexer.removeResource(project, resource);
        }
    }

    public String processName() {
        return Util.bind("process.name");
    }

    public void shutdown() {
        if (this.indexerMap != null) {
            Set projects = this.indexerMap.keySet();
            Iterator i = projects.iterator();
            while (i.hasNext()) {
                IProject tempProject = (IProject)i.next();
                ICDTIndexer indexer = (ICDTIndexer)this.indexerMap.get(tempProject);
                if (indexer == null) continue;
                indexer.shutdown();
            }
        }
        if (elementChangeListener != null) {
            CoreModel.getDefault().removeElementChangedListener(elementChangeListener);
            elementChangeListener = null;
        }
        super.shutdown();
    }

    public IIndexStorage getIndexStorageForIndexer(ICDTIndexer indexer) {
        return new CIndexStorage(indexer);
    }

    public int getJobStart() {
        return this.jobStart;
    }

    public int getJobEnd() {
        return this.jobEnd;
    }

    public IIndexJob getAwaitingJobAt(int position) {
        return this.awaitingJobs[position];
    }

    public void updateDependencies(IProject project, IResource resource) {
        ICDTIndexer indexer = this.getIndexerForProject(project);
        if (indexer instanceof DOMSourceIndexer) {
            ((DOMSourceIndexer)indexer).updateDependencies(resource);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDTIndexer getIndexerForProject(IProject project) {
        ICDTIndexer indexer = null;
        try {
            this.monitor.enterRead();
            indexer = (ICDTIndexer)this.indexerMap.get(project);
            if (indexer == null) {
                this.monitor.exitRead();
                try {
                    this.monitor.enterWrite();
                    indexer = this.getIndexer(project);
                    if (indexer != null) {
                        this.indexerMap.put(project, indexer);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.monitor.exitWriteEnterRead();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    this.monitor.exitWriteEnterRead();
                }
            }
            ICDTIndexer iCDTIndexer = indexer;
            Object var5_7 = null;
            this.monitor.exitRead();
            return iCDTIndexer;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.monitor.exitRead();
            throw throwable;
        }
    }

    public ICDTIndexer getDefaultIndexer(IProject project) throws CoreException {
        IExtensionPoint extensionPoint;
        IExtension extension;
        ICDTIndexer indexer = null;
        String id = CCorePlugin.getDefault().getPluginPreferences().getDefaultString("indexer");
        if (id == null || id.length() == 0) {
            id = "org.eclipse.cdt.core.domsourceindexer";
        }
        if ((extension = (extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", "CIndexer")).getExtension(id)) != null) {
            IConfigurationElement[] element = extension.getConfigurationElements();
            int i = 0;
            while (i < element.length) {
                if (element[i].getName().equalsIgnoreCase("cextension")) {
                    indexer = (ICDTIndexer)element[i].createExecutableExtension("run");
                    indexer.setIndexerProject(project);
                    break;
                }
                ++i;
            }
        } else {
            Status s = new Status(4, "org.eclipse.cdt.core", -1, "No Indexer Found", null);
            throw new CoreException((IStatus)s);
        }
        return indexer;
    }

    protected ICDTIndexer getIndexer(IProject project) {
        ICDTIndexer indexer = null;
        try {
            ICExtensionReference[] cextensions;
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(project, false);
            if (cdesc != null && (cextensions = cdesc.get("org.eclipse.cdt.core.CIndexer", true)) != null && cextensions.length > 0) {
                indexer = (ICDTIndexer)((Object)cextensions[0].createExtension());
            }
        }
        catch (CoreException coreException) {}
        if (indexer == null) {
            try {
                indexer = this.getDefaultIndexer(project);
            }
            catch (CoreException coreException) {}
        }
        return indexer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void notifyIdle(long idlingTime) {
        this.monitor.enterRead();
        try {
            if (this.indexerMap == null) {
                Object var7_2 = null;
                this.monitor.exitRead();
                return;
            }
            Set mapKeys = this.indexerMap.keySet();
            Iterator i = mapKeys.iterator();
            while (i.hasNext()) {
                IProject tempProject = (IProject)i.next();
                ICDTIndexer indexer = (ICDTIndexer)this.indexerMap.get(tempProject);
                if (indexer == null) continue;
                indexer.notifyIdle(idlingTime);
            }
        }
        catch (Throwable throwable) {
            Object var7_3 = null;
            this.monitor.exitRead();
            throw throwable;
        }
        {
            Object var7_4 = null;
            this.monitor.exitRead();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void indexerChangeNotification(IProject project) {
        this.discardJobs(project.getName());
        currentIndexer = this.getIndexerForProject(project);
        currentIndexer.indexerRemoved(project);
        storage = currentIndexer.getIndexStorage();
        if (storage instanceof CIndexStorage) {
            ((CIndexStorage)storage).removeIndex(project.getFullPath());
        }
        this.monitor.enterWrite();
        try {
            this.indexerMap.remove(project);
            ** GOTO lbl-1000
        }
        catch (Throwable var5_4) {
            var4_5 = null;
            this.monitor.exitWrite();
            indexer = this.getIndexerForProject(project);
            finalProject = project;
            job = new Job("Index Change Notification", indexer, finalProject){
                private final /* synthetic */ ICDTIndexer val$indexer;
                private final /* synthetic */ IProject val$finalProject;
                {
                    this.val$indexer = iCDTIndexer;
                    this.val$finalProject = iProject;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    Platform.run((ISafeRunnable)new ISafeRunnable(this, this.val$indexer, this.val$finalProject){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ICDTIndexer val$indexer;
                        private final /* synthetic */ IProject val$finalProject;
                        {
                            this.this$1 = var1_1;
                            this.val$indexer = iCDTIndexer;
                            this.val$finalProject = iProject;
                        }

                        public void handleException(Throwable exception) {
                            CCorePlugin.log(exception);
                        }

                        public void run() throws Exception {
                            this.val$indexer.notifyIndexerChange(this.val$finalProject);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            if (this.listeners == null) throw var5_4;
            i = 0;
        }
        while (true) {
            if (i >= this.listeners.length) {
                throw var5_4;
            }
            if (this.listeners[i] != null) {
                this.listeners[i].indexerSelectionChanged(project);
            }
            ++i;
        }
lbl-1000:
        // 1 sources

        {
            var4_6 = null;
            this.monitor.exitWrite();
            indexer = this.getIndexerForProject(project);
            finalProject = project;
        }
        job = new /* invalid duplicate definition of identical inner class */;
        job.schedule();
        if (this.listeners == null) return;
        i = 0;
        while (true) {
            if (i >= this.listeners.length) {
                return;
            }
            if (this.listeners[i] != null) {
                this.listeners[i].indexerSelectionChanged(project);
            }
            ++i;
        }
    }

    public void removeIndexerProblems(IResource resource) {
        String jobName = "remove markers";
        RemoveIndexMarkersJob job = new RemoveIndexMarkersJob(resource, jobName);
        job.setRule((ISchedulingRule)resource);
        job.setPriority(50);
        job.schedule();
    }

    public static interface IIndexerSelectionListener {
        public void indexerSelectionChanged(IProject var1);
    }

    public class ElementChangeListener
    implements IElementChangedListener {
        private boolean scannerInfoChanged = false;
        private IProject currentProject = null;
        private List changedElements = new ArrayList();

        public void elementChanged(ElementChangedEvent event) {
            this.scannerInfoChanged = false;
            this.currentProject = null;
            this.changedElements.clear();
            this.processDelta(event.getDelta());
            if (!this.scannerInfoChanged) {
                return;
            }
            if (this.changedElements.size() > 0) {
                Iterator i = this.changedElements.iterator();
                while (i.hasNext()) {
                    IFile file = (IFile)i.next();
                    IndexManager.this.addResource(this.currentProject, (IResource)file);
                }
            } else if (!CoreModel.isScannerInformationEmpty((IResource)this.currentProject)) {
                IndexManager.this.addResource(this.currentProject, (IResource)this.currentProject);
            }
        }

        private void processDelta(ICElementDelta delta) {
            ICElement element = delta.getElement();
            IResource res = element.getResource();
            if (element instanceof ICProject && res instanceof IProject) {
                this.currentProject = (IProject)res;
            }
            if (this.isPathEntryChange(delta)) {
                this.scannerInfoChanged = true;
                if (element instanceof ITranslationUnit && res instanceof IFile && !this.changedElements.contains(res)) {
                    this.changedElements.add(res);
                }
            }
            ICElementDelta[] affectedChildren = delta.getAffectedChildren();
            int i = 0;
            while (i < affectedChildren.length) {
                this.processDelta(affectedChildren[i]);
                ++i;
            }
        }

        private boolean isPathEntryChange(ICElementDelta delta) {
            int flags = delta.getFlags();
            return delta.getKind() == 4 && ((flags & 0x800) != 0 || (flags & 0x400) != 0 || (flags & 0x40000) != 0);
        }
    }

    private static class RemoveIndexMarkersJob
    extends Job {
        private final IResource resource;

        public RemoveIndexMarkersJob(IResource resource, String name) {
            super(name);
            this.resource = resource;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.resource.deleteMarkers("org.eclipse.cdt.core.indexermarker", true, 2);
            }
            catch (CoreException coreException) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

