/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.indexing;

import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.model.SourceRoot;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class IndexerModelListener
implements IElementChangedListener {
    private static IndexerModelListener indexerModelListener;
    private static IndexManager indexManager;

    private IndexerModelListener() {
    }

    public static synchronized IndexerModelListener getDefault() {
        if (indexerModelListener == null) {
            indexerModelListener = new IndexerModelListener();
            CoreModel.getDefault().addElementChangedListener(indexerModelListener);
            indexManager = CoreModel.getDefault().getIndexManager();
        }
        return indexerModelListener;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (CModelException cModelException) {}
    }

    protected void processDelta(ICElementDelta delta) throws CModelException {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        ICElement element = delta.getElement();
        IProject project = element.getCProject().getProject();
        ICDTIndexer indexer = indexManager.getIndexerForProject(project);
        if (!(indexer instanceof DOMSourceIndexer)) {
            return;
        }
        DOMSourceIndexer sourceIndexer = (DOMSourceIndexer)indexer;
        switch (kind) {
            case 4: {
                IProject tempProject;
                IResource tempResource;
                if ((flags & 0x800) != 0 || (flags & 0x400) != 0 || (flags & 0x100) != 0) {
                    tempResource = element.getResource();
                    SourceRoot tempRootElement = null;
                    if (tempResource == null) {
                        return;
                    }
                    switch (tempResource.getType()) {
                        case 1: {
                            sourceIndexer.addSource((IFile)tempResource, tempResource.getProject().getFullPath());
                            break;
                        }
                        case 2: {
                            tempRootElement = (SourceRoot)this.getElementSource(element);
                            if (tempRootElement == null) break;
                            IProject theProj = tempResource.getProject();
                            sourceIndexer.indexSourceFolder(theProj, tempResource.getFullPath(), tempRootElement.getSourceEntry().fullExclusionPatternChars());
                            break;
                        }
                        case 4: {
                            sourceIndexer.indexAll(tempResource.getProject());
                        }
                    }
                    break;
                }
                if ((flags & 0x200) == 0 || sourceIndexer.indexProblemsEnabled(tempProject = (tempResource = element.getResource()).getProject()) == 0) break;
                sourceIndexer.removeIndexerProblems(tempResource);
            }
        }
        ICElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    ICElement getElementSource(ICElement element) {
        if (element instanceof SourceRoot) {
            return element;
        }
        if (element.getParent() != null) {
            return this.getElementSource(element.getParent());
        }
        return null;
    }

    public void shutdown() {
        if (indexerModelListener != null) {
            CoreModel.getDefault().removeElementChangedListener(indexerModelListener);
        }
    }
}

