/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.util.Iterator;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.search.matching.ClassDeclarationPattern;

public class FriendPattern
extends ClassDeclarationPattern {
    public FriendPattern(char[] name, char[][] containers, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limit, int mode, boolean caseSensitive) {
        super(name, containers, searchFor, limit, mode, caseSensitive);
    }

    public char[] indexEntryPrefix() {
        return Index.bestTypePrefix(this.searchFor, this.getLimitTo(), this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        if (this.decodedType != 7) {
            return false;
        }
        return super.matchIndexEntry();
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        if (!(node instanceof IASTClassSpecifier)) {
            return 0;
        }
        if (!this.canAccept(limit)) {
            return 0;
        }
        IASTClassSpecifier tempNode = (IASTClassSpecifier)node;
        Iterator i = tempNode.getFriends();
        boolean matchFlag = false;
        while (i.hasNext()) {
            Object friend = i.next();
            char[][] qualName = null;
            if (friend instanceof IASTClassSpecifier) {
                IASTClassSpecifier classSpec = (IASTClassSpecifier)friend;
                qualName = classSpec.getFullyQualifiedNameCharArrays();
                if (this.simpleName != null && !this.matchesName(this.simpleName, classSpec.getNameCharArray())) {
                    continue;
                }
            } else if (friend instanceof IASTElaboratedTypeSpecifier) {
                IASTElaboratedTypeSpecifier elabType = (IASTElaboratedTypeSpecifier)friend;
                qualName = elabType.getFullyQualifiedNameCharArrays();
                if (this.simpleName != null && !this.matchesName(this.simpleName, elabType.getNameCharArray())) continue;
            }
            if (qualName == null || !this.matchQualifications(this.qualifications, qualName, true)) continue;
            matchFlag = true;
            break;
        }
        if (matchFlag) {
            return 2;
        }
        return 0;
    }
}

