/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.sourcedependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.cindexstorage.IncludeEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.search.IndexSelector;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IIndexJob;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class DependencyQueryJob
implements IIndexJob {
    IProject project;
    IFile file;
    ArrayList includeFiles;
    DOMSourceIndexer indexer;
    IndexManager indexManager;
    protected IndexSelector indexSelector;
    protected long executionTime = 0L;

    public DependencyQueryJob(IProject project, IFile file, DOMSourceIndexer indexer, List includeFiles) {
        this.project = project;
        this.file = file;
        this.indexer = indexer;
        this.includeFiles = (ArrayList)includeFiles;
        this.indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
    }

    public boolean belongsTo(String jobFamily) {
        return true;
    }

    public void cancel() {
    }

    public boolean execute(IProgressMonitor progressMonitor) {
        boolean bl;
        block10: {
            if (this.project == null || this.file == null) {
                return false;
            }
            if (progressMonitor != null && progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            boolean isComplete = true;
            this.executionTime = 0L;
            if (this.indexSelector == null) {
                this.indexSelector = new IndexSelector(SearchEngine.createWorkspaceScope(), null, false, this.indexManager);
            }
            IIndex[] searchIndexes = this.indexSelector.getIndexes();
            try {
                int max = searchIndexes.length;
                if (progressMonitor != null) {
                    progressMonitor.beginTask("", max);
                }
                int i = 0;
                while (i < max) {
                    isComplete &= this.getFileDeps(searchIndexes[i], progressMonitor);
                    if (progressMonitor != null) {
                        if (progressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        progressMonitor.worked(1);
                    }
                    ++i;
                }
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> execution time: " + this.executionTime + "ms - " + this);
                }
                bl = isComplete;
                Object var6_7 = null;
                if (progressMonitor == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var6_8 = null;
                    if (progressMonitor == null) break block11;
                    progressMonitor.done();
                }
                throw throwable;
            }
            progressMonitor.done();
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFileDeps(IIndex index, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (index == null) {
            return true;
        }
        if (!(this.indexer instanceof DOMSourceIndexer)) {
            return false;
        }
        DOMSourceIndexer sourceIndexer = this.indexer;
        ReadWriteMonitor monitor = sourceIndexer.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                block16: {
                    monitor.enterRead();
                    if (!index.hasChanged()) break block16;
                    try {
                        try {
                            monitor.exitRead();
                            monitor.enterWrite();
                            sourceIndexer.saveIndex(index);
                        }
                        catch (IOException iOException) {
                            Object var5_5 = null;
                            monitor.exitWriteEnterRead();
                            Object var10_9 = null;
                            monitor.exitRead();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        monitor.exitWriteEnterRead();
                        throw throwable;
                    }
                    {
                        Object var5_7 = null;
                        monitor.exitWriteEnterRead();
                    }
                }
                long start = System.currentTimeMillis();
                BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
                try {
                    ((IndexInput)input).open();
                    this.findDep(input);
                }
                catch (Throwable throwable) {
                    Object var8_16 = null;
                    ((IndexInput)input).close();
                    throw throwable;
                }
                {
                    Object var8_17 = null;
                }
                ((IndexInput)input).close();
                this.executionTime += System.currentTimeMillis() - start;
                Object var10_10 = null;
                monitor.exitRead();
                return true;
            }
            catch (IOException iOException) {
                Object var10_11 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            monitor.exitRead();
            throw throwable;
        }
    }

    private void findDep(IndexInput input) throws IOException {
        IndexedFileEntry indexedFile = input.getIndexedFile(this.file.getFullPath().toString());
        if (indexedFile == null) {
            return;
        }
        int fileNum = indexedFile.getFileID();
        IncludeEntry[] tempEntries = input.queryIncludeEntries(fileNum);
        if (tempEntries != null) {
            int r = 0;
            while (r < tempEntries.length) {
                char[] tempFile = tempEntries[r].getFile();
                StringBuffer tempString = new StringBuffer();
                tempString.append(tempFile);
                this.includeFiles.add(tempString.toString());
                ++r;
            }
        }
    }

    public String toString() {
        return "searching for the dependencies of" + this.file.getName();
    }

    public boolean isReadyToRun() {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(SearchEngine.createWorkspaceScope(), null, false, this.indexManager);
            this.indexSelector.getIndexes();
        }
        return true;
    }
}

