/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.DebugCoreMessages;
import org.eclipse.cdt.debug.core.ICBreakpointListener;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.internal.core.DebugConfiguration;
import org.eclipse.cdt.debug.internal.core.ICDebugInternalConstants;
import org.eclipse.cdt.debug.internal.core.ListenerList;
import org.eclipse.cdt.debug.internal.core.SessionManager;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CommonSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.SourceUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.osgi.framework.BundleContext;

public class CDebugCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.core";
    public static final int INTERNAL_ERROR = 1000;
    private static CDebugCorePlugin plugin;
    private HashMap fDebugConfigurations;
    private ListenerList fBreakpointListeners;
    private CommonSourceLookupDirector fCommonSourceLookupDirector;
    private SessionManager fSessionManager = null;

    public CDebugCorePlugin() {
        plugin = this;
    }

    public static CDebugCorePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        if (CDebugCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return CDebugCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, "Internal error logged from CDI Debug: ", top));
    }

    public static void log(IStatus status) {
        CDebugCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        CDebugCorePlugin.getDefault().getLog().log((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 1000, message, null));
    }

    private void initializeDebugConfiguration() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CDebugCorePlugin.getUniqueIdentifier(), "CDebugger");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fDebugConfigurations = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            DebugConfiguration configType = new DebugConfiguration(configurationElement);
            this.fDebugConfigurations.put(configType.getID(), configType);
            ++i;
        }
    }

    public ICDebugConfiguration[] getDebugConfigurations() {
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        return this.fDebugConfigurations.values().toArray(new ICDebugConfiguration[0]);
    }

    public ICDebugConfiguration getDebugConfiguration(String id) throws CoreException {
        ICDebugConfiguration dbgCfg;
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        if ((dbgCfg = (ICDebugConfiguration)this.fDebugConfigurations.get(id)) == null) {
            Status status = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 100, DebugCoreMessages.getString("CDebugCorePlugin.0"), null);
            throw new CoreException((IStatus)status);
        }
        return dbgCfg;
    }

    protected void resetBreakpointsInstallCount() {
        IBreakpointManager bm = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = bm.getBreakpoints(CDebugCorePlugin.getUniqueIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof CBreakpoint) {
                try {
                    ((CBreakpoint)breakpoints[i]).resetInstallCount();
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log(e.getStatus());
                }
            }
            ++i;
        }
    }

    protected SessionManager getSessionManager() {
        return this.fSessionManager;
    }

    protected void setSessionManager(SessionManager sm) {
        if (this.fSessionManager != null) {
            this.fSessionManager.dispose();
        }
        this.fSessionManager = sm;
    }

    public void saveCommonSourceLocations(ICSourceLocation[] locations) {
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_SOURCE_LOCATIONS, SourceUtils.getCommonSourceLocationsMemento(locations));
    }

    public ICSourceLocation[] getCommonSourceLocations() {
        return SourceUtils.getCommonSourceLocationsFromMemento(CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugConstants.PREF_SOURCE_LOCATIONS));
    }

    public void addCBreakpointListener(ICBreakpointListener listener) {
        this.fBreakpointListeners.add(listener);
    }

    public void removeCBreakpointListener(ICBreakpointListener listener) {
        this.fBreakpointListeners.remove(listener);
    }

    public Object[] getCBreakpointListeners() {
        return this.fBreakpointListeners.getListeners();
    }

    private void createBreakpointListenersList() {
        this.fBreakpointListeners = new ListenerList(1);
    }

    private void disposeBreakpointListenersList() {
        this.fBreakpointListeners.removeAll();
        this.fBreakpointListeners = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeCommonSourceLookupDirector();
        this.createBreakpointListenersList();
        this.resetBreakpointsInstallCount();
        this.setSessionManager(new SessionManager());
    }

    public void stop(BundleContext context) throws Exception {
        this.setSessionManager(null);
        this.disposeBreakpointListenersList();
        this.resetBreakpointsInstallCount();
        this.disposeCommonSourceLookupDirector();
        super.stop(context);
    }

    private void initializeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector == null) {
            this.fCommonSourceLookupDirector = new CommonSourceLookupDirector();
            String newMemento = CDebugCorePlugin.getDefault().getPluginPreferences().getString(ICDebugInternalConstants.PREF_COMMON_SOURCE_CONTAINERS);
            if (newMemento.length() == 0) {
                this.convertSourceLocations(this.fCommonSourceLookupDirector);
            } else {
                try {
                    this.fCommonSourceLookupDirector.initializeFromMemento(newMemento);
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log(e.getStatus());
                }
            }
        }
    }

    private void disposeCommonSourceLookupDirector() {
        if (this.fCommonSourceLookupDirector != null) {
            this.fCommonSourceLookupDirector.dispose();
        }
    }

    public CSourceLookupDirector getCommonSourceLookupDirector() {
        return this.fCommonSourceLookupDirector;
    }

    private void convertSourceLocations(CommonSourceLookupDirector director) {
        director.setSourceContainers(SourceUtils.convertSourceLocations(this.getCommonSourceLocations()));
    }
}

