/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.core.model.IAsmInstruction;
import org.eclipse.cdt.debug.core.model.IAsmSourceLine;
import org.eclipse.cdt.debug.internal.core.model.AsmInstruction;

public class AsmSourceLine
implements IAsmSourceLine {
    private String fText;
    private IAsmInstruction[] fInstructions = null;
    private int fLineNumber;

    public AsmSourceLine(IAddressFactory factory, String text, ICDIInstruction[] cdiInstructions) {
        this(factory, text, -1, cdiInstructions);
    }

    public AsmSourceLine(IAddressFactory factory, String text, int lineNumber, ICDIInstruction[] cdiInstructions) {
        this.fText = text;
        this.fLineNumber = lineNumber;
        this.fInstructions = new IAsmInstruction[cdiInstructions.length];
        int i = 0;
        while (i < this.fInstructions.length) {
            this.fInstructions[i] = new AsmInstruction(factory, cdiInstructions[i]);
            ++i;
        }
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public IAsmInstruction[] getInstructions() {
        return this.fInstructions;
    }

    public String toString() {
        return this.fText;
    }
}

