/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.CDebugElementState;
import org.eclipse.cdt.debug.core.model.ICDebugElement;
import org.eclipse.cdt.debug.core.model.ICDebugElementStatus;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;

public abstract class CDebugElement
extends PlatformObject
implements ICDebugElement,
ICDebugElementStatus {
    private CDebugTarget fDebugTarget;
    private int fSeverity = 0;
    private String fMessage = null;
    private CDebugElementState fState = CDebugElementState.UNDEFINED;
    private CDebugElementState fOldState = CDebugElementState.UNDEFINED;
    private Object fCurrentStateInfo = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public CDebugElement(CDebugTarget target) {
        this.setDebugTarget(target);
    }

    public String getModelIdentifier() {
        return CDIDebugModel.getPluginIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    protected void setDebugTarget(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    protected void logError(Exception e) {
        DebugPlugin.log((Throwable)e);
    }

    protected void logError(String message) {
        DebugPlugin.logMessage((String)message, null);
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    protected void fireEventSet(DebugEvent[] events) {
        DebugPlugin.getDefault().fireDebugEventSet(events);
    }

    public void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    public DebugEvent createCreateEvent() {
        return new DebugEvent((Object)this, 4);
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 1, detail));
    }

    public DebugEvent createResumeEvent(int detail) {
        return new DebugEvent((Object)this, 1, detail);
    }

    public void fireSuspendEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 2, detail));
    }

    public DebugEvent createSuspendEvent(int detail) {
        return new DebugEvent((Object)this, 2, detail);
    }

    public void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public DebugEvent createTerminateEvent() {
        return new DebugEvent((Object)this, 8);
    }

    public void fireChangeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 16, detail));
    }

    public DebugEvent createChangeEvent(int detail) {
        return new DebugEvent((Object)this, 16, detail);
    }

    public ICDISession getCDISession() {
        return this.getCDITarget().getSession();
    }

    public ICDITarget getCDITarget() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDITarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICDITarget)iDebugTarget.getAdapter((Class)clazz);
    }

    public static void requestFailed(String message, Exception e) throws DebugException {
        CDebugElement.requestFailed(message, e, 5012);
    }

    public static void targetRequestFailed(String message, CDIException e) throws DebugException {
        CDebugElement.requestFailed(MessageFormat.format("Target request failed: {0}.", message), e, 5010);
    }

    public static void requestFailed(String message, Throwable e, int code) throws DebugException {
        CDebugElement.throwDebugException(message, code, e);
    }

    public static void targetRequestFailed(String message, Throwable e) throws DebugException {
        CDebugElement.throwDebugException(MessageFormat.format("Target request failed: {0}.", message), 5010, e);
    }

    public static void notSupported(String message) throws DebugException {
        CDebugElement.throwDebugException(message, 5011, null);
    }

    protected static void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), code, message, exception));
    }

    protected void infoMessage(Throwable e) {
        Status newStatus = new Status(1, CDebugCorePlugin.getUniqueIdentifier(), 10001, e.getMessage(), null);
        CDebugUtils.info((IStatus)newStatus, this.getDebugTarget());
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.debug.core.model.IDebugElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.cdt.debug.internal.core.model.CDebugElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz3)) {
            return this;
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugElementStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz4)) {
            return this;
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz5)) {
            return this.getCDISession();
        }
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz6)) {
            return this.getDebugTarget();
        }
        Class<?> clazz7 = class$7;
        if (clazz7 == null) {
            try {
                clazz7 = class$7 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz7)) {
            return this.getDebugTarget();
        }
        Class<?> clazz8 = class$8;
        if (clazz8 == null) {
            try {
                clazz8 = class$8 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz8)) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    protected void setStatus(int severity, String message) {
        this.fSeverity = severity;
        this.fMessage = message;
        if (this.fMessage != null) {
            this.fMessage.trim();
        }
    }

    protected void resetStatus() {
        this.fSeverity = 0;
        this.fMessage = null;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public CDebugElementState getState() {
        return this.fState;
    }

    protected synchronized void setState(CDebugElementState state) throws IllegalArgumentException {
        this.fOldState = this.fState;
        this.fState = state;
    }

    protected synchronized void restoreState() {
        this.fState = this.fOldState;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    protected void setCurrentStateInfo(Object currentStateInfo) {
        this.fCurrentStateInfo = currentStateInfo;
    }
}

