/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.sourcelookup.CDirectorySourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupParticipant;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;

public class CSourceLookupDirector
extends AbstractSourceLookupDirector {
    private static Set fSupportedTypes = new HashSet();

    static {
        fSupportedTypes.add(WorkspaceSourceContainer.TYPE_ID);
        fSupportedTypes.add(ProjectSourceContainer.TYPE_ID);
        fSupportedTypes.add(FolderSourceContainer.TYPE_ID);
        fSupportedTypes.add(CDirectorySourceContainer.TYPE_ID);
        fSupportedTypes.add(MappingSourceContainer.TYPE_ID);
    }

    public void initializeParticipants() {
        this.addParticipants(new ISourceLookupParticipant[]{new CSourceLookupParticipant()});
    }

    public boolean supportsSourceContainerType(ISourceContainerType type) {
        return fSupportedTypes.contains(type.getId());
    }

    public boolean contains(ICBreakpoint breakpoint) {
        try {
            IResource resource;
            String handle = breakpoint.getSourceHandle();
            IMarker marker = breakpoint.getMarker();
            if (marker != null && (resource = marker.getResource()).isLinked() && resource.getLocation().toOSString().equals(handle)) {
                return this.contains(resource.getProject());
            }
            ISourceContainer[] containers = this.getSourceContainers();
            int i = 0;
            while (i < containers.length) {
                if (this.contains(containers[i], handle)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public boolean contains(IProject project) {
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            if (this.contains(containers[i], project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean contains(ISourceContainer container, IProject project) {
        if (container instanceof ProjectSourceContainer && ((ProjectSourceContainer)container).getProject().equals((Object)project)) {
            return true;
        }
        try {
            ISourceContainer[] containers = container.getSourceContainers();
            int i = 0;
            while (i < containers.length) {
                if (this.contains(containers[i], project)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean contains(ISourceContainer container, String sourceName) {
        IContainer folder;
        IPath folderPath;
        IProject project;
        IPath projPath;
        Path path = new Path(sourceName);
        if (!path.isValidPath(sourceName)) {
            return false;
        }
        if (container instanceof ProjectSourceContainer && (projPath = (project = ((ProjectSourceContainer)container).getProject()).getLocation()) != null && projPath.isPrefixOf((IPath)path)) {
            IFile file = ((ProjectSourceContainer)container).getProject().getFile(path.removeFirstSegments(projPath.segmentCount()));
            return file != null && file.exists();
        }
        if (container instanceof FolderSourceContainer && (folderPath = (folder = ((FolderSourceContainer)container).getContainer()).getLocation()) != null && folderPath.isPrefixOf((IPath)path)) {
            IFile file = ((FolderSourceContainer)container).getContainer().getFile(path.removeFirstSegments(folderPath.segmentCount()));
            return file != null && file.exists();
        }
        if (container instanceof CDirectorySourceContainer) {
            File dir = ((CDirectorySourceContainer)container).getDirectory();
            boolean searchSubfolders = ((CDirectorySourceContainer)container).searchSubfolders();
            Path dirPath = new Path(dir.getAbsolutePath());
            if (searchSubfolders || dirPath.segmentCount() + 1 == path.segmentCount()) {
                return dirPath.isPrefixOf((IPath)path);
            }
        }
        if (container instanceof MappingSourceContainer) {
            return ((MappingSourceContainer)container).getCompilationPath(sourceName) != null;
        }
        try {
            ISourceContainer[] containers = container.getSourceContainers();
            int i = 0;
            while (i < containers.length) {
                if (this.contains(containers[i], sourceName)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public IPath getCompilationPath(String sourceName) {
        IPath path = null;
        ISourceContainer[] containers = this.getSourceContainers();
        int i = 0;
        while (i < containers.length) {
            IPath cp = this.getCompilationPath(containers[i], sourceName);
            if (cp != null) {
                path = cp;
                break;
            }
            ++i;
        }
        return path;
    }

    private IPath getCompilationPath(ISourceContainer container, String sourceName) {
        IPath path = null;
        if (container instanceof MappingSourceContainer) {
            path = ((MappingSourceContainer)container).getCompilationPath(sourceName);
        } else {
            try {
                ISourceContainer[] containers = container.getSourceContainers();
                int i = 0;
                while (i < containers.length) {
                    path = this.getCompilationPath(containers[i], sourceName);
                    if (path == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (CoreException coreException) {}
        }
        return path;
    }
}

