/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.ICDIDebugger2;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public abstract class AbstractGDBCDIDebugger
implements ICDIDebugger2 {
    public ICDISession createDebuggerSession(ILaunch launch, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        return this.createSession(launch, exe.getPath().toFile(), monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createSession(ILaunch launch, File executable, IProgressMonitor monitor) throws CoreException {
        boolean failed = false;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        Session session = this.createGDBSession(config, executable, monitor);
        if (session != null) {
            ICDITarget[] targets = session.getTargets();
            int i = 0;
            while (i < targets.length) {
                Process debugger = session.getSessionProcess(targets[i]);
                if (debugger != null) {
                    IProcess debuggerProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)debugger, (String)this.renderDebuggerProcessLabel(config));
                    launch.addProcess(debuggerProcess);
                }
                try {
                    ((Target)targets[i]).getMISession().start();
                }
                catch (MIException e) {
                    failed = true;
                    throw this.newCoreException(e);
                }
                ++i;
            }
        }
        try {
            try {
                this.doStartSession(config, session, monitor);
            }
            catch (CoreException e) {
                failed = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (!failed) {
                    if (!monitor.isCanceled()) throw throwable;
                }
                session.terminate();
                throw throwable;
            }
            catch (CDIException cDIException) {}
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (CDIException cDIException) {
            return session;
        }
        if (!failed) {
            if (!monitor.isCanceled()) return session;
        }
        session.terminate();
        return session;
    }

    protected Session createGDBSession(ILaunchConfiguration config, File executable, IProgressMonitor monitor) throws CoreException {
        String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        CommandFactory factory = this.getCommandFactory(config);
        String[] extraArgs = this.getExtraArguments(config);
        boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
        try {
            return MIPlugin.getDefault().createSession(this.getSessionType(config), gdb, factory, executable, extraArgs, usePty, monitor);
        }
        catch (Exception e) {
            if (e instanceof CoreException) {
                throw (CoreException)((Object)e);
            }
            throw this.newCoreException(e);
        }
    }

    protected int getSessionType(ILaunchConfiguration config) throws CoreException {
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if ("run".equals(debugMode)) {
            return 0;
        }
        if ("attach".equals(debugMode)) {
            return 1;
        }
        if ("core".equals(debugMode)) {
            return 2;
        }
        throw this.newCoreException(String.valueOf(MIPlugin.getResourceString("src.AbstractGDBCDIDebugger.0")) + debugMode, null);
    }

    protected abstract String[] getExtraArguments(ILaunchConfiguration var1) throws CoreException;

    protected abstract CommandFactory getCommandFactory(ILaunchConfiguration var1) throws CoreException;

    protected void doStartSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
    }

    protected String renderDebuggerProcessLabel(ILaunchConfiguration config) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        String label = MIPlugin.getResourceString("src.AbstractGDBCDIDebugger.0");
        try {
            label = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        }
        catch (CoreException coreException) {}
        return MessageFormat.format(format, label, timestamp);
    }

    protected CoreException newCoreException(Throwable exception) {
        String message = MIPlugin.getResourceString("src.AbstractGDBCDIDebugger.1");
        return this.newCoreException(message, exception);
    }

    protected CoreException newCoreException(String message, Throwable exception) {
        int code = 150;
        String ID = MIPlugin.getUniqueIdentifier();
        MultiStatus status = new MultiStatus(ID, code, message, exception);
        status.add((IStatus)new Status(4, ID, code, exception == null ? new String() : exception.getLocalizedMessage(), exception));
        return new CoreException((IStatus)status);
    }
}

