/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.GDBCDIDebugger;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.command.factories.win32.CygwinCommandFactory;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CygwinGDBCDIDebugger
extends GDBCDIDebugger {
    protected void initializeLibraries(ILaunchConfiguration config, Session session) throws CoreException {
    }

    public Session createLaunchSession(ILaunchConfiguration config, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        Session session = super.createLaunchSession(config, exe, monitor);
        ICDITarget[] targets = session.getTargets();
        int i = 0;
        while (i < targets.length) {
            Target target = (Target)targets[i];
            MISession miSession = target.getMISession();
            String miVersion = miSession.getCommandFactory().getMIVersion();
            miSession.setCommandFactory(new CygwinCommandFactory(miVersion));
            try {
                CommandFactory factory = miSession.getCommandFactory();
                MIGDBSet set = factory.createMIGDBSet(new String[]{"new-console"});
                miSession.postCommand(set);
                MIInfo info = set.getMIInfo();
                if (info == null) {
                    throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                }
            }
            catch (MIException mIException) {}
            ++i;
        }
        return session;
    }

    public Session createAttachSession(ILaunchConfiguration config, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        Session session = super.createAttachSession(config, exe, monitor);
        ICDITarget[] targets = session.getTargets();
        int i = 0;
        while (i < targets.length) {
            Target target = (Target)targets[i];
            MISession miSession = target.getMISession();
            String miVersion = miSession.getCommandFactory().getMIVersion();
            miSession.setCommandFactory(new CygwinCommandFactory(miVersion));
            ++i;
        }
        this.initializeLibraries(config, session);
        return session;
    }

    public Session createCoreSession(ILaunchConfiguration config, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        Session session = super.createCoreSession(config, exe, monitor);
        ICDITarget[] targets = session.getTargets();
        int i = 0;
        while (i < targets.length) {
            Target target = (Target)targets[i];
            MISession miSession = target.getMISession();
            String miVersion = miSession.getCommandFactory().getMIVersion();
            miSession.setCommandFactory(new CygwinCommandFactory(miVersion));
            ++i;
        }
        this.initializeLibraries(config, session);
        return session;
    }
}

