/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.AbstractGDBCDIDebugger;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CLITargetAttach;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;

public class GDBCDIDebugger2
extends AbstractGDBCDIDebugger {
    protected String[] getExtraArguments(ILaunchConfiguration config) throws CoreException {
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if ("run".equals(debugMode)) {
            return this.getRunArguments(config);
        }
        if ("attach".equals(debugMode)) {
            return this.getAttachArguments(config);
        }
        if ("core".equals(debugMode)) {
            return this.getCoreArguments(config);
        }
        return new String[0];
    }

    protected String[] getRunArguments(ILaunchConfiguration config) throws CoreException {
        return new String[]{this.getWorkingDirectory(config), this.getCommandFile(config)};
    }

    protected String[] getAttachArguments(ILaunchConfiguration config) throws CoreException {
        return new String[]{this.getWorkingDirectory(config), this.getCommandFile(config)};
    }

    protected String[] getCoreArguments(ILaunchConfiguration config) throws CoreException {
        Path coreFile = new Path(config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null));
        return new String[]{this.getWorkingDirectory(config), this.getCommandFile(config), "-c", coreFile.toFile().getAbsolutePath()};
    }

    protected CommandFactory getCommandFactory(ILaunchConfiguration config) throws CoreException {
        String factoryID = MIPlugin.getCommandFactory(config);
        CommandFactory factory = MIPlugin.getDefault().getCommandFactoryManager().getCommandFactory(factoryID);
        String miVersion = this.getMIVersion(config);
        if (factory != null) {
            factory.setMIVersion(miVersion);
        }
        return factory != null ? factory : new CommandFactory(miVersion);
    }

    public static IPath getProjectPath(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IPath p;
        String projectName = GDBCDIDebugger2.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (p = (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).getLocation()) != null) {
            return p;
        }
        return Path.EMPTY;
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    protected String getMIVersion(ILaunchConfiguration config) {
        return MIPlugin.getMIVersion(config);
    }

    protected void doStartSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        this.initializeLibraries(config, session);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if ("run".equals(debugMode)) {
            this.startLocalGDBSession(config, session, monitor);
        }
        if ("attach".equals(debugMode)) {
            this.startAttachGDBSession(config, session, monitor);
        }
        if ("core".equals(debugMode)) {
            this.startCoreGDBSession(config, session, monitor);
        }
    }

    protected void startLocalGDBSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        MISession miSession = this.getMISession(session);
        try {
            CommandFactory factory = miSession.getCommandFactory();
            MIGDBSet set = factory.createMIGDBSet(new String[]{"new-console"});
            miSession.postCommand(set);
            MIInfo info = set.getMIInfo();
            if (info == null) {
                throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
            }
        }
        catch (MIException mIException) {}
    }

    protected void startAttachGDBSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        MISession miSession = this.getMISession(session);
        CommandFactory factory = miSession.getCommandFactory();
        int pid = -1;
        try {
            pid = config.getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
        }
        catch (CoreException e) {
            throw this.newCoreException(MIPlugin.getResourceString("src.GDBCDIDebugger2.0"), e);
        }
        if (pid <= 0) {
            throw this.newCoreException(MIPlugin.getResourceString("src.GDBCDIDebugger2.1"), null);
        }
        try {
            CLITargetAttach attach = factory.createCLITargetAttach(pid);
            miSession.postCommand(attach);
            MIInfo info = attach.getMIInfo();
            if (info == null) {
                throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
            }
            miSession.getMIInferior().setInferiorPID(pid);
            miSession.getMIInferior().setConnected();
        }
        catch (MIException e) {
            throw this.newCoreException(MessageFormat.format(MIPlugin.getResourceString("src.GDBCDIDebugger2.2"), new Integer(pid)), e);
        }
        miSession.getMIInferior().setSuspended();
        miSession.getMIInferior().update();
    }

    protected void startCoreGDBSession(ILaunchConfiguration config, Session session, IProgressMonitor monitor) throws CoreException {
        this.getMISession(session).getMIInferior().setSuspended();
        try {
            session.getSharedLibraryManager().update();
        }
        catch (CDIException e) {
            throw this.newCoreException(e);
        }
    }

    protected MISession getMISession(Session session) {
        ICDITarget[] targets = session.getTargets();
        if (targets.length == 0 || !(targets[0] instanceof Target)) {
            return null;
        }
        return ((Target)targets[0]).getMISession();
    }

    protected void initializeLibraries(ILaunchConfiguration config, Session session) throws CoreException {
        try {
            SharedLibraryManager sharedMgr = session.getSharedLibraryManager();
            boolean autolib = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
            boolean stopOnSolibEvents = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
            List p = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST);
            ICDITarget[] dtargets = session.getTargets();
            int i = 0;
            while (i < dtargets.length) {
                Target target = (Target)dtargets[i];
                try {
                    sharedMgr.setAutoLoadSymbols(target, autolib);
                    sharedMgr.setStopOnSolibEvents(target, stopOnSolibEvents);
                    if (autolib && !stopOnSolibEvents) {
                        sharedMgr.setDeferredBreakpoint(true);
                        sharedMgr.setStopOnSolibEvents(target, true);
                    }
                }
                catch (CDIException cDIException) {}
                if (p.size() > 0) {
                    String[] oldPaths = sharedMgr.getSharedLibraryPaths(target);
                    String[] paths = new String[oldPaths.length + p.size()];
                    System.arraycopy(p.toArray(new String[p.size()]), 0, paths, 0, p.size());
                    System.arraycopy(oldPaths, 0, paths, p.size(), oldPaths.length);
                    sharedMgr.setSharedLibraryPaths(target, paths);
                }
                ++i;
            }
        }
        catch (CDIException e) {
            throw this.newCoreException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_initializing_shared_lib_options")) + e.getMessage(), e);
        }
    }

    private String getWorkingDirectory(ILaunchConfiguration config) throws CoreException {
        File cwd = GDBCDIDebugger2.getProjectPath(config).toFile();
        return "--cd=" + cwd.getAbsolutePath();
    }

    private String getCommandFile(ILaunchConfiguration config) throws CoreException {
        String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
        return gdbinit != null && gdbinit.length() > 0 ? "--command=" + gdbinit : "--nx";
    }
}

