/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.RxThread;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Signal;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CLIHandle;
import org.eclipse.cdt.debug.mi.core.command.CLIInfoSignals;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.CLIInfoSignalsInfo;
import org.eclipse.cdt.debug.mi.core.output.MISigHandle;

public class SignalManager
extends Manager {
    ICDISignal[] EMPTY_SIGNALS = new ICDISignal[0];
    MISigHandle[] noSigs = new MISigHandle[0];
    Map signalsMap = new Hashtable();

    public SignalManager(Session session) {
        super(session, false);
    }

    synchronized List getSignalsList(Target target) {
        List signalsList = (List)this.signalsMap.get(target);
        if (signalsList == null) {
            signalsList = Collections.synchronizedList(new ArrayList());
            this.signalsMap.put(target, signalsList);
        }
        return signalsList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MISigHandle[] getMISignals(MISession miSession) throws CDIException {
        MISigHandle[] miSigs;
        CommandFactory factory = miSession.getCommandFactory();
        CLIInfoSignals sigs = factory.createCLIInfoSignals();
        try {
            try {
                RxThread rxThread = miSession.getRxThread();
                rxThread.setEnableConsole(false);
                miSession.postCommand(sigs);
                CLIInfoSignalsInfo info = sigs.getMIInfoSignalsInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                miSigs = info.getMISignals();
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            RxThread rxThread = miSession.getRxThread();
            rxThread.setEnableConsole(true);
            throw throwable;
        }
        {
            Object var7_10 = null;
            RxThread rxThread = miSession.getRxThread();
            rxThread.setEnableConsole(true);
            return miSigs;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MISigHandle getMISignal(MISession miSession, String name) throws CDIException {
        MISigHandle sig = null;
        CommandFactory factory = miSession.getCommandFactory();
        CLIInfoSignals sigs = factory.createCLIInfoSignals(name);
        try {
            try {
                RxThread rxThread = miSession.getRxThread();
                rxThread.setEnableConsole(false);
                miSession.postCommand(sigs);
                CLIInfoSignalsInfo info = sigs.getMIInfoSignalsInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                MISigHandle[] miSigs = info.getMISignals();
                if (miSigs.length > 0) {
                    sig = miSigs[0];
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            RxThread rxThread = miSession.getRxThread();
            rxThread.setEnableConsole(true);
            throw throwable;
        }
        {
            Object var9_12 = null;
            RxThread rxThread = miSession.getRxThread();
            rxThread.setEnableConsole(true);
            return sig;
        }
    }

    private boolean hasSignalChanged(ICDISignal sig, MISigHandle miSignal) {
        return !sig.getName().equals(miSignal.getName()) || sig.isStopSet() != miSignal.isStop() || sig.isIgnore() != !miSignal.isPass();
    }

    protected ICDISignal findSignal(Target target, String name) {
        ICDISignal sig = null;
        List signalsList = (List)this.signalsMap.get(target);
        if (signalsList != null) {
            ICDISignal[] sigs = signalsList.toArray(new ICDISignal[0]);
            int i = 0;
            while (i < sigs.length) {
                if (sigs[i].getName().equals(name)) {
                    sig = sigs[i];
                    break;
                }
                ++i;
            }
        }
        return sig;
    }

    public ICDISignal getSignal(MISession miSession, String name) {
        Session session = (Session)this.getSession();
        Target target = session.getTarget(miSession);
        return this.getSignal(target, name);
    }

    public ICDISignal getSignal(Target target, String name) {
        ICDISignal sig = this.findSignal(target, name);
        if (sig == null) {
            MISigHandle miSig = null;
            try {
                miSig = this.getMISignal(target.getMISession(), name);
                sig = new Signal(target, miSig);
                List signalsList = this.getSignalsList(target);
                signalsList.add(sig);
            }
            catch (CDIException cDIException) {
                miSig = new MISigHandle(name, false, false, false, name);
                sig = new Signal(target, miSig);
            }
        }
        return sig;
    }

    public void handle(Signal sig, boolean isIgnore, boolean isStop) throws CDIException {
        Target target = (Target)sig.getTarget();
        MISession miSession = target.getMISession();
        CommandFactory factory = miSession.getCommandFactory();
        StringBuffer buffer = new StringBuffer(sig.getName());
        buffer.append(" ");
        if (isIgnore) {
            buffer.append("ignore");
        } else {
            buffer.append("noignore");
        }
        buffer.append(" ");
        if (isStop) {
            buffer.append("stop");
        } else {
            buffer.append("nostop");
        }
        CLIHandle handle = factory.createCLIHandle(buffer.toString());
        try {
            miSession.postCommand(handle);
            handle.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
        sig.getMISignal().handle(isIgnore, isStop);
        miSession.fireEvent(new MISignalChangedEvent(miSession, sig.getName()));
    }

    public ICDISignal[] getSignals(Target target) throws CDIException {
        List signalsList = (List)this.signalsMap.get(target);
        if (signalsList == null) {
            this.update(target);
        }
        if ((signalsList = (List)this.signalsMap.get(target)) != null) {
            return signalsList.toArray(new ICDISignal[0]);
        }
        return this.EMPTY_SIGNALS;
    }

    public void update(Target target) throws CDIException {
        MISession miSession = target.getMISession();
        MISigHandle[] miSigs = this.getMISignals(miSession);
        ArrayList<MISignalChangedEvent> eventList = new ArrayList<MISignalChangedEvent>(miSigs.length);
        List signalsList = this.getSignalsList(target);
        int i = 0;
        while (i < miSigs.length) {
            ICDISignal sig = this.findSignal(target, miSigs[i].getName());
            if (sig != null) {
                if (this.hasSignalChanged(sig, miSigs[i])) {
                    ((Signal)sig).setMISignal(miSigs[i]);
                    eventList.add(new MISignalChangedEvent(miSession, miSigs[i].getName()));
                }
            } else {
                signalsList.add(new Signal(target, miSigs[i]));
            }
            ++i;
        }
        MIEvent[] events = eventList.toArray(new MIEvent[0]);
        miSession.fireEvents(events);
    }
}

