/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.output.MIVar;

public class Register
extends Variable
implements ICDIRegister {
    public Register(Target target, Thread thread, StackFrame frame, String n, String q, int pos, int depth, MIVar miVar) {
        super(target, thread, frame, n, q, pos, depth, miVar);
    }

    public Register(RegisterDescriptor obj, MIVarCreate var) {
        super(obj, var);
    }

    protected void addToTypeCache(String nameType, ICDIType type) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        RegisterManager mgr = session.getRegisterManager();
        mgr.addToTypeCache(nameType, type);
    }

    protected ICDIType getFromTypeCache(String nameType) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        RegisterManager mgr = session.getRegisterManager();
        return mgr.getFromTypeCache(nameType);
    }

    public String getFullName() {
        if (this.fFullName == null) {
            String n = this.getName();
            this.fFullName = !n.startsWith("$") ? "$" + n : n;
        }
        return this.fFullName;
    }

    protected Variable createVariable(Target target, Thread thread, StackFrame frame, String name, String fullName, int pos, int depth, MIVar miVar) {
        return new Register(target, thread, frame, name, fullName, pos, depth, miVar);
    }

    public void dispose() throws CDIException {
        ICDITarget target = this.getTarget();
        RegisterManager regMgr = ((Session)target.getSession()).getRegisterManager();
        regMgr.destroyRegister(this);
    }

    public ICDIValue getValue(ICDIStackFrame context) throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        RegisterManager mgr = session.getRegisterManager();
        Variable var = mgr.createShadowRegister(this, (StackFrame)context, this.getQualifiedName());
        return var.getValue();
    }

    public boolean equals(ICDIRegister register) {
        if (register instanceof Register) {
            Register reg = (Register)register;
            return super.equals(reg);
        }
        return super.equals((ICDIVariableDescriptor)register);
    }
}

