/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model.type;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.type.DerivedValue;

public class ArrayValue
extends DerivedValue
implements ICDIArrayValue {
    public ArrayValue(Variable v) {
        super(v);
    }

    public ICDIVariable[] getVariables() throws CDIException {
        int timeout = this.getVariable().getMIVar().getNumChild() * 8 + 5000;
        return this.getVariable().getChildren(timeout);
    }

    public ICDIVariable[] getVariables(int index, int length) throws CDIException {
        Variable variable = this.getVariable();
        if (variable instanceof Register) {
            ICDIVariable[] vars = this.getVariables();
            if (index < vars.length && index + length <= vars.length) {
                ICDIVariable[] newVars = new ICDIVariable[length];
                System.arraycopy(vars, index, newVars, 0, length);
                return newVars;
            }
            return new ICDIVariable[0];
        }
        ICDITarget target = this.getTarget();
        Session session = (Session)target.getSession();
        VariableManager mgr = session.getVariableManager();
        VariableDescriptor vo = mgr.getVariableDescriptorAsArray(variable, index, length);
        return mgr.createVariable(vo).getValue().getVariables();
    }
}

