/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model.type;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntegralValue;
import org.eclipse.cdt.debug.mi.core.MIFormat;
import org.eclipse.cdt.debug.mi.core.cdi.model.Value;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;

public abstract class IntegralValue
extends Value
implements ICDIIntegralValue {
    public IntegralValue(Variable v) {
        super(v);
    }

    public BigInteger bigIntegerValue() throws CDIException {
        return IntegralValue.bigIntegerValue(this.getValueString());
    }

    public static BigInteger bigIntegerValue(String valueString) {
        if (valueString.startsWith("@")) {
            int colon = (valueString = valueString.substring(1)).indexOf(58);
            if (colon != -1) {
                valueString = valueString.substring(colon + 1);
            }
        } else {
            int space = valueString.indexOf(32);
            if (space != -1) {
                valueString = valueString.substring(0, space).trim();
            }
        }
        try {
            return MIFormat.getBigInteger(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            return BigInteger.ZERO;
        }
    }

    public long longValue() throws CDIException {
        return this.bigIntegerValue().longValue();
    }

    public int intValue() throws CDIException {
        return this.bigIntegerValue().intValue();
    }

    public short shortValue() throws CDIException {
        return this.bigIntegerValue().shortValue();
    }

    public int byteValue() throws CDIException {
        return this.bigIntegerValue().byteValue();
    }
}

