/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.Iterator;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.editor.IMakefileDocumentProvider;
import org.eclipse.cdt.make.internal.ui.editor.MakefileDocumentSetupParticipant;
import org.eclipse.cdt.make.internal.ui.editor.MakefileStorageDocumentProvider;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.ForwardingDocumentProvider;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class MakefileDocumentProvider
extends TextFileDocumentProvider
implements IMakefileDocumentProvider {
    IMakefile fMakefile;

    public MakefileDocumentProvider() {
        TextFileDocumentProvider provider = new TextFileDocumentProvider((IDocumentProvider)new MakefileStorageDocumentProvider());
        provider = new ForwardingDocumentProvider("___makefile_partitioning", (IDocumentSetupParticipant)new MakefileDocumentSetupParticipant(), (IDocumentProvider)provider);
        this.setParentDocumentProvider((IDocumentProvider)provider);
    }

    private IMakefile createMakefile(IFile file) {
        return MakeCorePlugin.getDefault().createMakefile(file);
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new MakefileAnnotationModel((IResource)file);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        if (!(element instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput input = (IFileEditorInput)element;
        IMakefile original = this.createMakefile(input.getFile());
        if (original == null) {
            return null;
        }
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof MakefileFileInfo)) {
            return null;
        }
        MakefileFileInfo makefileInfo = (MakefileFileInfo)info;
        this.setUpSynchronization(makefileInfo);
        makefileInfo.fCopy = original;
        if (makefileInfo.fModel instanceof MakefileAnnotationModel) {
            MakefileAnnotationModel model = (MakefileAnnotationModel)makefileInfo.fModel;
            model.setMakefile(makefileInfo.fCopy);
        }
        return makefileInfo;
    }

    protected void disposeFileInfo(Object element, TextFileDocumentProvider.FileInfo info) {
        if (info instanceof MakefileFileInfo) {
            MakefileFileInfo makefileInfo = (MakefileFileInfo)info;
            if (makefileInfo.fCopy != null) {
                makefileInfo.fCopy = null;
            }
        }
        super.disposeFileInfo(element, info);
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new MakefileFileInfo();
    }

    public IMakefile getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof MakefileFileInfo) {
            MakefileFileInfo info = (MakefileFileInfo)fileInfo;
            return info.fCopy;
        }
        return null;
    }

    public void shutdown() {
        Iterator e = this.getConnectedElementsIterator();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    private void setUpSynchronization(MakefileFileInfo antInfo) {
        IDocument document = antInfo.fTextFileBuffer.getDocument();
        IAnnotationModel model = antInfo.fModel;
        if (document instanceof ISynchronizable && model instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            ((ISynchronizable)model).setLockObject(lock);
        }
    }

    protected class MakefileAnnotationModel
    extends ResourceMarkerAnnotationModel {
        public MakefileAnnotationModel(IResource resource) {
            super(resource);
        }

        public void setMakefile(IMakefile makefile) {
            MakefileDocumentProvider.this.fMakefile = makefile;
        }
    }

    protected class MakefileFileInfo
    extends TextFileDocumentProvider.FileInfo {
        public IMakefile fCopy;

        protected MakefileFileInfo() {
        }
    }
}

