/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.gnu.IInclude;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class OpenIncludeAction
extends Action {
    ISelectionProvider fSelectionProvider;

    public OpenIncludeAction(ISelectionProvider provider) {
        super(MakeUIPlugin.getResourceString("OpenIncludeAction.title"));
        this.setDescription(MakeUIPlugin.getResourceString("OpenIncludeAction.description"));
        this.setToolTipText(MakeUIPlugin.getResourceString("OpenIncludeAction.tooltip"));
        this.fSelectionProvider = provider;
    }

    public void run() {
        IInclude[] includes = this.getIncludeDirective(this.fSelectionProvider.getSelection());
        if (includes != null) {
            int i = 0;
            while (i < includes.length) {
                IDirective[] directives = includes[i].getDirectives();
                int j = 0;
                while (j < directives.length) {
                    try {
                        OpenIncludeAction.openInEditor(directives[j]);
                    }
                    catch (PartInitException partInitException) {}
                    ++j;
                }
                ++i;
            }
        }
    }

    private static IEditorPart openInEditor(IDirective directive) throws PartInitException {
        String filename = directive.getFileName();
        Path path = new Path(filename);
        IFile file = MakeUIPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (file != null) {
            IWorkbenchPage p = MakeUIPlugin.getActivePage();
            if (p != null) {
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)true);
                if (editorPart instanceof MakefileEditor) {
                    ((MakefileEditor)editorPart).setSelection(directive, true);
                }
                return editorPart;
            }
        } else {
            FileStorage storage = new FileStorage((IPath)path);
            ExternalEditorInput input = new ExternalEditorInput((IStorage)storage);
            IWorkbenchPage p = MakeUIPlugin.getActivePage();
            if (p != null) {
                String editorID = "org.eclipse.cdt.make.editor";
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IEditorInput)input, (String)editorID, (boolean)true);
                if (editorPart instanceof MakefileEditor) {
                    ((MakefileEditor)editorPart).setSelection(directive, true);
                }
                return editorPart;
            }
        }
        return null;
    }

    IInclude[] getIncludeDirective(ISelection sel) {
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() > 0) {
            ArrayList includes = new ArrayList(list.size());
            int i = 0;
            while (i < list.size()) {
                Object element = list.get(i);
                if (element instanceof IInclude) {
                    includes.add(element);
                }
                ++i;
            }
            return includes.toArray(new IInclude[includes.size()]);
        }
        return null;
    }

    public boolean canActionBeAdded(ISelection selection) {
        return this.getIncludeDirective(selection) != null;
    }
}

