/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.preferences.TabFolderLayout;
import org.eclipse.cdt.make.ui.dialogs.AbstractDiscoveryPage;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDiscoveryOptionsBlock
extends AbstractCOptionPage {
    protected static final String PREFIX = "ScannerConfigOptionsDialog";
    private static final String UNSAVEDCHANGES_TITLE = "ScannerConfigOptionsDialog.unsavedchanges.title";
    private static final String UNSAVEDCHANGES_MESSAGE = "ScannerConfigOptionsDialog.unsavedchanges.message";
    private static final String UNSAVEDCHANGES_BSAVE = "ScannerConfigOptionsDialog.unsavedchanges.button.save";
    private static final String UNSAVEDCHANGES_BCANCEL = "ScannerConfigOptionsDialog.unsavedchanges.button.cancel";
    private static final String ERROR_TITLE = "ScannerConfigOptionsDialog.error.title";
    private static final String ERROR_MESSAGE = "ScannerConfigOptionsDialog.error.message";
    private static final String PROFILE_PAGE = "profilePage";
    private static final String PROFILE_ID = "profileId";
    private Preferences fPrefs;
    private IScannerConfigBuilderInfo2 fBuildInfo;
    private boolean fInitialized = false;
    private String fPersistedProfileId = null;
    private Map fProfilePageMap = null;
    private Composite fCompositeParent;
    private AbstractDiscoveryPage fCurrentPage;

    public IProject getProject() {
        return this.getContainer().getProject();
    }

    public Preferences getPrefs() {
        return this.fPrefs;
    }

    public IScannerConfigBuilderInfo2 getBuildInfo() {
        return this.fBuildInfo;
    }

    public boolean isInitialized() {
        return this.fInitialized;
    }

    public void setInitialized(boolean initialized) {
        this.fInitialized = initialized;
    }

    public boolean checkDialogForChanges() {
        boolean rc = true;
        if (this.isProfileDifferentThenPersisted()) {
            String title = MakeUIPlugin.getResourceString(UNSAVEDCHANGES_TITLE);
            String message = MakeUIPlugin.getResourceString(UNSAVEDCHANGES_MESSAGE);
            String[] buttonLabels = new String[]{MakeUIPlugin.getResourceString(UNSAVEDCHANGES_BSAVE), MakeUIPlugin.getResourceString(UNSAVEDCHANGES_BCANCEL)};
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
            int res = dialog.open();
            if (res == 0) {
                this.callPerformApply();
                rc = true;
            } else if (res == 1) {
                rc = false;
            }
        }
        return rc;
    }

    public boolean isProfileDifferentThenPersisted() {
        return this.fPersistedProfileId != null && !this.fPersistedProfileId.equals(this.getBuildInfo().getSelectedProfileId());
    }

    public void updatePersistedProfile() {
        this.fPersistedProfileId = this.getBuildInfo().getSelectedProfileId();
    }

    public AbstractDiscoveryOptionsBlock(String title) {
        super(title);
        this.initializeProfilePageMap();
    }

    public AbstractDiscoveryOptionsBlock(String title, ImageDescriptor image) {
        super(title, image);
        this.initializeProfilePageMap();
    }

    private void initializeProfilePageMap() {
        this.fProfilePageMap = new HashMap(5);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(MakeUIPlugin.getPluginId(), "DiscoveryProfilePage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getName().equals(PROFILE_PAGE)) {
                String id = infos[i].getAttribute(PROFILE_ID);
                this.fProfilePageMap.put(id, new DiscoveryProfilePageConfiguration(infos[i]));
            }
            ++i;
        }
    }

    public void setContainer(ICOptionContainer container) {
        super.setContainer(container);
        this.fPrefs = this.getContainer().getPreferences();
        IProject project = this.getContainer().getProject();
        this.fInitialized = true;
        if (project != null) {
            try {
                this.fBuildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2((IProject)project);
            }
            catch (CoreException coreException) {
                this.fInitialized = false;
                this.fBuildInfo = null;
            }
        } else {
            this.fBuildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2((Preferences)this.fPrefs, (boolean)false);
        }
        if (this.fBuildInfo != null) {
            this.fPersistedProfileId = this.fBuildInfo.getSelectedProfileId();
        }
    }

    public void updateContainer() {
        this.getContainer().updateContainer();
    }

    protected void createBuildInfo() {
        if (this.getProject() != null) {
            try {
                this.fBuildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2((IProject)this.getProject());
            }
            catch (CoreException coreException) {
                this.fBuildInfo = null;
            }
        } else {
            this.fBuildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2((Preferences)this.fPrefs, (boolean)false);
        }
    }

    protected void createDefaultBuildInfo() {
        this.fBuildInfo = this.getProject() != null ? ScannerConfigProfileManager.createScannerConfigBuildInfo2((Preferences)this.fPrefs, (boolean)false) : ScannerConfigProfileManager.createScannerConfigBuildInfo2((Preferences)this.fPrefs, (boolean)true);
    }

    protected Composite getCompositeParent() {
        return this.fCompositeParent;
    }

    protected void setCompositeParent(Composite parent) {
        this.fCompositeParent = parent;
        this.fCompositeParent.setLayout((Layout)new TabFolderLayout());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.handleDiscoveryProfileChanged();
        }
    }

    protected void handleDiscoveryProfileChanged() {
        if (this.getCompositeParent() == null) {
            return;
        }
        String profileId = this.getCurrentProfileId();
        AbstractDiscoveryPage page = this.getDiscoveryProfilePage(profileId);
        if (page != null) {
            if (page.getControl() == null) {
                Composite parent = this.getCompositeParent();
                page.setContainer(this);
                page.createControl(parent);
                parent.layout(true);
            }
            if (this.fCurrentPage != null) {
                this.fCurrentPage.setVisible(false);
            }
            page.setVisible(true);
        }
        this.setCurrentPage(page);
    }

    protected AbstractDiscoveryPage getCurrentPage() {
        return this.fCurrentPage;
    }

    protected void setCurrentPage(AbstractDiscoveryPage page) {
        this.fCurrentPage = page;
    }

    public boolean isValid() {
        return this.getCurrentPage() == null ? true : this.getCurrentPage().isValid();
    }

    public String getErrorMessage() {
        return this.getCurrentPage().getErrorMessage();
    }

    protected AbstractDiscoveryPage getDiscoveryProfilePage(String profileId) {
        DiscoveryProfilePageConfiguration configElement = (DiscoveryProfilePageConfiguration)this.fProfilePageMap.get(profileId);
        if (configElement != null) {
            try {
                return configElement.getPage();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected String getDiscoveryProfileName(String profileId) {
        DiscoveryProfilePageConfiguration configElement = (DiscoveryProfilePageConfiguration)this.fProfilePageMap.get(profileId);
        if (configElement != null) {
            return configElement.getName();
        }
        return null;
    }

    protected String getDiscoveryProfileId(String profileName) {
        Iterator I = this.fProfilePageMap.keySet().iterator();
        while (I.hasNext()) {
            String profileId = (String)I.next();
            String confProfileName = this.getDiscoveryProfileName(profileId);
            if (!profileName.equals(confProfileName)) continue;
            return profileId;
        }
        return null;
    }

    protected List getDiscoveryProfileIdList() {
        return new ArrayList(this.fProfilePageMap.keySet());
    }

    protected abstract String getCurrentProfileId();

    public void callPerformApply() {
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AbstractDiscoveryOptionsBlock.this.performApply(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            String title = CPathEntryMessages.getString((String)ERROR_TITLE);
            String message = CPathEntryMessages.getString((String)ERROR_MESSAGE);
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected static class DiscoveryProfilePageConfiguration {
        AbstractDiscoveryPage page;
        IConfigurationElement fElement;

        public DiscoveryProfilePageConfiguration(IConfigurationElement element) {
            this.fElement = element;
        }

        public AbstractDiscoveryPage getPage() throws CoreException {
            if (this.page == null) {
                this.page = (AbstractDiscoveryPage)((Object)this.fElement.createExecutableExtension("class"));
            }
            return this.page;
        }

        public String getName() {
            return this.fElement.getAttribute("name");
        }
    }
}

