/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class SettingsBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "SettingsBlock";
    private static final String MAKE_LABEL = "SettingsBlock.label";
    private static final String MAKE_MESSAGE = "SettingsBlock.message";
    private static final String MAKE_SETTING_GROUP = "SettingsBlock.makeSetting.group_label";
    private static final String MAKE_SETTING_STOP_ERROR = "SettingsBlock.makeSetting.stopOnError";
    private static final String MAKE_CMD_GROUP = "SettingsBlock.makeCmd.group_label";
    private static final String MAKE_CMD_USE_DEFAULT = "SettingsBlock.makeCmd.use_default";
    private static final String MAKE_CMD_LABEL = "SettingsBlock.makeCmd.label";
    private static final String MAKE_WORKBENCH_BUILD_GROUP = "SettingsBlock.makeWorkbench.group_label";
    private static final String MAKE_WORKBENCH_BUILD_TYPE = "SettingsBlock.makeWorkbench.type";
    private static final String MAKE_WORKBENCH_BUILD_TARGET = "SettingsBlock.makeWorkbench.target";
    private static final String MAKE_WORKBENCH_BUILD_AUTO = "SettingsBlock.makeWorkbench.auto";
    private static final String MAKE_WORKBENCH_BUILD_INCR = "SettingsBlock.makeWorkbench.incremental";
    private static final String MAKE_WORKBENCH_BUILD_FULL = "SettingsBlock.makeWorkbench.full";
    private static final String MAKE_WORKBENCH_BUILD_CLEAN = "SettingsBlock.makeWorkbench.clean";
    private static final String MAKE_BUILD_DIR_GROUP = "SettingsBlock.makeDir.group_label";
    private static final String MAKE_BUILD_DIR_LABEL = "SettingsBlock.makeDir.label";
    private static final String MAKE_BUILD_DIR_BROWSE = "SettingsBlock.makeDir.browse";
    private static final String MAKE_BUILD_AUTO_TARGET = "SettingsBlock.makeWorkbench.autoBuildTarget";
    private static final String MAKE_BUILD_INCREMENTAL_TARGET = "SettingsBlock.makeWorkbench.incrementalBuildTarget";
    private static final String MAKE_BUILD_FULL_TARGET = "SettingsBlock.makeWorkbench.fullBuildTarget";
    private static final String MAKE_BUILD_CLEAN_TARGET = "SettingsBlock.makeWorkbench.cleanTarget";
    Button stopOnErrorButton;
    Button defButton;
    Text buildCommand;
    Button argumentVariablesButton;
    Text buildLocation;
    Button locationVariablesButton;
    Text targetIncr;
    Text targetAuto;
    Text targetClean;
    Button incrButton;
    Button autoButton;
    Button cleanButton;
    Button incrVariableButton;
    Button autoVariableButton;
    Button cleanVariableButton;
    IMakeBuilderInfo fBuildInfo;
    Preferences fPrefs;
    String fBuilderID;

    public SettingsBlock(Preferences prefs, String builderID) {
        super(MakeUIPlugin.getResourceString(MAKE_LABEL));
        this.setDescription(MakeUIPlugin.getResourceString(MAKE_MESSAGE));
        this.fPrefs = prefs;
        this.fBuilderID = builderID;
    }

    protected void createSettingControls(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_SETTING_GROUP), (int)1);
        this.stopOnErrorButton = new Button((Composite)group, 32);
        this.stopOnErrorButton.setText(MakeUIPlugin.getResourceString(MAKE_SETTING_STOP_ERROR));
        if (this.fBuildInfo.isStopOnError()) {
            this.stopOnErrorButton.setSelection(true);
        }
        this.stopOnErrorButton.setEnabled(this.fBuildInfo.isDefaultBuildCmd());
    }

    protected void createBuildCmdControls(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_CMD_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.defButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_USE_DEFAULT));
        this.defButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SettingsBlock.this.defButton.getSelection()) {
                    SettingsBlock.this.buildCommand.setEnabled(false);
                    SettingsBlock.this.argumentVariablesButton.setEnabled(false);
                    SettingsBlock.this.stopOnErrorButton.setEnabled(true);
                    SettingsBlock.this.getContainer().updateContainer();
                } else {
                    SettingsBlock.this.buildCommand.setEnabled(true);
                    SettingsBlock.this.argumentVariablesButton.setEnabled(true);
                    SettingsBlock.this.stopOnErrorButton.setEnabled(false);
                    SettingsBlock.this.getContainer().updateContainer();
                }
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.defButton.setLayoutData((Object)gd);
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_CMD_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.buildCommand = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.buildCommand.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.buildCommand.getLayoutData()).grabExcessHorizontalSpace = true;
        this.buildCommand.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                SettingsBlock.this.getContainer().updateContainer();
            }
        });
        if (this.fBuildInfo.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, null) != null) {
            String args;
            StringBuffer cmd = new StringBuffer(this.fBuildInfo.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, ""));
            if (!this.fBuildInfo.isDefaultBuildCmd() && (args = this.fBuildInfo.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, "")) != null && !args.equals("")) {
                cmd.append(" ");
                cmd.append(args);
            }
            this.buildCommand.setText(cmd.toString());
        }
        this.argumentVariablesButton = this.addVariablesButton((Composite)group, this.buildCommand);
        if (this.fBuildInfo.isDefaultBuildCmd()) {
            this.buildCommand.setEnabled(false);
            this.argumentVariablesButton.setEnabled(false);
        }
        this.defButton.setSelection(this.fBuildInfo.isDefaultBuildCmd());
    }

    protected void createWorkBenchBuildControls(Composite parent) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SettingsBlock.this.targetAuto.setEnabled(SettingsBlock.this.autoButton.getSelection());
                SettingsBlock.this.autoVariableButton.setEnabled(SettingsBlock.this.autoButton.getSelection());
                SettingsBlock.this.targetIncr.setEnabled(SettingsBlock.this.incrButton.getSelection());
                SettingsBlock.this.incrVariableButton.setEnabled(SettingsBlock.this.incrButton.getSelection());
                SettingsBlock.this.targetClean.setEnabled(SettingsBlock.this.cleanButton.getSelection());
                SettingsBlock.this.cleanVariableButton.setEnabled(SettingsBlock.this.cleanButton.getSelection());
                SettingsBlock.this.getContainer().updateContainer();
            }
        };
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_TYPE));
        label = new Label((Composite)group, 0);
        label.setText(MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_TARGET));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.autoButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_AUTO));
        this.autoButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.autoButton.setSelection(this.fBuildInfo.isAutoBuildEnable());
        this.targetAuto = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetAuto.setText(this.fBuildInfo.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_AUTO, ""));
        ((GridData)this.targetAuto.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetAuto.getLayoutData()).grabExcessHorizontalSpace = true;
        this.addControlAccessibleListener((Control)this.targetAuto, MakeUIPlugin.getResourceString(MAKE_BUILD_AUTO_TARGET));
        this.autoVariableButton = this.addVariablesButton((Composite)group, this.targetAuto);
        String noteTitle = MakeUIPlugin.getResourceString("SettingsBlock.makeWorkbench.note");
        String noteMessage = MakeUIPlugin.getResourceString("SettingsBlock.makeWorkbench.autobuildMessage");
        Composite noteControl = this.createNoteComposite(JFaceResources.getDialogFont(), (Composite)group, noteTitle, noteMessage);
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        noteControl.setLayoutData((Object)gd);
        this.incrButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_INCR));
        this.incrButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.incrButton.setSelection(this.fBuildInfo.isIncrementalBuildEnabled());
        this.targetIncr = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetIncr.setText(this.fBuildInfo.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_INCREMENTAL, ""));
        ((GridData)this.targetIncr.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetIncr.getLayoutData()).grabExcessHorizontalSpace = true;
        this.addControlAccessibleListener((Control)this.targetIncr, MakeUIPlugin.getResourceString(MAKE_BUILD_INCREMENTAL_TARGET));
        this.incrVariableButton = this.addVariablesButton((Composite)group, this.targetIncr);
        this.cleanButton = ControlFactory.createCheckBox((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_WORKBENCH_BUILD_CLEAN));
        this.cleanButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.cleanButton.setSelection(this.fBuildInfo.isCleanBuildEnabled());
        this.targetClean = ControlFactory.createTextField((Composite)group, (int)2052);
        this.targetClean.setText(this.fBuildInfo.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_CLEAN, ""));
        ((GridData)this.targetClean.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.targetClean.getLayoutData()).grabExcessHorizontalSpace = true;
        this.addControlAccessibleListener((Control)this.targetClean, MakeUIPlugin.getResourceString(MAKE_BUILD_CLEAN_TARGET));
        this.cleanVariableButton = this.addVariablesButton((Composite)group, this.targetClean);
        selectionAdapter.widgetSelected(null);
    }

    private Button addVariablesButton(Composite parent, final Text control) {
        String variablesTitle = MakeUIPlugin.getResourceString("SettingsBlock.variables");
        Button variablesButton = this.createPushButton(parent, variablesTitle, null);
        GridData gd = new GridData(128);
        variablesButton.setLayoutData((Object)gd);
        variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SettingsBlock.this.handleVariablesButtonSelected(control);
            }
        });
        return variablesButton;
    }

    protected Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        Composite messageComposite = new Composite(composite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageComposite.setLayout((Layout)messageLayout);
        messageComposite.setLayoutData((Object)new GridData(256));
        messageComposite.setFont(font);
        final Label noteLabel = new Label(messageComposite, 1);
        noteLabel.setText(title);
        noteLabel.setFont(JFaceResources.getBannerFont());
        noteLabel.setLayoutData((Object)new GridData(2));
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jface.bannerfont".equals(event.getProperty())) {
                    noteLabel.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(fontListener);
        noteLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                JFaceResources.getFontRegistry().removeListener(fontListener);
            }
        });
        Label messageLabel = new Label(messageComposite, 64);
        messageLabel.setText(message);
        messageLabel.setFont(font);
        return messageComposite;
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(controlName));
    }

    protected void createBuilderWorkingDirControls(Composite parent) {
        Group group = ControlFactory.createGroup((Composite)parent, (String)MakeUIPlugin.getResourceString(MAKE_BUILD_DIR_GROUP), (int)1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        Label label = ControlFactory.createLabel((Composite)group, (String)MakeUIPlugin.getResourceString(MAKE_BUILD_DIR_LABEL));
        ((GridData)label.getLayoutData()).horizontalAlignment = 1;
        ((GridData)label.getLayoutData()).grabExcessHorizontalSpace = false;
        this.buildLocation = ControlFactory.createTextField((Composite)group, (int)2052);
        ((GridData)this.buildLocation.getLayoutData()).horizontalAlignment = 4;
        ((GridData)this.buildLocation.getLayoutData()).grabExcessHorizontalSpace = true;
        this.buildLocation.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                SettingsBlock.this.getContainer().updateContainer();
            }
        });
        Button browse = new Button((Composite)group, 0);
        browse.setText(MakeUIPlugin.getResourceString(MAKE_BUILD_DIR_BROWSE));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(SettingsBlock.this.getShell(), (IContainer)SettingsBlock.this.getContainer().getProject(), true, MakeUIPlugin.getResourceString("SettingsBlock.title.selectLocationToBuildFrom"));
                if (dialog.open() == 0 && (selection = dialog.getResult()).length > 0) {
                    SettingsBlock.this.buildLocation.setText(((IPath)selection[0]).toOSString());
                }
            }
        });
        this.buildLocation.setText(this.fBuildInfo.getBuildAttribute(IMakeCommonBuildInfo.BUILD_LOCATION, ""));
        this.locationVariablesButton = this.addVariablesButton((Composite)group, this.buildLocation);
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.append(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    public void createControl(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)1);
        this.setControl((Control)composite);
        MakeUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), IMakeHelpContextIds.MAKE_BUILDER_SETTINGS);
        if (this.fBuildInfo == null) {
            ControlFactory.createEmptySpace((Composite)composite);
            ControlFactory.createLabel((Composite)composite, (String)MakeUIPlugin.getResourceString("SettingsBlock.label.missingBuilderInformation"));
            return;
        }
        this.createBuildCmdControls(composite);
        this.createSettingControls(composite);
        this.createWorkBenchBuildControls(composite);
        if (this.getContainer().getProject() != null) {
            this.createBuilderWorkingDirControls(composite);
        }
    }

    public boolean isValid() {
        String cmd;
        return this.defButton == null || this.defButton.getSelection() || (cmd = this.getBuildLine()) != null && cmd.length() != 0;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (this.fBuildInfo == null) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IWorkspace workspace = MakeUIPlugin.getWorkspace();
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(MakeUIPlugin.getResourceString("SettingsBlock.monitor.applyingSettings"), 1);
                IMakeBuilderInfo info = null;
                if (SettingsBlock.this.getContainer().getProject() != null) {
                    try {
                        info = MakeCorePlugin.createBuildInfo((IProject)SettingsBlock.this.getContainer().getProject(), (String)SettingsBlock.this.fBuilderID);
                    }
                    catch (CoreException e) {
                        MakeCorePlugin.log((Throwable)e);
                        return;
                    }
                } else {
                    info = MakeCorePlugin.createBuildInfo((Preferences)SettingsBlock.this.fPrefs, (String)SettingsBlock.this.fBuilderID, (boolean)false);
                }
                info.setStopOnError(SettingsBlock.this.isStopOnError());
                info.setUseDefaultBuildCmd(SettingsBlock.this.useDefaultBuildCmd());
                if (!SettingsBlock.this.useDefaultBuildCmd()) {
                    String bldLine = SettingsBlock.this.getBuildLine();
                    int start = 0;
                    int end = -1;
                    if (!bldLine.startsWith("\"")) {
                        end = bldLine.indexOf(32);
                    } else {
                        start = 1;
                        end = bldLine.indexOf(34, 1);
                    }
                    String path = end == -1 ? bldLine : bldLine.substring(start, end);
                    info.setBuildAttribute(IMakeBuilderInfo.BUILD_COMMAND, path);
                    String args = "";
                    if (end != -1) {
                        args = bldLine.substring(end + 1);
                    }
                    info.setBuildAttribute(IMakeBuilderInfo.BUILD_ARGUMENTS, args);
                }
                info.setAutoBuildEnable(SettingsBlock.this.autoButton.getSelection());
                info.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_AUTO, SettingsBlock.this.targetAuto.getText().trim());
                info.setIncrementalBuildEnable(SettingsBlock.this.incrButton.getSelection());
                info.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_INCREMENTAL, SettingsBlock.this.targetIncr.getText().trim());
                info.setFullBuildEnable(SettingsBlock.this.incrButton.getSelection());
                info.setCleanBuildEnable(SettingsBlock.this.cleanButton.getSelection());
                info.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_CLEAN, SettingsBlock.this.targetClean.getText().trim());
                if (SettingsBlock.this.buildLocation != null) {
                    info.setBuildAttribute(IMakeBuilderInfo.BUILD_LOCATION, SettingsBlock.this.buildLocation.getText().trim());
                }
            }
        };
        if (this.getContainer().getProject() != null) {
            workspace.run(operation, monitor);
        } else {
            operation.run(monitor);
        }
    }

    public void performDefaults() {
        if (this.fBuildInfo == null) {
            return;
        }
        IMakeBuilderInfo info = this.getContainer().getProject() != null ? MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)false) : MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)true);
        if (info.isStopOnError()) {
            this.stopOnErrorButton.setSelection(true);
        } else {
            this.stopOnErrorButton.setSelection(false);
        }
        if (info.getBuildCommand() != null) {
            String args;
            StringBuffer cmd = new StringBuffer(info.getBuildCommand().toOSString());
            if (!info.isDefaultBuildCmd() && (args = info.getBuildArguments()) != null && !args.equals("")) {
                cmd.append(" ");
                cmd.append(args);
            }
            this.buildCommand.setText(cmd.toString());
        }
        if (info.isDefaultBuildCmd()) {
            this.buildCommand.setEnabled(false);
            this.argumentVariablesButton.setEnabled(false);
            this.stopOnErrorButton.setEnabled(true);
        } else {
            this.buildCommand.setEnabled(true);
            this.argumentVariablesButton.setEnabled(true);
            this.stopOnErrorButton.setEnabled(false);
        }
        this.defButton.setSelection(info.isDefaultBuildCmd());
        this.autoButton.setSelection(info.isAutoBuildEnable());
        this.autoVariableButton.setEnabled(info.isAutoBuildEnable());
        this.targetAuto.setEnabled(info.isAutoBuildEnable());
        this.targetAuto.setText(info.getAutoBuildTarget());
        this.incrButton.setSelection(info.isIncrementalBuildEnabled());
        this.incrVariableButton.setEnabled(info.isIncrementalBuildEnabled());
        this.targetIncr.setText(info.getIncrementalBuildTarget());
        this.targetIncr.setEnabled(info.isIncrementalBuildEnabled());
        this.cleanButton.setSelection(info.isCleanBuildEnabled());
        this.cleanVariableButton.setEnabled(info.isCleanBuildEnabled());
        this.targetClean.setText(info.getCleanBuildTarget());
        this.targetClean.setEnabled(info.isCleanBuildEnabled());
    }

    boolean isStopOnError() {
        return this.stopOnErrorButton.getSelection();
    }

    boolean useDefaultBuildCmd() {
        return this.defButton.getSelection();
    }

    String getBuildLine() {
        String cmd;
        if (this.buildCommand != null && (cmd = this.buildCommand.getText()) != null) {
            return cmd.trim();
        }
        return null;
    }

    public void setContainer(ICOptionContainer container) {
        super.setContainer(container);
        if (this.getContainer().getProject() != null) {
            try {
                this.fBuildInfo = MakeCorePlugin.createBuildInfo((IProject)this.getContainer().getProject(), (String)this.fBuilderID);
            }
            catch (CoreException coreException) {}
        } else {
            this.fBuildInfo = MakeCorePlugin.createBuildInfo((Preferences)this.fPrefs, (String)this.fBuilderID, (boolean)false);
        }
    }

    public String getErrorMessage() {
        String cmd;
        if (!(this.useDefaultBuildCmd() || (cmd = this.getBuildLine()) != null && cmd.length() != 0)) {
            return MakeUIPlugin.getResourceString("SettingsBlock.message.mustEnterBuildCommand");
        }
        return null;
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }
}

