/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IConvertManagedBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElementProvider;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentBuildPathsChangeListener;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.OutputType;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class ManagedBuildManager
extends AbstractCExtension
implements IScannerInfoProvider {
    private static final QualifiedName buildInfoProperty = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "managedBuildInfo");
    private static final String ROOT_NODE_NAME = "ManagedProjectBuildInfo";
    public static final String SETTINGS_FILE_NAME = ".cdtbuild";
    private static final ITarget[] emptyTargets = new ITarget[0];
    public static final String INTERFACE_IDENTITY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildManager";
    public static final String EXTENSION_POINT_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".buildDefinitions";
    public static final String EXTENSION_POINT_ID_V2 = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildInfo";
    private static final String REVISION_ELEMENT_NAME = "managedBuildRevision";
    private static final String VERSION_ELEMENT_NAME = "fileVersion";
    private static final String MANIFEST_VERSION_ERROR = "ManagedBuildManager.error.manifest.version.error";
    private static final String PROJECT_VERSION_ERROR = "ManagedBuildManager.error.project.version.error";
    private static final String PROJECT_FILE_ERROR = "ManagedBuildManager.error.project.file.missing";
    private static final String MANIFEST_ERROR_HEADER = "ManagedBuildManager.error.manifest.header";
    public static final String MANIFEST_ERROR_RESOLVING = "ManagedBuildManager.error.manifest.resolving";
    public static final String MANIFEST_ERROR_DUPLICATE = "ManagedBuildManager.error.manifest.duplicate";
    public static final String MANIFEST_ERROR_ICON = "ManagedBuildManager.error.manifest.icon";
    private static final String MANIFEST_ERROR_OPTION_CATEGORY = "ManagedBuildManager.error.manifest.option.category";
    private static final String MANIFEST_ERROR_OPTION_FILTER = "ManagedBuildManager.error.manifest.option.filter";
    private static final String MANIFEST_ERROR_OPTION_VALUEHANDLER = "ManagedBuildManager.error.manifest.option.valuehandler";
    private static final String MANIFEST_ERROR_READ_ONLY = "ManagedBuildManager.error.read_only";
    private static final String MANIFEST_ERROR_WRITE_FAILED = "ManagedBuildManager.error.write_failed";
    public static final int ERROR_CATEGORY = 0;
    public static final int ERROR_FILTER = 1;
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final PluginVersionIdentifier buildInfoVersion = new PluginVersionIdentifier(3, 0, 0);
    private static Map depCalculatorsMap;
    private static boolean projectTypesLoaded;
    private static boolean projectTypesLoading;
    public static SortedMap projectTypeMap;
    private static List projectTypes;
    private static Map extensionConfigurationMap;
    private static Map extensionResourceConfigurationMap;
    private static SortedMap extensionToolChainMap;
    private static SortedMap extensionToolMap;
    private static Map extensionTargetPlatformMap;
    private static SortedMap extensionBuilderMap;
    private static Map extensionOptionMap;
    private static Map extensionOptionCategoryMap;
    private static Map extensionInputTypeMap;
    private static Map extensionOutputTypeMap;
    private static Map extensionTargetMap;
    private static Map configElementMap;
    private static Map buildModelListeners;
    private static Random randomNumber;
    private static IEnvironmentBuildPathsChangeListener fEnvironmentBuildPathsChangeListener;

    static {
        projectTypesLoaded = false;
        projectTypesLoading = false;
        fEnvironmentBuildPathsChangeListener = new IEnvironmentBuildPathsChangeListener(){

            public void buildPathsChanged(IConfiguration configuration, int buildPathType) {
                if (buildPathType == 1) {
                    ManagedBuildManager.initializePathEntries(configuration, null);
                    ManagedBuildManager.notifyListeners(configuration, null);
                }
            }
        };
        ManagedBuildManager.getEnvironmentVariableProvider().subscribe(fEnvironmentBuildPathsChangeListener);
    }

    public static int getRandomNumber() {
        int i;
        if (randomNumber == null) {
            randomNumber = new Random();
            randomNumber.setSeed(System.currentTimeMillis());
        }
        if ((i = randomNumber.nextInt()) < 0) {
            i *= -1;
        }
        return i;
    }

    public static IProjectType[] getDefinedProjectTypes() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        List definedTypes = null;
        int size = projectTypes != null ? projectTypes.size() + (definedTypes != null ? definedTypes.size() : 0) : 0;
        IProjectType[] types = new IProjectType[size];
        int n = 0;
        int i = 0;
        while (i < projectTypes.size()) {
            types[n++] = (IProjectType)projectTypes.get(i);
            ++i;
        }
        if (definedTypes != null) {
            i = 0;
            while (i < definedTypes.size()) {
                types[n++] = (IProjectType)definedTypes.get(i);
                ++i;
            }
        }
        return types;
    }

    public static IProjectType getProjectType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IProjectType)ManagedBuildManager.getExtensionProjectTypeMap().get(id);
    }

    protected static Map getExtensionDepCalcMap() {
        if (depCalculatorsMap == null) {
            depCalculatorsMap = new HashMap();
        }
        return depCalculatorsMap;
    }

    public static SortedMap getExtensionProjectTypeMap() {
        if (projectTypeMap == null) {
            projectTypeMap = new TreeMap();
        }
        return projectTypeMap;
    }

    protected static Map getExtensionConfigurationMap() {
        if (extensionConfigurationMap == null) {
            extensionConfigurationMap = new HashMap();
        }
        return extensionConfigurationMap;
    }

    protected static Map getExtensionResourceConfigurationMap() {
        if (extensionResourceConfigurationMap == null) {
            extensionResourceConfigurationMap = new HashMap();
        }
        return extensionResourceConfigurationMap;
    }

    public static SortedMap getExtensionToolChainMap() {
        if (extensionToolChainMap == null) {
            extensionToolChainMap = new TreeMap();
        }
        return extensionToolChainMap;
    }

    public static SortedMap getExtensionToolMap() {
        if (extensionToolMap == null) {
            extensionToolMap = new TreeMap();
        }
        return extensionToolMap;
    }

    protected static Map getExtensionTargetPlatformMap() {
        if (extensionTargetPlatformMap == null) {
            extensionTargetPlatformMap = new HashMap();
        }
        return extensionTargetPlatformMap;
    }

    public static SortedMap getExtensionBuilderMap() {
        if (extensionBuilderMap == null) {
            extensionBuilderMap = new TreeMap();
        }
        return extensionBuilderMap;
    }

    protected static Map getExtensionOptionMap() {
        if (extensionOptionMap == null) {
            extensionOptionMap = new HashMap();
        }
        return extensionOptionMap;
    }

    protected static Map getExtensionOptionCategoryMap() {
        if (extensionOptionCategoryMap == null) {
            extensionOptionCategoryMap = new HashMap();
        }
        return extensionOptionCategoryMap;
    }

    protected static Map getExtensionInputTypeMap() {
        if (extensionInputTypeMap == null) {
            extensionInputTypeMap = new HashMap();
        }
        return extensionInputTypeMap;
    }

    protected static Map getExtensionOutputTypeMap() {
        if (extensionOutputTypeMap == null) {
            extensionOutputTypeMap = new HashMap();
        }
        return extensionOutputTypeMap;
    }

    protected static Map getExtensionTargetMap() {
        if (extensionTargetMap == null) {
            extensionTargetMap = new HashMap();
        }
        return extensionTargetMap;
    }

    public static ITarget[] getTargets(IResource resource) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(resource);
        if (buildInfo != null) {
            List targets = buildInfo.getTargets();
            return targets.toArray(new ITarget[targets.size()]);
        }
        return emptyTargets;
    }

    public static IProjectType getExtensionProjectType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IProjectType)ManagedBuildManager.getExtensionProjectTypeMap().get(id);
    }

    public static IConfiguration getExtensionConfiguration(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IConfiguration)ManagedBuildManager.getExtensionConfigurationMap().get(id);
    }

    public static IResourceConfiguration getExtensionResourceConfiguration(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IResourceConfiguration)ManagedBuildManager.getExtensionResourceConfigurationMap().get(id);
    }

    public static IToolChain getExtensionToolChain(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IToolChain)ManagedBuildManager.getExtensionToolChainMap().get(id);
    }

    public static ITool getExtensionTool(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (ITool)ManagedBuildManager.getExtensionToolMap().get(id);
    }

    public static ITargetPlatform getExtensionTargetPlatform(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (ITargetPlatform)ManagedBuildManager.getExtensionTargetPlatformMap().get(id);
    }

    public static IBuilder getExtensionBuilder(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IBuilder)ManagedBuildManager.getExtensionBuilderMap().get(id);
    }

    public static IOption getExtensionOption(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IOption)ManagedBuildManager.getExtensionOptionMap().get(id);
    }

    public static IInputType getExtensionInputType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IInputType)ManagedBuildManager.getExtensionInputTypeMap().get(id);
    }

    public static IOutputType getExtensionOutputType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IOutputType)ManagedBuildManager.getExtensionOutputTypeMap().get(id);
    }

    public static ITarget getExtensionTarget(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (ITarget)ManagedBuildManager.getExtensionTargetMap().get(id);
    }

    public static ITarget getTarget(IResource resource, String id) {
        IManagedBuildInfo buildInfo;
        ITarget target = null;
        if (resource != null && (buildInfo = ManagedBuildManager.getBuildInfo(resource)) != null) {
            target = buildInfo.getTarget(id);
        }
        if (target == null) {
            target = (ITarget)ManagedBuildManager.getExtensionTargetMap().get(id);
        }
        return target;
    }

    public static void setDefaultConfiguration(IProject project, IConfiguration newDefault) {
        if (project == null || newDefault == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setDefaultConfiguration(newDefault);
        }
    }

    public static void setSelectedConfiguration(IProject project, IConfiguration config) {
        if (project == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setSelectedConfiguration(config);
        }
    }

    public static IManagedBuilderMakefileGenerator getBuildfileGenerator(IConfiguration config) {
        IBuilder builder;
        IToolChain toolChain = config.getToolChain();
        if (toolChain != null && (builder = toolChain.getBuilder()) != null) {
            return builder.getBuildFileGenerator();
        }
        return new GnuMakefileGenerator();
    }

    public static IManagedCommandLineGenerator getCommandLineGenerator(IConfiguration config, String toolId) {
        ITool tool = config.getTool(toolId);
        if (tool != null) {
            return tool.getCommandLineGenerator();
        }
        return ManagedCommandLineGenerator.getCommandLineGenerator();
    }

    public static String getScannerInfoProfileId(IConfiguration config) {
        IToolChain toolChain = config.getToolChain();
        return toolChain.getScannerConfigDiscoveryProfileId();
    }

    public static IConfiguration getSelectedConfiguration(IProject project) {
        if (project == null) {
            return null;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            return info.getSelectedConfiguration();
        }
        return null;
    }

    private static void notifyListeners(IConfiguration config, IOption option) {
        try {
            if (config.isTemporary() || option != null && option.getValueType() != 4 && option.getValueType() != 5) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        IResource resource = config.getOwner();
        List listeners = (List)ManagedBuildManager.getBuildModelListeners().get(resource);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification(resource, (IScannerInfo)ManagedBuildManager.getBuildInfo(resource));
        }
    }

    public static void initializePathEntries(IConfiguration config, IOption option) {
        IManagedBuildInfo info;
        try {
            if (config.isTemporary() || option != null && option.getValueType() != 4 && option.getValueType() != 5 && option.getValueType() != 6) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        IResource rc = config.getOwner();
        if (rc != null && (info = ManagedBuildManager.getBuildInfo(rc)) instanceof ManagedBuildInfo && config.equals(info.getDefaultConfiguration())) {
            ((ManagedBuildInfo)info).initializePathEntries();
        }
    }

    public static void initializePathEntries(IResourceConfiguration resConfig, IOption option) {
        IConfiguration cfg = resConfig.getParent();
        if (cfg != null) {
            ManagedBuildManager.initializePathEntries(cfg, option);
        }
    }

    private static void notifyListeners(IResourceConfiguration resConfig, IOption option) {
        try {
            if (resConfig.getParent().isTemporary() || option != null && option.getValueType() != 4 && option.getValueType() != 5) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        IResource resource = resConfig.getOwner();
        List listeners = (List)ManagedBuildManager.getBuildModelListeners().get(resource);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification(resource, (IScannerInfo)ManagedBuildManager.getBuildInfo(resource));
        }
    }

    public static void setNewProjectVersion(IProject newProject) {
        ManagedBuildInfo info = ManagedBuildManager.findBuildInfo((IResource)newProject, true);
        info.setVersion(buildInfoVersion.toString());
    }

    public static IOption setOption(IConfiguration config, IHoldsOptions holder, IOption option, boolean value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(config, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.initializePathEntries(config, retOpt);
            ManagedBuildManager.notifyListeners(config, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceConfiguration resConfig, IHoldsOptions holder, IOption option, boolean value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.initializePathEntries(resConfig, retOpt);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IConfiguration config, IHoldsOptions holder, IOption option, String value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(config, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.initializePathEntries(config, retOpt);
            ManagedBuildManager.notifyListeners(config, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceConfiguration resConfig, IHoldsOptions holder, IOption option, String value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.initializePathEntries(resConfig, retOpt);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IConfiguration config, IHoldsOptions holder, IOption option, String[] value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(config, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.initializePathEntries(config, retOpt);
            ManagedBuildManager.notifyListeners(config, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceConfiguration resConfig, IHoldsOptions holder, IOption option, String[] value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.initializePathEntries(resConfig, retOpt);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static void setToolCommand(IConfiguration config, ITool tool, String command) {
        if (tool instanceof IToolReference) {
            ((IToolReference)tool).setToolCommand(command);
        } else {
            config.setToolCommand(tool, command);
        }
    }

    public static void setToolCommand(IResourceConfiguration resConfig, ITool tool, String command) {
        if (tool instanceof IToolReference) {
            ((IToolReference)tool).setToolCommand(command);
        } else {
            resConfig.setToolCommand(tool, command);
        }
    }

    public static boolean saveBuildInfo(IProject project, boolean force) {
        Throwable err = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            ManagedBuildInfo buildInfo = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo != null && !buildInfo.isReadOnly() && buildInfo.isValid() && (force || buildInfo.isDirty())) {
                String projectVersion = buildInfo.getVersion();
                if (projectVersion != null) {
                    ProcessingInstruction instruction = doc.createProcessingInstruction(VERSION_ELEMENT_NAME, projectVersion);
                    doc.appendChild(instruction);
                }
                Element rootElement = doc.createElement(ROOT_NODE_NAME);
                doc.appendChild(rootElement);
                buildInfo.serialize(doc, rootElement);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(stream);
                transformer.transform(source, result);
                IFile projectFile = project.getFile(SETTINGS_FILE_NAME);
                String utfString = stream.toString("UTF-8");
                if (projectFile.exists()) {
                    if (projectFile.isReadOnly()) {
                        IStatus status;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null) {
                            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                            window = windows[0];
                        }
                        Shell shell = null;
                        if (window != null) {
                            shell = window.getShell();
                        }
                        if (!(status = projectFile.getWorkspace().validateEdit(new IFile[]{projectFile}, (Object)shell)).isOK() && status.getCode() == 279) {
                            stream.close();
                            throw new IOException(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_READ_ONLY, projectFile.getFullPath().toString()));
                        }
                    }
                    projectFile.setContents((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    projectFile.create((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                }
                stream.close();
            }
        }
        catch (ParserConfigurationException e) {
            err = e;
        }
        catch (FactoryConfigurationError e) {
            err = e.getException();
        }
        catch (TransformerConfigurationException e) {
            err = e;
        }
        catch (TransformerFactoryConfigurationError e) {
            err = e.getException();
        }
        catch (TransformerException e) {
            err = e;
        }
        catch (IOException e) {
            err = e;
        }
        catch (CoreException e) {
            err = e;
        }
        if (err != null) {
            Shell shell;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                window = windows[0];
            }
            if ((shell = window.getShell()) != null) {
                final String exceptionMsg = err.getMessage();
                shell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)shell, (String)ManagedMakeMessages.getResourceString("ManagedBuildManager.error.write_failed_title"), (String)ManagedMakeMessages.getFormattedString(ManagedBuildManager.MANIFEST_ERROR_WRITE_FAILED, exceptionMsg));
                    }
                });
            }
        }
        return true;
    }

    public static void removeBuildInfo(IResource resource) {
        ManagedBuildInfo info = ManagedBuildManager.findBuildInfo(resource, false);
        if (info != null) {
            IConfiguration[] configs = info.getManagedProject().getConfigurations();
            int i = 0;
            while (i < configs.length) {
                ManagedBuildManager.performValueHandlerEvent(configs[i], 2);
                ++i;
            }
            info.setValid(false);
            try {
                resource.setSessionProperty(buildInfoProperty, null);
            }
            catch (CoreException coreException) {}
        }
    }

    public static void resetConfiguration(IProject project, IConfiguration configuration) {
        ((Configuration)configuration).reset();
        ManagedBuildManager.performValueHandlerEvent(configuration, 3, false);
    }

    public static void resetResourceConfiguration(IProject project, IResourceConfiguration resConfig) {
        ((ResourceConfiguration)resConfig).reset();
        ManagedBuildManager.performValueHandlerEvent(resConfig, 3);
    }

    public static void addExtensionProjectType(ProjectType projectType) {
        if (projectTypes == null) {
            projectTypes = new ArrayList();
        }
        projectTypes.add(projectType);
        ProjectType previous = ManagedBuildManager.getExtensionProjectTypeMap().put(projectType.getId(), projectType);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("ProjectType", projectType.getId());
        }
    }

    public static void addExtensionConfiguration(Configuration configuration) {
        Configuration previous = ManagedBuildManager.getExtensionConfigurationMap().put(configuration.getId(), configuration);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Configuration", configuration.getId());
        }
    }

    public static void addExtensionResourceConfiguration(ResourceConfiguration resourceConfiguration) {
        ResourceConfiguration previous = ManagedBuildManager.getExtensionResourceConfigurationMap().put(resourceConfiguration.getId(), resourceConfiguration);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("ResourceConfiguration", resourceConfiguration.getId());
        }
    }

    public static void addExtensionToolChain(ToolChain toolChain) {
        ToolChain previous = ManagedBuildManager.getExtensionToolChainMap().put(toolChain.getId(), toolChain);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("ToolChain", toolChain.getId());
        }
    }

    public static void addExtensionTool(Tool tool) {
        Tool previous = ManagedBuildManager.getExtensionToolMap().put(tool.getId(), tool);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Tool", tool.getId());
        }
    }

    public static void addExtensionTargetPlatform(TargetPlatform targetPlatform) {
        TargetPlatform previous = ManagedBuildManager.getExtensionTargetPlatformMap().put(targetPlatform.getId(), targetPlatform);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("TargetPlatform", targetPlatform.getId());
        }
    }

    public static void addExtensionBuilder(Builder builder) {
        Builder previous = ManagedBuildManager.getExtensionBuilderMap().put(builder.getId(), builder);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Builder", builder.getId());
        }
    }

    public static void addExtensionOption(Option option) {
        Option previous = ManagedBuildManager.getExtensionOptionMap().put(option.getId(), option);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Option", option.getId());
        }
    }

    public static void addExtensionOptionCategory(OptionCategory optionCategory) {
        OptionCategory previous = ManagedBuildManager.getExtensionOptionCategoryMap().put(optionCategory.getId(), optionCategory);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("OptionCategory", optionCategory.getId());
        }
    }

    public static void addExtensionInputType(InputType inputType) {
        InputType previous = ManagedBuildManager.getExtensionInputTypeMap().put(inputType.getId(), inputType);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("InputType", inputType.getId());
        }
    }

    public static void addExtensionOutputType(OutputType outputType) {
        OutputType previous = ManagedBuildManager.getExtensionOutputTypeMap().put(outputType.getId(), outputType);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("OutputType", outputType.getId());
        }
    }

    public static void addExtensionTarget(Target target) {
        ManagedBuildManager.getExtensionTargetMap().put(target.getId(), target);
    }

    public static IManagedProject createManagedProject(IResource resource, IProjectType parent) throws BuildException {
        return new ManagedProject(resource, parent);
    }

    public static ITarget createTarget(IResource resource, ITarget parentTarget) throws BuildException {
        IResource owner = parentTarget.getOwner();
        if (owner != null && owner.equals((Object)resource)) {
            return parentTarget;
        }
        if (resource instanceof IProject) {
            if (owner != null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_null"));
            }
        } else {
            if (owner == null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.null_owner"));
            }
            if (!owner.equals((Object)resource.getProject())) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_project"));
            }
        }
        return new Target(resource, parentTarget);
    }

    public static IStatus initBuildInfoContainer(IResource resource) {
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = ManagedBuildManager.findBuildInfo((IResource)resource.getProject(), true);
            ManagedBuildManager.initBuildInfoContainer(buildInfo);
        }
        catch (CoreException e) {
            return new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, e.getLocalizedMessage(), (Throwable)e);
        }
        return new Status(0, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ManagedMakeMessages.getFormattedString("ManagedBuildInfo.message.init.ok", resource.getName()), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initBuildInfoContainer(ManagedBuildInfo info) throws CoreException {
        ICProject cProject;
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, new String(), null));
        }
        if (info.isContainerInited()) {
            return;
        }
        ICProject iCProject = cProject = info.getCProject();
        synchronized (iCProject) {
            IPathEntry[] entries = cProject.getRawPathEntries();
            ArrayList<IPathEntry> newEntries = new ArrayList<IPathEntry>(Arrays.asList(entries));
            if (!newEntries.contains(ManagedBuildInfo.containerEntry)) {
                newEntries.add((IPathEntry)ManagedBuildInfo.containerEntry);
                cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
            }
            info.setContainerInited(true);
        }
    }

    private static boolean isVersionCompatible(IExtension extension) {
        PluginVersionIdentifier version = null;
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int index = 0;
        while (index < elements.length) {
            IConfigurationElement element = elements[index];
            if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                version = new PluginVersionIdentifier(element.getAttribute(VERSION_ELEMENT_NAME));
                break;
            }
            ++index;
        }
        if (version == null) {
            return true;
        }
        return buildInfoVersion.isGreaterOrEqualTo(version);
    }

    private static boolean canLoadBuildInfo(IProject project) {
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        if (file == null) {
            return false;
        }
        File cdtbuild = file.getLocation().toFile();
        if (cdtbuild == null) {
            return false;
        }
        return cdtbuild.exists();
    }

    private static ManagedBuildInfo loadBuildInfo(IProject project) throws Exception {
        PluginVersionIdentifier version;
        ManagedBuildInfo buildInfo = null;
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        File cdtbuild = file.getLocation().toFile();
        if (!cdtbuild.exists()) {
            throw new BuildException(ManagedMakeMessages.getFormattedString(PROJECT_FILE_ERROR, project.getName()));
        }
        FileInputStream stream = new FileInputStream(cdtbuild);
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = parser.parse(stream);
        String fileVersion = null;
        Node rootElement = document.getFirstChild();
        if (rootElement.getNodeType() == 7 && !buildInfoVersion.isGreaterThan(version = new PluginVersionIdentifier(fileVersion = rootElement.getNodeValue())) && !buildInfoVersion.isCompatibleWith(version)) {
            throw new BuildException(ManagedMakeMessages.getFormattedString(PROJECT_VERSION_ERROR, project.getName()));
        }
        NodeList nodes = document.getElementsByTagName(ROOT_NODE_NAME);
        if (nodes.getLength() > 0) {
            PluginVersionIdentifier version21;
            PluginVersionIdentifier version2;
            Node node = nodes.item(0);
            buildInfo = new ManagedBuildInfo((IResource)project, (Element)node, fileVersion);
            if (fileVersion != null && (version2 = new PluginVersionIdentifier(fileVersion)).isGreaterOrEqualTo(version21 = new PluginVersionIdentifier("2.1"))) {
                if (buildInfo.getManagedProject() == null || !buildInfo.getManagedProject().isValid()) {
                    throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
                }
                if (!(ManagedBuildManager.checkForMigrationSupport(buildInfo, false) || buildInfo.getManagedProject() != null && buildInfo.getManagedProject().isValid())) {
                    throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
                }
            }
            if (!UpdateManagedProjectManager.isCompatibleProject(buildInfo)) {
                UpdateManagedProjectManager.updateProject(project, buildInfo);
            }
            if (buildInfo.getManagedProject() == null || !buildInfo.getManagedProject().isValid()) {
                throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
            }
            if (!(ManagedBuildManager.checkForMigrationSupport(buildInfo, true) || buildInfo.getManagedProject() != null && buildInfo.getManagedProject().isValid())) {
                throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
            }
            IConfiguration[] configs = buildInfo.getManagedProject().getConfigurations();
            int i = 0;
            while (i < configs.length) {
                ManagedBuildManager.performValueHandlerEvent(configs[i], 1);
                ++i;
            }
            project.setSessionProperty(buildInfoProperty, (Object)buildInfo);
        }
        buildInfo.setValid(true);
        return buildInfo;
    }

    private static void loadExtensions() throws BuildException {
        if (projectTypesLoaded) {
            return;
        }
        ManagedBuildManager.loadExtensionsSynchronized();
    }

    private static synchronized void loadExtensionsSynchronized() throws BuildException {
        IConfigurationElement element;
        IExtension[] extensions;
        if (projectTypesLoaded) {
            return;
        }
        if (projectTypesLoading) {
            return;
        }
        projectTypesLoading = true;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                if (!ManagedBuildManager.isVersionCompatible(extension)) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null) {
                        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        window = windows[0];
                    }
                    final Shell shell = window.getShell();
                    final String errMsg = ManagedMakeMessages.getFormattedString(MANIFEST_VERSION_ERROR, extension.getUniqueIdentifier());
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)shell, (String)ManagedMakeMessages.getResourceString("ManagedBuildManager.error.manifest_load_failed_title"), (String)errMsg);
                        }
                    });
                } else {
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    String revision = null;
                    int j = 0;
                    while (j < elements.length) {
                        element = elements[j];
                        if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                            revision = element.getAttribute(VERSION_ELEMENT_NAME);
                            break;
                        }
                        ++j;
                    }
                    ManagedBuildManager.loadConfigElements(DefaultManagedConfigElement.convertArray(elements, extension), revision);
                }
                ++i;
            }
            Iterator projectTypeIter = ManagedBuildManager.getExtensionProjectTypeMap().values().iterator();
            while (projectTypeIter.hasNext()) {
                try {
                    ProjectType projectType = (ProjectType)projectTypeIter.next();
                    projectType.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator configurationIter = ManagedBuildManager.getExtensionConfigurationMap().values().iterator();
            while (configurationIter.hasNext()) {
                try {
                    Configuration configuration = (Configuration)configurationIter.next();
                    configuration.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator resConfigIter = ManagedBuildManager.getExtensionResourceConfigurationMap().values().iterator();
            while (resConfigIter.hasNext()) {
                try {
                    ResourceConfiguration resConfig = (ResourceConfiguration)resConfigIter.next();
                    resConfig.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator toolChainIter = ManagedBuildManager.getExtensionToolChainMap().values().iterator();
            while (toolChainIter.hasNext()) {
                try {
                    ToolChain toolChain = (ToolChain)toolChainIter.next();
                    toolChain.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator toolIter = ManagedBuildManager.getExtensionToolMap().values().iterator();
            while (toolIter.hasNext()) {
                try {
                    Tool tool = (Tool)toolIter.next();
                    tool.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator targetPlatformIter = ManagedBuildManager.getExtensionTargetPlatformMap().values().iterator();
            while (targetPlatformIter.hasNext()) {
                try {
                    TargetPlatform targetPlatform = (TargetPlatform)targetPlatformIter.next();
                    targetPlatform.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator builderIter = ManagedBuildManager.getExtensionBuilderMap().values().iterator();
            while (builderIter.hasNext()) {
                try {
                    Builder builder = (Builder)builderIter.next();
                    builder.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator optionIter = ManagedBuildManager.getExtensionOptionMap().values().iterator();
            while (optionIter.hasNext()) {
                try {
                    Option option = (Option)optionIter.next();
                    option.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator optionCatIter = ManagedBuildManager.getExtensionOptionCategoryMap().values().iterator();
            while (optionCatIter.hasNext()) {
                try {
                    OptionCategory optionCat = (OptionCategory)optionCatIter.next();
                    optionCat.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID_V2)) != null) {
            extensions = extensionPoint.getExtensions();
            String revision = null;
            if (extensions != null && extensions.length > 0) {
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    if (!ManagedBuildManager.isVersionCompatible(extension)) {
                        throw new BuildException(ManagedMakeMessages.getResourceString(MANIFEST_VERSION_ERROR));
                    }
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        element = elements[j];
                        if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                            revision = element.getAttribute(VERSION_ELEMENT_NAME);
                            break;
                        }
                        ++j;
                    }
                    if (revision == null) {
                        revision = "1.2.0";
                    }
                    ManagedBuildManager.loadConfigElementsV2(DefaultManagedConfigElement.convertArray(elements, extension), revision);
                    ++i;
                }
                Iterator targetIter = ManagedBuildManager.getExtensionTargetMap().values().iterator();
                while (targetIter.hasNext()) {
                    try {
                        Target target = (Target)targetIter.next();
                        target.resolveReferences();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Iterator toolIter = ManagedBuildManager.getExtensionToolMap().values().iterator();
                while (toolIter.hasNext()) {
                    try {
                        Tool tool = (Tool)toolIter.next();
                        tool.resolveReferences();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                targetIter = ManagedBuildManager.getExtensionTargetMap().values().iterator();
                while (targetIter.hasNext()) {
                    try {
                        Target target = (Target)targetIter.next();
                        if (target.getCreatedProjectType() != null) continue;
                        target.convertToProjectType(revision);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Iterator projTypeIter = ManagedBuildManager.getExtensionProjectTypeMap().values().iterator();
                while (projTypeIter.hasNext()) {
                    try {
                        ProjectType projType = (ProjectType)projTypeIter.next();
                        projType.resolveReferences();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        ManagedBuildManager.performAdjustments();
        projectTypesLoading = false;
        projectTypesLoaded = true;
    }

    private static void performAdjustments() {
        int j;
        IConfiguration[] cfgs;
        IProjectType[] types = ManagedBuildManager.getDefinedProjectTypes();
        int i = 0;
        while (i < types.length) {
            cfgs = types[i].getConfigurations();
            j = 0;
            while (j < cfgs.length) {
                ManagedBuildManager.adjustConfig(cfgs[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < types.length) {
            cfgs = types[i].getConfigurations();
            j = 0;
            while (j < cfgs.length) {
                ManagedBuildManager.performValueHandlerEvent(cfgs[j], 5);
                ++j;
            }
            ++i;
        }
    }

    private static void adjustConfig(IConfiguration cfg) {
        IToolChain tc = cfg.getToolChain();
        ManagedBuildManager.adjustHolder(cfg, tc);
        ITool[] tools = cfg.getTools();
        int i = 0;
        while (i < tools.length) {
            ManagedBuildManager.adjustHolder(cfg, tools[i]);
            ++i;
        }
        IResourceConfiguration[] rcCfgs = cfg.getResourceConfigurations();
        int i2 = 0;
        while (i2 < rcCfgs.length) {
            ITool[] rcTools = rcCfgs[i2].getTools();
            int j = 0;
            while (j < rcTools.length) {
                ManagedBuildManager.adjustHolder(rcCfgs[i2], rcTools[j]);
                ++j;
            }
            ++i2;
        }
    }

    private static void adjustHolder(IBuildObject cfg, IHoldsOptions holder) {
        IOption[] options = holder.getOptions();
        int i = 0;
        while (i < options.length) {
            Option option = (Option)options[i];
            BooleanExpressionApplicabilityCalculator calc = option.getBooleanExpressionCalculator();
            if (calc != null) {
                calc.performAdjustment(cfg, holder, option);
            }
            ++i;
        }
    }

    private static void loadConfigElements(IManagedConfigElement[] elements, String revision) {
        int toolIndex = 0;
        while (toolIndex < elements.length) {
            try {
                IManagedConfigElement element = elements[toolIndex];
                if (element.getName().equals("projectType")) {
                    new ProjectType(element, revision);
                } else if (element.getName().equals("configuration")) {
                    new Configuration(null, element, revision);
                } else if (element.getName().equals("toolChain")) {
                    new ToolChain(null, element, revision);
                } else if (element.getName().equals("tool")) {
                    new Tool(null, element, revision);
                } else if (element.getName().equals("targetPlatform")) {
                    new TargetPlatform(null, element, revision);
                } else if (element.getName().equals("builder")) {
                    new Builder(null, element, revision);
                } else if (element.getName().equals("dynamicElementProvider") && element instanceof DefaultManagedConfigElement) {
                    IManagedConfigElementProvider provider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)element);
                    IManagedConfigElement[] providedConfigs = provider.getConfigElements();
                    ManagedBuildManager.loadConfigElements(providedConfigs, revision);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++toolIndex;
        }
    }

    private static void loadConfigElementsV2(IManagedConfigElement[] elements, String revision) {
        int toolIndex = 0;
        while (toolIndex < elements.length) {
            try {
                IManagedConfigElement element = elements[toolIndex];
                if (element.getName().equals("tool")) {
                    new Tool(element, revision);
                } else if (element.getName().equals("target")) {
                    new Target(element, revision);
                } else if (element.getName().equals("dynamicElementProvider") && element instanceof DefaultManagedConfigElement) {
                    IManagedConfigElementProvider provider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)element);
                    IManagedConfigElement[] providedConfigs = provider.getConfigElements();
                    ManagedBuildManager.loadConfigElementsV2(providedConfigs, revision);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++toolIndex;
        }
    }

    public static ManagedBuildInfo createBuildInfo(IResource resource) {
        ManagedBuildInfo buildInfo = new ManagedBuildInfo(resource);
        try {
            resource.setSessionProperty(buildInfoProperty, (Object)buildInfo);
        }
        catch (CoreException coreException) {
            buildInfo = null;
        }
        return buildInfo;
    }

    private static IManagedConfigElementProvider createConfigProvider(DefaultManagedConfigElement element) throws CoreException {
        return (IManagedConfigElementProvider)element.getConfigurationElement().createExecutableExtension("class");
    }

    public static boolean manages(IResource resource) {
        IProject project = null;
        if (resource instanceof IProject) {
            project = (IProject)resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return false;
        }
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        if (file.exists()) {
            try {
                InputStream stream = file.getContents();
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(stream);
                NodeList nodes = document.getElementsByTagName(ROOT_NODE_NAME);
                return nodes.getLength() > 0;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static ManagedBuildInfo findBuildInfo(IResource resource, boolean forceLoad) {
        if (resource == null) {
            return null;
        }
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = (ManagedBuildInfo)resource.getSessionProperty(buildInfoProperty);
            if (buildInfo != null) {
                buildInfo.updateOwner(resource);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        if (buildInfo == null && resource instanceof IProject) {
            buildInfo = ManagedBuildManager.findBuildInfoSynchronized((IProject)resource, forceLoad);
        }
        return buildInfo;
    }

    private static boolean canFindBuildInfo(IResource resource) {
        if (resource == null) {
            return false;
        }
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
            return false;
        }
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = (ManagedBuildInfo)resource.getSessionProperty(buildInfoProperty);
        }
        catch (CoreException coreException) {}
        if (buildInfo == null && resource instanceof IProject) {
            buildInfo = UpdateManagedProjectManager.getConvertedManagedBuildInfo((IProject)resource);
            if (buildInfo != null) {
                return true;
            }
            return ManagedBuildManager.canLoadBuildInfo((IProject)resource);
        }
        return buildInfo != null;
    }

    private static synchronized ManagedBuildInfo findBuildInfoSynchronized(IProject project, boolean forceLoad) {
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = (ManagedBuildInfo)project.getSessionProperty(buildInfoProperty);
            if (buildInfo != null) {
                buildInfo.updateOwner((IResource)project);
            }
        }
        catch (CoreException coreException) {}
        if (buildInfo == null && forceLoad) {
            try {
                ManagedBuildManager.loadExtensions();
            }
            catch (BuildException e) {
                e.printStackTrace();
                return null;
            }
            buildInfo = UpdateManagedProjectManager.getConvertedManagedBuildInfo(project);
            if (buildInfo == null) {
                try {
                    buildInfo = ManagedBuildManager.loadBuildInfo(project);
                }
                catch (Exception e) {
                    if (buildInfo == null) {
                        buildInfo = ManagedBuildManager.createBuildInfo((IResource)project);
                    }
                    buildInfo.setValid(false);
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null) {
                        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        window = windows[0];
                    }
                    final Shell shell = window.getShell();
                    final String exceptionMsg = e.getMessage();
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)shell, (String)ManagedMakeMessages.getResourceString("ManagedBuildManager.error.open_failed_title"), (String)ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.open_failed", exceptionMsg));
                        }
                    });
                }
                if (buildInfo != null && !buildInfo.isContainerInited()) {
                    try {
                        ManagedBuildManager.initBuildInfoContainer(buildInfo);
                    }
                    catch (CoreException coreException) {}
                }
            }
        }
        return buildInfo;
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource) {
        return ManagedBuildManager.getBuildInfo(resource, true);
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource, boolean forceLoad) {
        return ManagedBuildManager.findBuildInfo((IResource)resource.getProject(), forceLoad);
    }

    public static boolean canGetBuildInfo(IResource resource) {
        return ManagedBuildManager.canFindBuildInfo((IResource)resource.getProject());
    }

    public static PluginVersionIdentifier getBuildInfoVersion() {
        return buildInfoVersion;
    }

    public static URL getURLInBuildDefinitions(DefaultManagedConfigElement element, IPath path) {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                if (element.getExtension().getExtensionPointUniqueIdentifier() == extension.getExtensionPointUniqueIdentifier()) {
                    Bundle bundle = Platform.getBundle((String)extension.getNamespace());
                    URL url = Platform.find((Bundle)bundle, (IPath)path);
                    if (url != null) {
                        try {
                            return Platform.asLocalURL((URL)url);
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                    ManagedBuildManager.OutputIconError(path.toString());
                }
                ++i;
            }
        }
        return null;
    }

    private static Map getBuildModelListeners() {
        if (buildModelListeners == null) {
            buildModelListeners = new HashMap();
        }
        return buildModelListeners;
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        return (IScannerInfo)ManagedBuildManager.getBuildInfo((IResource)resource.getProject());
    }

    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        ArrayList<IScannerInfoChangeListener> list = (ArrayList<IScannerInfoChangeListener>)map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!list.contains(listener)) {
            list.add(listener);
            map.put(project, list);
        }
    }

    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        List list = (List)map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
            map.put(project, list);
        }
    }

    private static Map getConfigElementMap() {
        if (configElementMap == null) {
            configElementMap = new HashMap();
        }
        return configElementMap;
    }

    public static void putConfigElement(IBuildObject buildObj, IManagedConfigElement configElement) {
        ManagedBuildManager.getConfigElementMap().put(buildObj, configElement);
    }

    private static void removeConfigElement(IBuildObject buildObj) {
        ManagedBuildManager.getConfigElementMap().remove(buildObj);
    }

    public static IManagedConfigElement getConfigElement(IBuildObject buildObj) {
        return (IManagedConfigElement)ManagedBuildManager.getConfigElementMap().get(buildObj);
    }

    public static void OptionValidError(int errorId, String id) {
        String[] msgs = new String[]{id};
        switch (errorId) {
            case 0: {
                ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_OPTION_CATEGORY, msgs));
                break;
            }
            case 1: {
                ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_OPTION_FILTER, msgs));
            }
        }
    }

    public static void OptionValueHandlerError(String attribute, String id) {
        String[] msgs = new String[]{attribute, id};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_OPTION_VALUEHANDLER, msgs));
    }

    public static void OutputResolveError(String attribute, String lookupId, String type, String id) {
        String[] msgs = new String[]{attribute, lookupId, type, id};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_RESOLVING, msgs));
    }

    public static void OutputDuplicateIdError(String type, String id) {
        String[] msgs = new String[]{type, id};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_DUPLICATE, msgs));
    }

    public static void OutputManifestError(String message) {
        System.err.println(String.valueOf(ManagedMakeMessages.getResourceString(MANIFEST_ERROR_HEADER)) + message + NEWLINE);
    }

    public static void OutputIconError(String iconLocation) {
        String[] msgs = new String[]{iconLocation};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_ICON, msgs));
    }

    public static IEnvironmentVariableProvider getEnvironmentVariableProvider() {
        return EnvironmentVariableProvider.getDefault();
    }

    public static String getVersionFromIdAndVersion(String idAndVersion) {
        String version;
        IStatus status;
        int index = idAndVersion.lastIndexOf(95);
        if (index != -1 && (status = PluginVersionIdentifier.validateVersion((String)(version = idAndVersion.substring(index + 1)))).isOK()) {
            return version;
        }
        return null;
    }

    public static String getIdFromIdAndVersion(String idAndVersion) {
        if (ManagedBuildManager.getVersionFromIdAndVersion(idAndVersion) != null) {
            int index = idAndVersion.lastIndexOf(95);
            return idAndVersion.substring(0, index);
        }
        return idAndVersion;
    }

    public static IBuildMacroProvider getBuildMacroProvider() {
        return BuildMacroProvider.getDefault();
    }

    public static void performValueHandlerEvent(IConfiguration config, int event) {
        ManagedBuildManager.performValueHandlerEvent(config, event, true);
    }

    public static void performValueHandlerEvent(IConfiguration config, int event, boolean doChildren) {
        IToolChain toolChain = config.getToolChain();
        if (toolChain == null) {
            return;
        }
        IOption[] options = toolChain.getOptions();
        int i = 0;
        while (i < options.length) {
            if (options[i].isValid()) {
                options[i].getValueHandler().handleValue(config, toolChain, options[i], options[i].getValueHandlerExtraArgument(), event);
            }
            ++i;
        }
        ITool[] tools = config.getFilteredTools();
        int i2 = 0;
        while (i2 < tools.length) {
            IOption[] toolOptions = tools[i2].getOptions();
            int j = 0;
            while (j < toolOptions.length) {
                if (toolOptions[j].isValid()) {
                    toolOptions[j].getValueHandler().handleValue(config, tools[i2], toolOptions[j], toolOptions[j].getValueHandlerExtraArgument(), event);
                }
                ++j;
            }
            ++i2;
        }
        if (doChildren) {
            IResourceConfiguration[] resConfigs = config.getResourceConfigurations();
            int j = 0;
            while (j < resConfigs.length) {
                ManagedBuildManager.performValueHandlerEvent(resConfigs[j], event);
                ++j;
            }
        }
    }

    public static void performValueHandlerEvent(IResourceConfiguration config, int event) {
        ITool[] tools = config.getToolsToInvoke();
        int i = 0;
        while (i < tools.length) {
            IOption[] toolOptions = tools[i].getOptions();
            int j = 0;
            while (j < toolOptions.length) {
                if (toolOptions[j].isValid()) {
                    toolOptions[j].getValueHandler().handleValue(config, tools[i], toolOptions[j], toolOptions[j].getValueHandlerExtraArgument(), event);
                }
                ++j;
            }
            ++i;
        }
    }

    private static boolean checkForMigrationSupport(ManagedBuildInfo buildInfo, boolean forCurrentMbsVersion) {
        IConfigurationElement element = null;
        IManagedProject managedProject = buildInfo.getManagedProject();
        IProjectType projectType = managedProject.getProjectType();
        element = forCurrentMbsVersion ? ((ProjectType)projectType).getCurrentMbsVersionConversionElement() : ((ProjectType)projectType).getPreviousMbsVersionConversionElement();
        if (element != null) {
            if (ManagedBuildManager.invokeConverter(managedProject, element) == null) {
                buildInfo.getManagedProject().setValid(false);
                return false;
            }
        } else {
            IConfiguration[] configs = managedProject.getConfigurations();
            int i = 0;
            while (i < configs.length) {
                IResourceConfiguration[] resourceConfigs;
                IConfiguration configuration = configs[i];
                IToolChain toolChain = configuration.getToolChain();
                element = forCurrentMbsVersion ? ((ToolChain)toolChain).getCurrentMbsVersionConversionElement() : ((ToolChain)toolChain).getPreviousMbsVersionConversionElement();
                if (element != null) {
                    if (ManagedBuildManager.invokeConverter(toolChain, element) == null) {
                        buildInfo.getManagedProject().setValid(false);
                        return false;
                    }
                } else {
                    ITool[] tools = toolChain.getTools();
                    int j = 0;
                    while (j < tools.length) {
                        ITool tool = tools[j];
                        element = forCurrentMbsVersion ? ((Tool)tool).getCurrentMbsVersionConversionElement() : ((Tool)tool).getPreviousMbsVersionConversionElement();
                        if (element != null && ManagedBuildManager.invokeConverter(tool, element) == null) {
                            buildInfo.getManagedProject().setValid(false);
                            return false;
                        }
                        ++j;
                    }
                    IBuilder builder = toolChain.getBuilder();
                    if (builder != null && (element = forCurrentMbsVersion ? ((Builder)builder).getCurrentMbsVersionConversionElement() : ((Builder)builder).getPreviousMbsVersionConversionElement()) != null && ManagedBuildManager.invokeConverter(builder, element) == null) {
                        buildInfo.getManagedProject().setValid(false);
                        return false;
                    }
                }
                if ((resourceConfigs = configuration.getResourceConfigurations()) != null && resourceConfigs.length > 0) {
                    int j = 0;
                    while (j < resourceConfigs.length) {
                        IResourceConfiguration resConfig = resourceConfigs[j];
                        ITool[] resTools = resConfig.getTools();
                        int k = 0;
                        while (k < resTools.length) {
                            ITool resTool = resTools[k];
                            element = forCurrentMbsVersion ? ((Tool)resTool).getCurrentMbsVersionConversionElement() : ((Tool)resTool).getPreviousMbsVersionConversionElement();
                            if (element != null && ManagedBuildManager.invokeConverter(resTool, element) == null) {
                                buildInfo.getManagedProject().setValid(false);
                                return false;
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private static IBuildObject invokeConverter(IBuildObject buildObject, IConfigurationElement element) {
        if (element != null) {
            IConvertManagedBuildObject convertBuildObject = null;
            String toId = element.getAttribute("toId");
            String fromId = element.getAttribute("fromId");
            try {
                convertBuildObject = (IConvertManagedBuildObject)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (convertBuildObject != null) {
                return convertBuildObject.convert(buildObject, fromId, toId, false);
            }
        }
        return null;
    }

    public static IBuildObject convert(IBuildObject buildObj, String toId, boolean userhasConfirmed) {
        String tmpToId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter") && ManagedBuildManager.isBuildObjectApplicableForConversion(buildObj, element) && (tmpToId = element.getAttribute("toId")).equals(toId)) {
                        return ManagedBuildManager.invokeConverter(buildObj, element);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean hasTargetConversionElements(IBuildObject buildObj) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter") && ManagedBuildManager.isBuildObjectApplicableForConversion(buildObj, element)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public static Map getConversionElements(IBuildObject buildObj) {
        HashMap<String, IConfigurationElement> conversionTargets = new HashMap<String, IConfigurationElement>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter") && ManagedBuildManager.isBuildObjectApplicableForConversion(buildObj, element)) {
                        conversionTargets.put(element.getAttribute("name"), element);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return conversionTargets;
    }

    private static boolean isBuildObjectApplicableForConversion(IBuildObject buildObj, IConfigurationElement element) {
        block9: {
            String fromId;
            String id;
            block11: {
                block10: {
                    block8: {
                        id = null;
                        fromId = element.getAttribute("fromId");
                        if (!(buildObj instanceof IProjectType)) break block8;
                        IProjectType projType = (IProjectType)buildObj;
                        while (projType != null) {
                            id = projType.getId();
                            if (fromId.equals(id)) {
                                return true;
                            }
                            projType = projType.getSuperClass();
                        }
                        break block9;
                    }
                    if (!(buildObj instanceof IToolChain)) break block10;
                    IToolChain toolChain = (IToolChain)buildObj;
                    while (toolChain != null) {
                        id = toolChain.getId();
                        if (fromId.equals(id)) {
                            return true;
                        }
                        toolChain = toolChain.getSuperClass();
                    }
                    break block9;
                }
                if (!(buildObj instanceof ITool)) break block11;
                ITool tool = (ITool)buildObj;
                while (tool != null) {
                    id = tool.getId();
                    if (fromId.equals(id)) {
                        return true;
                    }
                    tool = tool.getSuperClass();
                }
                break block9;
            }
            if (!(buildObj instanceof IBuilder)) break block9;
            IBuilder builder = (IBuilder)buildObj;
            while (builder != null) {
                id = builder.getId();
                if (fromId.equals(id)) {
                    return true;
                }
                builder = builder.getSuperClass();
            }
        }
        return false;
    }

    public static String calculateChildId(String superId, String suffix) {
        String version;
        if (suffix == null) {
            suffix = new Integer(ManagedBuildManager.getRandomNumber()).toString();
        }
        if ((version = ManagedBuildManager.getVersionFromIdAndVersion(superId)) != null) {
            return String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(superId)) + "." + suffix + "_" + version;
        }
        return String.valueOf(superId) + "." + suffix;
    }

    public static IPath calculateRelativePath(IPath container, IPath contents) {
        IPath path = contents;
        if (container.isPrefixOf(contents)) {
            path = contents.setDevice(null).removeFirstSegments(container.segmentCount());
        } else {
            String file = null;
            container = container.addTrailingSeparator();
            if (!contents.hasTrailingSeparator()) {
                file = contents.lastSegment();
                contents = contents.removeLastSegments(1);
                contents = contents.addTrailingSeparator();
            }
            IPath prefix = contents;
            while (prefix.segmentCount() > 0 && !prefix.isPrefixOf(container)) {
                prefix = prefix.removeLastSegments(1);
            }
            if (prefix.segmentCount() > 0) {
                int diff = container.segmentCount() - prefix.segmentCount();
                StringBuffer buff = new StringBuffer();
                while (diff-- > 0) {
                    buff.append("../");
                }
                path = new Path(buff.toString()).append(contents.removeFirstSegments(prefix.segmentCount()));
                if (file != null) {
                    path = path.append(file);
                }
            }
        }
        return path;
    }
}

