/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.GeneratedMakefileBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceChangeHandler;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildCPathEntryContainer;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildPathEntryContainerInitializer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

public class ManagedBuilderCorePlugin
extends Plugin {
    private static final String PLUGIN_ID = "org.eclipse.cdt.managedbuilder.core";
    private static ManagedBuilderCorePlugin plugin;
    public static final String MAKEGEN_ID = "makefileGenerator";
    public static final String COMMANDLINEGEN_ID = "commandlineGenerator";
    public static final String MANAGED_MAKE_PROJECT_ID;
    private static ResourceChangeHandler listener;
    private static final String PATH_ENTRY;
    private static final String PATH_ENTRY_INIT;
    private static final String BUILDER;

    static {
        MANAGED_MAKE_PROJECT_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".managedMake";
        PATH_ENTRY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "/debug/pathEntry";
        PATH_ENTRY_INIT = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "/debug/pathEntryInit";
        BUILDER = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + "/debug/builder";
    }

    public ManagedBuilderCorePlugin() {
        plugin = this;
    }

    public static String getUniqueIdentifier() {
        if (ManagedBuilderCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return ManagedBuilderCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static ManagedBuilderCorePlugin getDefault() {
        return plugin;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configurePluginDebugOptions();
        IJobManager jobManager = Platform.getJobManager();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            try {
                jobManager.beginRule((ISchedulingRule)root, null);
                this.startResourceChangeHandling();
            }
            catch (Exception exception) {
                Job rcJob = new Job(ManagedMakeMessages.getResourceString("ManagedBuilderCorePlugin.resourceChangeHandlingInitializationJob")){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ManagedBuilderCorePlugin.this.startResourceChangeHandling();
                        }
                        catch (CoreException e) {
                            CCorePlugin.log((Throwable)e);
                            return e.getStatus();
                        }
                        return new Status(0, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
                    }
                };
                rcJob.setRule((ISchedulingRule)root);
                rcJob.setPriority(10);
                rcJob.setSystem(true);
                rcJob.schedule();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            jobManager.endRule((ISchedulingRule)root);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        jobManager.endRule((ISchedulingRule)root);
    }

    private void startResourceChangeHandling() throws CoreException {
        listener = new ResourceChangeHandler();
        ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, (ISaveParticipant)listener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 7);
        if (lastState != null) {
            lastState.processResourceChangeEvents((IResourceChangeListener)listener);
        }
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            listener.sendClose(projects[i]);
            ++i;
        }
        listener = null;
        super.stop(context);
    }

    private void configurePluginDebugOptions() {
        if (this.isDebugging()) {
            String builder;
            String pathCalc;
            String pathInit = Platform.getDebugOption((String)PATH_ENTRY_INIT);
            if (pathInit != null) {
                ManagedBuildPathEntryContainerInitializer.VERBOSE = pathInit.equalsIgnoreCase("true");
            }
            if ((pathCalc = Platform.getDebugOption((String)PATH_ENTRY)) != null) {
                ManagedBuildCPathEntryContainer.VERBOSE = pathCalc.equalsIgnoreCase("true");
            }
            if ((builder = Platform.getDebugOption((String)BUILDER)) != null) {
                GeneratedMakefileBuilder.VERBOSE = builder.equalsIgnoreCase("true");
            }
        }
    }
}

