/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IInputOrder;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.AdditionalInput;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.InputOrder;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InputType
extends BuildObject
implements IInputType {
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String EMPTY_STRING = new String();
    private IInputType superClass;
    private String superClassId;
    private ITool parent;
    private Vector inputOrderList;
    private Vector additionalInputList;
    private String sourceContentTypeId;
    private IContentType sourceContentType;
    private List inputExtensions;
    private String dependencyContentTypeId;
    private IContentType dependencyContentType;
    private List dependencyExtensions;
    private String optionId;
    private String assignToOptionId;
    private String buildVariable;
    private Boolean multipleOfType;
    private Boolean primaryInput;
    private IConfigurationElement dependencyGeneratorElement = null;
    private IManagedDependencyGenerator dependencyGenerator = null;
    private boolean isExtensionInputType = false;
    private boolean isDirty = false;
    private boolean resolved = true;

    public InputType(ITool parent, IManagedConfigElement element) {
        this.parent = parent;
        this.isExtensionInputType = true;
        this.resolved = false;
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionInputType(this);
        IManagedConfigElement[] iElements = element.getChildren();
        int l = 0;
        while (l < iElements.length) {
            IManagedConfigElement iElement = iElements[l];
            if (iElement.getName().equals("inputOrder")) {
                InputOrder inputOrder = new InputOrder((IInputType)this, iElement);
                this.getInputOrderList().add(inputOrder);
            } else if (iElement.getName().equals("additionalInput")) {
                AdditionalInput addlInput = new AdditionalInput((IInputType)this, iElement);
                this.getAdditionalInputList().add(addlInput);
            }
            ++l;
        }
    }

    public InputType(Tool parent, IInputType superClass, String Id, String name, boolean isExtensionElement) {
        this.parent = parent;
        this.superClass = superClass;
        if (this.superClass != null) {
            this.superClassId = this.superClass.getId();
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionInputType = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionInputType(this);
        } else {
            this.setDirty(true);
        }
    }

    public InputType(ITool parent, Element element) {
        this.parent = parent;
        this.isExtensionInputType = false;
        this.loadFromProject(element);
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("inputOrder")) {
                InputOrder inputOrder = new InputOrder((IInputType)this, (Element)configElement);
                this.getInputOrderList().add(inputOrder);
            } else if (configElement.getNodeName().equals("additionalInput")) {
                AdditionalInput addlInput = new AdditionalInput((IInputType)this, (Element)configElement);
                this.getAdditionalInputList().add(addlInput);
            }
            ++i;
        }
    }

    public InputType(ITool parent, String Id, String name, InputType inputType) {
        ListIterator iter;
        this.parent = parent;
        this.superClass = inputType.superClass;
        if (this.superClass != null && inputType.superClassId != null) {
            this.superClassId = new String(inputType.superClassId);
        }
        this.setId(Id);
        this.setName(name);
        this.isExtensionInputType = false;
        if (inputType.sourceContentTypeId != null) {
            this.sourceContentTypeId = new String(inputType.sourceContentTypeId);
        }
        this.sourceContentType = inputType.sourceContentType;
        if (inputType.inputExtensions != null) {
            this.inputExtensions = new ArrayList(inputType.inputExtensions);
        }
        if (inputType.dependencyContentTypeId != null) {
            this.dependencyContentTypeId = new String(inputType.dependencyContentTypeId);
        }
        this.dependencyContentType = inputType.dependencyContentType;
        if (inputType.dependencyExtensions != null) {
            this.dependencyExtensions = new ArrayList(inputType.dependencyExtensions);
        }
        if (inputType.optionId != null) {
            this.optionId = new String(inputType.optionId);
        }
        if (inputType.assignToOptionId != null) {
            this.assignToOptionId = new String(inputType.assignToOptionId);
        }
        if (inputType.buildVariable != null) {
            this.buildVariable = new String(inputType.buildVariable);
        }
        if (inputType.multipleOfType != null) {
            this.multipleOfType = new Boolean(inputType.multipleOfType);
        }
        if (inputType.primaryInput != null) {
            this.primaryInput = new Boolean(inputType.primaryInput);
        }
        this.dependencyGeneratorElement = inputType.dependencyGeneratorElement;
        this.dependencyGenerator = inputType.dependencyGenerator;
        if (inputType.inputOrderList != null) {
            iter = inputType.getInputOrderList().listIterator();
            while (iter.hasNext()) {
                InputOrder inputOrder = (InputOrder)iter.next();
                InputOrder newInputOrder = new InputOrder((IInputType)this, inputOrder);
                this.getInputOrderList().add(newInputOrder);
            }
        }
        if (inputType.additionalInputList != null) {
            iter = inputType.getAdditionalInputList().listIterator();
            while (iter.hasNext()) {
                AdditionalInput additionalInput = (AdditionalInput)iter.next();
                AdditionalInput newAdditionalInput = new AdditionalInput((IInputType)this, additionalInput);
                this.getAdditionalInputList().add(newAdditionalInput);
            }
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String isPI;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.superClassId = element.getAttribute("superClass");
        this.sourceContentTypeId = element.getAttribute("sourceContentType");
        String inputs = element.getAttribute("sources");
        if (inputs != null) {
            StringTokenizer tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInputExtensionsList().add(tokenizer.nextElement());
            }
        }
        this.dependencyContentTypeId = element.getAttribute("dependencyContentType");
        String headers = element.getAttribute("dependencyExtensions");
        if (headers != null) {
            StringTokenizer tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getDependencyExtensionsList().add(tokenizer.nextElement());
            }
        }
        this.optionId = element.getAttribute("option");
        this.assignToOptionId = element.getAttribute("assignToOption");
        String isMOT = element.getAttribute("multipleOfType");
        if (isMOT != null) {
            this.multipleOfType = new Boolean("true".equals(isMOT));
        }
        if ((isPI = element.getAttribute("primaryInput")) != null) {
            this.primaryInput = new Boolean("true".equals(isPI));
        }
        this.buildVariable = element.getAttribute("buildVariable");
        String depGenerator = element.getAttribute("dependencyCalculator");
        if (depGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.dependencyGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
    }

    protected boolean loadFromProject(Element element) {
        String isPI;
        String isMOT;
        String headers;
        StringTokenizer tokenizer;
        String inputs;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            this.superClass = ManagedBuildManager.getExtensionInputType(this.superClassId);
        }
        IContentTypeManager manager = Platform.getContentTypeManager();
        if (element.hasAttribute("sourceContentType")) {
            this.sourceContentTypeId = element.getAttribute("sourceContentType");
            if (this.sourceContentTypeId != null && this.sourceContentTypeId.length() > 0) {
                this.sourceContentType = manager.getContentType(this.sourceContentTypeId);
            }
        }
        if (element.hasAttribute("sources") && (inputs = element.getAttribute("sources")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInputExtensionsList().add(tokenizer.nextElement());
            }
        }
        if (element.hasAttribute("dependencyContentType")) {
            this.dependencyContentTypeId = element.getAttribute("dependencyContentType");
            if (this.dependencyContentTypeId != null && this.dependencyContentTypeId.length() > 0) {
                this.dependencyContentType = manager.getContentType(this.dependencyContentTypeId);
            }
        }
        if (element.hasAttribute("dependencyExtensions") && (headers = element.getAttribute("dependencyExtensions")) != null) {
            tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getDependencyExtensionsList().add(tokenizer.nextElement());
            }
        }
        if (element.hasAttribute("option")) {
            this.optionId = element.getAttribute("option");
        }
        if (element.hasAttribute("assignToOption")) {
            this.assignToOptionId = element.getAttribute("assignToOption");
        }
        if (element.hasAttribute("multipleOfType") && (isMOT = element.getAttribute("multipleOfType")) != null) {
            this.multipleOfType = new Boolean("true".equals(isMOT));
        }
        if (element.hasAttribute("primaryInput") && (isPI = element.getAttribute("primaryInput")) != null) {
            this.primaryInput = new Boolean("true".equals(isPI));
        }
        if (element.hasAttribute("buildVariable")) {
            this.buildVariable = element.getAttribute("buildVariable");
        }
        element.hasAttribute("dependencyCalculator");
        return true;
    }

    public void serialize(Document doc, Element element) {
        ListIterator iter;
        List list;
        if (this.superClass != null) {
            element.setAttribute("superClass", this.superClass.getId());
        }
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.sourceContentTypeId != null) {
            element.setAttribute("sourceContentType", this.sourceContentTypeId);
        }
        if (this.getInputExtensionsList().size() > 0) {
            list = this.getInputExtensionsList();
            iter = list.listIterator();
            String inputs = (String)iter.next();
            while (iter.hasNext()) {
                inputs = String.valueOf(inputs) + DEFAULT_SEPARATOR;
                inputs = String.valueOf(inputs) + iter.next();
            }
            element.setAttribute("sources", inputs);
        }
        if (this.dependencyContentTypeId != null) {
            element.setAttribute("dependencyContentType", this.dependencyContentTypeId);
        }
        if (this.getDependencyExtensionsList().size() > 0) {
            list = this.getDependencyExtensionsList();
            iter = list.listIterator();
            String headers = (String)iter.next();
            while (iter.hasNext()) {
                headers = String.valueOf(headers) + DEFAULT_SEPARATOR;
                headers = String.valueOf(headers) + iter.next();
            }
            element.setAttribute("dependencyExtensions", headers);
        }
        if (this.optionId != null) {
            element.setAttribute("option", this.optionId);
        }
        if (this.assignToOptionId != null) {
            element.setAttribute("assignToOption", this.assignToOptionId);
        }
        if (this.multipleOfType != null) {
            element.setAttribute("multipleOfType", this.multipleOfType.toString());
        }
        if (this.primaryInput != null) {
            element.setAttribute("primaryInput", this.primaryInput.toString());
        }
        if (this.buildVariable != null) {
            element.setAttribute("buildVariable", this.buildVariable);
        }
        Vector childElements = this.getInputOrderList();
        ListIterator iter2 = childElements.listIterator();
        while (iter2.hasNext()) {
            InputOrder io = (InputOrder)iter2.next();
            Element ioElement = doc.createElement("inputOrder");
            element.appendChild(ioElement);
            io.serialize(doc, ioElement);
        }
        childElements = this.getAdditionalInputList();
        iter2 = childElements.listIterator();
        while (iter2.hasNext()) {
            AdditionalInput ai = (AdditionalInput)iter2.next();
            Element aiElement = doc.createElement("additionalInput");
            element.appendChild(aiElement);
            ai.serialize(doc, aiElement);
        }
        this.isDirty = false;
    }

    public ITool getParent() {
        return this.parent;
    }

    public IInputOrder createInputOrder(String path) {
        InputOrder inputOrder = new InputOrder(this, false);
        inputOrder.setPath(path);
        this.getInputOrderList().add(inputOrder);
        this.setDirty(true);
        return inputOrder;
    }

    public IInputOrder[] getInputOrders() {
        Vector ours = this.getInputOrderList();
        IInputOrder[] orders = ours.toArray(new IInputOrder[ours.size()]);
        return orders;
    }

    public IInputOrder getInputOrder(String path) {
        Vector orders = this.getInputOrderList();
        ListIterator iter = orders.listIterator();
        while (iter.hasNext()) {
            InputOrder io = (InputOrder)iter.next();
            if (path.compareToIgnoreCase(io.getPath()) == 0) continue;
            return io;
        }
        return null;
    }

    public void removeInputOrder(String path) {
        IInputOrder order = this.getInputOrder(path);
        if (order != null) {
            this.removeInputOrder(order);
        }
    }

    public void removeInputOrder(IInputOrder element) {
        this.getInputOrderList().remove(element);
        this.setDirty(true);
    }

    public IAdditionalInput createAdditionalInput(String paths) {
        AdditionalInput addlInput = new AdditionalInput(this, false);
        addlInput.setPaths(paths);
        this.getAdditionalInputList().add(addlInput);
        this.setDirty(true);
        return addlInput;
    }

    public IAdditionalInput[] getAdditionalInputs() {
        Vector ours = this.getAdditionalInputList();
        IAdditionalInput[] inputs = ours.toArray(new IAdditionalInput[ours.size()]);
        return inputs;
    }

    public IAdditionalInput getAdditionalInput(String paths) {
        String[] inputTokens = paths.split(";");
        Vector inputs = this.getInputOrderList();
        ListIterator iter = inputs.listIterator();
        while (iter.hasNext()) {
            AdditionalInput ai = (AdditionalInput)iter.next();
            boolean match = false;
            String[] tokens = ai.getPaths();
            if (tokens.length == inputTokens.length) {
                match = true;
                int i = 0;
                while (i < tokens.length) {
                    if (tokens[i].compareToIgnoreCase(inputTokens[i]) != 0) {
                        match = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!match) continue;
            return ai;
        }
        return null;
    }

    public void removeAdditionalInput(String path) {
        IAdditionalInput input = this.getAdditionalInput(path);
        if (input != null) {
            this.removeAdditionalInput(input);
        }
    }

    public void removeAdditionalInput(IAdditionalInput element) {
        this.getAdditionalInputList().remove(element);
        this.setDirty(true);
    }

    public IPath[] getAdditionalDependencies() {
        ArrayList<IPath> deps = new ArrayList<IPath>();
        Iterator typeIter = this.getAdditionalInputList().iterator();
        while (typeIter.hasNext()) {
            String[] paths;
            AdditionalInput current = (AdditionalInput)typeIter.next();
            int kind = current.getKind();
            if (kind != 1 && kind != 3 || (paths = current.getPaths()) == null) continue;
            int i = 0;
            while (i < paths.length) {
                if (paths[i].length() > 0) {
                    deps.add(Path.fromOSString((String)paths[i]));
                }
                ++i;
            }
        }
        return deps.toArray(new IPath[deps.size()]);
    }

    public IPath[] getAdditionalResources() {
        ArrayList<IPath> ins = new ArrayList<IPath>();
        Iterator typeIter = this.getAdditionalInputList().iterator();
        while (typeIter.hasNext()) {
            String[] paths;
            AdditionalInput current = (AdditionalInput)typeIter.next();
            int kind = current.getKind();
            if (kind != 2 && kind != 3 || (paths = current.getPaths()) == null) continue;
            int i = 0;
            while (i < paths.length) {
                if (paths[i].length() > 0) {
                    ins.add(Path.fromOSString((String)paths[i]));
                }
                ++i;
            }
        }
        return ins.toArray(new IPath[ins.size()]);
    }

    private Vector getInputOrderList() {
        if (this.inputOrderList == null) {
            this.inputOrderList = new Vector();
        }
        return this.inputOrderList;
    }

    private Vector getAdditionalInputList() {
        if (this.additionalInputList == null) {
            this.additionalInputList = new Vector();
        }
        return this.additionalInputList;
    }

    public IInputType getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name == null && this.superClass != null ? this.superClass.getName() : this.name;
    }

    public String getBuildVariable() {
        if (this.buildVariable == null) {
            if (this.superClass != null) {
                return this.superClass.getBuildVariable();
            }
            return EMPTY_STRING;
        }
        return this.buildVariable;
    }

    public void setBuildVariable(String variableName) {
        if (variableName == null && this.buildVariable == null) {
            return;
        }
        if (this.buildVariable == null || variableName == null || !variableName.equals(this.buildVariable)) {
            this.buildVariable = variableName;
            this.setDirty(true);
        }
    }

    public IContentType getDependencyContentType() {
        if (this.dependencyContentType == null) {
            if (this.superClass != null) {
                return this.superClass.getDependencyContentType();
            }
            return null;
        }
        return this.dependencyContentType;
    }

    public void setDependencyContentType(IContentType type) {
        if (this.dependencyContentType != type) {
            this.dependencyContentType = type;
            this.dependencyContentTypeId = this.dependencyContentType != null ? this.dependencyContentType.getId() : null;
            this.setDirty(true);
        }
    }

    public String[] getDependencyExtensionsAttribute() {
        if (this.dependencyExtensions == null || this.dependencyExtensions.size() == 0) {
            if (this.superClass != null) {
                return this.superClass.getDependencyExtensionsAttribute();
            }
            if (this.dependencyExtensions == null) {
                this.dependencyExtensions = new ArrayList();
            }
        }
        return this.dependencyExtensions.toArray(new String[this.dependencyExtensions.size()]);
    }

    public void setDependencyExtensionsAttribute(String extensions) {
        this.getDependencyExtensionsList().clear();
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getDependencyExtensionsList().add(tokenizer.nextElement());
            }
        }
        this.setDirty(true);
    }

    public String[] getDependencyExtensions(ITool tool) {
        IContentType type = this.getDependencyContentType();
        if (type != null) {
            String[] exts = ((Tool)tool).getContentTypeFileSpecs(type);
            if (type.getId().compareTo("org.eclipse.cdt.core.cxxHeader") == 0) {
                boolean h_found = false;
                int i = 0;
                while (i < exts.length) {
                    if (exts[i].compareTo("h") == 0) {
                        h_found = true;
                        break;
                    }
                    ++i;
                }
                if (!h_found) {
                    String[] cppexts = new String[exts.length + 1];
                    int i2 = 0;
                    while (i2 < exts.length) {
                        cppexts[i2] = exts[i2];
                        ++i2;
                    }
                    cppexts[i2] = "h";
                    return cppexts;
                }
            }
            return exts;
        }
        return this.getDependencyExtensionsAttribute();
    }

    public boolean isDependencyExtension(ITool tool, String ext) {
        String[] exts = this.getDependencyExtensions(tool);
        int i = 0;
        while (i < exts.length) {
            if (ext.equals(exts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List getDependencyExtensionsList() {
        if (this.dependencyExtensions == null) {
            this.dependencyExtensions = new ArrayList();
        }
        return this.dependencyExtensions;
    }

    public IManagedDependencyGenerator getDependencyGenerator() {
        if (this.dependencyGenerator != null) {
            return this.dependencyGenerator;
        }
        IConfigurationElement element = this.getDependencyGeneratorElement();
        if (element != null) {
            try {
                if (element.getAttribute("dependencyCalculator") != null) {
                    this.dependencyGenerator = (IManagedDependencyGenerator)element.createExecutableExtension("dependencyCalculator");
                    return this.dependencyGenerator;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public IConfigurationElement getDependencyGeneratorElement() {
        if (this.dependencyGeneratorElement == null && this.superClass != null) {
            return ((InputType)this.superClass).getDependencyGeneratorElement();
        }
        return this.dependencyGeneratorElement;
    }

    public void setDependencyGeneratorElement(IConfigurationElement element) {
        this.dependencyGeneratorElement = element;
        this.setDirty(true);
    }

    public boolean getMultipleOfType() {
        if (this.multipleOfType == null) {
            if (this.superClass != null) {
                return this.superClass.getMultipleOfType();
            }
            return false;
        }
        return this.multipleOfType;
    }

    public void setMultipleOfType(boolean b) {
        if (this.multipleOfType == null || b != this.multipleOfType) {
            this.multipleOfType = new Boolean(b);
            this.setDirty(true);
        }
    }

    public boolean getPrimaryInput() {
        if (this.primaryInput == null) {
            if (this.superClass != null) {
                return this.superClass.getPrimaryInput();
            }
            return false;
        }
        return this.primaryInput;
    }

    public void setPrimaryInput(boolean b) {
        if (this.primaryInput == null || b != this.primaryInput) {
            this.primaryInput = new Boolean(b);
            this.setDirty(true);
        }
    }

    public String getOptionId() {
        if (this.optionId == null) {
            if (this.superClass != null) {
                return this.superClass.getOptionId();
            }
            return null;
        }
        return this.optionId;
    }

    public void setOptionId(String id) {
        if (id == null && this.optionId == null) {
            return;
        }
        if (id == null || this.optionId == null || !this.optionId.equals(id)) {
            this.optionId = id;
            this.setDirty(true);
        }
    }

    public String getAssignToOptionId() {
        if (this.assignToOptionId == null) {
            if (this.superClass != null) {
                return this.superClass.getAssignToOptionId();
            }
            return null;
        }
        return this.assignToOptionId;
    }

    public void setAssignToOptionId(String id) {
        if (id == null && this.assignToOptionId == null) {
            return;
        }
        if (id == null || this.assignToOptionId == null || !this.assignToOptionId.equals(id)) {
            this.assignToOptionId = id;
            this.setDirty(true);
        }
    }

    public IContentType getSourceContentType() {
        if (this.sourceContentType == null) {
            if (this.superClass != null) {
                return this.superClass.getSourceContentType();
            }
            return null;
        }
        return this.sourceContentType;
    }

    public void setSourceContentType(IContentType type) {
        if (this.sourceContentType != type) {
            this.sourceContentType = type;
            this.sourceContentTypeId = this.sourceContentType != null ? this.sourceContentType.getId() : null;
            this.setDirty(true);
        }
    }

    public String[] getSourceExtensionsAttribute() {
        if (this.inputExtensions == null || this.inputExtensions.size() == 0) {
            if (this.superClass != null) {
                return this.superClass.getSourceExtensionsAttribute();
            }
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions.toArray(new String[this.inputExtensions.size()]);
    }

    public void setSourceExtensionsAttribute(String extensions) {
        this.getInputExtensionsList().clear();
        if (extensions != null) {
            StringTokenizer tokenizer = new StringTokenizer(extensions, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInputExtensionsList().add(tokenizer.nextElement());
            }
        }
        this.setDirty(true);
    }

    public String[] getSourceExtensions(ITool tool) {
        IContentType type = this.getSourceContentType();
        if (type != null) {
            return ((Tool)tool).getContentTypeFileSpecs(type);
        }
        return this.getSourceExtensionsAttribute();
    }

    public boolean isSourceExtension(ITool tool, String ext) {
        String[] exts = this.getSourceExtensions(tool);
        int i = 0;
        while (i < exts.length) {
            if (ext.equals(exts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List getInputExtensionsList() {
        if (this.inputExtensions == null) {
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions;
    }

    public boolean isExtensionElement() {
        return this.isExtensionInputType;
    }

    public boolean isDirty() {
        Object current;
        if (this.isExtensionInputType) {
            return false;
        }
        Iterator typeIter = this.getInputOrderList().iterator();
        while (typeIter.hasNext()) {
            current = (InputOrder)typeIter.next();
            if (!((InputOrder)current).isDirty()) continue;
            return true;
        }
        typeIter = this.getAdditionalInputList().iterator();
        while (typeIter.hasNext()) {
            current = (AdditionalInput)typeIter.next();
            if (!((AdditionalInput)current).isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            Object current;
            Iterator typeIter = this.getInputOrderList().iterator();
            while (typeIter.hasNext()) {
                current = (InputOrder)typeIter.next();
                ((InputOrder)current).setDirty(false);
            }
            typeIter = this.getAdditionalInputList().iterator();
            while (typeIter.hasNext()) {
                current = (AdditionalInput)typeIter.next();
                ((AdditionalInput)current).setDirty(false);
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            Object current;
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.superClass = ManagedBuildManager.getExtensionInputType(this.superClassId);
                if (this.superClass == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "inputType", this.getId());
                }
            }
            IContentTypeManager manager = Platform.getContentTypeManager();
            if (this.sourceContentTypeId != null && this.sourceContentTypeId.length() > 0) {
                this.sourceContentType = manager.getContentType(this.sourceContentTypeId);
            }
            if (this.dependencyContentTypeId != null && this.dependencyContentTypeId.length() > 0) {
                this.dependencyContentType = manager.getContentType(this.dependencyContentTypeId);
            }
            Iterator typeIter = this.getInputOrderList().iterator();
            while (typeIter.hasNext()) {
                current = (InputOrder)typeIter.next();
                ((InputOrder)current).resolveReferences();
            }
            typeIter = this.getAdditionalInputList().iterator();
            while (typeIter.hasNext()) {
                current = (AdditionalInput)typeIter.next();
                ((AdditionalInput)current).resolveReferences();
            }
        }
    }

    public String getManagedBuildRevision() {
        if (this.managedBuildRevision == null && this.getParent() != null) {
            return this.getParent().getManagedBuildRevision();
        }
        return this.managedBuildRevision;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.getParent() != null) {
            return this.getParent().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }
}

