/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IEnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.EnvVarBuildPath;
import org.eclipse.cdt.managedbuilder.internal.core.HoldsOptions;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.OutputType;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildfileMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Tool
extends HoldsOptions
implements ITool,
IOptionCategory {
    public static final String DEFAULT_PATTERN = "${COMMAND} ${FLAGS} ${OUTPUT_FLAG}${OUTPUT_PREFIX}${OUTPUT} ${INPUTS}";
    public static final String DEFAULT_CBS_PATTERN = "${COMMAND}";
    private static final String DEFAULT_SEPARATOR = ",";
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String DEFAULT_ANNOUNCEMENT_PREFIX = "Tool.default.announcement";
    private static final String WHITESPACE = " ";
    private static final boolean resolvedDefault = true;
    private String superClassId;
    private IBuildObject parent;
    private Vector inputTypeList;
    private Map inputTypeMap;
    private Vector outputTypeList;
    private Map outputTypeMap;
    private List envVarBuildPathList;
    private String unusedChildren;
    private Boolean isAbstract;
    private String command;
    private List inputExtensions;
    private List interfaceExtensions;
    private Integer natureFilter;
    private String outputExtensions;
    private String outputFlag;
    private String outputPrefix;
    private String errorParserIds;
    private String commandLinePattern;
    private String versionsSupported;
    private String convertToId;
    private Boolean advancedInputCategory;
    private Boolean customBuildStep;
    private String announcement;
    private IConfigurationElement commandLineGeneratorElement = null;
    private IManagedCommandLineGenerator commandLineGenerator = null;
    private IConfigurationElement dependencyGeneratorElement = null;
    private IManagedDependencyGenerator dependencyGenerator = null;
    private URL iconPathURL;
    private boolean isExtensionTool = false;
    private boolean isDirty = false;
    private boolean resolved = true;
    private IConfigurationElement previousMbsVersionConversionElement = null;
    private IConfigurationElement currentMbsVersionConversionElement = null;

    public Tool(IManagedConfigElement element, String managedBuildRevision) {
        super(false);
        this.resolved = false;
        this.isExtensionTool = true;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionTool(this);
        this.addOptionCategory(this);
        IManagedConfigElement[] toolElements = element.getChildren();
        int l = 0;
        while (l < toolElements.length) {
            IManagedConfigElement toolElement = toolElements[l];
            if (!this.loadChild(toolElement)) {
                if (toolElement.getName().equals("inputType")) {
                    InputType inputType = new InputType((ITool)this, toolElement);
                    this.addInputType(inputType);
                } else if (toolElement.getName().equals("outputType")) {
                    OutputType outputType = new OutputType((ITool)this, toolElement);
                    this.addOutputType(outputType);
                } else if (toolElement.getName().equals("envVarBuildPath")) {
                    this.addEnvVarBuildPath(new EnvVarBuildPath(this, toolElement));
                }
            }
            ++l;
        }
    }

    public Tool(IBuildObject parent, IManagedConfigElement element, String managedBuildRevision) {
        this(element, managedBuildRevision);
        this.parent = parent;
    }

    public Tool(ToolChain parent, ITool superClass, String Id, String name, boolean isExtensionElement) {
        super(true);
        this.parent = parent;
        this.setSuperClass(superClass);
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        if (this.getSuperClass() != null) {
            this.superClassId = this.getSuperClass().getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setVersion(this.getVersionFromId());
        this.isExtensionTool = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionTool(this);
        } else {
            this.setDirty(true);
        }
    }

    public Tool(ResourceConfiguration parent, ITool superClass, String Id, String name, boolean isExtensionElement) {
        super(true);
        this.parent = parent;
        this.setSuperClass(superClass);
        this.setManagedBuildRevision(parent.getManagedBuildRevision());
        if (this.getSuperClass() != null) {
            this.superClassId = this.getSuperClass().getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setVersion(this.getVersionFromId());
        this.isExtensionTool = isExtensionElement;
        if (isExtensionElement) {
            ManagedBuildManager.addExtensionTool(this);
        } else {
            this.setDirty(true);
        }
    }

    public Tool(IBuildObject parent, Element element, String managedBuildRevision) {
        super(true);
        this.parent = parent;
        this.isExtensionTool = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
        this.addOptionCategory(this);
        NodeList toolElements = element.getChildNodes();
        int i = 0;
        while (i < toolElements.getLength()) {
            Node toolElement = toolElements.item(i);
            if (!this.loadChild(toolElement)) {
                if (toolElement.getNodeName().equals("inputType")) {
                    InputType inputType = new InputType((ITool)this, (Element)toolElement);
                    this.addInputType(inputType);
                } else if (toolElement.getNodeName().equals("outputType")) {
                    OutputType outputType = new OutputType((ITool)this, (Element)toolElement);
                    this.addOutputType(outputType);
                }
            }
            ++i;
        }
    }

    public Tool(IBuildObject parent, ITool toolSuperClass, String Id, String name, Tool tool) {
        super(true);
        String subName;
        String subId;
        int nnn;
        ListIterator iter;
        this.parent = parent;
        if (toolSuperClass != null) {
            this.setSuperClass(toolSuperClass);
        } else {
            this.setSuperClass(tool.getSuperClass());
        }
        if (this.getSuperClass() != null) {
            this.superClassId = this.getSuperClass().getId();
        }
        this.setId(Id);
        this.setName(name);
        this.setManagedBuildRevision(tool.getManagedBuildRevision());
        this.setVersion(this.getVersionFromId());
        this.isExtensionTool = false;
        if (tool.versionsSupported != null) {
            this.versionsSupported = new String(tool.versionsSupported);
        }
        if (tool.convertToId != null) {
            this.convertToId = new String(tool.convertToId);
        }
        if (tool.unusedChildren != null) {
            this.unusedChildren = new String(tool.unusedChildren);
        }
        if (tool.errorParserIds != null) {
            this.errorParserIds = new String(tool.errorParserIds);
        }
        if (tool.isAbstract != null) {
            this.isAbstract = new Boolean(tool.isAbstract);
        }
        if (tool.command != null) {
            this.command = new String(tool.command);
        }
        if (tool.commandLinePattern != null) {
            this.commandLinePattern = new String(tool.commandLinePattern);
        }
        if (tool.inputExtensions != null) {
            this.inputExtensions = new ArrayList(tool.inputExtensions);
        }
        if (tool.interfaceExtensions != null) {
            this.interfaceExtensions = new ArrayList(tool.interfaceExtensions);
        }
        if (tool.natureFilter != null) {
            this.natureFilter = new Integer(tool.natureFilter);
        }
        if (tool.outputExtensions != null) {
            this.outputExtensions = new String(tool.outputExtensions);
        }
        if (tool.outputFlag != null) {
            this.outputFlag = new String(tool.outputFlag);
        }
        if (tool.outputPrefix != null) {
            this.outputPrefix = new String(tool.outputPrefix);
        }
        if (tool.advancedInputCategory != null) {
            this.advancedInputCategory = new Boolean(tool.advancedInputCategory);
        }
        if (tool.customBuildStep != null) {
            this.customBuildStep = new Boolean(tool.customBuildStep);
        }
        if (tool.announcement != null) {
            this.announcement = new String(tool.announcement);
        }
        this.commandLineGeneratorElement = tool.commandLineGeneratorElement;
        this.commandLineGenerator = tool.commandLineGenerator;
        this.dependencyGeneratorElement = tool.dependencyGeneratorElement;
        this.dependencyGenerator = tool.dependencyGenerator;
        if (tool.envVarBuildPathList != null) {
            this.envVarBuildPathList = new ArrayList(tool.envVarBuildPathList);
        }
        super.copyChildren(tool);
        if (tool.inputTypeList != null) {
            iter = tool.getInputTypeList().listIterator();
            while (iter.hasNext()) {
                InputType inputType = (InputType)iter.next();
                nnn = ManagedBuildManager.getRandomNumber();
                if (inputType.getSuperClass() != null) {
                    subId = String.valueOf(inputType.getSuperClass().getId()) + "." + nnn;
                    subName = inputType.getSuperClass().getName();
                } else {
                    subId = String.valueOf(inputType.getId()) + "." + nnn;
                    subName = inputType.getName();
                }
                InputType newInputType = new InputType(this, subId, subName, inputType);
                this.addInputType(newInputType);
            }
        }
        if (tool.outputTypeList != null) {
            iter = tool.getOutputTypeList().listIterator();
            while (iter.hasNext()) {
                OutputType outputType = (OutputType)iter.next();
                nnn = ManagedBuildManager.getRandomNumber();
                if (outputType.getSuperClass() != null) {
                    subId = String.valueOf(outputType.getSuperClass().getId()) + "." + nnn;
                    subName = outputType.getSuperClass().getName();
                } else {
                    subId = String.valueOf(outputType.getId()) + "." + nnn;
                    subName = outputType.getName();
                }
                OutputType newOutputType = new OutputType(this, subId, subName, outputType);
                this.addOutputType(newOutputType);
            }
        }
        if (tool.iconPathURL != null) {
            this.iconPathURL = tool.iconPathURL;
        }
        this.setDirty(true);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        String depGenerator;
        String cbs;
        String headers;
        String inputs;
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        this.setVersion(this.getVersionFromId());
        this.superClassId = element.getAttribute("superClass");
        this.unusedChildren = element.getAttribute("unusedChildren");
        this.versionsSupported = element.getAttribute("versionsSupported");
        this.convertToId = element.getAttribute("convertToId");
        String isAbs = element.getAttribute("isAbstract");
        if (isAbs != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        this.errorParserIds = element.getAttribute("errorParsers");
        String nature = element.getAttribute("natureFilter");
        if (nature != null) {
            this.natureFilter = "both".equals(nature) ? new Integer(2) : ("cnature".equals(nature) ? new Integer(0) : ("ccnature".equals(nature) ? new Integer(1) : new Integer(2)));
        }
        if ((inputs = element.getAttribute("sources")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInputExtensionsList().add(tokenizer.nextElement());
            }
        }
        if ((headers = element.getAttribute("headerExtensions")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInterfaceExtensionsList().add(tokenizer.nextElement());
            }
        }
        this.outputExtensions = element.getAttribute("outputs");
        this.command = element.getAttribute("command");
        this.outputFlag = element.getAttribute("outputFlag");
        this.outputPrefix = element.getAttribute("outputPrefix");
        this.commandLinePattern = element.getAttribute("commandLinePattern");
        String advInput = element.getAttribute("advancedInputCategory");
        if (advInput != null) {
            this.advancedInputCategory = new Boolean("true".equals(advInput));
        }
        if ((cbs = element.getAttribute("customBuildStep")) != null) {
            this.customBuildStep = new Boolean("true".equals(cbs));
        }
        this.announcement = element.getAttribute("announcement");
        String commandLineGenerator = element.getAttribute("commandLineGenerator");
        if (commandLineGenerator != null && element instanceof DefaultManagedConfigElement) {
            this.commandLineGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if ((depGenerator = element.getAttribute("dependencyCalculator")) != null && element instanceof DefaultManagedConfigElement) {
            this.dependencyGeneratorElement = ((DefaultManagedConfigElement)element).getConfigurationElement();
        }
        if (element.getAttribute("icon") != null && element instanceof DefaultManagedConfigElement) {
            String icon = element.getAttribute("icon");
            this.iconPathURL = ManagedBuildManager.getURLInBuildDefinitions((DefaultManagedConfigElement)element, (IPath)new Path(icon));
        }
    }

    protected void loadFromProject(Element element) {
        String cbs;
        String advInput;
        String headers;
        StringTokenizer tokenizer;
        String inputs;
        String nature;
        String isAbs;
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        this.setVersion(this.getVersionFromId());
        this.superClassId = element.getAttribute("superClass");
        if (this.superClassId != null && this.superClassId.length() > 0) {
            if (this.getParent() instanceof IResourceConfiguration) {
                IResourceConfiguration resConfig = (IResourceConfiguration)this.getParent();
                this.setSuperClass(resConfig.getParent().getTool(this.superClassId));
            } else {
                this.setSuperClass(ManagedBuildManager.getExtensionTool(this.superClassId));
            }
            this.checkForMigrationSupport();
        }
        if (element.hasAttribute("unusedChildren")) {
            this.unusedChildren = element.getAttribute("unusedChildren");
        }
        if (element.hasAttribute("isAbstract") && (isAbs = element.getAttribute("isAbstract")) != null) {
            this.isAbstract = new Boolean("true".equals(isAbs));
        }
        if (element.hasAttribute("versionsSupported")) {
            this.versionsSupported = element.getAttribute("versionsSupported");
        }
        if (element.hasAttribute("convertToId")) {
            this.convertToId = element.getAttribute("convertToId");
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        if (element.hasAttribute("natureFilter") && (nature = element.getAttribute("natureFilter")) != null) {
            this.natureFilter = "both".equals(nature) ? new Integer(2) : ("cnature".equals(nature) ? new Integer(0) : ("ccnature".equals(nature) ? new Integer(1) : new Integer(2)));
        }
        if (element.hasAttribute("sources") && (inputs = element.getAttribute("sources")) != null) {
            tokenizer = new StringTokenizer(inputs, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInputExtensionsList().add(tokenizer.nextElement());
            }
        }
        if (element.hasAttribute("headerExtensions") && (headers = element.getAttribute("headerExtensions")) != null) {
            tokenizer = new StringTokenizer(headers, DEFAULT_SEPARATOR);
            while (tokenizer.hasMoreElements()) {
                this.getInterfaceExtensionsList().add(tokenizer.nextElement());
            }
        }
        if (element.hasAttribute("outputs")) {
            this.outputExtensions = element.getAttribute("outputs");
        }
        if (element.hasAttribute("command")) {
            this.command = element.getAttribute("command");
        }
        if (element.hasAttribute("outputFlag")) {
            this.outputFlag = element.getAttribute("outputFlag");
        }
        if (element.hasAttribute("outputPrefix")) {
            this.outputPrefix = element.getAttribute("outputPrefix");
        }
        if (element.hasAttribute("commandLinePattern")) {
            this.commandLinePattern = element.getAttribute("commandLinePattern");
        }
        if (element.hasAttribute("advancedInputCategory") && (advInput = element.getAttribute("advancedInputCategory")) != null) {
            this.advancedInputCategory = new Boolean("true".equals(advInput));
        }
        if (element.hasAttribute("customBuildStep") && (cbs = element.getAttribute("customBuildStep")) != null) {
            this.customBuildStep = new Boolean("true".equals(cbs));
        }
        if (element.hasAttribute("announcement")) {
            this.announcement = element.getAttribute("announcement");
        }
        if (element.hasAttribute("icon")) {
            String iconPath = element.getAttribute("icon");
            try {
                this.iconPathURL = new URL(iconPath);
            }
            catch (MalformedURLException malformedURLException) {
                ManagedBuildManager.OutputIconError(iconPath);
                this.iconPathURL = null;
            }
        }
    }

    public void serialize(Document doc, Element element) {
        try {
            Element typeElement;
            BuildObject type;
            ListIterator iter;
            List list;
            if (this.getSuperClass() != null) {
                element.setAttribute("superClass", this.getSuperClass().getId());
            }
            element.setAttribute("id", this.id);
            if (this.name != null) {
                element.setAttribute("name", this.name);
            }
            if (this.unusedChildren != null) {
                element.setAttribute("unusedChildren", this.unusedChildren);
            }
            if (this.isAbstract != null) {
                element.setAttribute("isAbstract", this.isAbstract.toString());
            }
            if (this.versionsSupported != null) {
                element.setAttribute("versionsSupported", this.versionsSupported);
            }
            if (this.convertToId != null) {
                element.setAttribute("convertToId", this.convertToId);
            }
            if (this.errorParserIds != null) {
                element.setAttribute("errorParsers", this.errorParserIds);
            }
            if (this.natureFilter != null) {
                String nature = this.natureFilter == 0 ? "cnature" : (this.natureFilter == 1 ? "ccnature" : "both");
                element.setAttribute("natureFilter", nature);
            }
            if (this.getInputExtensionsList().size() > 0) {
                list = this.getInputExtensionsList();
                iter = list.listIterator();
                String inputs = (String)iter.next();
                while (iter.hasNext()) {
                    inputs = String.valueOf(inputs) + DEFAULT_SEPARATOR;
                    inputs = String.valueOf(inputs) + iter.next();
                }
                element.setAttribute("sources", inputs);
            }
            if (this.getInterfaceExtensionsList().size() > 0) {
                list = this.getInterfaceExtensionsList();
                iter = list.listIterator();
                String headers = (String)iter.next();
                while (iter.hasNext()) {
                    headers = String.valueOf(headers) + DEFAULT_SEPARATOR;
                    headers = String.valueOf(headers) + iter.next();
                }
                element.setAttribute("headerExtensions", headers);
            }
            if (this.outputExtensions != null) {
                element.setAttribute("outputs", this.outputExtensions);
            }
            if (this.command != null) {
                element.setAttribute("command", this.command);
            }
            if (this.outputFlag != null) {
                element.setAttribute("outputFlag", this.outputFlag);
            }
            if (this.outputPrefix != null) {
                element.setAttribute("outputPrefix", this.outputPrefix);
            }
            if (this.commandLinePattern != null) {
                element.setAttribute("commandLinePattern", this.commandLinePattern);
            }
            if (this.advancedInputCategory != null) {
                element.setAttribute("advancedInputCategory", this.advancedInputCategory.toString());
            }
            if (this.customBuildStep != null) {
                element.setAttribute("customBuildStep", this.customBuildStep.toString());
            }
            if (this.announcement != null) {
                element.setAttribute("announcement", this.announcement);
            }
            super.serialize(doc, element);
            Vector typeElements = this.getInputTypeList();
            ListIterator iter2 = typeElements.listIterator();
            while (iter2.hasNext()) {
                type = (InputType)iter2.next();
                typeElement = doc.createElement("inputType");
                element.appendChild(typeElement);
                ((InputType)type).serialize(doc, typeElement);
            }
            typeElements = this.getOutputTypeList();
            iter2 = typeElements.listIterator();
            while (iter2.hasNext()) {
                type = (OutputType)iter2.next();
                typeElement = doc.createElement("outputType");
                element.appendChild(typeElement);
                ((OutputType)type).serialize(doc, typeElement);
            }
            if (this.iconPathURL != null) {
                element.setAttribute("icon", this.iconPathURL.toString());
            }
            this.isDirty = false;
        }
        catch (Exception exception) {}
    }

    public IBuildObject getParent() {
        return this.parent;
    }

    public void setToolParent(IBuildObject newParent) {
        this.parent = newParent;
    }

    public IOptionCategory getTopOptionCategory() {
        return this;
    }

    public IInputType createInputType(IInputType superClass, String Id, String name, boolean isExtensionElement) {
        InputType type = new InputType(this, superClass, Id, name, isExtensionElement);
        this.addInputType(type);
        this.setDirty(true);
        return type;
    }

    public void removeInputType(IInputType type) {
        this.getInputTypeList().remove(type);
        this.getInputTypeMap().remove(type.getId());
        this.setDirty(true);
    }

    public IInputType[] getInputTypes() {
        IInputType[] types = null;
        if (this.getSuperClass() != null) {
            types = this.getSuperClass().getInputTypes();
        }
        Vector ourTypes = this.getInputTypeList();
        if (types != null) {
            int i = 0;
            while (i < ourTypes.size()) {
                IInputType ourType = (IInputType)ourTypes.get(i);
                int j = 0;
                while (j < types.length) {
                    if (ourType.getSuperClass() != null && ourType.getSuperClass().getId().equals(types[j].getId())) {
                        types[j] = ourType;
                        break;
                    }
                    ++j;
                }
                if (j == types.length) {
                    IInputType[] newTypes = new IInputType[types.length + 1];
                    int k = 0;
                    while (k < types.length) {
                        newTypes[k] = types[k];
                        ++k;
                    }
                    newTypes[j] = ourType;
                    types = newTypes;
                }
                ++i;
            }
        } else {
            types = ourTypes.toArray(new IInputType[ourTypes.size()]);
        }
        return types;
    }

    private boolean hasInputTypes() {
        Vector ourTypes = this.getInputTypeList();
        return ourTypes.size() > 0;
    }

    public IInputType getInputTypeById(String id) {
        IInputType type = (IInputType)this.getInputTypeMap().get(id);
        if (type == null && this.getSuperClass() != null) {
            return this.getSuperClass().getInputTypeById(id);
        }
        return type;
    }

    public IOutputType createOutputType(IOutputType superClass, String Id, String name, boolean isExtensionElement) {
        OutputType type = new OutputType(this, superClass, Id, name, isExtensionElement);
        this.addOutputType(type);
        this.setDirty(true);
        return type;
    }

    public void removeOutputType(IOutputType type) {
        this.getOutputTypeList().remove(type);
        this.getOutputTypeMap().remove(type.getId());
        this.setDirty(true);
    }

    public IOutputType[] getOutputTypes() {
        IOutputType[] types = null;
        if (this.getSuperClass() != null) {
            types = this.getSuperClass().getOutputTypes();
        }
        Vector ourTypes = this.getOutputTypeList();
        if (types != null) {
            int i = 0;
            while (i < ourTypes.size()) {
                IOutputType ourType = (IOutputType)ourTypes.get(i);
                int j = 0;
                while (j < types.length) {
                    if (ourType.getSuperClass() != null && ourType.getSuperClass().getId().equals(types[j].getId())) {
                        types[j] = ourType;
                        break;
                    }
                    ++j;
                }
                if (j == types.length) {
                    IOutputType[] newTypes = new IOutputType[types.length + 1];
                    int k = 0;
                    while (k < types.length) {
                        newTypes[k] = types[k];
                        ++k;
                    }
                    newTypes[j] = ourType;
                    types = newTypes;
                }
                ++i;
            }
        } else {
            types = ourTypes.toArray(new IOutputType[ourTypes.size()]);
        }
        return types;
    }

    private boolean hasOutputTypes() {
        Vector ourTypes = this.getOutputTypeList();
        return ourTypes.size() > 0;
    }

    public IOutputType getPrimaryOutputType() {
        IOutputType type = null;
        IOutputType[] types = this.getOutputTypes();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                if (i == 0) {
                    type = types[0];
                }
                if (types[i].getPrimaryOutput()) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    public IOutputType getOutputTypeById(String id) {
        IOutputType type = (IOutputType)this.getOutputTypeMap().get(id);
        if (type == null && this.getSuperClass() != null) {
            return this.getSuperClass().getOutputTypeById(id);
        }
        return type;
    }

    public IOptionCategory getOwner() {
        return null;
    }

    public URL getIconPath() {
        if (this.iconPathURL == null && this.getSuperClass() != null) {
            return this.getSuperClass().getTopOptionCategory().getIconPath();
        }
        return this.iconPathURL;
    }

    public Object[][] getOptions(IConfiguration configuration, IHoldsOptions optionHolder) {
        if (optionHolder != this) {
            return null;
        }
        return this.getOptions(configuration);
    }

    public Object[][] getOptions(IConfiguration configuration) {
        if (configuration != null) {
            ITool[] tools = configuration.getTools();
            return this.getOptions(tools);
        }
        return this.getAllOptions(this);
    }

    public Object[][] getOptions(IResourceConfiguration resConfig, IHoldsOptions optionHolder) {
        if (optionHolder != this) {
            return null;
        }
        return this.getOptions(resConfig);
    }

    public Object[][] getOptions(IResourceConfiguration resConfig) {
        ITool[] tools = resConfig.getTools();
        return this.getOptions(tools);
    }

    private Object[][] getOptions(ITool[] tools) {
        Tool catTool = this;
        ITool tool = null;
        int i = 0;
        while (i < tools.length) {
            ITool current = tools[i];
            do {
                if (catTool != current) continue;
                tool = tools[i];
                break;
            } while ((current = current.getSuperClass()) != null);
            if (tool != null) break;
            ++i;
        }
        if (tool == null) {
            return null;
        }
        return this.getAllOptions(tool);
    }

    private Object[][] getAllOptions(ITool tool) {
        IOption[] allOptions = tool.getOptions();
        Object[][] myOptions = new Object[allOptions.length][2];
        int index = 0;
        int i = 0;
        while (i < allOptions.length) {
            IOption option = allOptions[i];
            IOptionCategory optCat = option.getCategory();
            if (optCat instanceof ITool) {
                ITool current = this;
                boolean match = false;
                do {
                    if (optCat != current) continue;
                    match = true;
                    break;
                } while ((current = current.getSuperClass()) != null);
                if (match) {
                    myOptions[index] = new Object[2];
                    myOptions[index][0] = tool;
                    myOptions[index][1] = option;
                    ++index;
                }
            }
            ++i;
        }
        return myOptions;
    }

    public ITool getTool() {
        return this;
    }

    public IHoldsOptions getOptionHolder() {
        return this;
    }

    private Vector getInputTypeList() {
        if (this.inputTypeList == null) {
            this.inputTypeList = new Vector();
        }
        return this.inputTypeList;
    }

    private Map getInputTypeMap() {
        if (this.inputTypeMap == null) {
            this.inputTypeMap = new HashMap();
        }
        return this.inputTypeMap;
    }

    public void addInputType(InputType type) {
        this.getInputTypeList().add(type);
        this.getInputTypeMap().put(type.getId(), type);
    }

    private Vector getOutputTypeList() {
        if (this.outputTypeList == null) {
            this.outputTypeList = new Vector();
        }
        return this.outputTypeList;
    }

    private Map getOutputTypeMap() {
        if (this.outputTypeMap == null) {
            this.outputTypeMap = new HashMap();
        }
        return this.outputTypeMap;
    }

    public void addOutputType(OutputType type) {
        this.getOutputTypeList().add(type);
        this.getOutputTypeMap().put(type.getId(), type);
    }

    public ITool getSuperClass() {
        return (ITool)this.superClass;
    }

    private void setSuperClass(ITool superClass) {
        this.superClass = superClass;
    }

    public String getName() {
        return this.name == null && this.getSuperClass() != null ? this.getSuperClass().getName() : this.name;
    }

    public boolean isAbstract() {
        if (this.isAbstract != null) {
            return this.isAbstract;
        }
        return false;
    }

    public void setIsAbstract(boolean b) {
        this.isAbstract = new Boolean(b);
        this.setDirty(true);
    }

    public String getUnusedChildren() {
        if (this.unusedChildren != null) {
            return this.unusedChildren;
        }
        return EMPTY_STRING;
    }

    public String getErrorParserIds() {
        String ids = this.errorParserIds;
        if (ids == null && this.getSuperClass() != null) {
            ids = this.getSuperClass().getErrorParserIds();
        }
        return ids;
    }

    public String[] getErrorParserList() {
        String[] errorParsers;
        String parserIDs = this.getErrorParserIds();
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = new String[]{};
        }
        return errorParsers;
    }

    public List getInputExtensions() {
        String[] exts = this.getPrimaryInputExtensions();
        ArrayList<String> extList = new ArrayList<String>();
        int i = 0;
        while (i < exts.length) {
            extList.add(exts[i]);
            ++i;
        }
        return extList;
    }

    private List getInputExtensionsAttribute() {
        if (this.inputExtensions == null || this.inputExtensions.size() == 0) {
            if (this.getSuperClass() != null) {
                return ((Tool)this.getSuperClass()).getInputExtensionsAttribute();
            }
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions;
    }

    private List getInputExtensionsList() {
        if (this.inputExtensions == null) {
            this.inputExtensions = new ArrayList();
        }
        return this.inputExtensions;
    }

    public String getDefaultInputExtension() {
        String[] exts;
        IInputType type = this.getPrimaryInputType();
        if (type != null && (exts = type.getSourceExtensions(this)).length > 0) {
            return exts[0];
        }
        List extsList = this.getInputExtensionsAttribute();
        if (extsList != null && extsList.size() > 0) {
            return (String)extsList.get(0);
        }
        return EMPTY_STRING;
    }

    public String[] getPrimaryInputExtensions() {
        String[] exts;
        IInputType type = this.getPrimaryInputType();
        if (type != null && (exts = type.getSourceExtensions(this)).length > 0) {
            return exts;
        }
        List extsList = this.getInputExtensionsAttribute();
        if (extsList != null && extsList.size() > 0) {
            return extsList.toArray(new String[extsList.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getAllInputExtensions() {
        List extsList;
        IInputType[] types = this.getInputTypes();
        if (types != null && types.length > 0) {
            ArrayList<String> allExts = new ArrayList<String>();
            int i = 0;
            while (i < types.length) {
                String[] exts = types[i].getSourceExtensions(this);
                int j = 0;
                while (j < exts.length) {
                    allExts.add(exts[j]);
                    ++j;
                }
                ++i;
            }
            if (allExts.size() > 0) {
                return allExts.toArray(new String[allExts.size()]);
            }
        }
        if ((extsList = this.getInputExtensionsAttribute()) != null && extsList.size() > 0) {
            return extsList.toArray(new String[extsList.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    public IInputType getPrimaryInputType() {
        IInputType type = null;
        IInputType[] types = this.getInputTypes();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                if (i == 0) {
                    type = types[0];
                }
                if (types[i].getPrimaryInput()) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    public IInputType getInputType(String inputExtension) {
        IInputType type = null;
        IInputType[] types = this.getInputTypes();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                if (types[i].isSourceExtension(this, inputExtension)) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    public IPath[] getAdditionalDependencies() {
        ArrayList<Object> allDeps = new ArrayList<Object>();
        IInputType[] types = this.getInputTypes();
        int i = 0;
        while (i < types.length) {
            IInputType type = types[i];
            IPath[] deps = type.getAdditionalDependencies();
            int j = 0;
            while (j < deps.length) {
                allDeps.add(deps[j]);
                ++j;
            }
            if (type != this.getPrimaryInputType()) {
                if (type.getOptionId() != null) {
                    IOption option = this.getOptionBySuperClassId(type.getOptionId());
                    if (option != null) {
                        try {
                            ArrayList<IPath> inputs = new ArrayList<IPath>();
                            int optType = option.getValueType();
                            if (optType == 2) {
                                inputs.add(Path.fromOSString((String)option.getStringValue()));
                            } else if (optType == 3 || optType == 6 || optType == 7) {
                                List inputNames = (List)option.getValue();
                                int j2 = 0;
                                while (j2 < inputNames.size()) {
                                    inputs.add(Path.fromOSString((String)((String)inputNames.get(j2))));
                                    ++j2;
                                }
                            }
                            allDeps.addAll(inputs);
                        }
                        catch (BuildException buildException) {}
                    }
                } else if (type.getBuildVariable() != null && type.getBuildVariable().length() > 0) {
                    allDeps.add(Path.fromOSString((String)("$(" + type.getBuildVariable() + ")")));
                }
            }
            ++i;
        }
        return allDeps.toArray(new IPath[allDeps.size()]);
    }

    public IPath[] getAdditionalResources() {
        ArrayList<IPath> allRes = new ArrayList<IPath>();
        IInputType[] types = this.getInputTypes();
        int i = 0;
        while (i < types.length) {
            String var;
            IInputType type = types[i];
            IPath[] res = type.getAdditionalResources();
            int j = 0;
            while (j < res.length) {
                allRes.add(res[j]);
                ++j;
            }
            if (type != this.getPrimaryInputType() && (var = type.getBuildVariable()) != null && var.length() > 0) {
                allRes.add(Path.fromOSString((String)("$(" + type.getBuildVariable() + ")")));
            }
            ++i;
        }
        return allRes.toArray(new IPath[allRes.size()]);
    }

    public String[] getAllDependencyExtensions() {
        List extsList;
        IInputType[] types = this.getInputTypes();
        if (types != null && types.length > 0) {
            ArrayList<String> allExts = new ArrayList<String>();
            int i = 0;
            while (i < types.length) {
                String[] exts = types[i].getDependencyExtensions(this);
                int j = 0;
                while (j < exts.length) {
                    allExts.add(exts[j]);
                    ++j;
                }
                ++i;
            }
            if (allExts.size() > 0) {
                return allExts.toArray(new String[allExts.size()]);
            }
        }
        if ((extsList = this.getHeaderExtensionsAttribute()) != null && extsList.size() > 0) {
            return extsList.toArray(new String[extsList.size()]);
        }
        return EMPTY_STRING_ARRAY;
    }

    public List getInterfaceExtensions() {
        return this.getHeaderExtensionsAttribute();
    }

    private List getHeaderExtensionsAttribute() {
        if (this.interfaceExtensions == null || this.interfaceExtensions.size() == 0) {
            if (this.getSuperClass() != null) {
                return ((Tool)this.getSuperClass()).getHeaderExtensionsAttribute();
            }
            if (this.interfaceExtensions == null) {
                this.interfaceExtensions = new ArrayList();
            }
        }
        return this.interfaceExtensions;
    }

    private List getInterfaceExtensionsList() {
        if (this.interfaceExtensions == null) {
            this.interfaceExtensions = new ArrayList();
        }
        return this.interfaceExtensions;
    }

    public String getOutputFlag() {
        if (this.outputFlag == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getOutputFlag();
            }
            return EMPTY_STRING;
        }
        return this.outputFlag;
    }

    public String getOutputPrefix() {
        IOutputType type = null;
        IOutputType[] types = this.getOutputTypes();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                if (i == 0) {
                    type = types[0];
                }
                if (types[i].getPrimaryOutput()) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        }
        if (type != null) {
            return type.getOutputPrefix();
        }
        if (this.outputPrefix == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getOutputPrefix();
            }
            return EMPTY_STRING;
        }
        return this.outputPrefix;
    }

    public String getToolCommand() {
        if (this.command == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getToolCommand();
            }
            return EMPTY_STRING;
        }
        return this.command;
    }

    public String getCommandLinePattern() {
        if (this.commandLinePattern == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getCommandLinePattern();
            }
            if (this.getCustomBuildStep()) {
                return new String(DEFAULT_CBS_PATTERN);
            }
            return new String(DEFAULT_PATTERN);
        }
        return this.commandLinePattern;
    }

    public boolean getAdvancedInputCategory() {
        if (this.advancedInputCategory == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getAdvancedInputCategory();
            }
            return false;
        }
        return this.advancedInputCategory;
    }

    public boolean getCustomBuildStep() {
        if (this.customBuildStep == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getCustomBuildStep();
            }
            return false;
        }
        return this.customBuildStep;
    }

    public String getAnnouncement() {
        if (this.announcement == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getAnnouncement();
            }
            String defaultAnnouncement = String.valueOf(ManagedMakeMessages.getResourceString(DEFAULT_ANNOUNCEMENT_PREFIX)) + WHITESPACE + this.getName();
            return defaultAnnouncement;
        }
        return this.announcement;
    }

    public IConfigurationElement getCommandLineGeneratorElement() {
        if (this.commandLineGeneratorElement == null && this.getSuperClass() != null) {
            return ((Tool)this.getSuperClass()).getCommandLineGeneratorElement();
        }
        return this.commandLineGeneratorElement;
    }

    public void setCommandLineGeneratorElement(IConfigurationElement element) {
        this.commandLineGeneratorElement = element;
        this.setDirty(true);
    }

    public IManagedCommandLineGenerator getCommandLineGenerator() {
        if (this.commandLineGenerator != null) {
            return this.commandLineGenerator;
        }
        IConfigurationElement element = this.getCommandLineGeneratorElement();
        if (element != null) {
            try {
                if (element.getAttribute("commandLineGenerator") != null) {
                    this.commandLineGenerator = (IManagedCommandLineGenerator)element.createExecutableExtension("commandLineGenerator");
                    return this.commandLineGenerator;
                }
            }
            catch (CoreException coreException) {}
        }
        return ManagedCommandLineGenerator.getCommandLineGenerator();
    }

    public IConfigurationElement getDependencyGeneratorElement() {
        IConfigurationElement primary;
        IInputType type = this.getPrimaryInputType();
        if (type != null && (primary = ((InputType)type).getDependencyGeneratorElement()) != null) {
            return primary;
        }
        return this.getToolDependencyGeneratorElement();
    }

    public IConfigurationElement getDependencyGeneratorElementForExtension(String sourceExt) {
        IInputType[] types = this.getInputTypes();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                if (types[i].isSourceExtension(this, sourceExt)) {
                    return ((InputType)types[i]).getDependencyGeneratorElement();
                }
                ++i;
            }
        }
        return this.getToolDependencyGeneratorElement();
    }

    private IConfigurationElement getToolDependencyGeneratorElement() {
        if (this.dependencyGeneratorElement == null && this.getSuperClass() != null) {
            return ((Tool)this.getSuperClass()).getToolDependencyGeneratorElement();
        }
        return this.dependencyGeneratorElement;
    }

    public void setDependencyGeneratorElement(IConfigurationElement element) {
        this.dependencyGeneratorElement = element;
        this.setDirty(true);
    }

    public IManagedDependencyGenerator getDependencyGenerator() {
        if (this.dependencyGenerator != null) {
            return this.dependencyGenerator;
        }
        IConfigurationElement element = this.getDependencyGeneratorElement();
        if (element != null) {
            try {
                if (element.getAttribute("dependencyCalculator") != null) {
                    this.dependencyGenerator = (IManagedDependencyGenerator)element.createExecutableExtension("dependencyCalculator");
                    return this.dependencyGenerator;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public IManagedDependencyGenerator getDependencyGeneratorForExtension(String sourceExt) {
        if (this.dependencyGenerator != null) {
            return this.dependencyGenerator;
        }
        IConfigurationElement element = this.getDependencyGeneratorElementForExtension(sourceExt);
        if (element != null) {
            try {
                if (element.getAttribute("dependencyCalculator") != null) {
                    this.dependencyGenerator = (IManagedDependencyGenerator)element.createExecutableExtension("dependencyCalculator");
                    return this.dependencyGenerator;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public int getNatureFilter() {
        if (this.natureFilter == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getNatureFilter();
            }
            return 2;
        }
        return this.natureFilter;
    }

    public String[] getAllOutputExtensions() {
        String[] extsList;
        IOutputType[] types = this.getOutputTypes();
        if (types != null && types.length > 0) {
            ArrayList<String> allExts = new ArrayList<String>();
            int i = 0;
            while (i < types.length) {
                String[] exts = types[i].getOutputExtensions(this);
                if (exts != null) {
                    int j = 0;
                    while (j < exts.length) {
                        allExts.add(exts[j]);
                        ++j;
                    }
                }
                ++i;
            }
            if (allExts.size() > 0) {
                return allExts.toArray(new String[allExts.size()]);
            }
        }
        if ((extsList = this.getOutputsAttribute()) != null && extsList.length > 0) {
            return extsList;
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getOutputExtensions() {
        return this.getOutputsAttribute();
    }

    public String[] getOutputsAttribute() {
        if (this.outputExtensions == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getOutputsAttribute();
            }
            return null;
        }
        return this.outputExtensions.split(DEFAULT_SEPARATOR);
    }

    public String getOutputExtension(String inputExtension) {
        String[] exts;
        int i;
        IOutputType[] types = this.getOutputTypes();
        if (types != null) {
            IOutputType outType;
            i = 0;
            while (i < types.length) {
                IInputType inputType = types[i].getPrimaryInputType();
                if (inputType != null && inputType.isSourceExtension(this, inputExtension) && (exts = types[i].getOutputExtensions(this)) != null && exts.length > 0) {
                    return exts[0];
                }
                ++i;
            }
            if (this.getInputType(inputExtension) != null && (exts = (outType = this.getPrimaryOutputType()).getOutputExtensions(this)) != null && exts.length > 0) {
                return exts[0];
            }
        }
        String[] inputExts = this.getAllInputExtensions();
        i = 0;
        while (i < inputExts.length) {
            if (inputExts[i].equals(inputExtension) && (exts = this.getOutputsAttribute()) != null) {
                if (i < exts.length) {
                    return exts[i];
                }
                return exts[exts.length - 1];
            }
            ++i;
        }
        return null;
    }

    public IOutputType getOutputType(String outputExtension) {
        IOutputType type = null;
        IOutputType[] types = this.getOutputTypes();
        if (types != null && types.length > 0) {
            int i = 0;
            while (i < types.length) {
                if (types[i].isOutputExtension(this, outputExtension)) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        }
        return type;
    }

    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public boolean setToolCommand(String cmd) {
        if (cmd == null && this.command == null) {
            return false;
        }
        if (cmd == null || this.command == null || !cmd.equals(this.command)) {
            this.command = cmd;
            this.isDirty = true;
            return true;
        }
        return false;
    }

    public void setCommandLinePattern(String pattern) {
        if (pattern == null && this.commandLinePattern == null) {
            return;
        }
        if (pattern == null || this.commandLinePattern == null || !pattern.equals(this.commandLinePattern)) {
            this.commandLinePattern = pattern;
            this.isDirty = true;
        }
    }

    public void setOutputFlag(String flag) {
        if (flag == null && this.outputFlag == null) {
            return;
        }
        if (this.outputFlag == null || flag == null || !flag.equals(this.outputFlag)) {
            this.outputFlag = flag;
            this.isDirty = true;
        }
    }

    public void setOutputPrefix(String prefix) {
        if (prefix == null && this.outputPrefix == null) {
            return;
        }
        if (this.outputPrefix == null || prefix == null || !prefix.equals(this.outputPrefix)) {
            this.outputPrefix = prefix;
            this.isDirty = true;
        }
    }

    public void setOutputsAttribute(String ext) {
        if (ext == null && this.outputExtensions == null) {
            return;
        }
        if (this.outputExtensions == null || ext == null || !ext.equals(this.outputExtensions)) {
            this.outputExtensions = ext;
            this.isDirty = true;
        }
    }

    public void setAdvancedInputCategory(boolean b) {
        if (this.advancedInputCategory == null || b != this.advancedInputCategory) {
            this.advancedInputCategory = new Boolean(b);
            this.setDirty(true);
        }
    }

    public void setCustomBuildStep(boolean b) {
        if (this.customBuildStep == null || b != this.customBuildStep) {
            this.customBuildStep = new Boolean(b);
            this.setDirty(true);
        }
    }

    public void setAnnouncement(String newText) {
        if (newText == null && this.announcement == null) {
            return;
        }
        if (this.announcement == null || newText == null || !newText.equals(this.announcement)) {
            this.announcement = newText;
            this.setDirty(true);
        }
    }

    public String[] getCommandFlags() throws BuildException {
        return this.getToolCommandFlags(null, null);
    }

    public String getToolFlags() throws BuildException {
        return this.getToolCommandFlagsString(null, null);
    }

    public String[] getToolCommandFlags(IPath inputFileLocation, IPath outputFileLocation, IMacroSubstitutor macroSubstitutor) throws BuildException {
        IOption[] opts = this.getOptions();
        ArrayList<String> flags = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < opts.length) {
            IOption option = opts[index];
            sb.setLength(0);
            IOptionApplicability applicabilityCalculator = option.getApplicabilityCalculator();
            IBuildObject config = null;
            IBuildObject parent = this.getParent();
            if (parent instanceof IResourceConfiguration) {
                config = parent;
            } else if (parent instanceof IToolChain) {
                config = ((IToolChain)parent).getParent();
            }
            if (applicabilityCalculator == null || applicabilityCalculator.isOptionUsedInCommandLine(config, this, option)) {
                try {
                    switch (option.getValueType()) {
                        case 0: {
                            String boolCmd = option.getBooleanValue() ? option.getCommand() : option.getCommandFalse();
                            if (boolCmd == null || boolCmd.length() <= 0) break;
                            sb.append(boolCmd);
                            break;
                        }
                        case 1: {
                            String enumVal = option.getEnumCommand(option.getSelectedEnum());
                            if (enumVal.length() <= 0) break;
                            sb.append(enumVal);
                            break;
                        }
                        case 2: {
                            String strCmd = option.getCommand();
                            String val = option.getStringValue();
                            macroSubstitutor.setMacroContextInfo(1, new FileContextData(inputFileLocation, outputFileLocation, option, this));
                            if (val.length() <= 0 || (val = MacroResolver.resolveToString(val, macroSubstitutor)).length() <= 0) break;
                            sb.append(this.evaluateCommand(strCmd, val));
                            break;
                        }
                        case 3: {
                            String listCmd = option.getCommand();
                            macroSubstitutor.setMacroContextInfo(1, new FileContextData(inputFileLocation, outputFileLocation, option, this));
                            String[] list = MacroResolver.resolveStringListValues(option.getStringListValue(), macroSubstitutor, true);
                            if (list == null) break;
                            int j = 0;
                            while (j < list.length) {
                                String temp = list[j];
                                if (temp.length() > 0) {
                                    sb.append(String.valueOf(this.evaluateCommand(listCmd, temp)) + WHITESPACE);
                                }
                                ++j;
                            }
                            break;
                        }
                        case 4: {
                            String incCmd = option.getCommand();
                            macroSubstitutor.setMacroContextInfo(1, new FileContextData(inputFileLocation, outputFileLocation, option, this));
                            String[] paths = MacroResolver.resolveStringListValues(option.getIncludePaths(), macroSubstitutor, true);
                            if (paths == null) break;
                            int j = 0;
                            while (j < paths.length) {
                                String temp = paths[j];
                                if (temp.length() > 0) {
                                    sb.append(String.valueOf(this.evaluateCommand(incCmd, temp)) + WHITESPACE);
                                }
                                ++j;
                            }
                            break;
                        }
                        case 5: {
                            String defCmd = option.getCommand();
                            macroSubstitutor.setMacroContextInfo(1, new FileContextData(inputFileLocation, outputFileLocation, option, this));
                            String[] symbols = MacroResolver.resolveStringListValues(option.getDefinedSymbols(), macroSubstitutor, true);
                            if (symbols == null) break;
                            int j = 0;
                            while (j < symbols.length) {
                                String temp = symbols[j];
                                if (temp.length() > 0) {
                                    sb.append(String.valueOf(this.evaluateCommand(defCmd, temp)) + WHITESPACE);
                                }
                                ++j;
                            }
                            break;
                        }
                    }
                    if (sb.toString().trim().length() > 0) {
                        flags.add(sb.toString().trim());
                    }
                }
                catch (BuildMacroException buildMacroException) {}
            }
            ++index;
        }
        String[] f = new String[flags.size()];
        return flags.toArray(f);
    }

    public String[] getToolCommandFlags(IPath inputFileLocation, IPath outputFileLocation) throws BuildException {
        BuildfileMacroSubstitutor macroSubstitutor = new BuildfileMacroSubstitutor(null, EMPTY_STRING, WHITESPACE);
        return this.getToolCommandFlags(inputFileLocation, outputFileLocation, macroSubstitutor);
    }

    public String getToolCommandFlagsString(IPath inputFileLocation, IPath outputFileLocation) throws BuildException {
        StringBuffer buf = new StringBuffer();
        String[] flags = this.getToolCommandFlags(inputFileLocation, outputFileLocation);
        int index = 0;
        while (index < flags.length) {
            if (flags[index] != null) {
                buf.append(String.valueOf(flags[index]) + WHITESPACE);
            }
            ++index;
        }
        return buf.toString().trim();
    }

    public boolean isHeaderFile(String ext) {
        if (ext == null) {
            return false;
        }
        String[] exts = this.getAllDependencyExtensions();
        int i = 0;
        while (i < exts.length) {
            if (ext.equals(exts[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean buildsFileType(String extension) {
        if (extension == null) {
            return false;
        }
        IInputType it = this.getInputType(extension);
        if (it != null) {
            if (it == this.getPrimaryInputType()) {
                return true;
            }
            if (it.getOptionId() != null && it.getOptionId().length() > 0) {
                return false;
            }
            return it.getAssignToOptionId() == null || it.getAssignToOptionId().length() <= 0;
        }
        if (!this.hasInputTypes()) {
            return this.getInputExtensionsAttribute().contains(extension);
        }
        return false;
    }

    public boolean isInputFileType(String extension) {
        if (extension == null) {
            return false;
        }
        IInputType it = this.getInputType(extension);
        if (it != null) {
            return true;
        }
        if (!this.hasInputTypes()) {
            return this.getInputExtensionsAttribute().contains(extension);
        }
        return false;
    }

    public boolean producesFileType(String extension) {
        String[] exts;
        if (extension == null) {
            return false;
        }
        if (this.getOutputType(extension) != null) {
            return true;
        }
        if (!this.hasOutputTypes() && (exts = this.getOutputsAttribute()) != null) {
            int i = 0;
            while (i < exts.length) {
                if (exts[i].equals(extension)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isExtensionElement() {
        return this.isExtensionTool;
    }

    public boolean isDirty() {
        BuildObject type;
        if (this.isExtensionTool) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        Vector typeElements = this.getInputTypeList();
        ListIterator iter = typeElements.listIterator();
        while (iter.hasNext()) {
            type = (InputType)iter.next();
            if (!((InputType)type).isDirty()) continue;
            return true;
        }
        typeElements = this.getOutputTypeList();
        iter = typeElements.listIterator();
        while (iter.hasNext()) {
            type = (OutputType)iter.next();
            if (!((OutputType)type).isDirty()) continue;
            return true;
        }
        if (super.isDirty()) {
            return true;
        }
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        super.setDirty(isDirty);
        if (!isDirty) {
            BuildObject type;
            Vector typeElements = this.getInputTypeList();
            ListIterator iter = typeElements.listIterator();
            while (iter.hasNext()) {
                type = (InputType)iter.next();
                ((InputType)type).setDirty(false);
            }
            typeElements = this.getOutputTypeList();
            iter = typeElements.listIterator();
            while (iter.hasNext()) {
                type = (OutputType)iter.next();
                ((OutputType)type).setDirty(false);
            }
        }
    }

    public void resolveReferences() {
        if (!this.resolved) {
            BuildObject current;
            this.resolved = true;
            if (this.superClassId != null && this.superClassId.length() > 0) {
                this.setSuperClass(ManagedBuildManager.getExtensionTool(this.superClassId));
                if (this.getSuperClass() == null) {
                    ManagedBuildManager.OutputResolveError("superClass", this.superClassId, "tool", this.getId());
                }
            }
            super.resolveReferences();
            Iterator typeIter = this.getInputTypeList().iterator();
            while (typeIter.hasNext()) {
                current = (InputType)typeIter.next();
                ((InputType)current).resolveReferences();
            }
            typeIter = this.getOutputTypeList().iterator();
            while (typeIter.hasNext()) {
                current = (OutputType)typeIter.next();
                ((OutputType)current).resolveReferences();
            }
        }
    }

    public String evaluateCommand(String command, String values) {
        int len;
        int index;
        if (command == null) {
            return values.trim();
        }
        String ret = command;
        boolean found = false;
        int start = 0;
        while ((index = ret.indexOf("${", start)) >= 0 && (len = ret.length()) >= index + 8) {
            start = index;
            char ch = ret.charAt(index += 2);
            if (!(ch != 'v' && ch != 'V' || (ch = ret.charAt(++index)) != 'a' && ch != 'A' || (ch = ret.charAt(++index)) != 'l' && ch != 'L' || (ch = ret.charAt(++index)) != 'u' && ch != 'U' || (ch = ret.charAt(++index)) != 'e' && ch != 'E' || (ch = ret.charAt(++index)) != '}')) {
                String temp = "";
                ++index;
                found = true;
                if (start > 0) {
                    temp = ret.substring(0, start);
                }
                temp = temp.concat(values.trim());
                if (len > index) {
                    start = temp.length();
                    ret = temp.concat(ret.substring(index));
                    index = start;
                } else {
                    ret = temp;
                    break;
                }
            }
            start = index;
        }
        if (found) {
            return ret.trim();
        }
        return new String(String.valueOf(command) + values).trim();
    }

    public String getConvertToId() {
        if (this.convertToId == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getConvertToId();
            }
            return EMPTY_STRING;
        }
        return this.convertToId;
    }

    public void setConvertToId(String convertToId) {
        if (convertToId == null && this.convertToId == null) {
            return;
        }
        if (convertToId == null || this.convertToId == null || !convertToId.equals(this.convertToId)) {
            this.convertToId = convertToId;
            this.setDirty(true);
        }
    }

    public String getVersionsSupported() {
        if (this.versionsSupported == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().getVersionsSupported();
            }
            return EMPTY_STRING;
        }
        return this.versionsSupported;
    }

    public void setVersionsSupported(String versionsSupported) {
        if (versionsSupported == null && this.versionsSupported == null) {
            return;
        }
        if (versionsSupported == null || this.versionsSupported == null || !versionsSupported.equals(this.versionsSupported)) {
            this.versionsSupported = versionsSupported;
            this.setDirty(true);
        }
    }

    public IEnvVarBuildPath[] getEnvVarBuildPaths() {
        if (this.envVarBuildPathList != null) {
            return this.envVarBuildPathList.toArray(new IEnvVarBuildPath[this.envVarBuildPathList.size()]);
        }
        if (this.getSuperClass() != null) {
            return this.getSuperClass().getEnvVarBuildPaths();
        }
        return null;
    }

    private void addEnvVarBuildPath(IEnvVarBuildPath path) {
        if (path == null) {
            return;
        }
        if (this.envVarBuildPathList == null) {
            this.envVarBuildPathList = new ArrayList();
        }
        this.envVarBuildPathList.add(path);
    }

    public void checkForMigrationSupport() {
        boolean isExists = false;
        if (this.getSuperClass() == null) {
            String high = (String)ManagedBuildManager.getExtensionToolMap().lastKey();
            SortedMap subMap = null;
            if (this.superClassId.compareTo(high) > 0) {
                IToolChain parent = (IToolChain)this.getParent();
                IConfiguration parentConfig = parent.getParent();
                IManagedProject managedProject = parentConfig.getManagedProject();
                if (managedProject != null) {
                    managedProject.setValid(false);
                }
                return;
            }
            subMap = ManagedBuildManager.getExtensionToolMap().subMap(this.superClassId, String.valueOf(high) + "\u0000");
            String baseId = ManagedBuildManager.getIdFromIdAndVersion(this.superClassId);
            String version = ManagedBuildManager.getVersionFromIdAndVersion(this.superClassId);
            ITool[] toolElements = (ITool[])subMap.values().toArray();
            int i = 0;
            while (i < toolElements.length) {
                String versionsSupported;
                ITool toolElement = toolElements[i];
                if (ManagedBuildManager.getIdFromIdAndVersion(toolElement.getId()).compareTo(baseId) > 0) break;
                if (ManagedBuildManager.getIdFromIdAndVersion(toolElement.getId()).equals(baseId) && (versionsSupported = toolElement.getVersionsSupported()) != null && !versionsSupported.equals("")) {
                    String[] tmpVersions = versionsSupported.split(DEFAULT_SEPARATOR);
                    int j = 0;
                    while (j < tmpVersions.length) {
                        if (new PluginVersionIdentifier(version).equals((Object)new PluginVersionIdentifier(tmpVersions[j]))) {
                            String supportedVersion = ManagedBuildManager.getVersionFromIdAndVersion(toolElement.getId());
                            this.setId(String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(this.getId())) + "_" + supportedVersion);
                            this.setSuperClass(toolElement);
                            this.superClassId = this.getSuperClass().getId();
                            isExists = true;
                            break;
                        }
                        ++j;
                    }
                    if (isExists) break;
                }
                ++i;
            }
        }
        if (this.getSuperClass() != null) {
            String convertToId = this.getSuperClass().getConvertToId();
            if (convertToId == null || convertToId.equals("")) {
                return;
            }
            this.getConverter(convertToId);
        } else {
            IToolChain parent = (IToolChain)this.getParent();
            IConfiguration parentConfig = parent.getParent();
            IManagedProject managedProject = parentConfig.getManagedProject();
            if (managedProject != null) {
                managedProject.setValid(false);
            }
        }
    }

    private void getConverter(String convertToId) {
        IToolChain parent;
        IConfiguration parentConfig;
        IManagedProject managedProject;
        String fromId = null;
        String toId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter")) {
                        fromId = element.getAttribute("fromId");
                        toId = element.getAttribute("toId");
                        if (fromId.equals(this.getSuperClass().getId()) && toId.equals(convertToId)) {
                            String mbsVersion = element.getAttribute("mbsVersion");
                            PluginVersionIdentifier currentMbsVersion = ManagedBuildManager.getBuildInfoVersion();
                            if (currentMbsVersion.isGreaterThan(new PluginVersionIdentifier(mbsVersion))) {
                                this.previousMbsVersionConversionElement = element;
                            } else {
                                this.currentMbsVersionConversionElement = element;
                            }
                            return;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        if ((managedProject = (parentConfig = (parent = (IToolChain)this.getParent()).getParent()).getManagedProject()) != null) {
            managedProject.setValid(false);
        }
    }

    public IConfigurationElement getPreviousMbsVersionConversionElement() {
        return this.previousMbsVersionConversionElement;
    }

    public IConfigurationElement getCurrentMbsVersionConversionElement() {
        return this.currentMbsVersionConversionElement;
    }

    public IProject getProject() {
        IBuildObject toolParent = this.getParent();
        if (toolParent != null) {
            if (toolParent instanceof IToolChain) {
                IConfiguration config = ((IToolChain)toolParent).getParent();
                if (config == null) {
                    return null;
                }
                return (IProject)config.getOwner();
            }
            if (toolParent instanceof IResourceConfiguration) {
                return (IProject)((IResourceConfiguration)toolParent).getOwner();
            }
        }
        return null;
    }

    public String[] getContentTypeFileSpecs(IContentType type) {
        String[] globalSpecs = type.getFileSpecs(8);
        IContentTypeSettings settings = null;
        IProject project = this.getProject();
        if (project != null) {
            String[] specs;
            ProjectScope projectScope = new ProjectScope(project);
            try {
                settings = type.getSettings((IScopeContext)projectScope);
            }
            catch (Exception exception) {}
            if (settings != null && (specs = settings.getFileSpecs(8)).length > 0) {
                int total = globalSpecs.length + specs.length;
                String[] projSpecs = new String[total];
                int i = 0;
                int j = 0;
                while (j < specs.length) {
                    projSpecs[i] = specs[j];
                    ++i;
                    ++j;
                }
                j = 0;
                while (j < globalSpecs.length) {
                    projSpecs[i] = globalSpecs[j];
                    ++i;
                    ++j;
                }
                return projSpecs;
            }
        }
        return globalSpecs;
    }
}

